/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.npsdk;

import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.BPlatform;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.IPlatformLibrary;
import com.tridium.platform.NativePlatformLibraryNpsdk;
import com.tridium.platform.NativePlatformLibraryTridium;
import com.tridium.platform.archive.FileArchive;
import com.tridium.platform.archive.NullFileArchive;
import com.tridium.platform.archive.ZipArchive;
import com.tridium.platform.timezone.BDstSupportLevel;
import java.io.File;
import javax.baja.naming.SlotPath;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSystemPlatformServiceNpsdk
extends BSystemPlatformService {
    public static final Type TYPE;
    private static long lastFileCheck;
    private static final IPlatformLibrary _PLATFORM_LIBRARY_INSTANCE;
    private String[] fileSystems;
    private Property[] filesystemProps;
    static /* synthetic */ Class class$com$tridium$platform$npsdk$BSystemPlatformServiceNpsdk;

    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        return false;
    }

    public void loadPlatformServiceProperties() {
        super.loadPlatformServiceProperties();
        if (!NativePlatformLibraryNpsdk.load()) {
            return;
        }
        IPlatformLibrary iPlatformLibrary = this.getPlatformLibrary();
        this.fileSystems = iPlatformLibrary.getAllFileSystemNames();
        this.filesystemProps = new Property[this.fileSystems.length];
        this.getFilesystemAttributes().removeAll();
        int n = 0;
        while (n < this.fileSystems.length) {
            BFilesystemAttributes bFilesystemAttributes = new BFilesystemAttributes(iPlatformLibrary.getTotalBytes(this.fileSystems[n]) / 1024L, iPlatformLibrary.getFreeBytes(this.fileSystems[n]) / 1024L, iPlatformLibrary.getBlockSize(this.fileSystems[n]), iPlatformLibrary.getMaxFileCount(this.fileSystems[n]), iPlatformLibrary.getCurrentFileCount(this.fileSystems[n]), iPlatformLibrary.isFlash(this.fileSystems[n]));
            this.filesystemProps[n] = this.getFilesystemAttributes().add(SlotPath.escape((String)this.fileSystems[n]), (BValue)bFilesystemAttributes, 3);
            ++n;
        }
        this.setTotalPhysicalMemory((int)(iPlatformLibrary.getTotalPhysicalMemoryBytes() / 1024L));
        this.setFreePhysicalMemory((int)(iPlatformLibrary.getFreePhysicalMemoryBytes() / 1024L));
        this.setCurrentCpuUsage(iPlatformLibrary.getCurrentCPUUtilization());
        this.setOverallCpuUsage(iPlatformLibrary.getOverallCPUUtilization());
        this.setNumCpus(iPlatformLibrary.getNumberCPUs());
    }

    public String makeRootName(String string) {
        return "/" + string + '/';
    }

    public void doPoll(Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (!NativePlatformLibraryNpsdk.load()) {
            return;
        }
        IPlatformLibrary iPlatformLibrary = this.getPlatformLibrary();
        this.setTotalPhysicalMemory((int)(iPlatformLibrary.getTotalPhysicalMemoryBytes() / 1024L));
        this.setFreePhysicalMemory((int)(iPlatformLibrary.getFreePhysicalMemoryBytes() / 1024L));
        this.setCurrentCpuUsage(iPlatformLibrary.getCurrentCPUUtilization());
        this.setOverallCpuUsage(iPlatformLibrary.getOverallCPUUtilization());
        long l = Clock.ticks();
        if (l - lastFileCheck > 15000L) {
            lastFileCheck = l;
            int n = 0;
            while (n < this.fileSystems.length) {
                BFilesystemAttributes bFilesystemAttributes = (BFilesystemAttributes)this.getFilesystemAttributes().get(this.filesystemProps[n]);
                bFilesystemAttributes.setFreeSpace(iPlatformLibrary.getFreeBytes(this.fileSystems[n]) / 1024L);
                bFilesystemAttributes.setTotalSpace(iPlatformLibrary.getTotalBytes(this.fileSystems[n]) / 1024L);
                bFilesystemAttributes.setBlockSize(iPlatformLibrary.getBlockSize(this.fileSystems[n]));
                bFilesystemAttributes.setMaxFileCount((int)iPlatformLibrary.getMaxFileCount(this.fileSystems[n]));
                bFilesystemAttributes.setCurrentFileCount((int)iPlatformLibrary.getCurrentFileCount(this.fileSystems[n]));
                ++n;
            }
        }
        if (context != null && context.getFacets().getb("resourceOnly", false)) {
            return;
        }
        super.doPoll(context);
    }

    public boolean archiveEnabled(String string) {
        NativePlatformLibraryNpsdk.load();
        String string2 = ((NativePlatformLibraryNpsdk)_PLATFORM_LIBRARY_INSTANCE).getAltArchivePath();
        boolean bl = false;
        if (string2 != null) {
            bl = true;
        }
        return bl;
    }

    public FileArchive createFileArchive(String string) {
        NativePlatformLibraryNpsdk.load();
        String string2 = ((NativePlatformLibraryNpsdk)_PLATFORM_LIBRARY_INSTANCE).getAltArchivePath();
        if (string2 == null) {
            return new NullFileArchive();
        }
        String string3 = Sys.getStationHome().getPath() + '/' + string;
        String string4 = string + ".zip";
        File file = new File(Sys.getStationHome().getPath() + File.separator + string);
        file.mkdir();
        return new ZipArchive(string3, string4, this.getArchiveBackupCount());
    }

    private final int getArchiveBackupCount() {
        int n = ((NativePlatformLibraryNpsdk)_PLATFORM_LIBRARY_INSTANCE).getArchiveBackupCount();
        if (n <= 0) {
            return 0;
        }
        return n;
    }

    public synchronized void extractArchive(String string) {
        NativePlatformLibraryNpsdk.load();
        String string2 = ((NativePlatformLibraryNpsdk)_PLATFORM_LIBRARY_INSTANCE).getAltArchivePath();
        if (string2 == null) {
            return;
        }
        try {
            ZipArchive.unzip(Sys.getStationHome().getPath() + File.separator + string, string + ".zip", File.separator + string2 + File.separator + string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            BPlatform.log.error("Failed to extrace archive " + string + " to  " + string2, (Throwable)exception);
        }
    }

    public String getRuntimeDirectory(String string) {
        String string2 = ((NativePlatformLibraryNpsdk)_PLATFORM_LIBRARY_INSTANCE).getAltArchivePath();
        if (string2 == null) {
            return super.getRuntimeDirectory(string);
        }
        return string2 + File.separator + string;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"SystemPlatformServiceLinux", 2);
        if (this.isProxy()) {
            spyWriter.prop((Object)"lastErrorMessage", (Object)"remote");
        } else if (NativePlatformLibraryTridium.load()) {
            spyWriter.prop((Object)"lastErrorMessage", (Object)this.getPlatformLibrary().getLastErrorMessage());
        }
        spyWriter.endProps();
    }

    public IPlatformLibrary getPlatformLibrary() {
        NativePlatformLibraryNpsdk.load();
        return _PLATFORM_LIBRARY_INSTANCE;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("Platform Service Test");
            NativePlatformLibraryTridium.load();
            System.out.println("Natives loaded");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BSystemPlatformServiceNpsdk() {
        this.setTimezoneDayModeSupport(BDstSupportLevel.full);
    }

    static {
        Class clazz = class$com$tridium$platform$npsdk$BSystemPlatformServiceNpsdk;
        if (clazz == null) {
            clazz = class$com$tridium$platform$npsdk$BSystemPlatformServiceNpsdk = BSystemPlatformServiceNpsdk.class("[Lcom.tridium.platform.npsdk.BSystemPlatformServiceNpsdk;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lastFileCheck = 0L;
        _PLATFORM_LIBRARY_INSTANCE = new NativePlatformLibraryNpsdk();
    }
}

