/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.license;

import com.tridium.file.types.text.BCertificateFile;
import com.tridium.platform.license.IFileInfo;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.license.dom.VendorCertificate;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.util.LexiconText;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CertificateInfo
implements IFileInfo {
    private static LexiconText neverExpiresFmt = LexiconText.make((String)"platform", (String)"CertificateInfo.neverExpiresFormat");
    private static LexiconText defaultFmt = LexiconText.make((String)"platform", (String)"CertificateInfo.format");
    public static final FilePath CERTS_PATH = new FilePath("!certificates");
    public VendorCertificate vendorCertificate;
    public BIFile file;
    static /* synthetic */ Class class$com$tridium$platform$license$CertificateInfo;

    public static CertificateInfo[] make(BIFile[] bIFileArray) throws Exception {
        CertificateInfo[] certificateInfoArray = new CertificateInfo[bIFileArray.length];
        int n = 0;
        while (n < bIFileArray.length) {
            certificateInfoArray[n] = new CertificateInfo(bIFileArray[n]);
            ++n;
        }
        return certificateInfoArray;
    }

    public static CertificateInfo[] make(XElem[] xElemArray) throws Exception {
        CertificateInfo[] certificateInfoArray = new CertificateInfo[xElemArray.length];
        int n = 0;
        while (n < xElemArray.length) {
            certificateInfoArray[n] = new CertificateInfo(xElemArray[n]);
            ++n;
        }
        return certificateInfoArray;
    }

    public static CertificateInfo[] make(VendorCertificate[] vendorCertificateArray) throws Exception {
        CertificateInfo[] certificateInfoArray = new CertificateInfo[vendorCertificateArray.length];
        int n = 0;
        while (n < vendorCertificateArray.length) {
            certificateInfoArray[n] = new CertificateInfo(vendorCertificateArray[n], null);
            ++n;
        }
        return certificateInfoArray;
    }

    public static CertificateInfo[] listLocal() {
        Class clazz = class$com$tridium$platform$license$CertificateInfo;
        if (clazz == null) {
            clazz = class$com$tridium$platform$license$CertificateInfo = CertificateInfo.class("[Lcom.tridium.platform.license.CertificateInfo;", false);
        }
        Array array = new Array(clazz);
        BDirectory bDirectory = (BDirectory)BFileSystem.INSTANCE.findFile(CERTS_PATH);
        BIFile[] bIFileArray = bDirectory.listFiles();
        int n = 0;
        while (n < bIFileArray.length) {
            if (bIFileArray[n] instanceof BCertificateFile) {
                try {
                    array.add((Object)new CertificateInfo(bIFileArray[n]));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++n;
        }
        return (CertificateInfo[])array.trim();
    }

    public String getInstalledFileName() {
        return TextUtil.capitalize((String)this.vendorCertificate.getVendor()) + ".certificate";
    }

    public String getXmlContent() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.vendorCertificate.save((OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toString();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public String getXmlSummary() {
        return CertificateInfo.getXmlSummary(this.vendorCertificate);
    }

    public static String getXmlSummary(VendorCertificate vendorCertificate) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<certificateSummary ");
        stringBuffer.append("vendor=\"" + vendorCertificate.getVendor() + "\" ");
        stringBuffer.append("expiration=\"" + vendorCertificate.getExpiration() + "\" ");
        stringBuffer.append("signature=\"" + vendorCertificate.getSignature() + "\"/>");
        return stringBuffer.toString();
    }

    public FilePath getInstalledFilePath() {
        return CERTS_PATH.merge(this.getInstalledFileName());
    }

    public void write(OutputStream outputStream) throws Exception {
        this.write(outputStream, true);
    }

    public void write(OutputStream outputStream, boolean bl) throws Exception {
        this.vendorCertificate.save(outputStream, bl);
    }

    public String toString() {
        return this.toString(null);
    }

    public static String getSummaryText(VendorCertificate vendorCertificate, Context context) {
        return CertificateInfo.getSummaryText(vendorCertificate.getVendor() + ".certificate", vendorCertificate, context);
    }

    public String toString(Context context) {
        String string = this.file != null && this.file instanceof BCertificateFile ? this.file.getFileName() : this.getInstalledFileName();
        return CertificateInfo.getSummaryText(string, this.vendorCertificate, context);
    }

    public static String getSummaryText(String string, VendorCertificate vendorCertificate, Context context) {
        if (vendorCertificate.getExpiration() == Long.MAX_VALUE) {
            return neverExpiresFmt.getText(context, new Object[]{string, vendorCertificate.getVendor()});
        }
        return defaultFmt.getText(context, new Object[]{string, vendorCertificate.getVendor(), LicenseUtil.formatDate((long)vendorCertificate.getExpiration())});
    }

    public BIFile getFile() {
        return this.file;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public CertificateInfo(XElem xElem) throws Exception {
        this(xElem, null);
    }

    public CertificateInfo(BIFile bIFile) throws Exception {
        this(VendorCertificate.make((BIFile)bIFile), bIFile);
    }

    public CertificateInfo(XElem xElem, BIFile bIFile) throws Exception {
        this(VendorCertificate.make((String)(bIFile == null ? "CertificateInfo" : bIFile.getFileName()), (XElem)xElem), bIFile);
    }

    public CertificateInfo(VendorCertificate vendorCertificate, BIFile bIFile) {
        this.vendorCertificate = vendorCertificate;
        this.file = bIFile;
    }

    public CertificateInfo(InputStream inputStream) throws Exception {
        this(inputStream, true);
    }

    public CertificateInfo(InputStream inputStream, boolean bl) throws Exception {
        this(XParser.make((InputStream)inputStream).parse(bl), null);
    }
}

