/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.fox;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxCircuit;
import java.io.IOException;
import java.io.OutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ChunkedOutputStream
extends OutputStream {
    private FoxCircuit circuit;
    private byte[] buf;
    private int n;

    public void write(int n) throws IOException {
        this.buf[this.n++] = (byte)(0xFF & n);
        if (this.n >= this.buf.length) {
            this.flush();
        }
    }

    public void flush() throws IOException {
        if (this.n > 0) {
            FoxMessage foxMessage = new FoxMessage();
            foxMessage.add("type", "chunk");
            foxMessage.add("chunk", this.buf, this.n);
            this.writeMessage(foxMessage);
            this.n = 0;
        }
    }

    public void close() throws IOException {
        this.flush();
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("type", "chunk");
        foxMessage.add("chunk", this.buf, 0);
        this.writeMessage(foxMessage);
        FoxMessage foxMessage2 = this.readMessage();
        this.circuit.close();
        String string = foxMessage2.getString("error", null);
        if (string != null) {
            throw new IOException(string);
        }
    }

    private final FoxMessage readMessage() throws IOException {
        try {
            return this.circuit.readMessage();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    private final void writeMessage(FoxMessage foxMessage) throws IOException {
        try {
            this.circuit.writeMessage(foxMessage);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    private final /* synthetic */ void this() {
        this.buf = new byte[Fox.circuitChunkSize - 256];
    }

    public ChunkedOutputStream(FoxCircuit foxCircuit) {
        this.this();
        this.circuit = foxCircuit;
    }
}

