/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.file;

import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.FilePathComparator;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;

public class StoreCache {
    public static final int FOUND = 0;
    public static final int NOT_FOUND = 1;
    public static final int UNKNOWN = 2;
    private TreeSet pathsNotFound = new TreeSet(FilePathComparator.INSTANCE);
    private TreeMap storeByPath = new TreeMap(FilePathComparator.INSTANCE);
    private TreeSet completedPaths = new TreeSet(FilePathComparator.INSTANCE);

    public int getCacheStatus(FilePath filePath) {
        if (this.pathsNotFound.contains(filePath)) {
            return 1;
        }
        if (this.storeByPath.containsKey(filePath)) {
            return 0;
        }
        if (filePath.getParent() != null && this.completedPaths.contains(filePath.getParent())) {
            return 1;
        }
        return 2;
    }

    public BIFileStore getStore(FilePath filePath) {
        return (BIFileStore)this.storeByPath.get(filePath);
    }

    public void cacheResult(BIFileStore bIFileStore) {
        this.storeByPath.put(bIFileStore.getFilePath(), bIFileStore);
    }

    public void cacheNotFound(FilePath filePath) {
        this.pathsNotFound.add(filePath);
    }

    public void cacheCompleted(FilePath filePath) {
        this.completedPaths.add(filePath);
    }

    public void clear() {
        this.pathsNotFound.clear();
        this.storeByPath.clear();
        this.completedPaths.clear();
    }

    public void clear(FilePath filePath) {
        Object object;
        Object object2;
        TreeSet<Object> treeSet = new TreeSet<Object>(FilePathComparator.INSTANCE);
        Object object3 = this.pathsNotFound.iterator();
        while (object3.hasNext()) {
            object2 = (FilePath)object3.next();
            if (DaemonFileUtil.isSubPath((FilePath)object2, filePath)) continue;
            treeSet.add(object2);
        }
        object3 = new TreeMap(FilePathComparator.INSTANCE);
        object2 = this.storeByPath.keySet().iterator();
        while (object2.hasNext()) {
            object = (FilePath)object2.next();
            if (DaemonFileUtil.isSubPath((FilePath)object, filePath)) continue;
            ((TreeMap)object3).put(object, this.storeByPath.get(object));
        }
        object2 = new TreeSet(FilePathComparator.INSTANCE);
        object = this.completedPaths.iterator();
        while (object.hasNext()) {
            FilePath filePath2 = (FilePath)object.next();
            if (DaemonFileUtil.isSubPath(filePath2, filePath)) continue;
            ((TreeSet)object2).add(filePath2);
        }
        this.pathsNotFound = treeSet;
        this.storeByPath = object3;
        this.completedPaths = object2;
    }

    public void dump() {
        System.out.println("cached not found:");
        Iterator<Object> iterator = this.pathsNotFound.iterator();
        while (iterator.hasNext()) {
            System.out.println("  " + iterator.next());
        }
        System.out.println("cached stores:");
        iterator = this.storeByPath.keySet().iterator();
        while (iterator.hasNext()) {
            System.out.println("  " + iterator.next());
        }
        System.out.println("cached completed:");
        iterator = this.completedPaths.iterator();
        while (iterator.hasNext()) {
            System.out.println("  " + iterator.next());
        }
    }
}

