/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.file;

import com.tridium.platform.daemon.file.BCacheAccessPolicy;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.message.FileTransferMessage;
import java.util.Iterator;
import java.util.TreeMap;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.nre.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DirectoryClean {
    private static final int UNKNOWN = 0;
    private static final int KEEP_SOME = 1;
    private static final int KEEP_ALL = 2;
    private static final int CLEAN_SOME = 16;
    private static final int CLEAN_ALL = 32;
    private static final int CASCADE_PARENT = 1;
    private static final int CASCADE_CHILD = 16;
    private static final int CASCADE_ANY = 17;
    private TreeMap sysHomeAbsRootsByName;
    private TreeMap localAbsRootsByName;

    public void clean(BIFileStore bIFileStore) {
        if (bIFileStore == null) {
            return;
        }
        FilePath filePath = this.normalizePath(bIFileStore.getFilePath());
        Node node = this.makeNode(filePath);
        node.setStore(bIFileStore);
        node.transition(32);
    }

    public void keep(FilePath filePath) {
        this.makeNode(this.normalizePath(filePath)).transition(2);
    }

    public void addTransferElements(FileTransferMessage fileTransferMessage) {
        Iterator iterator = this.sysHomeAbsRootsByName.values().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).addTransferElements(fileTransferMessage);
        }
        iterator = this.localAbsRootsByName.values().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).addTransferElements(fileTransferMessage);
        }
    }

    public void dump() {
        Iterator iterator = this.sysHomeAbsRootsByName.values().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).dump("!");
        }
        iterator = this.localAbsRootsByName.values().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).dump("/");
        }
    }

    private final FilePath normalizePath(FilePath filePath) {
        if (filePath == null || filePath.isSysHomeAbsolute()) {
            return filePath;
        }
        if (filePath.isLocalAbsolute()) {
            if (filePath.depth() == 0 || !filePath.nameAt(0).equals("niagara")) {
                return filePath;
            }
            FilePath filePath2 = new FilePath("!");
            int n = 1;
            while (n < filePath.depth()) {
                filePath2 = filePath2.merge(filePath.nameAt(n));
                ++n;
            }
            return filePath2;
        }
        throw new IllegalArgumentException("path must be sys home or local absolute");
    }

    private final Node makeNode(FilePath filePath) {
        if (filePath.depth() == 0) {
            throw new IllegalArgumentException("root path");
        }
        TreeMap treeMap = null;
        if (filePath.isSysHomeAbsolute()) {
            treeMap = this.sysHomeAbsRootsByName;
        } else if (filePath.isLocalAbsolute()) {
            treeMap = this.localAbsRootsByName;
        } else {
            throw new IllegalArgumentException("Path must be sys home or local absolute");
        }
        Node node = (Node)treeMap.get(filePath.nameAt(0));
        if (node == null) {
            node = new Node(null, filePath.nameAt(0));
            treeMap.put(filePath.nameAt(0), node);
        }
        int n = 1;
        while (n < filePath.depth()) {
            node = node.makeChild(filePath.nameAt(n));
            ++n;
        }
        return node;
    }

    static /* synthetic */ int access$0() {
        return 0;
    }

    static /* synthetic */ int access$1() {
        return 32;
    }

    static /* synthetic */ int access$2() {
        return 16;
    }

    static /* synthetic */ int access$3() {
        return 1;
    }

    static /* synthetic */ int access$4() {
        return 2;
    }

    static /* synthetic */ int access$5() {
        return 17;
    }

    static /* synthetic */ int access$6() {
        return 1;
    }

    static /* synthetic */ int access$7() {
        return 16;
    }

    private final /* synthetic */ void this() {
        this.sysHomeAbsRootsByName = new TreeMap();
        this.localAbsRootsByName = new TreeMap();
    }

    public DirectoryClean() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class Node {
        private BIFileStore store;
        private String name;
        private Node parent;
        private TreeMap childByName;
        private int status;

        public Node makeChild(String string) {
            Node node = (Node)this.childByName.get(string);
            if (node == null) {
                node = new Node(this, string);
                this.childByName.put(string, node);
            }
            return node;
        }

        public void setStore(BIFileStore bIFileStore) {
            if (this.store == null) {
                this.store = bIFileStore;
                if (bIFileStore instanceof BDaemonDirectoryStore) {
                    Array array = ((BDaemonDirectoryStore)bIFileStore).getChildren(BCacheAccessPolicy.lazyFetch, true, true, false);
                    int n = 0;
                    while (n < array.size()) {
                        BIFileStore bIFileStore2 = (BIFileStore)array.get(n);
                        Node node = this.makeChild(bIFileStore2.getFilePath().getName());
                        node.setStore(bIFileStore2);
                        ++n;
                    }
                }
            }
        }

        public void addTransferElements(FileTransferMessage fileTransferMessage) {
            if (this.status == 32) {
                fileTransferMessage.addDelete(this.store.getFilePath());
            } else if ((this.status & 0x10) > 0) {
                Iterator iterator = this.childByName.values().iterator();
                while (iterator.hasNext()) {
                    ((Node)iterator.next()).addTransferElements(fileTransferMessage);
                }
            }
        }

        public void dump(String string) {
            System.out.print(string);
            System.out.print(this.name);
            System.out.print("  ");
            if (this.status == 0) {
                System.out.print("unknown ");
            }
            if ((this.status & 1) > 0) {
                System.out.print("keepSome ");
            }
            if ((this.status & 2) > 0) {
                System.out.print("keepAll ");
            }
            if ((this.status & 0x10) > 0) {
                System.out.print("cleanSome ");
            }
            if ((this.status & 0x20) > 0) {
                System.out.print("cleanAll ");
            }
            System.out.println();
            Iterator iterator = this.childByName.values().iterator();
            while (iterator.hasNext()) {
                ((Node)iterator.next()).dump(string + this.name + '/');
            }
        }

        public void transition(int n) {
            this.transition(n, 17);
        }

        private final void transition(int n, int n2) {
            if (n == this.status || this.status == 2) {
                return;
            }
            if (n == 0) {
                throw new IllegalArgumentException("Can't transition to unknown");
            }
            if (n == 2) {
                this.status = 2;
                this.transitionParent(1, n2);
                this.transitionChildren(2, n2);
            } else if (n == 1) {
                if (this.status == 0) {
                    this.status = 1;
                    this.transitionParent(1, n2);
                } else if (this.status == 32 || this.status == 16) {
                    this.status = 17;
                    this.transitionParent(1, n2);
                }
            } else if (n == 16) {
                if (this.status == 0) {
                    this.status = 16;
                    this.transitionParent(16, n2);
                } else if (this.status == 1) {
                    this.status = 17;
                    this.transitionParent(16, n2);
                }
            } else if (n == 32) {
                if (this.status == 0) {
                    this.status = 32;
                    this.transitionChildren(32, n2);
                    this.transitionParent(16, n2);
                } else if ((this.status & 1) > 0) {
                    this.status |= 0x10;
                    this.transitionChildren(32, n2);
                    this.transitionParent(16, n2);
                } else if (this.status == 16) {
                    this.transitionChildren(32, n2);
                }
            }
        }

        private final void transitionParent(int n, int n2) {
            if ((n2 & 1) > 0 && this.parent != null) {
                this.parent.transition(n, n2 & 0xFFFFFFEF);
            }
        }

        private final void transitionChildren(int n, int n2) {
            if ((n2 & 0x10) > 0) {
                Iterator iterator = this.childByName.values().iterator();
                while (iterator.hasNext()) {
                    ((Node)iterator.next()).transition(n, n2 & 0xFFFFFFFE);
                }
            }
        }

        private final /* synthetic */ void this() {
            this.childByName = new TreeMap();
            this.status = 0;
        }

        public Node(Node node, String string) {
            this.this();
            this.parent = node;
            this.name = string;
        }
    }
}

