/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.file;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BCacheAccessPolicy;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.BDaemonFileStore;
import com.tridium.platform.daemon.file.FileHeaderInfo;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.FileHeaderMessage;
import java.io.IOException;
import java.net.ConnectException;
import javax.baja.file.BAbstractFileStore;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BIcon;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDefaultDaemonFileSpace
extends BDaemonFileSpace {
    public static final Type TYPE;
    private static final BIcon icon;
    private BOrd ordInSession = BOrd.make((String)"file:");
    static /* synthetic */ Class class$com$tridium$platform$daemon$file$BDefaultDaemonFileSpace;

    public Type getType() {
        return TYPE;
    }

    public BDaemonSession getDaemonSession() {
        return (BDaemonSession)this.getNavParent();
    }

    protected void init() throws ConnectException, AuthenticationException {
        if (this.roots != null) {
            return;
        }
        super.init();
    }

    public boolean hasNavChildren() {
        return true;
    }

    public BINavNode getNavChild(String string) {
        try {
            this.init();
            int n = 0;
            while (n < this.roots.length) {
                if (this.roots[n].getFileName().equals(string)) {
                    return this.roots[n];
                }
                ++n;
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public BINavNode[] getNavChildren() {
        try {
            this.init();
            return (BINavNode[])this.roots.clone();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public BOrd getOrdInSession() {
        return this.ordInSession;
    }

    public String getNavDescription(Context context) {
        return this.getLexicon().getText("DaemonFileSpace.navDesc");
    }

    public BDirectory makeDir(FilePath filePath, Context context) throws IOException {
        throw new LocalizableRuntimeException("platform", "DaemonFileSpace.readonly");
    }

    public BIFile makeFile(FilePath filePath, Context context) throws IOException {
        throw new LocalizableRuntimeException("platform", "DaemonFileSpace.readonly");
    }

    public void delete(FilePath filePath, Context context) throws IOException {
        throw new LocalizableRuntimeException("platform", "DaemonFileSpace.readonly");
    }

    public void move(FilePath filePath, FilePath filePath2, Context context) throws IOException {
        throw new LocalizableRuntimeException("platform", "DaemonFileSpace.readonly");
    }

    public BIFile findFile(FilePath filePath, BCacheAccessPolicy bCacheAccessPolicy) {
        try {
            BIFileStore bIFileStore = this.findStore(null, filePath, false, false, bCacheAccessPolicy);
            if (bIFileStore == null) {
                return null;
            }
            if (bIFileStore instanceof BDaemonDirectoryStore) {
                return new BDirectory(bIFileStore);
            }
            return this.makeFile(bIFileStore);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public BIFileStore findStore(FilePath filePath) {
        try {
            return this.findStore(null, filePath, false, false, BCacheAccessPolicy.lazyFetch);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public BIFileStore findStore(FilePath filePath, BCacheAccessPolicy bCacheAccessPolicy) {
        try {
            return this.findStore(null, filePath, false, false, bCacheAccessPolicy);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public BIFileStore findStore(StoreCache storeCache, FilePath filePath, boolean bl, boolean bl2) throws ConnectException, AuthenticationException, IOException {
        return this.findStore(storeCache, filePath, bl, bl2, BCacheAccessPolicy.lazyFetch);
    }

    public BIFileStore findStore(StoreCache storeCache, FilePath filePath, boolean bl, boolean bl2, BCacheAccessPolicy bCacheAccessPolicy) throws ConnectException, AuthenticationException, IOException {
        BAbstractFileStore bAbstractFileStore;
        int n = bCacheAccessPolicy == BCacheAccessPolicy.forceFetch || storeCache == null ? 2 : storeCache.getCacheStatus(filePath);
        if (n == 1) {
            return null;
        }
        if (n == 0) {
            return storeCache.getStore(filePath);
        }
        if (bCacheAccessPolicy == BCacheAccessPolicy.cacheOnly) {
            return null;
        }
        FileHeaderInfo fileHeaderInfo = DaemonFileUtil.getFileHeaderInfo(this.getDaemonSession(), new FileHeaderMessage(filePath, this));
        if (fileHeaderInfo == null) {
            if (storeCache != null) {
                storeCache.cacheNotFound(filePath);
            }
            return null;
        }
        if (fileHeaderInfo.isDirectory()) {
            bAbstractFileStore = BDaemonDirectoryStore.make(this, filePath, bl, bl2, false, storeCache);
        } else if (filePath.depth() == 1 || !bl2) {
            bAbstractFileStore = new BDaemonFileStore(this, filePath, fileHeaderInfo.getContentLength(), -1);
            if (storeCache != null) {
                storeCache.cacheResult((BIFileStore)bAbstractFileStore);
            }
        } else {
            BDaemonDirectoryStore bDaemonDirectoryStore = BDaemonDirectoryStore.make(this, filePath.getParent(), bl, true, false, storeCache);
            if (bDaemonDirectoryStore == null) {
                bAbstractFileStore = new BDaemonFileStore(this, filePath, fileHeaderInfo.getContentLength(), -1);
                if (storeCache != null) {
                    storeCache.cacheResult((BIFileStore)bAbstractFileStore);
                }
            } else {
                bAbstractFileStore = bDaemonDirectoryStore.getChild(filePath.getName());
            }
        }
        return bAbstractFileStore;
    }

    public BIFile getChild(BIFile bIFile, String string, BCacheAccessPolicy bCacheAccessPolicy) {
        if (bIFile.isDirectory()) {
            BDaemonDirectoryStore bDaemonDirectoryStore = (BDaemonDirectoryStore)bIFile.getStore();
            BIFileStore bIFileStore = bDaemonDirectoryStore.getChild(string, bCacheAccessPolicy);
            return bIFileStore == null ? null : this.makeFile(bIFileStore);
        }
        return null;
    }

    public BIFile[] getChildren(BIFile bIFile, BCacheAccessPolicy bCacheAccessPolicy) {
        if (bIFile.isDirectory()) {
            BDaemonDirectoryStore bDaemonDirectoryStore = (BDaemonDirectoryStore)bIFile.getStore();
            Array array = bDaemonDirectoryStore.getChildren(bCacheAccessPolicy);
            BIFile[] bIFileArray = new BIFile[array.size()];
            int n = 0;
            while (n < bIFileArray.length) {
                bIFileArray[n] = this.makeFile((BIFileStore)array.get(n));
                ++n;
            }
            return bIFileArray;
        }
        return null;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$platform$daemon$file$BDefaultDaemonFileSpace;
        if (clazz == null) {
            clazz = class$com$tridium$platform$daemon$file$BDefaultDaemonFileSpace = BDefaultDaemonFileSpace.class("[Lcom.tridium.platform.daemon.file.BDefaultDaemonFileSpace;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"drive.png");
    }
}

