/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.PlatformOperationListener;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.UpdateStationMessage;
import java.net.ConnectException;
import javax.baja.file.BDirectory;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.IPlatformOperationListener;
import javax.baja.platform.RemoteStation;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.LocalizableRuntimeException;

public class RemotePlatformStation
implements RemoteStation {
    private BStationSurrogate station;

    public BStationStatus getStatus() {
        return this.station.getStationStatus();
    }

    public String getName() {
        return this.station.getStationName();
    }

    public BOrd getFoxOrd() {
        return this.station.getFoxOrd();
    }

    public void poll() throws Exception {
        this.station.poll();
    }

    public boolean canStart() throws Exception {
        this.poll();
        if (this.station.isStationRunning()) {
            return false;
        }
        if (!(this.canRestart() || this.station.getStationStatus() != BStationStatus.halted && this.station.getStationStatus() != BStationStatus.failed)) {
            return false;
        }
        System.out.println("canRestart = " + this.canRestart());
        System.out.println("status = " + (Object)((Object)this.station.getStationStatus()));
        return true;
    }

    public void start(IPlatformOperationListener iPlatformOperationListener) throws Exception {
        this.poll();
        if (!(this.station.isStationRunning() || this.canRestart() || this.station.getStationStatus() != BStationStatus.halted && this.station.getStationStatus() != BStationStatus.failed)) {
            throw new LocalizableRuntimeException("platform", "RemotePlatformStation.cannotStartHalted");
        }
        PlatformOperationListener platformOperationListener = new PlatformOperationListener(iPlatformOperationListener);
        this.station.startStation(platformOperationListener, platformOperationListener);
    }

    public void startAsync() throws Exception {
        this.poll();
        if (this.station.isStationRunning()) {
            throw new LocalizableRuntimeException("platform", "RemotePlatformStation.stationRunning");
        }
        if (!(this.canRestart() || this.station.getStationStatus() != BStationStatus.halted && this.station.getStationStatus() != BStationStatus.failed)) {
            throw new LocalizableRuntimeException("platform", "RemotePlatformStation.cannotStartHalted");
        }
        this.station.startStationAsync();
    }

    public void saveAsync() throws ConnectException, AuthenticationException {
        this.station.saveStationAsync();
    }

    public void save(IPlatformOperationListener iPlatformOperationListener) throws ConnectException, AuthenticationException {
        PlatformOperationListener platformOperationListener = new PlatformOperationListener(iPlatformOperationListener);
        this.station.saveStation(platformOperationListener, platformOperationListener);
    }

    public void rename(String string, IPlatformOperationListener iPlatformOperationListener) throws Exception {
        PlatformOperationListener platformOperationListener = new PlatformOperationListener(iPlatformOperationListener);
        BDaemonSession bDaemonSession = this.station.getDaemonSession();
        if (this.station.isStationRunning()) {
            this.station.stopStation(platformOperationListener, platformOperationListener);
        }
        DaemonFileUtil.transfer(bDaemonSession, FileTransferMessage.makeRename(new FilePath("!stations/" + this.station.getStationName()), string, bDaemonSession.getFileSpace()), null, platformOperationListener);
        bDaemonSession.sendMessage(new UpdateStationMessage());
        this.station = BStationSurrogate.make(bDaemonSession, string);
    }

    public void stopAsync() throws ConnectException, AuthenticationException {
        this.station.stopStationAsync();
    }

    public void stop(IPlatformOperationListener iPlatformOperationListener) throws ConnectException, AuthenticationException {
        PlatformOperationListener platformOperationListener = new PlatformOperationListener(iPlatformOperationListener);
        this.station.stopStation(platformOperationListener, platformOperationListener);
    }

    public boolean canRestart() throws Exception {
        return this.station.isRestartEnabled();
    }

    public void restartAsync() throws Exception {
        if (!this.canRestart()) {
            throw new LocalizableRuntimeException("platform", "RemotePlatformStation.restartNotAllowed");
        }
        this.station.restartStationAsync();
    }

    public void killAsync() throws ConnectException, AuthenticationException {
        this.station.killStationAsync();
    }

    public void delete(IPlatformOperationListener iPlatformOperationListener) throws ConnectException, AuthenticationException {
        PlatformOperationListener platformOperationListener = new PlatformOperationListener(iPlatformOperationListener);
        this.station.deleteStation(platformOperationListener, platformOperationListener);
    }

    public void makeLocalCopy(BDirectory bDirectory, IPlatformOperationListener iPlatformOperationListener) throws Exception {
        PlatformOperationListener platformOperationListener = new PlatformOperationListener(iPlatformOperationListener);
        this.station.makeStationCopy(bDirectory, platformOperationListener);
    }

    private static final RemoteStation[] array(BStationSurrogate[] bStationSurrogateArray) {
        RemoteStation[] remoteStationArray = new RemoteStation[bStationSurrogateArray.length];
        int n = 0;
        while (n < bStationSurrogateArray.length) {
            remoteStationArray[n] = new RemotePlatformStation(bStationSurrogateArray[n]);
            ++n;
        }
        return remoteStationArray;
    }

    public static RemoteStation[] getAllStations(BDaemonSession bDaemonSession) throws Exception {
        return RemotePlatformStation.array(BStationSurrogate.makeAll(bDaemonSession));
    }

    public static RemoteStation getStation(BDaemonSession bDaemonSession, String string) throws Exception {
        return new RemotePlatformStation(BStationSurrogate.make(bDaemonSession, string));
    }

    public static RemoteStation[] stopAllStations(BDaemonSession bDaemonSession, IPlatformOperationListener iPlatformOperationListener) throws Exception {
        PlatformOperationListener platformOperationListener = new PlatformOperationListener(iPlatformOperationListener);
        return RemotePlatformStation.array(BStationSurrogate.stopAllStations(bDaemonSession, platformOperationListener, platformOperationListener));
    }

    private RemotePlatformStation(BStationSurrogate bStationSurrogate) {
        this.station = bStationSurrogate;
    }
}

