/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import java.io.IOException;
import java.io.OutputStream;
import javax.baja.net.HttpConnection;
import javax.baja.platform.ICancelHint;

class PostOutputStream
extends OutputStream {
    private HttpConnection conn;
    private OutputStream out;
    private ICancelHint cancelHint;

    public void close() throws IOException {
        this.conn.postComplete();
        this.out.close();
        this.conn.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(int n) throws IOException {
        if (PostOutputStream.canceled(this.cancelHint)) {
            throw new ICancelHint.CanceledException();
        }
        this.out.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        if (PostOutputStream.canceled(this.cancelHint)) {
            throw new ICancelHint.CanceledException();
        }
        this.out.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (PostOutputStream.canceled(this.cancelHint)) {
            throw new ICancelHint.CanceledException();
        }
        this.out.write(byArray, n, n2);
    }

    public static boolean canceled(ICancelHint iCancelHint) {
        boolean bl = false;
        if (iCancelHint != null && iCancelHint.isCanceled()) {
            bl = true;
        }
        return bl;
    }

    public PostOutputStream(HttpConnection httpConnection, ICancelHint iCancelHint) throws IOException {
        if (PostOutputStream.canceled(iCancelHint)) {
            throw new ICancelHint.CanceledException();
        }
        this.conn = httpConnection;
        this.out = httpConnection.getOutputStream();
        this.cancelHint = iCancelHint;
    }
}

