/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.net.HttpUtil;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import java.io.InputStream;
import javax.baja.platform.DaemonSecurityManager;
import javax.baja.security.BPassword;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class PlatformSecurityManager
implements DaemonSecurityManager {
    private BDaemonSession daemonSession;

    public static PlatformSecurityManager make(BDaemonSession bDaemonSession) {
        return new PlatformSecurityManager(bDaemonSession);
    }

    public void useSingleAdminAccount(String string, String string2) throws Exception {
        DigestFileAuthMessage digestFileAuthMessage = new DigestFileAuthMessage(string, BPassword.make((String)string2));
        if (!this.daemonSession.sendMessage(digestFileAuthMessage)) {
            throw new RuntimeException(digestFileAuthMessage.getErrorMessage());
        }
        Thread.sleep(3000L);
    }

    public void useOsGroups(String string, String string2) throws Exception {
        XElem xElem = null;
        XElem xElem2 = null;
        try {
            xElem = XParser.make((InputStream)this.daemonSession.getInputStream((DaemonMessage)new XmlResponseMessage(){

                public final String getMessageString() {
                    return "auth";
                }
            }, "text/xml")).parse();
            xElem2 = xElem.elem("auth");
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
        if (!xElem2.getb("nativeAuthSupported", this.daemonSession.getHostProperties().getOsName().startsWith("win"))) {
            throw new UnsupportedOperationException("OS group-based authentication is not available for this platform");
        }
        BasicNativeAuthMessage basicNativeAuthMessage = new BasicNativeAuthMessage(string, string2);
        if (!this.daemonSession.sendMessage(basicNativeAuthMessage)) {
            throw new RuntimeException(basicNativeAuthMessage.getErrorMessage());
        }
        Thread.sleep(3000L);
    }

    private PlatformSecurityManager(BDaemonSession bDaemonSession) {
        this.daemonSession = bDaemonSession;
    }

    private static class DigestFileAuthMessage
    extends XmlResponseMessage {
        private StringBuffer buf = new StringBuffer("auth?update=true&authtype=");

        public String getMessageString() {
            return this.buf.toString();
        }

        public int getConnectionFlags() {
            return 16;
        }

        public DigestFileAuthMessage(String string, BPassword bPassword) {
            this.buf.append(HttpUtil.encodeUrl((String)"digest/file"));
            this.buf.append("&user=");
            this.buf.append(HttpUtil.encodeUrl((String)string));
            this.buf.append("&password=");
            try {
                this.buf.append(HttpUtil.encodeUrl((String)bPassword.encodeToString()));
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class BasicNativeAuthMessage
    extends XmlResponseMessage {
        private StringBuffer buf = new StringBuffer("auth?update=true&authtype=");

        public String getMessageString() {
            return this.buf.toString();
        }

        public int getConnectionFlags() {
            return 16;
        }

        public BasicNativeAuthMessage(String string, String string2) {
            this.buf.append(HttpUtil.encodeUrl((String)"basic/native"));
            this.buf.append("&usergroup=");
            this.buf.append(HttpUtil.encodeUrl((String)string));
            this.buf.append("&admingroup=");
            this.buf.append(HttpUtil.encodeUrl((String)string2));
        }
    }
}

