/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.BVersion;
import com.tridium.install.DaemonPlatformUtil;
import com.tridium.install.InstallScenario;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BPart;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.PlatformInstallOperation;
import com.tridium.platform.daemon.PlatformOperationListener;
import com.tridium.platform.daemon.message.OSUpdateMessage;
import com.tridium.platform.daemon.message.RefreshDaemonBinariesMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.tcpip.TcpUtil;
import java.util.Iterator;
import javax.baja.file.BIFile;
import javax.baja.nre.util.Array;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.platform.IPlatformOperationListener;
import javax.baja.platform.InstallManager;
import javax.baja.platform.InstallOperation;
import javax.baja.platform.install.InstallationSummary;
import javax.baja.platform.install.PlatformDependency;
import javax.baja.platform.install.PlatformPart;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.SlotCursor;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PlatformInstallManager
implements InstallManager {
    private BDaemonSession daemonSession;
    static /* synthetic */ Class class$javax$baja$platform$install$PlatformPart;
    static /* synthetic */ Class class$com$tridium$platform$daemon$BAppSurrogate;

    public static PlatformInstallManager make(BDaemonSession bDaemonSession) {
        return new PlatformInstallManager(bDaemonSession);
    }

    public PlatformPart[] getPlatformParts(IPlatformOperationListener iPlatformOperationListener) throws Exception {
        PlatformOperationListener platformOperationListener = new PlatformOperationListener(iPlatformOperationListener);
        Class clazz = class$javax$baja$platform$install$PlatformPart;
        if (clazz == null) {
            clazz = class$javax$baja$platform$install$PlatformPart = PlatformInstallManager.class("[Ljavax.baja.platform.install.PlatformPart;", false);
        }
        Array array = new Array(clazz);
        BRemoteDaemonPlatform bRemoteDaemonPlatform = BRemoteDaemonPlatform.make(this.daemonSession, platformOperationListener);
        bRemoteDaemonPlatform.checkSession(platformOperationListener);
        if (!bRemoteDaemonPlatform.getArchPart().isNull()) {
            array.add((Object)bRemoteDaemonPlatform.getArchPart().asPlatformPart());
        }
        if (!bRemoteDaemonPlatform.getOsPart().isNull()) {
            array.add((Object)bRemoteDaemonPlatform.getOsPart().asPlatformPart());
        }
        if (!bRemoteDaemonPlatform.getNrePart().isNull()) {
            array.add((Object)bRemoteDaemonPlatform.getNrePart().asPlatformPart());
        }
        if (!bRemoteDaemonPlatform.getBrandPart().isNull()) {
            array.add((Object)bRemoteDaemonPlatform.getBrandPart().asPlatformPart());
        }
        if (!bRemoteDaemonPlatform.getVmPart().isNull()) {
            array.add((Object)bRemoteDaemonPlatform.getVmPart().asPlatformPart());
        }
        if (!bRemoteDaemonPlatform.getModelPart().isNull()) {
            array.add((Object)bRemoteDaemonPlatform.getModelPart().asPlatformPart());
        }
        SlotCursor slotCursor = bRemoteDaemonPlatform.getOtherParts().getProperties();
        while (slotCursor.next()) {
            array.add((Object)((BPart)slotCursor.get()).asPlatformPart());
        }
        bRemoteDaemonPlatform.getModuleList().init(platformOperationListener);
        slotCursor = bRemoteDaemonPlatform.getModuleList().getModules().getProperties();
        while (slotCursor.next()) {
            array.add((Object)((BModuleInstallable)slotCursor.get()).getModulePart().asPlatformPart());
        }
        return (PlatformPart[])array.trim();
    }

    public InstallationSummary checkInstall(InstallOperation installOperation, IPlatformOperationListener iPlatformOperationListener) throws Exception {
        PlatformInstallOperation platformInstallOperation = (PlatformInstallOperation)installOperation;
        PlatformOperationListener platformOperationListener = new PlatformOperationListener(iPlatformOperationListener);
        this.checkCanceled(platformOperationListener);
        BRemoteDaemonPlatform bRemoteDaemonPlatform = BRemoteDaemonPlatform.make(this.daemonSession, platformOperationListener);
        BDependency[] bDependencyArray = new BDependency[platformInstallOperation.installModuleVersions.size()];
        int n = 0;
        Iterator iterator = platformInstallOperation.installModuleVersions.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Version version = (Version)platformInstallOperation.installModuleVersions.get(string);
            if (version.equals((Object)Version.NULL)) {
                bDependencyArray[n] = BDependency.forModule(string);
                BInstallable bInstallable = LocalInstallableRegistry.getInstance().findInstallable(bDependencyArray[n], platformOperationListener);
                if (bInstallable != null) {
                    bDependencyArray[n] = BDependency.forPart(bInstallable.getPart());
                }
            } else {
                bDependencyArray[n] = new BDependency(string, new BVersion(version.toString()), BModulePart.TYPE.getTypeSpec());
            }
            ++n;
        }
        this.checkCanceled(platformOperationListener);
        iPlatformOperationListener.notifyStatus(Lexicon.make((String)"platform").getText("PlatformInstallManager.checkingDependencies"));
        return new InstallSummaryImpl(InstallScenario.solve((BDaemonPlatform)bRemoteDaemonPlatform, platformOperationListener, (String[])platformInstallOperation.uninstallModuleNames.trim(), bDependencyArray, (BInstallable[])platformInstallOperation.installDists.trim(), (InstallableRegistry)LocalInstallableRegistry.getInstance()));
    }

    public void registerInstallableFile(BIFile bIFile, IPlatformOperationListener iPlatformOperationListener) throws Exception {
        BInstallable bInstallable = BInstallable.make(bIFile);
        if (bInstallable == null) {
            throw new LocalizableRuntimeException("platform", "PlatformInstallManager.fileNotInstallable", new Object[]{bIFile.getFilePath().getBody()});
        }
        LocalInstallableRegistry.getInstance().register(bInstallable, new PlatformOperationListener(iPlatformOperationListener));
    }

    public void install(InstallOperation installOperation, IPlatformOperationListener iPlatformOperationListener) throws Exception {
        BStationStatus bStationStatus;
        int n;
        BAppSurrogate[] bAppSurrogateArray;
        boolean bl;
        BInstallable[] bInstallableArray;
        UnmeetableDependency[] unmeetableDependencyArray;
        PlatformInstallOperation platformInstallOperation = (PlatformInstallOperation)installOperation;
        PlatformOperationListener platformOperationListener = new PlatformOperationListener(iPlatformOperationListener);
        this.checkCanceled(platformOperationListener);
        BRemoteDaemonPlatform bRemoteDaemonPlatform = BRemoteDaemonPlatform.make(this.daemonSession, platformOperationListener);
        BDependency[] bDependencyArray = new BDependency[platformInstallOperation.installModuleVersions.size()];
        int n2 = 0;
        Object object = platformInstallOperation.installModuleVersions.keySet().iterator();
        while (object.hasNext()) {
            unmeetableDependencyArray = (UnmeetableDependency[])object.next();
            bInstallableArray = (BInstallable[])platformInstallOperation.installModuleVersions.get(unmeetableDependencyArray);
            if (bInstallableArray.equals((Object)Version.NULL)) {
                bDependencyArray[n2] = BDependency.forModule((String)unmeetableDependencyArray);
                BInstallable bInstallable = LocalInstallableRegistry.getInstance().findInstallable(bDependencyArray[n2], platformOperationListener);
                if (bInstallable != null) {
                    bDependencyArray[n2] = BDependency.forPart(bInstallable.getPart());
                }
            } else {
                bDependencyArray[n2] = new BDependency((String)unmeetableDependencyArray, new BVersion(bInstallableArray.toString()), BModulePart.TYPE.getTypeSpec());
            }
            ++n2;
        }
        this.checkCanceled(platformOperationListener);
        iPlatformOperationListener.notifyStatus(Lexicon.make((String)"platform").getText("PlatformInstallManager.checkingDependencies"));
        object = InstallScenario.solve((BDaemonPlatform)bRemoteDaemonPlatform, platformOperationListener, (String[])platformInstallOperation.uninstallModuleNames.trim(), bDependencyArray, (BInstallable[])platformInstallOperation.installDists.trim(), (InstallableRegistry)LocalInstallableRegistry.getInstance());
        unmeetableDependencyArray = ((InstallScenario)object).getUnmeetableDependencies();
        if (unmeetableDependencyArray.length > 0) {
            throw new LocalizableRuntimeException("platform", "PlatformInstallManager.unmetDependencies", new Object[]{unmeetableDependencyArray[0]});
        }
        bInstallableArray = ((InstallScenario)object).getExcludedInstallables();
        if (bInstallableArray.length > 0) {
            throw new LocalizableRuntimeException("platform", "PlatformInstallManager.excludedInstallables", new Object[]{bInstallableArray[0].getInstallableFileName()});
        }
        this.checkCanceled(platformOperationListener);
        long l = ((InstallScenario)object).getProcessingFlags();
        boolean bl2 = false;
        if (!platformInstallOperation.ignoreTcpIpChanges && (l & 0x80000L) > 0L) {
            bl2 = bl = true;
        }
        if (((InstallScenario)object).getTcpIpChanges() != null && ((InstallScenario)object).getTcpIpChanges().getIsReadonly()) {
            bl = false;
        }
        if (!this.daemonSession.getHostProperties().hasFullAccess() && (bl || (l & 0x30000L) > 0L)) {
            throw new LocalizableRuntimeException("platform", "PlatformInstallManager.insufficientAccess");
        }
        Class clazz = class$com$tridium$platform$daemon$BAppSurrogate;
        if (clazz == null) {
            clazz = class$com$tridium$platform$daemon$BAppSurrogate = PlatformInstallManager.class("[Lcom.tridium.platform.daemon.BAppSurrogate;", false);
        }
        Array array = new Array(clazz);
        if ((l & (long)4) > 0L && (l & 1L) == 0L && (l & (long)2) == 0L) {
            bAppSurrogateArray = BAppSurrogate.makeAll(null, this.daemonSession);
            n = 0;
            while (n < bAppSurrogateArray.length) {
                bStationStatus = bAppSurrogateArray[n].getAppStatus();
                if (bAppSurrogateArray[n] instanceof BStationSurrogate && (bStationStatus == BStationStatus.starting || bStationStatus == BStationStatus.stopping)) {
                    l |= (long)2;
                    break;
                }
                ++n;
            }
        }
        if ((l & 1L) > 0L || (l & (long)2) > 0L || (l & (long)4) > 0L) {
            bAppSurrogateArray = BAppSurrogate.makeAll(null, this.daemonSession);
            n = 0;
            while (n < bAppSurrogateArray.length) {
                bStationStatus = bAppSurrogateArray[n].getAppStatus();
                if (!(bStationStatus != BStationStatus.starting && bStationStatus != BStationStatus.running && bStationStatus != BStationStatus.stopping || (l & 1L) <= 0L && !(bAppSurrogateArray[n] instanceof BStationSurrogate))) {
                    array.add((Object)bAppSurrogateArray[n]);
                }
                ++n;
            }
        }
        if ((l & 1L) > 0L || (l & (long)2) > 0L) {
            bAppSurrogateArray = BAppSurrogate.stopAllApps(this.daemonSession, (l & 1L) > 0L ? null : BStationSurrogate.TYPE, platformOperationListener, platformOperationListener);
            BStationSurrogate[] bStationSurrogateArray = BStationSurrogate.makeAll(this.daemonSession);
            int n3 = 0;
            block3: while (n3 < bStationSurrogateArray.length) {
                if (bStationSurrogateArray[n3].getStationStatus() != BStationStatus.idle) {
                    BInstallable[] bInstallableArray2 = ((InstallScenario)object).getToInstall();
                    int n4 = 0;
                    while (n4 < bInstallableArray2.length) {
                        BPart bPart = bInstallableArray2[n4].getPart();
                        if (bPart != null && bPart instanceof BNrePart) {
                            DaemonPlatformUtil.doExtraStationShutdownTasks(bRemoteDaemonPlatform, platformOperationListener, platformOperationListener);
                            break block3;
                        }
                        ++n4;
                    }
                    break;
                }
                ++n3;
            }
            if (bAppSurrogateArray.length > 0) {
                n3 = 0;
                while (n3 < bAppSurrogateArray.length) {
                    iPlatformOperationListener.notifyStatus(Lexicon.make((String)"platform").getText("PlatformInstallManager.stoppedApp", new Object[]{bAppSurrogateArray[n3].getAppName()}));
                    ++n3;
                }
            }
        } else {
            bAppSurrogateArray = (BAppSurrogate[])array.trim();
        }
        this.checkCanceled(platformOperationListener);
        iPlatformOperationListener.notifyStatus(Lexicon.make((String)"platform").getText("PlatformInstallManager.committing"));
        ((InstallScenario)object).commit((DaemonSessionTaskListener)platformOperationListener, platformOperationListener, platformInstallOperation.ignoreAuthChanges);
        if (bl) {
            iPlatformOperationListener.notifyStatus(Lexicon.make((String)"platform").getText("PlatformInstallManager.tcpInstall"));
            TcpUtil.saveToSession(((InstallScenario)object).getTcpIpChanges(), this.daemonSession, false);
        }
        if ((l & 0x20000L) > 0L) {
            iPlatformOperationListener.notifyStatus(Lexicon.make((String)"platform").getText("PlatformInstallManager.osInstall"));
            this.daemonSession.sendMessage(OSUpdateMessage.getInstance());
        }
        if ((l & 0x10000L) > 0L) {
            iPlatformOperationListener.notifyStatus(Lexicon.make((String)"platform").getText("PlatformInstallManager.reboot"));
            this.daemonSession.sendRebootRequest();
        } else if ((l & 0x40000L) > 0L) {
            iPlatformOperationListener.notifyStatus(Lexicon.make((String)"platform").getText("PlatformInstallManager.updateDaemon"));
            this.daemonSession.sendMessage(RefreshDaemonBinariesMessage.getInstance());
        } else if ((l & (long)4) > 0L && (l & (long)2) == 0L && (l & 1L) == 0L) {
            int n5 = 0;
            while (n5 < bAppSurrogateArray.length) {
                if (bAppSurrogateArray[n5] instanceof BStationSurrogate) {
                    ((BStationSurrogate)bAppSurrogateArray[n5]).syncStationModulesAsync();
                }
                ++n5;
            }
        }
        iPlatformOperationListener.notifyStatus(Lexicon.make((String)"platform").getText("PlatformInstallManager.success"));
    }

    private final void checkCanceled(PlatformOperationListener platformOperationListener) {
        if (platformOperationListener.isCanceled()) {
            throw new ICancelHint.CanceledException();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private PlatformInstallManager(BDaemonSession bDaemonSession) {
        this.daemonSession = bDaemonSession;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class InstallSummaryImpl
    implements InstallationSummary {
        private InstallScenario scenario;
        static /* synthetic */ Class class$javax$baja$file$BIFile;

        public BIFile[] getFilesToInstall() {
            Class clazz = class$javax$baja$file$BIFile;
            if (clazz == null) {
                clazz = class$javax$baja$file$BIFile = InstallSummaryImpl.class("[Ljavax.baja.file.BIFile;", false);
            }
            Array array = new Array(clazz);
            int n = 0;
            while (n < this.scenario.getToInstall().length) {
                array.add((Object)((BIFile)this.scenario.getToInstall()[n].getInstallableFileOrd().get()));
                ++n;
            }
            return (BIFile[])array.trim();
        }

        public String[] getModulesToUninstall() {
            return this.scenario.getModulesToUninstall();
        }

        public PlatformDependency[] getUnmetDependencies() {
            UnmeetableDependency[] unmeetableDependencyArray = this.scenario.getUnmeetableDependencies();
            PlatformDependency[] platformDependencyArray = new PlatformDependency[unmeetableDependencyArray.length];
            int n = 0;
            while (n < unmeetableDependencyArray.length) {
                platformDependencyArray[n] = unmeetableDependencyArray[n].dependency.asPlatformDependency();
                ++n;
            }
            return platformDependencyArray;
        }

        public BIFile[] getExcludedFiles() {
            BInstallable[] bInstallableArray = this.scenario.getExcludedInstallables();
            BIFile[] bIFileArray = new BIFile[bInstallableArray.length];
            int n = 0;
            while (n < bInstallableArray.length) {
                bIFileArray[n] = (BIFile)bInstallableArray[n].getInstallableFileOrd().get();
                ++n;
            }
            return bIFileArray;
        }

        public boolean canInstall() {
            return this.scenario.canCommit();
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        public InstallSummaryImpl(InstallScenario installScenario) {
            this.scenario = installScenario;
        }
    }
}

