/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.install.part.BGenericPart;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.daemon.BDaemonAccessLevel;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.ewf.BEwfBootCommand;
import com.tridium.platform.ewf.BEwfEnableState;
import com.tridium.platform.ewf.BEwfOverlayAttributes;
import com.tridium.platform.timezone.BDstSupportLevel;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BHostProperties
extends BComponent {
    public static final Property hostId = BHostProperties.newProperty((int)3, (String)"", null);
    public static final Property brandId = BHostProperties.newProperty((int)3, (String)"", null);
    public static final Property sessionTimestamp = BHostProperties.newProperty((int)3, (String)"", null);
    public static final Property moduleContent = BHostProperties.newProperty((int)3, (BValue)BModuleContent.doc, null);
    public static final Property httpPort = BHostProperties.newProperty((int)3, (int)-1, null);
    public static final Property stripLineNumbers = BHostProperties.newProperty((int)3, (boolean)false, null);
    public static final Property hostArch = BHostProperties.newProperty((int)3, (String)"unknown", null);
    public static final Property modelName = BHostProperties.newProperty((int)3, (String)"unknown", null);
    public static final Property osCrcText = BHostProperties.newProperty((int)3, (String)"-1", null);
    public static final Property osName = BHostProperties.newProperty((int)3, (String)"unknown", null);
    public static final Property osDesc = BHostProperties.newProperty((int)3, (String)"unknown", null);
    public static final Property osVersion = BHostProperties.newProperty((int)3, (String)"", null);
    public static final Property osInstallable = BHostProperties.newProperty((int)3, (boolean)false, null);
    public static final Property nrePartName = BHostProperties.newProperty((int)3, (String)"unknown", null);
    public static final Property nrePartDesc = BHostProperties.newProperty((int)3, (String)"unknown", null);
    public static final Property nrePartVersion = BHostProperties.newProperty((int)3, (String)"", null);
    public static final Property vmName = BHostProperties.newProperty((int)3, (String)"unknown", null);
    public static final Property vmVendor = BHostProperties.newProperty((int)3, (String)"unknown", null);
    public static final Property vmVersion = BHostProperties.newProperty((int)3, (String)"", null);
    public static final Property isVmUnspecified = BHostProperties.newProperty((int)3, (boolean)false, null);
    public static final Property parts = BHostProperties.newProperty((int)3, (BValue)new BVector(), null);
    public static final Property isDirty = BHostProperties.newProperty((int)3, (boolean)true, null);
    public static final Property servletNames = BHostProperties.newProperty((int)3, (BValue)new BVector(), null);
    public static final Property maxStations = BHostProperties.newProperty((int)3, (int)1, null);
    public static final Property maxSedonaApps = BHostProperties.newProperty((int)3, (int)1, null);
    public static final Property numCpus = BHostProperties.newProperty((int)3, (int)1, null);
    public static final Property currentCpuUsage = BHostProperties.newProperty((int)3, (int)-1, null);
    public static final Property overallCpuUsage = BHostProperties.newProperty((int)3, (int)-1, null);
    public static final Property totalPhysicalMemory = BHostProperties.newProperty((int)3, (int)-1, null);
    public static final Property freePhysicalMemory = BHostProperties.newProperty((int)3, (int)-1, null);
    public static final Property filesystemAttributes = BHostProperties.newProperty((int)3, (BValue)new BVector(), null);
    public static final Property timezoneDayModeSupport = BHostProperties.newProperty((int)3, (BValue)BDstSupportLevel.none, null);
    public static final Property accessLevel = BHostProperties.newProperty((int)3, (BValue)BDaemonAccessLevel.restricted, null);
    public static final Property allowStationRestart = BHostProperties.newProperty((int)3, (boolean)true, null);
    public static final Property failureRebootLimit = BHostProperties.newProperty((int)3, (int)3, null);
    public static final Property failureRebootLimitPeriod = BHostProperties.newProperty((int)3, (BValue)BRelTime.HOUR, null);
    public static final Property ewfOverlays = BHostProperties.newProperty((int)3, (BValue)new BVector(), null);
    public static final Property configDistFileName = BHostProperties.newProperty((int)3, (String)"nre-config-*.dist", null);
    public static final Property isNpsdk = BHostProperties.newProperty((int)3, (boolean)false, null);
    public static final Property sedonaSupported = BHostProperties.newProperty((int)3, (boolean)false, null);
    public static final Property sedonaEnabled = BHostProperties.newProperty((int)3, (boolean)false, null);
    public static final Property niagaraStationsEnabled = BHostProperties.newProperty((int)3, (boolean)true, null);
    public static final Property niagaraR2Supported = BHostProperties.newProperty((int)3, (boolean)false, null);
    public static final Property niagaraR2Enabled = BHostProperties.newProperty((int)3, (boolean)false, null);
    public static final Property sslSupported = BHostProperties.newProperty((int)3, (boolean)false, null);
    public static final Property sslSettings = BHostProperties.newProperty((int)3, (BValue)new BPlatformSSLSettings(), null);
    public static final Topic hostPropertiesChanged = BHostProperties.newTopic((int)0, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$platform$daemon$BHostProperties;

    public String getHostId() {
        return this.getString(hostId);
    }

    public void setHostId(String string) {
        this.setString(hostId, string, null);
    }

    public String getBrandId() {
        return this.getString(brandId);
    }

    public void setBrandId(String string) {
        this.setString(brandId, string, null);
    }

    public String getSessionTimestamp() {
        return this.getString(sessionTimestamp);
    }

    public void setSessionTimestamp(String string) {
        this.setString(sessionTimestamp, string, null);
    }

    public BModuleContent getModuleContent() {
        return (BModuleContent)this.get(moduleContent);
    }

    public void setModuleContent(BModuleContent bModuleContent) {
        this.set(moduleContent, (BValue)bModuleContent, null);
    }

    public int getHttpPort() {
        return this.getInt(httpPort);
    }

    public void setHttpPort(int n) {
        this.setInt(httpPort, n, null);
    }

    public boolean getStripLineNumbers() {
        return this.getBoolean(stripLineNumbers);
    }

    public void setStripLineNumbers(boolean bl) {
        this.setBoolean(stripLineNumbers, bl, null);
    }

    public String getHostArch() {
        return this.getString(hostArch);
    }

    public void setHostArch(String string) {
        this.setString(hostArch, string, null);
    }

    public String getModelName() {
        return this.getString(modelName);
    }

    public void setModelName(String string) {
        this.setString(modelName, string, null);
    }

    public String getOsCrcText() {
        return this.getString(osCrcText);
    }

    public void setOsCrcText(String string) {
        this.setString(osCrcText, string, null);
    }

    public String getOsName() {
        return this.getString(osName);
    }

    public void setOsName(String string) {
        this.setString(osName, string, null);
    }

    public String getOsDesc() {
        return this.getString(osDesc);
    }

    public void setOsDesc(String string) {
        this.setString(osDesc, string, null);
    }

    public String getOsVersion() {
        return this.getString(osVersion);
    }

    public void setOsVersion(String string) {
        this.setString(osVersion, string, null);
    }

    public boolean getOsInstallable() {
        return this.getBoolean(osInstallable);
    }

    public void setOsInstallable(boolean bl) {
        this.setBoolean(osInstallable, bl, null);
    }

    public String getNrePartName() {
        return this.getString(nrePartName);
    }

    public void setNrePartName(String string) {
        this.setString(nrePartName, string, null);
    }

    public String getNrePartDesc() {
        return this.getString(nrePartDesc);
    }

    public void setNrePartDesc(String string) {
        this.setString(nrePartDesc, string, null);
    }

    public String getNrePartVersion() {
        return this.getString(nrePartVersion);
    }

    public void setNrePartVersion(String string) {
        this.setString(nrePartVersion, string, null);
    }

    public String getVmName() {
        return this.getString(vmName);
    }

    public void setVmName(String string) {
        this.setString(vmName, string, null);
    }

    public String getVmVendor() {
        return this.getString(vmVendor);
    }

    public void setVmVendor(String string) {
        this.setString(vmVendor, string, null);
    }

    public String getVmVersion() {
        return this.getString(vmVersion);
    }

    public void setVmVersion(String string) {
        this.setString(vmVersion, string, null);
    }

    public boolean getIsVmUnspecified() {
        return this.getBoolean(isVmUnspecified);
    }

    public void setIsVmUnspecified(boolean bl) {
        this.setBoolean(isVmUnspecified, bl, null);
    }

    public BVector getParts() {
        return (BVector)this.get(parts);
    }

    public void setParts(BVector bVector) {
        this.set(parts, (BValue)bVector, null);
    }

    public boolean getIsDirty() {
        return this.getBoolean(isDirty);
    }

    public void setIsDirty(boolean bl) {
        this.setBoolean(isDirty, bl, null);
    }

    public BVector getServletNames() {
        return (BVector)this.get(servletNames);
    }

    public void setServletNames(BVector bVector) {
        this.set(servletNames, (BValue)bVector, null);
    }

    public int getMaxStations() {
        return this.getInt(maxStations);
    }

    public void setMaxStations(int n) {
        this.setInt(maxStations, n, null);
    }

    public int getMaxSedonaApps() {
        return this.getInt(maxSedonaApps);
    }

    public void setMaxSedonaApps(int n) {
        this.setInt(maxSedonaApps, n, null);
    }

    public int getNumCpus() {
        return this.getInt(numCpus);
    }

    public void setNumCpus(int n) {
        this.setInt(numCpus, n, null);
    }

    public int getCurrentCpuUsage() {
        return this.getInt(currentCpuUsage);
    }

    public void setCurrentCpuUsage(int n) {
        this.setInt(currentCpuUsage, n, null);
    }

    public int getOverallCpuUsage() {
        return this.getInt(overallCpuUsage);
    }

    public void setOverallCpuUsage(int n) {
        this.setInt(overallCpuUsage, n, null);
    }

    public int getTotalPhysicalMemory() {
        return this.getInt(totalPhysicalMemory);
    }

    public void setTotalPhysicalMemory(int n) {
        this.setInt(totalPhysicalMemory, n, null);
    }

    public int getFreePhysicalMemory() {
        return this.getInt(freePhysicalMemory);
    }

    public void setFreePhysicalMemory(int n) {
        this.setInt(freePhysicalMemory, n, null);
    }

    public BVector getFilesystemAttributes() {
        return (BVector)this.get(filesystemAttributes);
    }

    public void setFilesystemAttributes(BVector bVector) {
        this.set(filesystemAttributes, (BValue)bVector, null);
    }

    public BDstSupportLevel getTimezoneDayModeSupport() {
        return (BDstSupportLevel)this.get(timezoneDayModeSupport);
    }

    public void setTimezoneDayModeSupport(BDstSupportLevel bDstSupportLevel) {
        this.set(timezoneDayModeSupport, (BValue)bDstSupportLevel, null);
    }

    public BDaemonAccessLevel getAccessLevel() {
        return (BDaemonAccessLevel)this.get(accessLevel);
    }

    public void setAccessLevel(BDaemonAccessLevel bDaemonAccessLevel) {
        this.set(accessLevel, (BValue)bDaemonAccessLevel, null);
    }

    public boolean getAllowStationRestart() {
        return this.getBoolean(allowStationRestart);
    }

    public void setAllowStationRestart(boolean bl) {
        this.setBoolean(allowStationRestart, bl, null);
    }

    public int getFailureRebootLimit() {
        return this.getInt(failureRebootLimit);
    }

    public void setFailureRebootLimit(int n) {
        this.setInt(failureRebootLimit, n, null);
    }

    public BRelTime getFailureRebootLimitPeriod() {
        return (BRelTime)this.get(failureRebootLimitPeriod);
    }

    public void setFailureRebootLimitPeriod(BRelTime bRelTime) {
        this.set(failureRebootLimitPeriod, (BValue)bRelTime, null);
    }

    public BVector getEwfOverlays() {
        return (BVector)this.get(ewfOverlays);
    }

    public void setEwfOverlays(BVector bVector) {
        this.set(ewfOverlays, (BValue)bVector, null);
    }

    public String getConfigDistFileName() {
        return this.getString(configDistFileName);
    }

    public void setConfigDistFileName(String string) {
        this.setString(configDistFileName, string, null);
    }

    public boolean getIsNpsdk() {
        return this.getBoolean(isNpsdk);
    }

    public void setIsNpsdk(boolean bl) {
        this.setBoolean(isNpsdk, bl, null);
    }

    public boolean getSedonaSupported() {
        return this.getBoolean(sedonaSupported);
    }

    public void setSedonaSupported(boolean bl) {
        this.setBoolean(sedonaSupported, bl, null);
    }

    public boolean getSedonaEnabled() {
        return this.getBoolean(sedonaEnabled);
    }

    public void setSedonaEnabled(boolean bl) {
        this.setBoolean(sedonaEnabled, bl, null);
    }

    public boolean getNiagaraStationsEnabled() {
        return this.getBoolean(niagaraStationsEnabled);
    }

    public void setNiagaraStationsEnabled(boolean bl) {
        this.setBoolean(niagaraStationsEnabled, bl, null);
    }

    public boolean getNiagaraR2Supported() {
        return this.getBoolean(niagaraR2Supported);
    }

    public void setNiagaraR2Supported(boolean bl) {
        this.setBoolean(niagaraR2Supported, bl, null);
    }

    public boolean getNiagaraR2Enabled() {
        return this.getBoolean(niagaraR2Enabled);
    }

    public void setNiagaraR2Enabled(boolean bl) {
        this.setBoolean(niagaraR2Enabled, bl, null);
    }

    public boolean getSslSupported() {
        return this.getBoolean(sslSupported);
    }

    public void setSslSupported(boolean bl) {
        this.setBoolean(sslSupported, bl, null);
    }

    public BPlatformSSLSettings getSslSettings() {
        return (BPlatformSSLSettings)this.get(sslSettings);
    }

    public void setSslSettings(BPlatformSSLSettings bPlatformSSLSettings) {
        this.set(sslSettings, (BValue)bPlatformSSLSettings, null);
    }

    public void fireHostPropertiesChanged(BValue bValue) {
        this.fire(hostPropertiesChanged, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getPartDescription(String string) {
        BValue bValue = this.getParts().loadSlots().get(string);
        return bValue == null ? null : bValue.toString();
    }

    public boolean hasFullAccess() {
        boolean bl = false;
        if (this.getAccessLevel() == BDaemonAccessLevel.full) {
            bl = true;
        }
        return bl;
    }

    public long getOsCrc() {
        return Long.parseLong(this.getOsCrcText());
    }

    public void reset() {
        this.getParts().removeAll();
        this.getServletNames().removeAll();
        this.copyFrom((BComplex)new BHostProperties());
    }

    public void checkTimestamp(String string) {
        if (!this.getSessionTimestamp().equals(string)) {
            this.reset();
            this.setSessionTimestamp(string);
        }
    }

    public void loadServletsInfo(XElem xElem) throws Exception {
        this.getServletNames().removeAll();
        this.setAccessLevel(BDaemonAccessLevel.restricted);
        XElem[] xElemArray = xElem.elems("servlet");
        int n = 0;
        while (n < xElemArray.length) {
            String string = xElemArray[n].get("name");
            this.getServletNames().add(string, (BValue)BString.make((String)string));
            if (string.equals("reboot")) {
                this.setAccessLevel(BDaemonAccessLevel.full);
            }
            ++n;
        }
    }

    public boolean supportsServlet(String string) {
        boolean bl = false;
        if (this.getServletNames().getProperty(string) != null) {
            bl = true;
        }
        return bl;
    }

    public void load(XElem xElem) throws Exception {
        XElem xElem2;
        boolean bl;
        Object object;
        XElem xElem3;
        this.removeAll();
        this.setHostId(xElem.get("hostId"));
        this.setHttpPort(xElem.geti("httpPort", -1));
        String string = xElem.get("brandId", "noBrand");
        if (string.trim().length() == 0) {
            string = "noBrand";
        }
        this.setBrandId(string);
        String string2 = xElem.get("moduleContent", null);
        if (string2 == null) {
            string2 = xElem.get("installFlag", null);
        }
        if (string2 == null) {
            string2 = xElem.getb("embedded", false) ? "runtime" : "doc";
        }
        this.setModuleContent(BModuleContent.make(string2));
        if (xElem.get("stripLineNumbers", null) != null) {
            this.setStripLineNumbers(xElem.getb("stripLineNumbers", false));
        } else {
            this.setStripLineNumbers(xElem.getb("embedded", false));
        }
        if (xElem.get("maxStations", null) != null) {
            this.setMaxStations(xElem.geti("maxStations", 32));
        } else if (xElem.getb("embedded", false)) {
            this.setMaxStations(1);
        } else {
            this.setMaxStations(32);
        }
        if (xElem.get("maxSedonaApps", null) != null) {
            this.setMaxSedonaApps(xElem.geti("maxSedonaApps", (int)((char)-1)));
        } else if (xElem.getb("embedded", false)) {
            this.setMaxSedonaApps(1);
        } else {
            this.setMaxSedonaApps((char)-1);
        }
        this.setFailureRebootLimit(xElem.geti("failureRebootLimit", 3));
        if (xElem.get("failureRebootLimitPeriod", null) != null) {
            this.setFailureRebootLimitPeriod(BRelTime.make((long)xElem.getl("failureRebootLimitPeriod")));
        } else {
            this.setFailureRebootLimitPeriod(BRelTime.HOUR);
        }
        this.setConfigDistFileName(xElem.get("configDistFileName", "nre-config-*.dist"));
        this.setIsNpsdk(xElem.getb("npsdk", false));
        this.setSedonaSupported(xElem.getb("sedonaSupported", false));
        this.setSedonaEnabled(xElem.getb("sedonaEnabled", false));
        this.setNiagaraStationsEnabled(xElem.getb("niagaraStationsEnabled", true));
        this.setNiagaraR2Supported(xElem.getb("niagaraR2Supported", false));
        this.setNiagaraR2Enabled(xElem.getb("niagaraR2Enabled", false));
        String string3 = xElem.get("arch", null);
        if (string3 != null) {
            if (string3.equals("amd64")) {
                string3 = "x64";
            }
            this.setHostArch(string3);
        }
        if ((xElem3 = xElem.elem("vm")) != null) {
            object = xElem3.get("name", null);
            if (object == null || ((String)object).indexOf("Undetermined") != -1) {
                this.setIsVmUnspecified(true);
            } else {
                this.setVmName((String)object);
                this.setVmVendor(xElem3.get("vendor", "unknown"));
                this.setVmVersion(xElem3.get("version", ""));
            }
        }
        if ((object = xElem.elem("os")) != null) {
            this.setOsName(object.get("name", "unknown"));
            string3 = object.get("arch", null);
            if (string3 != null) {
                this.setHostArch(string3);
            }
            this.setOsDesc(object.get("desc", "unknown"));
            this.setOsVersion(object.get("version", ""));
            this.setOsCrcText(object.get("crc", "-1"));
            bl = this.getOsName().toLowerCase().startsWith("qnx");
            this.setOsInstallable(object.getb("installable", bl));
        }
        bl = this.getOsName().toLowerCase().startsWith("win");
        this.setAllowStationRestart(xElem.getb("allowStationRestart", bl));
        XElem xElem4 = xElem.elem("nre");
        if (xElem4 != null) {
            this.setNrePartName(xElem4.get("name", "unknown"));
            this.setNrePartDesc(xElem4.get("desc", "unknown"));
            this.setNrePartVersion(xElem4.get("version", ""));
        }
        if ((xElem2 = xElem.elem("model")) != null) {
            this.setModelName(xElem2.get("name", "unknown"));
        }
        this.getParts().removeAll();
        XElem[] xElemArray = xElem.elems("part");
        int n = 0;
        while (n < xElemArray.length) {
            this.getParts().add(SlotPath.escape((String)xElemArray[n].get("name")), (BValue)BGenericPart.make(xElemArray[n]));
            ++n;
        }
        this.update(xElem);
    }

    public void update(XElem xElem) {
        XElem xElem2;
        XElem xElem3;
        Object object;
        Object object2;
        XElem xElem4;
        XElem xElem5 = xElem.elem("filesystems");
        if (xElem5 != null) {
            xElem4 = xElem5.elems("filesystem");
            int n = 0;
            while (n < ((XElem)xElem4).length) {
                object2 = SlotPath.escape((String)xElem4[n].get("name"));
                object = (BFilesystemAttributes)this.getFilesystemAttributes().get((String)object2);
                if (object == null) {
                    object = new BFilesystemAttributes(xElem4[n].getl("totalBytes") / 1024L, xElem4[n].getl("freeBytes") / 1024L, xElem4[n].geti("blockSize"), xElem4[n].getl("maxFileCount", (long)-1), xElem4[n].getl("currentFileCount", (long)-1), xElem4[n].getb("isFlash", false));
                    this.getFilesystemAttributes().add((String)object2, (BValue)object);
                } else {
                    object.setTotalSpace(xElem4[n].getl("totalBytes") / 1024L);
                    object.setFreeSpace(xElem4[n].getl("freeBytes") / 1024L);
                    object.setBlockSize(xElem4[n].geti("blockSize"));
                    object.setMaxFileCount(xElem4[n].getl("maxFileCount", (long)-1));
                    object.setCurrentFileCount(xElem4[n].getl("currentFileCount", (long)-1));
                    object.setIsFlash(xElem4[n].getb("isFlash", false));
                }
                ++n;
            }
        }
        if ((xElem4 = xElem.elem("cpu")) != null) {
            this.setCurrentCpuUsage(xElem4.geti("currentUtilization", -1));
            this.setOverallCpuUsage(xElem4.geti("overallUtilization", -1));
            this.setNumCpus(xElem4.geti("nCpus", 1));
        }
        if ((xElem3 = xElem.elem("physicalMemory")) != null) {
            this.setTotalPhysicalMemory((int)(xElem3.getl("totalBytes") / 1024L));
            this.setFreePhysicalMemory((int)(xElem3.getl("freeBytes") / 1024L));
        }
        if ((object2 = xElem.elem("tzSupport")) != null) {
            this.setTimezoneDayModeSupport(BDstSupportLevel.make(object2.get("dayMode", "none")));
        }
        if ((object = xElem.elem("sslSupported")) != null) {
            this.setSslSupported(true);
            if (this.getSslSettings() == null) {
                this.setSslSettings(new BPlatformSSLSettings());
            }
            this.getSslSettings().updateFromXml((XElem)object);
        }
        if ((xElem2 = xElem.elem("ewf")) != null) {
            XElem[] xElemArray = xElem2.elems("overlay");
            int n = 0;
            while (n < xElemArray.length) {
                String string = SlotPath.escape((String)xElemArray[n].get("drive"));
                BEwfOverlayAttributes bEwfOverlayAttributes = (BEwfOverlayAttributes)this.getEwfOverlays().get(string);
                if (bEwfOverlayAttributes == null) {
                    bEwfOverlayAttributes = new BEwfOverlayAttributes(BEwfEnableState.make(xElemArray[n].geti("state")), BEwfBootCommand.make(xElemArray[n].geti("command")), (double)xElemArray[n].getl("ramUsage") / 1048576.0);
                    this.getEwfOverlays().add(string, (BValue)bEwfOverlayAttributes);
                } else {
                    bEwfOverlayAttributes.setEnableState(BEwfEnableState.make(xElemArray[n].geti("state")));
                    bEwfOverlayAttributes.setBootCommand(BEwfBootCommand.make(xElemArray[n].geti("command")));
                    bEwfOverlayAttributes.setRamUsage((double)xElemArray[n].getl("ramUsage") / 1048576.0);
                }
                ++n;
            }
        }
        this.fireHostPropertiesChanged(null);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$platform$daemon$BHostProperties;
        if (clazz == null) {
            clazz = class$com$tridium$platform$daemon$BHostProperties = BHostProperties.class("[Lcom.tridium.platform.daemon.BHostProperties;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

