/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.net.HttpUtil;
import com.tridium.platform.BOperatingSystemEnum;
import com.tridium.platform.BPlatform;
import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.BSessionNavNode;
import com.tridium.platform.BSessionNavNodeFactory;
import com.tridium.platform.daemon.Authenticator;
import com.tridium.platform.daemon.BDaemonScheme;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.DaemonResponseException;
import com.tridium.platform.daemon.DaemonSSLRequiredException;
import com.tridium.platform.daemon.DaemonSessionListener;
import com.tridium.platform.daemon.DaemonText;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.daemon.PostOutputStream;
import com.tridium.platform.daemon.file.BDefaultDaemonFileSpace;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.GetDirectoryMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.sys.Nre;
import com.tridium.sys.license.Brand;
import com.tridium.sys.registry.NAgentInfo;
import com.tridium.util.BSessionInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.file.FilePath;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.log.Log;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BIpHost;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BSession;
import javax.baja.naming.OrdQuery;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.net.BInternetAddress;
import javax.baja.net.Http;
import javax.baja.net.HttpConnection;
import javax.baja.nre.util.Array;
import javax.baja.platform.ICancelHint;
import javax.baja.registry.TypeInfo;
import javax.baja.security.AuthenticationException;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDaemonSession
extends BSession {
    public static final Type TYPE;
    private static final BIcon iconConnected;
    private static final BIcon iconDisconnected;
    private static final BIcon tunnelIconConnected;
    private static final BIcon tunnelIconDisconnected;
    public static boolean debug;
    public static final int INFINITE_TIMEOUT = 0;
    public static int DEFAULT_TIMEOUT;
    private static final long FIVE_MINUTES = 300000L;
    public static final int STATION_OVERRIDE_NONE = 0;
    public static final int STATION_OVERRIDE_START = 1;
    public static final int STATION_OVERRIDE_STOP = 2;
    public static final int PORT_UNKNOWN = -1;
    public static final int UNKNOWN_CONTENT_LENGTH = -1;
    private static Version requiredVersion;
    private static Version requiredVersionForTunnel;
    private static RebootMessage rebootMessage;
    private static RebootMessage forceRebootMessage;
    private static String[] brandIdHolder;
    public static final int FLAGS_NONE = 0;
    public static final int FLAGS_NO_CONNECTED_NOTIFY = 1;
    public static final int FLAGS_NO_AUTH_NOTIFY = 2;
    public static final int FLAGS_DISCONNECT = 4;
    public static final int FLAGS_CLOSE = 8;
    public static final int FLAGS_CLEAR_CREDENTIALS = 16;
    public static final int FLAGS_EXPECT_CONTINUE = 32;
    private static final int MAX_REDIRECT_PAYLOAD = 75;
    public static Log log;
    private AgentList agentList;
    protected String[] tunnelAuthorities;
    private Properties cachedNonceValue;
    private BHost host;
    private int port;
    private BOrd ordInHost;
    private BOrd absOrd;
    private Authenticator authenticator;
    private BHostProperties hostProperties;
    private boolean localEnvironment;
    private long lastConnectTicks;
    private long lastConnectedTime;
    protected BSessionNavNodeFactory[] navFactories;
    private boolean connected;
    private boolean inInit;
    private HashSet listeners;
    static /* synthetic */ Class class$com$tridium$platform$daemon$BDaemonSession;
    static /* synthetic */ Class class$javax$baja$nav$BINavNode;

    public static BDaemonSession make(BHost bHost, int n) {
        return BDaemonSession.make(bHost, n, null);
    }

    public static BDaemonSession make(BHost bHost, int n, String string) {
        String[] stringArray = null;
        if (string != null) {
            stringArray = new String[]{string};
        }
        return BDaemonSession.make(bHost, n, stringArray);
    }

    public static BDaemonSession make(BHost bHost, int n, String[] stringArray) {
        BDaemonSession bDaemonSession;
        StringBuffer stringBuffer = new StringBuffer("platform");
        if (n != 3011) {
            stringBuffer.append(":").append(n);
        }
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2] != null) {
                    stringBuffer.append("/").append(stringArray[n2]);
                }
                ++n2;
            }
        }
        if ((bDaemonSession = (BDaemonSession)bHost.getNavChild(stringBuffer.toString())) == null) {
            bDaemonSession = new BDaemonSession(stringBuffer.toString(), bHost, n, stringArray);
            bHost.addNavChild((BINavNode)bDaemonSession);
        }
        return bDaemonSession;
    }

    public static BDaemonSession makeIgnoringCache(BHost bHost, int n, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("noCache:platform");
        if (n != 3011) {
            stringBuffer.append(":").append(n);
        }
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2] != null) {
                    stringBuffer.append("/").append(stringArray[n2]);
                }
                ++n2;
            }
        }
        return new BDaemonSession(stringBuffer.toString(), bHost, n, stringArray);
    }

    public BDaemonSession newSession(int n) {
        String[] stringArray = null;
        if (this.getTunnelAuthorities() != null && this.getTunnelAuthorities().length > 0) {
            stringArray = this.getTunnelAuthorities();
            int n2 = stringArray.length - 1;
            BInternetAddress bInternetAddress = new BInternetAddress(stringArray[n2]);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(bInternetAddress.getHost());
            if (n != this.getDefaultPort()) {
                stringBuffer.append(":" + n);
            }
            stringArray[n2] = stringBuffer.toString();
        }
        return this.makeNewSession(this.getHost(), n, stringArray);
    }

    protected BDaemonSession makeNewSession(BHost bHost, int n, String[] stringArray) {
        return BDaemonSession.make(bHost, n, stringArray);
    }

    public void close() {
        this.disconnect(true);
        this.host.removeNavChild((BINavNode)this);
    }

    public synchronized void connect() throws Exception {
        this.connect(DEFAULT_TIMEOUT);
    }

    public synchronized void connect(int n) throws Exception {
        if (!this.isConnected() || Clock.ticks() - this.lastConnectTicks > 300000L) {
            this.initHostProperties(true, n);
        }
        this.notifyConnected();
    }

    public synchronized void disconnect() {
        this.disconnect(true);
    }

    public synchronized void disconnect(boolean bl) {
        if (this.isConnected()) {
            this.lastConnectTicks = 0L;
            this.connected = false;
            this.agentList = null;
            if (bl && this.authenticator != null) {
                this.cachedNonceValue = null;
                this.authenticator.setCredentials(null);
            }
            this.hostProperties.reset();
            BINavNode[] bINavNodeArray = super.getNavChildren();
            int n = 0;
            while (n < bINavNodeArray.length) {
                this.removeNavChild(bINavNodeArray[n]);
                ++n;
            }
            if (this.navFactories != null) {
                n = 0;
                while (n < this.navFactories.length) {
                    this.navFactories[n].disconnect();
                    Array array = this.navFactories[n].getNavNodes();
                    int n2 = 0;
                    while (n2 < array.size()) {
                        BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeRemoved((BOrd)this.getNavOrd(), (String)((BINavNode)array.get(n2)).getNavName(), null));
                        ++n2;
                    }
                    ++n;
                }
            }
            if (this.getNavParent() != null) {
                BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeReplaced((BINavNode)this.getNavParent(), (String)this.getNavName(), null));
            }
            this.notifyDisconnected();
        }
    }

    public BICredentials getCredentials() {
        return this.authenticator == null ? null : this.authenticator.getCredentials();
    }

    public int getPort() {
        return this.port;
    }

    public int getRemotePort() {
        if (this.tunnelAuthorities == null || this.tunnelAuthorities.length == 0) {
            return this.getPort();
        }
        return HttpUtil.parsePort((String)this.tunnelAuthorities[this.tunnelAuthorities.length - 1], (int)3011);
    }

    public BHost getRemoteHost() {
        if (this.tunnelAuthorities == null || this.tunnelAuthorities.length == 0) {
            return this.getHost();
        }
        return new BIpHost(HttpUtil.parseHost((String)this.tunnelAuthorities[this.tunnelAuthorities.length - 1]));
    }

    public String[] getTunnelAuthorities() {
        return this.tunnelAuthorities;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public BICredentials makeCredentials() throws ConnectException {
        return this.makeCredentials(DEFAULT_TIMEOUT);
    }

    public BICredentials makeCredentials(int n) throws ConnectException {
        return this.getAuthenticator(true, n).makeCredentials();
    }

    public void setCredentials(BICredentials bICredentials) {
        try {
            this.setCredentials(bICredentials, false);
        }
        catch (ConnectException connectException) {}
    }

    public void setCredentials(BICredentials bICredentials, boolean bl) throws ConnectException {
        this.setCredentials(bICredentials, bl, DEFAULT_TIMEOUT);
    }

    public void setCredentials(BICredentials bICredentials, boolean bl, int n) throws ConnectException {
        BICredentials bICredentials2;
        this.getAuthenticator(bl, n);
        if (this.authenticator != null && bICredentials != null && (bICredentials2 = this.authenticator.makeCredentials()).getClass().isAssignableFrom(bICredentials.getClass())) {
            this.authenticator.setCredentials(bICredentials);
        }
    }

    public BSessionInfo getSessionInfo() {
        BHost bHost = this.getHost();
        if (bHost != null) {
            String string = null;
            if (this.getCredentials() instanceof BIUserCredentials) {
                string = ((BIUserCredentials)this.getCredentials()).getUsername();
            }
            return BSessionInfo.make((String)bHost.getHostname(), (BAbsTime)this.getLastConnectedAbsTime(), null, (String)string);
        }
        return null;
    }

    protected BAbsTime getLastConnectedAbsTime() {
        return BAbsTime.make((long)this.lastConnectedTime);
    }

    public BOrd getAbsoluteOrd() {
        return this.absOrd;
    }

    public BHost getHost() {
        return this.host;
    }

    public BINavNode getNavChild(String string) {
        if (!this.isConnected()) {
            return null;
        }
        BSessionNavNode bSessionNavNode = this.getNavNode(string);
        return bSessionNavNode == null ? super.getNavChild(string) : bSessionNavNode;
    }

    public BINavNode[] getNavChildren() {
        if (!this.isConnected()) {
            return new BINavNode[0];
        }
        if (Sys.getStation() == null) {
            if (this.navFactories == null) {
                this.navFactories = BSessionNavNodeFactory.makeFor((BISession)this);
            }
            this.getFileSpace();
            Class clazz = class$javax$baja$nav$BINavNode;
            if (clazz == null) {
                clazz = class$javax$baja$nav$BINavNode = BDaemonSession.class("[Ljavax.baja.nav.BINavNode;", false);
            }
            Array array = new Array(clazz);
            int n = 0;
            while (n < this.navFactories.length) {
                array.addAll(this.navFactories[n].getNavNodes());
                ++n;
            }
            array = array.sort(BSessionNavNodeFactory.NAV_NODE_COMPARATOR);
            array.addAll((Object[])super.getNavChildren());
            return (BINavNode[])array.trim();
        }
        this.getFileSpace();
        return super.getNavChildren();
    }

    public String getNavDisplayName(Context context) {
        String string = this.isConnected() ? this.getLexiconValue("connected") : this.getLexiconValue("disconnected");
        if (this.tunnelAuthorities == null) {
            if (this.port == this.getDefaultPort()) {
                return this.getLexiconValue("navDisplayName", new Object[]{super.getNavDisplayName(context), string});
            }
            return this.getLexiconValue("navDisplayNameWithPort", new Object[]{super.getNavDisplayName(context), String.valueOf(this.port), string});
        }
        return this.getLexiconValue("tunneledNavDisplayName", new Object[]{super.getNavDisplayName(context), String.valueOf(this.getRemoteAddressString()), string});
    }

    protected String getLexiconPrefix() {
        return "DaemonSession.";
    }

    private final String getLexiconValue(String string) {
        return this.getLexiconValue(string, null);
    }

    private final String getLexiconValue(String string, Object[] objectArray) {
        if (objectArray == null) {
            return this.getLexicon().getText(this.getLexiconPrefix() + string);
        }
        return this.getLexicon().getText(this.getLexiconPrefix() + string, objectArray);
    }

    public BSessionNavNode getNavNode(String string) {
        if (Sys.getStation() == null) {
            if (this.navFactories == null) {
                this.navFactories = BSessionNavNodeFactory.makeFor((BISession)this);
            }
            BSessionNavNode bSessionNavNode = null;
            int n = 0;
            while (bSessionNavNode == null && n < this.navFactories.length) {
                bSessionNavNode = this.navFactories[n].getNavNode(string);
                ++n;
            }
            return bSessionNavNode;
        }
        return null;
    }

    public BOrd getNavOrd() {
        return this.getAbsoluteOrd();
    }

    public BOrd getOrdInHost() {
        return this.ordInHost;
    }

    public boolean hasNavChildren() {
        return this.isConnected();
    }

    public String getAddressString() {
        return this.getAddressString(this.getHost(), this.getPort());
    }

    public String getRemoteAddressString() {
        return this.getAddressString(this.getRemoteHost(), this.getRemotePort());
    }

    public String getAddressString(BHost bHost, int n) {
        if (n == -1 || n == this.getDefaultPort()) {
            return bHost.getHostname();
        }
        return bHost.getHostname() + ':' + n;
    }

    protected int getDefaultPort() {
        return 3011;
    }

    public static void processException(Exception exception) throws ConnectException {
        BDaemonSession.processException(exception, (RuntimeException)new BajaRuntimeException((Throwable)exception));
    }

    public static void processException(Exception exception, RuntimeException runtimeException) throws ConnectException {
        if (exception instanceof ConnectException) {
            throw (ConnectException)exception;
        }
        if (exception instanceof SocketException) {
            throw new ConnectException(exception.getMessage());
        }
        if (exception instanceof EOFException) {
            throw new ConnectException();
        }
        if (exception instanceof InterruptedIOException) {
            throw new ConnectException(exception.getMessage());
        }
        if (exception instanceof UnknownHostException) {
            throw new ConnectException(exception.getMessage());
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw runtimeException;
    }

    public boolean usesLocalNiagaraEnvironment() {
        return this.localEnvironment;
    }

    public synchronized BHostProperties getHostProperties() {
        return this.getHostProperties(DEFAULT_TIMEOUT);
    }

    public synchronized BHostProperties getHostProperties(int n) {
        if (this.isConnected()) {
            try {
                this.initHostProperties(false, n);
            }
            catch (ConnectException connectException) {}
        }
        return this.hostProperties;
    }

    private final void initHostProperties(boolean bl) throws AuthenticationException, ConnectException {
        this.initHostProperties(bl, DEFAULT_TIMEOUT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void initHostProperties(boolean bl, int n) throws AuthenticationException, ConnectException {
        if (this.inInit) {
            return;
        }
        this.inInit = true;
        try {
            if (bl || this.hostProperties.getIsDirty()) {
                this.hostProperties.setIsDirty(false);
                HttpConnection httpConnection = this.getConnection("/platformInfo", "GET", -1, n, null, 1);
                try {
                    block24: {
                        Object object;
                        block22: {
                            XElem xElem = XParser.make((InputStream)httpConnection.getInputStream()).parse();
                            if (httpConnection != null) {
                                httpConnection.close();
                            }
                            this.hostProperties.load(xElem);
                            try {
                                try {
                                    httpConnection = this.getConnection("/servlets", "GET", -1, n, null, 1);
                                    object = XParser.make((InputStream)httpConnection.getInputStream()).parse();
                                    this.hostProperties.loadServletsInfo((XElem)object);
                                }
                                catch (Exception exception) {
                                    BDaemonSession.processException(exception, (RuntimeException)new LocalizableRuntimeException("platform", "DaemonSession.exception.badServletInfo", new Object[]{this.getAddressString()}, (Throwable)exception));
                                }
                                Object var8_10 = null;
                                if (httpConnection == null) break block22;
                            }
                            catch (Throwable throwable) {
                                Object var8_9 = null;
                                if (httpConnection == null) throw throwable;
                                httpConnection.close();
                                throw throwable;
                            }
                            httpConnection.close();
                        }
                        if (this.hostProperties.getHostId().equals(Nre.getHostId())) {
                            object = this.getInputStream((DaemonMessage)new GetDirectoryMessage(new FilePath("!"), false, false, true, this.getFileSpace()), n);
                            if (object == null) {
                                throw new ConnectException("Cannot connect to remote host");
                            }
                            try {
                                block23: {
                                    try {
                                        XElem xElem = XParser.make((InputStream)object).parse();
                                        String string = xElem.get("path").replace('/', File.separatorChar);
                                        String string2 = Sys.getBajaHome().getAbsolutePath().replace('/', File.separatorChar);
                                        if (!BOperatingSystemEnum.isOS(BOperatingSystemEnum.windows)) {
                                            this.localEnvironment = string2.equals(string);
                                            break block23;
                                        }
                                        this.localEnvironment = string2.equalsIgnoreCase(string);
                                    }
                                    catch (Exception exception) {
                                        BDaemonSession.processException(exception);
                                    }
                                }
                                Object var11_17 = null;
                                if (object == null) break block24;
                            }
                            catch (Throwable throwable) {
                                Object var11_16 = null;
                                if (object == null) throw throwable;
                                ((InputStream)object).close();
                                throw throwable;
                            }
                            ((InputStream)object).close();
                        } else {
                            this.localEnvironment = false;
                        }
                    }
                    this.doConnected();
                }
                catch (Exception exception) {
                    this.hostProperties.reset();
                    BDaemonSession.processException(exception, (RuntimeException)new LocalizableRuntimeException("platform", "DaemonSession.exception.badHostInfo", new Object[]{this.getAddressString()}, (Throwable)exception));
                }
            }
            Object var4_20 = null;
            this.inInit = false;
            return;
        }
        catch (Throwable throwable) {
            Object var4_19 = null;
            this.inInit = false;
            throw throwable;
        }
    }

    public void reloadHostProperties(int n) throws AuthenticationException, ConnectException {
        this.hostProperties.reset();
        this.initHostProperties(true, n);
    }

    public void reloadHostProperties() throws AuthenticationException, ConnectException {
        this.reloadHostProperties(DEFAULT_TIMEOUT);
    }

    public BHostProperties updateHostProperties() {
        return this.updateHostProperties(DEFAULT_TIMEOUT);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BHostProperties updateHostProperties(int n) {
        try {
            boolean bl = this.hostProperties.getIsDirty() ^ true;
            this.initHostProperties(false);
            if (!bl) return this.hostProperties;
            HttpConnection httpConnection = this.getConnection("/platformInfo", "GET", -1, DEFAULT_TIMEOUT, null, 1);
            try {
                try {
                    XElem xElem = XParser.make((InputStream)httpConnection.getInputStream()).parse();
                    this.getHostProperties().update(xElem);
                }
                catch (Exception exception) {
                    try {
                        BDaemonSession.processException(exception);
                    }
                    catch (ConnectException connectException) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                httpConnection.close();
                throw throwable;
            }
            {
                Object var5_8 = null;
                httpConnection.close();
                return this.hostProperties;
            }
        }
        catch (ConnectException connectException) {}
        return this.hostProperties;
    }

    public BDefaultDaemonFileSpace getFileSpace() {
        BDefaultDaemonFileSpace bDefaultDaemonFileSpace = (BDefaultDaemonFileSpace)this.getNavChild("file");
        if (bDefaultDaemonFileSpace == null) {
            if (this == LocalSessionUtil.getLocalSession()) {
                bDefaultDaemonFileSpace = new BDefaultDaemonFileSpace();
                this.addNavChild((BINavNode)bDefaultDaemonFileSpace);
                return bDefaultDaemonFileSpace;
            }
            return (BDefaultDaemonFileSpace)BOrd.make((String)"file:").get((BObject)this);
        }
        return bDefaultDaemonFileSpace;
    }

    public String getErrorText(XmlResponseMessage xmlResponseMessage) throws Exception {
        this.sendMessages(new XmlResponseMessage[]{xmlResponseMessage}, DEFAULT_TIMEOUT);
        return xmlResponseMessage.getErrorMessage();
    }

    public InputStream getInputStream(DaemonMessage daemonMessage) throws ConnectException, AuthenticationException {
        return this.getInputStream(daemonMessage.getMessageString(), DEFAULT_TIMEOUT, null, null);
    }

    public XElem post(DaemonMessage daemonMessage) throws Exception {
        if (daemonMessage != null && daemonMessage.getMethod().equals("POST")) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            daemonMessage.write(byteArrayOutputStream);
            HttpConnection httpConnection = this.getConnection(daemonMessage.getMessageString(), daemonMessage.getMethod(), byteArrayOutputStream.size(), DEFAULT_TIMEOUT, null, 32);
            if (httpConnection != null && byteArrayOutputStream != null) {
                OutputStream outputStream = httpConnection.getOutputStream();
                outputStream.write(byteArrayOutputStream.toByteArray());
                outputStream.flush();
                int n = httpConnection.postComplete();
                if (n == 500) {
                    return null;
                }
                XElem xElem = XParser.make((InputStream)httpConnection.getInputStream()).parse();
                httpConnection.close();
                return xElem;
            }
        }
        return null;
    }

    public InputStream getInputStream(DaemonMessage daemonMessage, int n) throws ConnectException, AuthenticationException {
        return this.getInputStream(daemonMessage.getMessageString(), n, null, null);
    }

    public InputStream getInputStream(DaemonMessage daemonMessage, String string) throws ConnectException, AuthenticationException {
        return this.getInputStream(daemonMessage.getMessageString(), DEFAULT_TIMEOUT, string, null);
    }

    public InputStream getInputStream(DaemonMessage daemonMessage, int n, String string) throws ConnectException, AuthenticationException {
        return this.getInputStream(daemonMessage.getMessageString(), n, string, null);
    }

    public InputStream getInputStream(DaemonMessage daemonMessage, int n, String string, HttpConnection httpConnection) throws ConnectException, AuthenticationException {
        return this.getInputStream(daemonMessage.getMessageString(), n, string, httpConnection);
    }

    public InputStream getInputStream(String string, int n, String string2, HttpConnection httpConnection) throws ConnectException, AuthenticationException {
        httpConnection = this.getConnection(string, "GET", -1, DEFAULT_TIMEOUT, httpConnection, 0);
        try {
            if (httpConnection == null) {
                return null;
            }
            httpConnection.setTimeout(n);
            String string3 = httpConnection.getResponseHeader("Content-Type");
            if (!(string2 == null || string3 != null && string3.equals(string2))) {
                httpConnection.close();
                return null;
            }
            return new Stream(httpConnection);
        }
        catch (Exception exception) {
            if (httpConnection != null) {
                httpConnection.close();
            }
            log.error("error sending message to daemon", (Throwable)exception);
            return null;
        }
    }

    public OutputStream getOutputStream(DaemonMessage daemonMessage, long l, ICancelHint iCancelHint) throws ConnectException, AuthenticationException {
        return this.getOutputStream(daemonMessage, l, DEFAULT_TIMEOUT, iCancelHint);
    }

    public OutputStream getOutputStream(DaemonMessage daemonMessage, long l, int n, ICancelHint iCancelHint) throws ConnectException, AuthenticationException {
        if (BDaemonSession.canceled(iCancelHint)) {
            throw new ICancelHint.CanceledException();
        }
        HttpConnection httpConnection = this.getConnection(daemonMessage.getMessageString(), "POST", l, n, null, 32);
        try {
            return httpConnection == null ? null : new PostOutputStream(httpConnection, iCancelHint);
        }
        catch (Exception exception) {
            log.error("error posting message to daemon", (Throwable)exception);
            return null;
        }
    }

    public boolean sendMessage(DaemonMessage daemonMessage) throws ConnectException, AuthenticationException {
        return this.sendMessage(daemonMessage.getMessageString(), daemonMessage.getMethod(), DEFAULT_TIMEOUT, daemonMessage.getConnectionFlags());
    }

    public boolean sendMessage(DaemonMessage daemonMessage, int n) throws ConnectException, AuthenticationException {
        return this.sendMessage(daemonMessage.getMessageString(), daemonMessage.getMethod(), n, daemonMessage.getConnectionFlags());
    }

    public synchronized XmlResponseMessage[] sendMessages(XmlResponseMessage[] xmlResponseMessageArray, int n) throws Exception {
        if (this.getHostProperties().supportsServlet("batch")) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 32;
            int n3 = 0;
            while (n3 < xmlResponseMessageArray.length) {
                stringBuffer.append("/");
                stringBuffer.append(xmlResponseMessageArray[n3].getMessageString());
                stringBuffer.append("\r\n");
                n2 |= xmlResponseMessageArray[n3].getConnectionFlags();
                ++n3;
            }
            stringBuffer.append("\r\n");
            HttpConnection httpConnection = this.getConnection("batch", "POST", stringBuffer.length(), n, null, n2);
            httpConnection.getOutputStream().write(stringBuffer.toString().getBytes());
            httpConnection.postComplete();
            XElem[] xElemArray = XParser.make((InputStream)httpConnection.getInputStream()).parse().elems();
            httpConnection.close();
            int n4 = 0;
            while (n4 < xElemArray.length) {
                xmlResponseMessageArray[n4].setResponse(xElemArray[n4]);
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < xmlResponseMessageArray.length) {
                try {
                    Stream stream = (Stream)this.getInputStream((DaemonMessage)xmlResponseMessageArray[n5], n);
                    if (stream.getContentType() != null && stream.getContentType().equals("text/xml")) {
                        xmlResponseMessageArray[n5].setResponse(XParser.make((InputStream)stream).parse());
                    } else {
                        xmlResponseMessageArray[n5].setResponse(new XElem("success"));
                        stream.close();
                    }
                }
                catch (DaemonResponseException daemonResponseException) {
                    xmlResponseMessageArray[n5].setErrorMessage(daemonResponseException.getMessage());
                }
                ++n5;
            }
        }
        return xmlResponseMessageArray;
    }

    public synchronized boolean sendRebootRequest() throws AuthenticationException {
        return this.sendRebootRequest(true);
    }

    public synchronized void sendForceRebootRequest() throws AuthenticationException {
        if (!this.getHostProperties().supportsServlet("reboot")) {
            return;
        }
        if (Boolean.valueOf(System.getProperty("niagara.daemonsession.bypassReboot", "false")).booleanValue()) {
            this.disconnect(true);
        } else {
            try {
                this.sendMessage(forceRebootMessage.getMessageString(), forceRebootMessage.getMethod(), 0, forceRebootMessage.getConnectionFlags());
                this.disconnect(true);
            }
            catch (SocketException socketException) {
                this.disconnect(true);
            }
        }
    }

    public synchronized boolean sendRebootRequest(boolean bl) throws AuthenticationException {
        if (!this.getHostProperties().supportsServlet("reboot")) {
            BPlatform.log.trace("sendRebootRequest returning false: reboot servlet not supported");
            return false;
        }
        if (Boolean.valueOf(System.getProperty("niagara.daemonsession.bypassReboot", "false")).booleanValue()) {
            BPlatform.log.trace("sendRebootRequest returning true: bypassReboot property set");
            this.disconnect(bl);
            return true;
        }
        try {
            if (this.sendMessage(rebootMessage.getMessageString(), rebootMessage.getMethod(), 0, rebootMessage.getConnectionFlags())) {
                BPlatform.log.trace("sendRebootRequest returning true: request succeeded");
                this.disconnect(bl);
                return true;
            }
            BPlatform.log.trace("sendRebootRequest returning false: request failed");
            return false;
        }
        catch (DaemonResponseException daemonResponseException) {
            if (daemonResponseException.responseCode == 409) {
                BPlatform.log.trace("sendRebootRequest returning false: received SC_CONFLICT response");
                return false;
            }
            throw daemonResponseException;
        }
        catch (SocketException socketException) {
            BPlatform.log.trace("sendRebootRequest returning true: encountered SocketException");
            this.disconnect(bl);
            return true;
        }
    }

    public String getAuthenticationRealmName() {
        return this.authenticator == null ? null : this.authenticator.getAuthenticationRealmName();
    }

    private final Authenticator getAuthenticator() {
        try {
            return this.getAuthenticator(false, DEFAULT_TIMEOUT);
        }
        catch (ConnectException connectException) {
            return null;
        }
    }

    private final Authenticator getAuthenticator(boolean bl, int n) throws ConnectException {
        if (this.authenticator == null && bl) {
            try {
                this.sendMessage("/", "GET", n, 2);
            }
            catch (AuthenticationException authenticationException) {}
        }
        return this.authenticator;
    }

    private final void initAuthenticator(HttpConnection httpConnection) throws ConnectException {
        this.authenticator = Authenticator.make(this.getAuthenticator(), this.getHost(), this.getPort(), this.getAbsoluteOrd().toString(), httpConnection);
    }

    private static final String getBrandId() {
        if (brandIdHolder == null) {
            try {
                Feature feature = Sys.getLicenseManager().checkFeature("tridium", "platformClient");
                brandIdHolder = feature.getb("useBrand", true) ? new String[]{Brand.getBrandId()} : new String[1];
            }
            catch (FeatureNotLicensedException featureNotLicensedException) {
                brandIdHolder = new String[]{Brand.getBrandId()};
            }
        }
        return brandIdHolder[0];
    }

    private static final void addBrandHeader(HttpConnection httpConnection) {
        String string = BDaemonSession.getBrandId();
        if (string != null) {
            if (Sys.getStation() == null) {
                httpConnection.setRequestHeader("Baja-Wb-Brand", string);
            } else {
                httpConnection.setRequestHeader("Baja-Station-Brand", string);
            }
        }
    }

    private static final void checkServerBrand(HttpConnection httpConnection) {
        String string;
        if (BDaemonSession.getBrandId() != null && (string = httpConnection.getResponseHeader("Baja-Station-Brand")) != null && string.trim().length() > 0) {
            if (Sys.getStation() == null) {
                Brand.checkWbOut((String)string);
            } else {
                Brand.checkStationOut((String)string);
            }
        }
    }

    private final synchronized void doConnected() {
        if (!this.isConnected()) {
            this.agentList = null;
            this.connected = true;
            this.lastConnectedTime = Clock.millis();
            if (this.navFactories != null) {
                Class clazz = class$javax$baja$nav$BINavNode;
                if (clazz == null) {
                    clazz = class$javax$baja$nav$BINavNode = BDaemonSession.class("[Ljavax.baja.nav.BINavNode;", false);
                }
                Array array = new Array(clazz);
                int n = 0;
                while (n < this.navFactories.length) {
                    this.navFactories[n].connect();
                    array.addAll(this.navFactories[n].getNavNodes());
                    ++n;
                }
                array = array.sort(BSessionNavNodeFactory.NAV_NODE_COMPARATOR);
                n = 0;
                while (n < array.size()) {
                    BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeAdded((BOrd)this.getNavOrd(), (String)((BINavNode)array.get(n)).getNavName(), null));
                    ++n;
                }
            }
        }
        this.lastConnectTicks = Clock.ticks();
    }

    boolean sendMessage(String string, int n) throws ConnectException, AuthenticationException {
        return this.sendMessage(string, "GET", n, 0);
    }

    boolean sendMessage(String string, String string2, int n) throws ConnectException, AuthenticationException {
        return this.sendMessage(string, string2, n, 0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean sendMessage(String string, String string2, int n, int n2) throws ConnectException, AuthenticationException {
        HttpConnection httpConnection = this.getConnection(string, string2, -1, n, null, n2);
        if (httpConnection == null) {
            return false;
        }
        try {
            try {
                byte[] byArray = new byte[1024];
                BufferedInputStream bufferedInputStream = new BufferedInputStream(httpConnection.getInputStream());
                while (bufferedInputStream.read(byArray, 0, 1024) > 0) {
                }
            }
            catch (Exception exception) {
                BDaemonSession.processException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            httpConnection.close();
            throw throwable;
        }
        {
            Object var7_11 = null;
        }
        httpConnection.close();
        return true;
    }

    synchronized HttpConnection getConnection(String string, String string2, int n) throws ConnectException, AuthenticationException {
        return this.getConnection(string, string2, -1, n, null, 0);
    }

    synchronized HttpConnection getConnection(String string, String string2, int n, HttpConnection httpConnection) throws ConnectException, AuthenticationException {
        return this.getConnection(string, string2, -1, n, httpConnection, 0);
    }

    synchronized HttpConnection getConnection(String string, String string2, long l, int n) throws ConnectException, AuthenticationException {
        return this.getConnection(string, string2, l, n, null, 0);
    }

    synchronized HttpConnection getConnection(String string, String string2, long l, int n, HttpConnection httpConnection) throws ConnectException, AuthenticationException {
        return this.getConnection(string, string2, l, n, httpConnection, 0);
    }

    synchronized HttpConnection getConnection(String string, String string2, long l, int n, HttpConnection httpConnection, int n2) throws ConnectException, AuthenticationException {
        int n3 = -1;
        String string3 = string.charAt(0) == '/' ? string : "/" + string;
        boolean bl = false;
        boolean bl2 = false;
        int n4 = 0;
        long l2 = Clock.ticks();
        log.trace("getConnection " + string2 + ' ' + string + " (" + n + ')');
        while (true) {
            String string4;
            try {
                if (this.tunnelAuthorities != null) {
                    string3 = this.parseTunnelAuthorities(string3);
                }
                if (httpConnection == null) {
                    httpConnection = this.createNewConnection(string2, l, n, n2, string3);
                    if (this.cachedNonceValue != null) {
                        this.setAuthOnConnection(httpConnection, string3);
                        this.addHeaders(string2, l, n, httpConnection, n2);
                    }
                    if ((n3 = this.connect(httpConnection)) == 302) {
                        this.redirect(string2, httpConnection, n3, string3);
                    }
                } else {
                    bl = this.setAuthOnConnection(httpConnection, string3);
                    this.addHeaders(string2, l, n, httpConnection, n2);
                    n3 = this.sendNewRequest(httpConnection, n3, string3);
                }
            }
            catch (SocketException socketException) {
                log.trace("socket exception", (Throwable)socketException);
                if (n4 < 1) {
                    string4 = this.getHost().toString();
                    if (string4.indexOf(":") != -1) {
                        string4 = "[" + string4 + ']';
                    }
                    log.warning("connection failed, retrying " + string2 + ' ' + string + " at " + string4 + ':' + this.getPort() + " (" + n + " ms timeout)");
                    ++n4;
                    continue;
                }
                this.handleRetriesExceeded(httpConnection, l2, socketException);
            }
            catch (Exception exception) {
                this.handleConnectionException(string2, httpConnection, string3, l2, exception);
            }
            this.validateResponse(httpConnection, l2);
            String string5 = httpConnection.getResponseHeader("Niagara-Started");
            if (string5 != null) {
                this.hostProperties.checkTimestamp(string5);
            }
            if (this.isSuccessResponseCode(n3)) {
                string4 = httpConnection.getRequestHeader("Authorization");
                if (string4 != null) {
                    this.cachedNonceValue = Authenticator.parseHeader(string4);
                }
                this.handleConnectionFlags(n2, l2);
                return httpConnection;
            }
            bl2 = this.handleErrorResponses(string2, httpConnection, n2, n3, string3, bl, l2);
            if (!bl2) break;
        }
        return null;
    }

    protected String redirect(String string, HttpConnection httpConnection, int n, String string2) throws IOException {
        byte[] byArray = new byte[Math.min(httpConnection.getContentLength(), 75)];
        httpConnection.getInputStream().read(byArray, 0, byArray.length);
        httpConnection.close();
        String string3 = httpConnection.getResponseHeader("location");
        throw new DaemonSSLRequiredException(n, this.getHost().getHostname(), string, string2, string3);
    }

    private final boolean handleErrorResponses(String string, HttpConnection httpConnection, int n, int n2, String string2, boolean bl, long l) throws ConnectException {
        boolean bl2 = false;
        if (n2 == 401) {
            this.readFully(httpConnection);
            bl2 = this.handleUnauthorizedResponse(httpConnection, n, bl, l);
        } else {
            log.trace("getConnection failed " + Http.getReasonPhrase((int)n2));
            if ((n & 1) == 0) {
                this.doConnected();
            }
            if (n2 == 404) {
                this.readFully(httpConnection);
                httpConnection.close();
                log.trace("getConnection completed in " + (Clock.ticks() - l) + "ms");
                bl2 = false;
            } else if (httpConnection != null && httpConnection.getContentType() != null && httpConnection.getContentType().equals("text/xml")) {
                this.handleXMLResponse(string, httpConnection, n2, string2, l);
            } else {
                this.handleInvalidResponse(string, httpConnection, n2, string2, l);
            }
        }
        return bl2;
    }

    private final boolean handleUnauthorizedResponse(HttpConnection httpConnection, int n, boolean bl, long l) throws ConnectException {
        if (this.cachedNonceValue == null) {
            if (bl) {
                this.initAuthenticator(httpConnection);
                this.connectionFailed(httpConnection, n, l);
            } else {
                this.initAuthenticator(httpConnection);
                if (this.getAuthenticator() == null || !this.getAuthenticator().hasCredentials()) {
                    this.connectionFailed(httpConnection, n, l);
                }
            }
        }
        this.cachedNonceValue = Authenticator.parseHeader(httpConnection, "Authorization");
        return true;
    }

    private final void connectionFailed(HttpConnection httpConnection, int n, long l) {
        httpConnection.close();
        AuthenticationException authenticationException = new AuthenticationException((AuthenticationRealm)this.getAuthenticator());
        if ((n & 2) == 0) {
            this.notifyConnectionError(authenticationException);
        }
        log.trace("getConnection completed in " + (Clock.ticks() - l) + "ms");
        throw authenticationException;
    }

    private final void handleConnectionException(String string, HttpConnection httpConnection, String string2, long l, Exception exception) {
        httpConnection.close();
        this.hostProperties.reset();
        this.notifyConnectionError(exception);
        this.disconnect(false);
        log.trace("getConnection completed in " + (Clock.ticks() - l) + "ms");
        if (exception instanceof ICancelHint.CanceledException) {
            throw (ICancelHint.CanceledException)((Object)exception);
        }
        if (exception instanceof DaemonSSLRequiredException) {
            throw (DaemonSSLRequiredException)((Object)exception);
        }
        throw new LocalizableRuntimeException("platform", "DaemonSession.exception.connectError", new Object[]{this.getAddressString(), string, string2}, (Throwable)exception);
    }

    private final void handleRetriesExceeded(HttpConnection httpConnection, long l, SocketException socketException) throws ConnectException {
        try {
            httpConnection.close();
        }
        catch (Exception exception) {}
        this.hostProperties.reset();
        this.notifyConnectionError(socketException);
        this.disconnect(false);
        if (socketException instanceof ConnectException) {
            log.trace("getConnection completed in " + (Clock.ticks() - l) + "ms");
            throw (ConnectException)socketException;
        }
        log.trace("getConnection completed in " + (Clock.ticks() - l) + "ms");
        throw new ConnectException(socketException.getMessage());
    }

    private final void handleConnectionFlags(int n, long l) throws ConnectException {
        if ((n & 0x10) > 0) {
            this.authenticator = null;
        }
        if ((n & 8) > 0) {
            this.close();
        } else if ((n & 4) > 0) {
            this.disconnect(false);
        } else if ((n & 0x10) == 0) {
            this.initHostProperties(false);
            if ((n & 1) == 0) {
                this.doConnected();
            }
            log.trace("getConnection completed in " + (Clock.ticks() - l) + "ms");
        }
    }

    private final void handleInvalidResponse(String string, HttpConnection httpConnection, int n, String string2, long l) {
        this.readFully(httpConnection);
        httpConnection.close();
        this.hostProperties.reset();
        log.trace("getConnection completed in " + (Clock.ticks() - l) + "ms");
        if (n == 403) {
            throw new LocalizableRuntimeException("platform", "DaemonSession.exception.badBrand", new Object[]{Brand.getBrandId()});
        }
        throw new DaemonResponseException(n, this.getAddressString(), string, string2);
    }

    private final void handleXMLResponse(String string, HttpConnection httpConnection, int n, String string2, long l) {
        try {
            XElem xElem;
            Object object;
            if (debug) {
                int n2;
                object = new ByteArrayOutputStream();
                InputStream inputStream = httpConnection.getInputStream();
                byte[] byArray = new byte[4096];
                while ((n2 = inputStream.read(byArray, 0, byArray.length)) > 0) {
                    ((ByteArrayOutputStream)object).write(byArray, 0, n2);
                }
                if (debug) {
                    ((ByteArrayOutputStream)object).writeTo(System.out);
                }
                xElem = XParser.make((InputStream)new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray())).parse();
            } else {
                xElem = XParser.make((InputStream)httpConnection.getInputStream()).parse();
            }
            object = new DaemonText(xElem);
            this.hostProperties.reset();
            httpConnection.close();
            log.trace("getConnection completed in " + (Clock.ticks() - l) + "ms");
            throw new DaemonResponseException(n, this.getAddressString(), ((DaemonText)object).message);
        }
        catch (LocalizableRuntimeException localizableRuntimeException) {
            log.trace("getConnection completed in " + (Clock.ticks() - l) + "ms");
            throw localizableRuntimeException;
        }
        catch (Exception exception) {
            httpConnection.close();
            this.hostProperties.reset();
            log.trace("getConnection completed in " + (Clock.ticks() - l) + "ms");
            throw new LocalizableRuntimeException("platform", "DaemonSession.exception.badConnectResponse", new Object[]{new Integer(n), this.getAddressString(), string, string2});
        }
    }

    private final void validateResponse(HttpConnection httpConnection, long l) {
        int n;
        Version version;
        BDaemonSession.checkServerBrand(httpConnection);
        String string = httpConnection.getResponseHeader("Server");
        if (string == null) {
            httpConnection.close();
            LocalizableRuntimeException localizableRuntimeException = new LocalizableRuntimeException("platform", "daemon.session.versionError", new Object[]{requiredVersion, this.getAddressString(), "?"});
            this.notifyConnectionError(localizableRuntimeException);
            this.disconnect(false);
            log.trace("getConnection completed in " + (Clock.ticks() - l) + "ms");
            throw localizableRuntimeException;
        }
        if (this.tunnelAuthorities != null) {
            if (httpConnection.getResponseHeader("Tunneled-Connection-Proxy-Response") != null) {
                LocalizableRuntimeException localizableRuntimeException = new LocalizableRuntimeException("platform", "daemon.session.proxyTunnelError", new Object[]{httpConnection.getStatusMessage()});
                httpConnection.close();
                this.notifyConnectionError(localizableRuntimeException);
                this.disconnect(false);
                log.trace("getConnection completed in " + (Clock.ticks() - l) + "ms");
                throw localizableRuntimeException;
            }
            if (httpConnection.getResponseHeader("Tunneled-Connection-Proxy") == null) {
                LocalizableRuntimeException localizableRuntimeException = new LocalizableRuntimeException("platform", "daemon.session.proxyVersionError", new Object[]{this.getAddressString(), requiredVersionForTunnel});
                httpConnection.close();
                this.notifyConnectionError(localizableRuntimeException);
                this.disconnect(false);
                log.trace("getConnection completed in " + (Clock.ticks() - l) + "ms");
                throw localizableRuntimeException;
            }
            if (httpConnection.getResponseHeader("Tunneled-Connection-Endpoint") == null) {
                LocalizableRuntimeException localizableRuntimeException = new LocalizableRuntimeException("platform", "daemon.session.endpointVersionError", new Object[]{this.getRemoteAddressString(), requiredVersionForTunnel});
                httpConnection.close();
                this.notifyConnectionError(localizableRuntimeException);
                this.disconnect(false);
                log.trace("getConnection completed in " + (Clock.ticks() - l) + "ms");
                throw localizableRuntimeException;
            }
        }
        if ((version = new Version(string.substring((n = string.lastIndexOf(47)) + 1))).compareTo((Object)requiredVersion) < 0) {
            httpConnection.close();
            LocalizableRuntimeException localizableRuntimeException = new LocalizableRuntimeException("platform", "daemon.session.versionError", new Object[]{requiredVersion, this.getAddressString(), version});
            this.notifyConnectionError(localizableRuntimeException);
            this.disconnect(false);
            log.trace("getConnection completed in " + (Clock.ticks() - l) + "ms");
            throw localizableRuntimeException;
        }
    }

    private final boolean isSuccessResponseCode(int n) {
        boolean bl = false;
        if (n > 99 && n < 300) {
            bl = true;
        }
        return bl;
    }

    private final int sendNewRequest(HttpConnection httpConnection, int n, String string) throws ConnectException {
        try {
            n = httpConnection.newRequest(string);
        }
        catch (Exception exception) {
            BDaemonSession.processException(exception);
        }
        return n;
    }

    protected void addHeaders(String string, long l, int n, HttpConnection httpConnection, int n2) throws SocketException {
        if (l >= 0L) {
            httpConnection.setRequestHeader("Content-Length", l);
        }
        BDaemonSession.addBrandHeader(httpConnection);
        httpConnection.setRequestMethod(string);
        httpConnection.setTimeout(n);
        if ((n2 & 0x20) != 0) {
            httpConnection.removeRequestHeader("expect");
            httpConnection.setRequestHeader("expect", "100-continue");
        }
    }

    protected boolean setAuthOnConnection(HttpConnection httpConnection, String string) throws IOException {
        boolean bl = this.getAuthenticator() == null ? false : (this.cachedNonceValue != null ? this.getAuthenticator().setAuthorization(httpConnection, string, this.cachedNonceValue) : this.getAuthenticator().setAuthorization(httpConnection, string));
        return bl;
    }

    protected int connect(HttpConnection httpConnection) throws ConnectException {
        int n = -1;
        try {
            if (httpConnection != null) {
                n = httpConnection.connect();
            }
        }
        catch (Exception exception) {
            BDaemonSession.processException(exception);
        }
        return n;
    }

    protected HttpConnection createNewConnection(String string, long l, int n, int n2, String string2) throws SocketException {
        HttpConnection httpConnection = new HttpConnection(this.getHost(), this.getPort(), string2);
        return this.initConnection(httpConnection, string, l, n, n2);
    }

    protected HttpConnection initConnection(HttpConnection httpConnection, String string, long l, int n, int n2) throws SocketException {
        this.addHeaders(string, l, n, httpConnection, n2);
        return httpConnection;
    }

    private final String parseTunnelAuthorities(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.tunnelAuthorities.length) {
            int n2;
            stringBuffer.append("/tunnel/").append(HttpUtil.parseHost((String)this.tunnelAuthorities[n]));
            if (n < this.tunnelAuthorities.length - 1) {
                n2 = HttpUtil.parsePort((String)this.tunnelAuthorities[n], (int)80);
                if (n2 != 80) {
                    stringBuffer.append(":" + n2);
                }
            } else {
                n2 = HttpUtil.parsePort((String)this.tunnelAuthorities[n], (int)3011);
                stringBuffer.append(":" + n2);
            }
            ++n;
        }
        if (!string.startsWith(stringBuffer.toString())) {
            stringBuffer.append(string);
            string = stringBuffer.toString();
        }
        return string;
    }

    String readFully(HttpConnection httpConnection) {
        try {
            int n;
            byte[] byArray = new byte[1024];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(httpConnection.getInputStream());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = bufferedInputStream.read(byArray, 0, 1024)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            return byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            if (debug) {
                exception.printStackTrace();
            }
            return null;
        }
    }

    public static boolean canceled(ICancelHint iCancelHint) {
        boolean bl = false;
        if (iCancelHint != null && iCancelHint.isCanceled()) {
            bl = true;
        }
        return bl;
    }

    public static void checkCanceled(ICancelHint iCancelHint) {
        if (BDaemonSession.canceled(iCancelHint)) {
            throw new ICancelHint.CanceledException();
        }
    }

    public boolean isSecure() {
        return this.getHost() instanceof BLocalHost;
    }

    public void addListener(DaemonSessionListener daemonSessionListener) {
        if (!this.listeners.contains(daemonSessionListener)) {
            this.listeners.add(daemonSessionListener);
        }
    }

    public void removeListener(DaemonSessionListener daemonSessionListener) {
        this.listeners.remove(daemonSessionListener);
    }

    protected void notifyConnected() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DaemonSessionListener daemonSessionListener = (DaemonSessionListener)iterator.next();
            daemonSessionListener.sessionConnected(this);
        }
    }

    protected void notifyDisconnected() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DaemonSessionListener daemonSessionListener = (DaemonSessionListener)iterator.next();
            daemonSessionListener.sessionDisconnected(this);
        }
    }

    protected void notifyConnectionError(Throwable throwable) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DaemonSessionListener daemonSessionListener = (DaemonSessionListener)iterator.next();
            daemonSessionListener.sessionConnectionError(this, throwable);
        }
    }

    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        if (this.isConnected()) {
            return this.tunnelAuthorities == null ? iconConnected : tunnelIconConnected;
        }
        return this.tunnelAuthorities == null ? iconDisconnected : tunnelIconDisconnected;
    }

    public AgentList getAgents(Context context) {
        if (this.isConnected()) {
            if (this.agentList == null) {
                AgentTypeComparator agentTypeComparator = new AgentTypeComparator(context);
                this.agentList = Sys.getRegistry().getAgents(this.getType().getTypeInfo());
                try {
                    AgentList agentList = this.getAgentList().filter(AgentFilter.is((String)"workbench:WbView"));
                    agentList.remove("workbench:NavContainerView");
                    agentList.remove("platDaemon:PlatformSessionListView");
                    AgentInfo[] agentInfoArray = agentList.list();
                    this.filterNavNodes(agentInfoArray);
                    this.sortAgentList(agentTypeComparator);
                    this.setDefaultAgent();
                    this.agentList.toTop("workbench:NavContainerView");
                    this.agentList.toTop("platDaemon:PlatformSessionListView");
                }
                catch (TypeNotFoundException typeNotFoundException) {
                    typeNotFoundException.printStackTrace();
                }
            }
        } else if (this.agentList == null) {
            this.agentList = super.getAgents(context);
            AgentList agentList = this.getAgentList().filter(AgentFilter.is((String)"workbench:WbView"));
            agentList.remove("workbench:NavContainerView");
            this.agentList.remove(agentList);
            AgentTypeComparator agentTypeComparator = new AgentTypeComparator(context);
            this.sortAgentList(agentTypeComparator);
            this.setDefaultAgent();
        }
        return this.agentList;
    }

    private final void filterNavNodes(AgentInfo[] agentInfoArray) {
        int n = 0;
        while (n < agentInfoArray.length) {
            if (agentInfoArray[n] instanceof NAgentInfo) {
                TypeInfo typeInfo = ((NAgentInfo)agentInfoArray[n]).getTypeInfo();
                String string = Lexicon.make((String)typeInfo.getModuleName()).get(typeInfo.getTypeName() + ".navName", typeInfo.getTypeName());
                if (this.getNavNode(string) == null) {
                    this.agentList.remove(agentInfoArray[n]);
                }
            } else {
                this.agentList.remove(agentInfoArray[n]);
            }
            ++n;
        }
    }

    private final void sortAgentList(Comparator comparator) {
        if (this.agentList.size() > 1) {
            int n = 0;
            while (n < this.agentList.size() - 1) {
                int n2 = n + 1;
                while (n2 < this.agentList.size()) {
                    if (comparator.compare(this.agentList.get(n), this.agentList.get(n2)) > 0) {
                        this.agentList.swap(n, n2);
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    public boolean shouldDowngrade(BPlatformSSLSettings bPlatformSSLSettings) {
        return false;
    }

    protected void setDefaultAgent() {
        if (this.tunnelAuthorities != null) {
            this.getAgentList().toTop("platform:DaemonTunnelSessionAgent");
        } else {
            this.getAgentList().toTop("platform:DaemonSessionAgent");
        }
    }

    protected AgentList getAgentList() {
        return this.agentList;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.agentList = null;
        this.tunnelAuthorities = null;
        this.localEnvironment = false;
        this.navFactories = null;
        this.connected = false;
        this.inInit = false;
        this.listeners = new HashSet();
    }

    protected BDaemonSession(String string, BHost bHost, int n, String[] stringArray) {
        super(string, stringArray == null ? LexiconText.make((String)"platform", (String)"daemon.session") : LexiconText.make((String)"platform", (String)"daemon.tunnel.session"));
        this.this();
        this.host = bHost;
        this.port = n;
        this.tunnelAuthorities = stringArray;
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                HttpUtil.parseHost((String)stringArray[n2]);
                HttpUtil.parsePort((String)stringArray[n2], (int)3011);
                ++n2;
            }
            this.ordInHost = BOrd.make((OrdQuery)new BDaemonScheme.DaemonQuery(n, stringArray));
        } else {
            this.ordInHost = BOrd.make((OrdQuery)new BDaemonScheme.DaemonQuery(n));
        }
        this.absOrd = BOrd.make((BOrd)bHost.getAbsoluteOrd(), (BOrd)this.ordInHost);
        this.hostProperties = new BHostProperties();
    }

    protected BDaemonSession(String string, BHost bHost, int n, String[] stringArray, BOrd bOrd, LexiconText lexiconText) {
        super(string, lexiconText);
        this.this();
        this.host = bHost;
        this.port = n;
        this.tunnelAuthorities = stringArray;
        this.ordInHost = bOrd;
        this.absOrd = BOrd.make((BOrd)bHost.getAbsoluteOrd(), (BOrd)this.ordInHost);
        this.hostProperties = new BHostProperties();
    }

    BDaemonSession(String string, BHost bHost, int n) {
        this(string, bHost, n, null);
    }

    static {
        Class clazz = class$com$tridium$platform$daemon$BDaemonSession;
        if (clazz == null) {
            clazz = class$com$tridium$platform$daemon$BDaemonSession = BDaemonSession.class("[Lcom.tridium.platform.daemon.BDaemonSession;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        iconConnected = BIcon.std((String)"platform.png");
        iconDisconnected = BIcon.std((String)"platformDisconnected.png");
        tunnelIconConnected = BIcon.std((String)"platformTunnel.png");
        tunnelIconDisconnected = BIcon.std((String)"platformTunnelDisconnected.png");
        debug = false;
        DEFAULT_TIMEOUT = 60000;
        debug = Boolean.valueOf(System.getProperty("niagara.daemonsession.debug", "false"));
        DEFAULT_TIMEOUT = debug ? 0 : Integer.parseInt(System.getProperty("niagara.daemonsession.timeout", "60000"));
        requiredVersion = new Version("3");
        requiredVersionForTunnel = new Version("3.5");
        rebootMessage = new RebootMessage(false);
        forceRebootMessage = new RebootMessage(true);
        brandIdHolder = null;
        log = Log.getLog((String)"platform.daemonSession");
    }

    public static class Stream
    extends FilterInputStream {
        private HttpConnection conn;

        public String getContentType() {
            return this.conn.getResponseHeader("Content-Type");
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void close() throws IOException {
            try {
                super.close();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.conn.close();
                throw throwable;
            }
            {
                Object var2_3 = null;
            }
            this.conn.close();
        }

        public Stream(HttpConnection httpConnection) throws IOException {
            super(httpConnection.getInputStream());
            this.conn = httpConnection;
        }
    }

    private static class RebootMessage
    extends DaemonMessage {
        private boolean force;

        public String getMessageString() {
            return "reboot?force=" + this.force;
        }

        public int getConnectionFlags() {
            return 4;
        }

        public RebootMessage(boolean bl) {
            this.force = bl;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class AgentTypeComparator
    implements Comparator {
        private Context context;

        public int compare(Object object, Object object2) {
            AgentInfo agentInfo = (AgentInfo)object;
            AgentInfo agentInfo2 = (AgentInfo)object2;
            return agentInfo.getDisplayName(this.context).compareTo(agentInfo2.getDisplayName(this.context));
        }

        public AgentTypeComparator(Context context) {
            this.context = context;
        }
    }
}

