/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonSSLRequiredException;
import java.util.StringTokenizer;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDaemonScheme
extends BOrdScheme {
    private static final String HTTPS_PREFIX = "https://";
    public static final BDaemonScheme INSTANCE = new BDaemonScheme();
    public static final int DEFAULT_PORT = 3011;
    public static final int DEFAULT_SSL_PORT = 5011;
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$platform$daemon$BDaemonScheme;

    public OrdQuery parse(String string) {
        return new DaemonQuery(string);
    }

    public OrdTarget resolve(OrdTarget ordTarget, OrdQuery ordQuery) throws SyntaxException, UnresolvedException {
        if (!(ordTarget.get() instanceof BHost)) {
            throw new InvalidOrdBaseException();
        }
        BHost bHost = (BHost)ordTarget.get();
        DaemonQuery daemonQuery = (DaemonQuery)ordQuery;
        int n = daemonQuery.port;
        String[] stringArray = daemonQuery.tunnelAuthorities;
        BDaemonSession bDaemonSession = null;
        try {
            bDaemonSession = BDaemonSession.make(bHost, n, stringArray);
            bDaemonSession.connect();
        }
        catch (DaemonSSLRequiredException daemonSSLRequiredException) {
            BOrd bOrd;
            if (bDaemonSession != null) {
                bDaemonSession.close();
            }
            if ((bOrd = BDaemonScheme.convert(bHost, daemonSSLRequiredException.getNewLocation())) != null) {
                return bOrd.resolve();
            }
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (Exception exception) {
            throw new UnresolvedException(ordQuery.toString(), (Throwable)exception);
        }
        return new OrdTarget(ordTarget, (BObject)bDaemonSession);
    }

    public static BOrd convert(BHost bHost, String string) {
        if (string.startsWith(HTTPS_PREFIX)) {
            String string2 = string.substring(HTTPS_PREFIX.length());
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
            String string3 = null;
            string2 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                return BDaemonScheme.createSSLOrd(bHost.getAbsoluteOrd(), string3);
            }
        }
        return null;
    }

    private static final BOrd createSSLOrd(BOrd bOrd, String string) {
        int n = 0;
        n = string.indexOf("/");
        if (n > 0) {
            string = string.substring(0, n);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(bOrd.toString()).append("|platformssl:");
            if (string != null && string.length() > 0) {
                stringBuffer.append(string);
            }
            String string2 = stringBuffer.toString();
            return BOrd.make((String)string2);
        }
        return null;
    }

    static String[] validateAuthorities(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        if (n < 1) {
            return null;
        }
        String[] stringArray2 = new String[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (stringArray[n3] != null && !stringArray[n3].equals("")) {
                stringArray2[n2] = stringArray[n3];
                ++n2;
            }
            ++n3;
        }
        String[] stringArray3 = new String[n2];
        System.arraycopy(stringArray2, 0, stringArray3, 0, n2);
        return stringArray3;
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BDaemonScheme() {
        super("platform");
    }

    static {
        Class clazz = class$com$tridium$platform$daemon$BDaemonScheme;
        if (clazz == null) {
            clazz = class$com$tridium$platform$daemon$BDaemonScheme = BDaemonScheme.class("[Lcom.tridium.platform.daemon.BDaemonScheme;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class DaemonQuery
    implements OrdQuery {
        int port;
        String[] tunnelAuthorities;

        public boolean isHost() {
            return false;
        }

        public boolean isSession() {
            return true;
        }

        public void normalize(OrdQueryList ordQueryList, int n) {
            ordQueryList.shiftToHost(n);
        }

        public String getScheme() {
            return "platform";
        }

        public String getBody() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.port != this.getDefaultPort()) {
                stringBuffer.append(String.valueOf(this.port));
            }
            if (this.tunnelAuthorities != null) {
                int n = 0;
                while (n < this.tunnelAuthorities.length) {
                    if (this.tunnelAuthorities[n] != null && !this.tunnelAuthorities[n].equals("")) {
                        stringBuffer.append("/").append(this.tunnelAuthorities[n]);
                    }
                    ++n;
                }
            }
            return stringBuffer.toString();
        }

        public String toString() {
            return "platform:" + this.getBody();
        }

        public int getDefaultPort() {
            return 3011;
        }

        public int getPort() {
            return this.port;
        }

        public String[] getTunnelAuthorities() {
            return this.tunnelAuthorities;
        }

        private final /* synthetic */ void this() {
            this.tunnelAuthorities = null;
        }

        protected DaemonQuery(String string) {
            this.this();
            string = string.trim();
            if (string.length() == 0) {
                this.port = this.getDefaultPort();
            } else {
                int n = string.indexOf(47);
                if (n >= 0) {
                    this.port = n == 0 ? this.getDefaultPort() : Integer.parseInt(string.substring(0, n));
                    string = string.substring(n);
                    this.tunnelAuthorities = BDaemonScheme.validateAuthorities(TextUtil.splitAndTrim((String)string, (char)'/'));
                } else {
                    this.port = Integer.parseInt(string);
                }
            }
        }

        protected DaemonQuery(int n) {
            this.this();
            this.port = n;
        }

        protected DaemonQuery(int n, String[] stringArray) {
            this.this();
            this.port = n;
            this.tunnelAuthorities = BDaemonScheme.validateAuthorities(stringArray);
        }
    }
}

