/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BasicAuthenticator;
import com.tridium.platform.daemon.DigestAuthenticator;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.baja.naming.BHost;
import javax.baja.net.HttpConnection;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;

public abstract class Authenticator
implements AuthenticationRealm {
    private BUsernameAndPassword credentials;

    public static Authenticator make(BHost bHost, int n, String string, HttpConnection httpConnection) {
        return Authenticator.make(null, bHost, n, string, httpConnection);
    }

    public static Authenticator make(Authenticator authenticator, BHost bHost, int n, String string, HttpConnection httpConnection) {
        Properties properties = Authenticator.parseHeader(httpConnection, "WWW-Authenticate");
        if (properties == null) {
            return null;
        }
        Authenticator authenticator2 = authenticator;
        String string2 = properties.getProperty("0");
        String string3 = Authenticator.unquote(properties.getProperty("realm", string));
        if (string3.equals("Niagara-Admin")) {
            string3 = string;
        }
        if (string2.equalsIgnoreCase("digest")) {
            if (authenticator2 == null || !(authenticator2 instanceof DigestAuthenticator)) {
                authenticator2 = new DigestAuthenticator(bHost, n, string3);
            } else {
                DigestAuthenticator digestAuthenticator = (DigestAuthenticator)authenticator2;
                if (!digestAuthenticator.getHost().getAbsoluteOrd().equals((Object)bHost.getAbsoluteOrd()) || digestAuthenticator.getPort() != n) {
                    authenticator2 = new DigestAuthenticator(bHost, n, string3);
                }
            }
        } else if (string2.equalsIgnoreCase("basic")) {
            if (authenticator2 == null || !(authenticator2 instanceof BasicAuthenticator)) {
                authenticator2 = new BasicAuthenticator(string3);
            }
        } else {
            throw new IllegalArgumentException("Unsupported auth type: " + string2);
        }
        return authenticator2;
    }

    public abstract boolean setAuthorization(HttpConnection var1, String var2) throws IOException;

    public abstract boolean setAuthorization(HttpConnection var1, String var2, Properties var3) throws IOException;

    public boolean hasCredentials() {
        boolean bl = false;
        if (this.credentials != null && this.credentials.getPassword() != null && this.credentials.getUsername() != null && !this.credentials.getUsername().equals("")) {
            bl = true;
        }
        return bl;
    }

    protected BUsernameAndPassword getUserAndPwd() {
        return (BUsernameAndPassword)this.getCredentials();
    }

    public void setCredentials(BICredentials bICredentials) {
        this.credentials = (BUsernameAndPassword)bICredentials;
    }

    public BICredentials getCredentials() {
        if (this.hasCredentials()) {
            return this.credentials;
        }
        return null;
    }

    public BICredentials makeCredentials() {
        return new BUsernameAndPassword();
    }

    protected String hexMD5(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = messageDigest.digest(string.getBytes());
            int n = 0;
            while (n < byArray.length) {
                stringBuffer.append(TextUtil.toLowerCase((String)TextUtil.byteToHexString((int)byArray[n])));
                ++n;
            }
        }
        catch (Exception exception) {
            BDaemonSession.log.error("error creating digest", (Throwable)exception);
        }
        return stringBuffer.toString();
    }

    protected static String quote(String string) {
        if (string.length() == 0) {
            return "\"\"";
        }
        if (string.charAt(0) == '\"') {
            return string;
        }
        return "\"" + string + '\"';
    }

    protected static String unquote(String string) {
        if (string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.charAt(0) == '\"') {
            stringBuffer.deleteCharAt(0);
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == '\"') {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    protected static Properties parseHeader(HttpConnection httpConnection, String string) {
        String string2 = httpConnection.getResponseHeader(string);
        if (string2 == null) {
            return null;
        }
        Properties properties = Authenticator.parseHeader(string2);
        return properties;
    }

    protected static Properties parseHeader(String string) {
        Properties properties = new Properties();
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            int n2;
            String string2 = stringTokenizer.nextToken();
            if (string2.endsWith(",")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if ((n2 = string2.indexOf(61)) < 0) {
                properties.setProperty(String.valueOf(n++), string2);
                continue;
            }
            properties.setProperty(string2.substring(0, n2), string2.substring(n2 + 1));
        }
        return properties;
    }
}

