/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.command;

import com.tridium.platform.command.BAbstractPlatformCommand;
import com.tridium.platform.command.BPlat;
import com.tridium.util.CommandLineArguments;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPlatformCommandScript
extends BAbstractPlatformCommand {
    public static final BPlatformCommandScript INSTANCE = new BPlatformCommandScript();
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$platform$command$BPlatformCommandScript;

    public Type getType() {
        return TYPE;
    }

    public String getCommandName() {
        return "script";
    }

    public String getCommandDescription() {
        return "run one or more platform commands in a script";
    }

    public void usage() {
        BPlatformCommandScript.println("usage:");
        BPlatformCommandScript.println("  plat script <flags>");
        BPlatformCommandScript.println("optional flags:");
        BPlatformCommandScript.println("  -f:<filePath> reads the script from the given file, instead");
        BPlatformCommandScript.println("                of from standard input");
        BPlatformCommandScript.println("  -echo         echo commands read from the script");
        BPlatformCommandScript.println("  -usage        prints this message");
        BPlatformCommandScript.println("  -?            same as -usage");
        BPlatformCommandScript.println("  -help         same as -usage");
        BPlatformCommandScript.println("  -locale:<x>   set the default locale (en_US)");
        BPlatformCommandScript.println("  -@<option>    pass option to Java VM");
        BPlatformCommandScript.println("  -buildreg     force rebuild of the registry");
        BPlatformCommandScript.println("");
    }

    public void help() {
        BPlatformCommandScript.println("Script commands:");
        BPlatformCommandScript.println("  quit");
        BPlatformCommandScript.println("    Quit this program");
        BPlatformCommandScript.println("  help");
        BPlatformCommandScript.println("    Display this help message");
        BPlatformCommandScript.println("  option -<optName>:<optVal>*");
        BPlatformCommandScript.println("    Set the default value for the given command option(s)");
        BPlatformCommandScript.println("  removeopt -<optName>");
        BPlatformCommandScript.println("    Remove a default option value previously set with 'option'");
        BPlatformCommandScript.println("  showoptions");
        BPlatformCommandScript.println("    Show all default option values");
        BPlatformCommandScript.println("  <command> <commandopts>");
        BPlatformCommandScript.println("    Execute one of the platform commands listed below");
        BPlatformCommandScript.println("Platform commands:");
        BPlat.commands();
    }

    public int invoke(CommandLineArguments commandLineArguments) throws Exception {
        String string;
        BufferedReader bufferedReader;
        Object object;
        boolean bl = false;
        boolean bl2 = commandLineArguments.hasOption("echo");
        if (commandLineArguments.hasHelpOption()) {
            this.usage();
            return 0;
        }
        if (commandLineArguments.hasOption("f")) {
            object = BFileSystem.INSTANCE.findFile(new FilePath(commandLineArguments.getOption("f")));
            if (object == null) {
                System.out.println("File not found");
                return 1;
            }
            bufferedReader = new BufferedReader(new InputStreamReader(object.getInputStream()));
        } else {
            bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            bl = true;
        }
        object = new HashMap();
        int n = 0;
        while (n < commandLineArguments.options.length) {
            if (!commandLineArguments.options[n].equals("f")) {
                ((HashMap)object).put(commandLineArguments.options[n], commandLineArguments.optionValues[n]);
            }
            ++n;
        }
        if (bl) {
            System.out.println("Type 'quit' to exit, 'help' for instructions");
            System.out.print("> ");
        }
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            if (bl2) {
                System.out.println(string);
            }
            string = string.trim();
            CommandLineArguments commandLineArguments2 = new CommandLineArguments(TextUtil.splitAndTrim((String)string, (char)' '));
            while (commandLineArguments2.parameters.length == 0 || commandLineArguments2.parameters[0].equals("plat")) {
                if (commandLineArguments2.parameters.length <= 0) continue;
                string = string.substring(5).trim();
                commandLineArguments2 = new CommandLineArguments(TextUtil.splitAndTrim((String)string, (char)' '));
            }
            if (commandLineArguments2.parameters.length == 0 || commandLineArguments2.parameters[0].trim().length() == 0) {
                if (commandLineArguments2.options.length > 0) {
                    this.help();
                }
                if (!bl) continue;
                System.out.print("> ");
                continue;
            }
            if (commandLineArguments2.parameters[0].equals("quit")) break;
            if (commandLineArguments2.parameters[0].equals("help")) {
                this.help();
                if (!bl) continue;
                System.out.print("> ");
                continue;
            }
            if (commandLineArguments2.parameters[0].equals("option")) {
                int n2 = 0;
                while (n2 < commandLineArguments2.options.length) {
                    ((HashMap)object).put(commandLineArguments2.options[n2], commandLineArguments2.optionValues[n2]);
                    ++n2;
                }
                if (!bl) continue;
                System.out.print("> ");
                continue;
            }
            if (commandLineArguments2.parameters[0].equals("removeopt")) {
                int n3 = 0;
                while (n3 < commandLineArguments2.options.length) {
                    ((HashMap)object).remove(commandLineArguments2.options[n3]);
                    ++n3;
                }
                if (!bl) continue;
                System.out.print("> ");
                continue;
            }
            if (commandLineArguments2.parameters[0].equals("showoptions")) {
                System.out.println("Default options:");
                Iterator iterator = ((HashMap)object).keySet().iterator();
                while (iterator.hasNext()) {
                    string2 = (String)iterator.next();
                    System.out.println("  " + string2 + ':' + ((HashMap)object).get(string2));
                }
                if (!bl) continue;
                System.out.print("> ");
                continue;
            }
            Iterator iterator = ((HashMap)object).keySet().iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                if (commandLineArguments2.hasOption(string2)) continue;
                string = string + " -" + string2 + ':' + ((HashMap)object).get(string2);
            }
            BPlat.parse(string);
            if (!bl) continue;
            System.out.print("> ");
        }
        bufferedReader.close();
        return 0;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$platform$command$BPlatformCommandScript;
        if (clazz == null) {
            clazz = class$com$tridium$platform$command$BPlatformCommandScript = BPlatformCommandScript.class("[Lcom.tridium.platform.command.BPlatformCommandScript;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

