/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ZipArchiveReader {
    private ZipInputStream in;
    private boolean isVerbose;

    public void extractAll(File file) throws IOException {
        ZipEntry zipEntry;
        if (!file.exists()) {
            throw new IllegalArgumentException("Path does not exist " + file);
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Path not a directory: " + file);
        }
        byte[] byArray = new byte[65000];
        while ((zipEntry = this.in.getNextEntry()) != null) {
            Object object;
            String string = file.getPath() + '/' + zipEntry.getName();
            String string2 = string.substring(0, string.lastIndexOf(47));
            new File(string2).mkdirs();
            if (zipEntry.isDirectory()) {
                object = new File(string);
                ((File)object).mkdir();
                if (this.isVerbose) {
                    System.out.println("ZipArchiveReader: creating dir " + string);
                }
            } else {
                object = new FileOutputStream(new File(string));
                if (this.isVerbose) {
                    System.out.println("ZipArchiveReader: expanding " + string);
                }
                int n = this.in.read(byArray);
                while (n >= 0) {
                    ((FileOutputStream)object).write(byArray, 0, n);
                    n = this.in.read(byArray);
                }
                ((OutputStream)object).flush();
                ((FileOutputStream)object).close();
            }
            this.in.closeEntry();
        }
    }

    private final /* synthetic */ void this() {
        this.isVerbose = false;
    }

    public ZipArchiveReader(File file, boolean bl) throws IOException {
        this.this();
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist: " + file);
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File is directory: " + file);
        }
        this.in = new ZipInputStream(new FileInputStream(file));
        this.isVerbose = bl;
        if (bl) {
            System.out.println("archive file name: " + file);
        }
    }
}

