/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install.part;

import com.tridium.install.BDependency;
import com.tridium.install.BVersion;
import com.tridium.install.PartSpec;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.part.BApplicationPart;
import com.tridium.install.part.BArchPart;
import com.tridium.install.part.BBrandPart;
import com.tridium.install.part.BGenericPart;
import com.tridium.install.part.BModelPart;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BVmPart;
import javax.baja.platform.install.BPlatformPartType;
import javax.baja.platform.install.PlatformPart;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.PatternFilter;
import javax.baja.util.Version;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BPart
extends BComponent {
    public static final Property dependencies = BPart.newProperty((int)1, (BValue)new BVector(), null);
    public static final Property partName = BPart.newProperty((int)1, (String)"unknown", null);
    public static final Property version = BPart.newProperty((int)1, (BValue)BVersion.makeZero(), null);
    public static final Property description = BPart.newProperty((int)1, (String)"", null);
    public static final Type TYPE;
    private BInstallable installable;
    private PartSpec spec;
    static /* synthetic */ Class class$com$tridium$install$part$BPart;

    public BVector getDependencies() {
        return (BVector)this.get(dependencies);
    }

    public void setDependencies(BVector bVector) {
        this.set(dependencies, (BValue)bVector, null);
    }

    public String getPartName() {
        return this.getString(partName);
    }

    public void setPartName(String string) {
        this.setString(partName, string, null);
    }

    public BVersion getVersion() {
        return (BVersion)this.get(version);
    }

    public void setVersion(BVersion bVersion) {
        this.set(version, (BValue)bVersion, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String string) {
        this.setString(description, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean equivalent(Object object) {
        if (object instanceof BPart) {
            BPart bPart = (BPart)((Object)object);
            boolean bl = false;
            if (this.getPartName().equals(bPart.getPartName()) && this.getType().equals(bPart.getType()) && this.getVersion().equivalent((Object)bPart.getVersion())) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public abstract boolean meets(BDependency var1);

    public BInstallable getInstallable() {
        if (this.installable == null) {
            BComplex bComplex = this.getParent();
            while (bComplex != null) {
                if (bComplex instanceof BInstallable) {
                    this.installable = (BInstallable)bComplex;
                    break;
                }
                bComplex = bComplex.getParent();
            }
        }
        return this.installable;
    }

    public void setInstallable(BInstallable bInstallable) {
        this.installable = bInstallable;
    }

    public boolean isInstallable() {
        return false;
    }

    public XElem getXml() {
        throw new UnsupportedOperationException();
    }

    public static String getVendorVersion(XElem xElem) {
        return xElem.get("vendorVersion", xElem.get("version", "0"));
    }

    public static final BPart makePart(XElem xElem, BInstallable bInstallable) {
        BPart bPart = null;
        if (xElem.name().equals("os")) {
            bPart = BOsPart.make(xElem, bInstallable);
        } else if (xElem.name().equals("vm")) {
            bPart = BVmPart.make(xElem, bInstallable);
        } else if (xElem.name().equals("arch")) {
            bPart = BArchPart.make(xElem, bInstallable);
        } else if (xElem.name().equals("brand")) {
            bPart = BBrandPart.make(xElem, bInstallable);
        } else if (xElem.name().equals("nre")) {
            bPart = BNrePart.make(xElem, bInstallable);
        } else if (xElem.name().equals("part")) {
            bPart = BGenericPart.make(xElem, bInstallable);
        } else if (xElem.name().equals("model")) {
            bPart = BModelPart.make(xElem, bInstallable);
        } else if (xElem.name().equals("app")) {
            bPart = BApplicationPart.make(xElem, bInstallable);
        }
        return bPart;
    }

    public PartSpec getPartSpec() {
        if (this.spec == null) {
            this.spec = new PartSpec(this.getPartName(), this.getType());
        }
        return this.spec;
    }

    public PlatformPart asPlatformPart() {
        if (this.isNull()) {
            return null;
        }
        return new PlatformPart(){

            public final String getPartName() {
                return BPart.this.getPartName();
            }

            public final BPlatformPartType getPartType() {
                return BPart.getPlatformPartType(BPart.this.getType().getTypeSpec());
            }

            public final Version getPartVersion() {
                return BPart.this.getVersion().getVendorVersion();
            }
        };
    }

    public static BPlatformPartType getPlatformPartType(BTypeSpec bTypeSpec) {
        if (bTypeSpec.equals((Object)BArchPart.TYPE.getTypeSpec())) {
            return BPlatformPartType.arch;
        }
        if (bTypeSpec.equals((Object)BBrandPart.TYPE.getTypeSpec())) {
            return BPlatformPartType.brand;
        }
        if (bTypeSpec.equals((Object)BModelPart.TYPE.getTypeSpec())) {
            return BPlatformPartType.model;
        }
        if (bTypeSpec.equals((Object)BModulePart.TYPE.getTypeSpec())) {
            return BPlatformPartType.module;
        }
        if (bTypeSpec.equals((Object)BNrePart.TYPE.getTypeSpec())) {
            return BPlatformPartType.nre;
        }
        if (bTypeSpec.equals((Object)BOsPart.TYPE.getTypeSpec())) {
            return BPlatformPartType.os;
        }
        if (bTypeSpec.equals((Object)BVmPart.TYPE.getTypeSpec())) {
            return BPlatformPartType.vm;
        }
        return BPlatformPartType.other;
    }

    public static String getPartTypeName(Type type) {
        Lexicon lexicon = type.getModule().getLexicon();
        String string = BPart.getLexiconText(lexicon, type.getTypeName() + ".typeName");
        if (string == null) {
            if (type.getSuperType() == null) {
                return TYPE.getModule().getLexicon().getText("Unknown.typeName");
            }
            return BPart.getPartTypeName(type.getSuperType());
        }
        return string;
    }

    public static BIcon getPartTypeIcon(Type type) {
        Lexicon lexicon = type.getModule().getLexicon();
        String string = BPart.getLexiconText(lexicon, type.getTypeName() + ".typeIcon");
        if (string == null) {
            if (type.getSuperType() == null) {
                string = TYPE.getModule().getLexicon().getText("Unknown.typeIcon");
            } else {
                return BPart.getPartTypeIcon(type.getSuperType());
            }
        }
        return BIcon.make((String)string);
    }

    public static String getPartTypeShortName(Type type) {
        Lexicon lexicon = type.getModule().getLexicon();
        String string = BPart.getLexiconText(lexicon, type.getTypeName() + ".typeNameShort");
        if (string == null && (string = BPart.getLexiconText(lexicon, type.getTypeName() + ".typeName")) == null) {
            if (type.getSuperType() == null) {
                return TYPE.getModule().getLexicon().getText("Unknown.typeName");
            }
            return BPart.getPartTypeShortName(type.getSuperType());
        }
        return string;
    }

    public BDependency[] getDependencyArray() {
        Property[] propertyArray = this.getDependencies().getPropertiesArray();
        BDependency[] bDependencyArray = new BDependency[propertyArray.length];
        int n = 0;
        while (n < propertyArray.length) {
            bDependencyArray[n] = (BDependency)this.getDependencies().get(propertyArray[n]);
            ++n;
        }
        return bDependencyArray;
    }

    public boolean matchesName(String string) {
        return BPart.matchesName(this.getPartName(), string);
    }

    public static boolean isWildcardName(String string) {
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case '\t': 
                case ' ': 
                case '*': 
                case ',': 
                case ';': 
                case '?': {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    public static boolean matchesName(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        PatternFilter[] patternFilterArray = PatternFilter.parseList((String)string2);
        int n = 0;
        while (n < patternFilterArray.length) {
            if (patternFilterArray[n].accept(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static final String getLexiconText(Lexicon lexicon, String string) {
        String string2 = lexicon.getText(string);
        if (string2.equals(string)) {
            return null;
        }
        return string2;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.installable = null;
        this.spec = null;
    }

    public BPart() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$install$part$BPart;
        if (clazz == null) {
            clazz = class$com$tridium$install$part$BPart = BPart.class("[Lcom.tridium.install.part.BPart;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

