/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BPartInstallStatus;
import com.tridium.install.BVersion;
import com.tridium.install.InstallableCandidates;
import com.tridium.install.InstallableFilter;
import com.tridium.install.PartSpec;
import com.tridium.install.SolutionParameters;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.ClosableCursor;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BArchPart;
import com.tridium.install.part.BBrandPart;
import com.tridium.install.part.BGenericPart;
import com.tridium.install.part.BModelPart;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BPart;
import com.tridium.install.part.BVmPart;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.ByteArrayFileTransferElement;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteFileTransferMessageElement;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.message.UpdateTimeMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.timezone.TimeZoneUtil;
import com.tridium.util.graph.Digraph;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.baja.file.BIFile;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.platform.ICancelHint;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.sys.BComponent;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class InstallScenario {
    public static BDependency BAJA_3_5 = new BDependency("baja", new BVersion("3.5"), BModulePart.TYPE.getTypeSpec());
    public static BDependency NRE_3_7 = new BDependency("*", new BVersion("3.7"), BNrePart.TYPE.getTypeSpec());
    public static BDependency PLATDIALUP_3_7 = new BDependency("platDialup", new BVersion("3.7"), BModulePart.TYPE.getTypeSpec());
    private static Log log = Log.getLog((String)"platform.install");
    private Array toInstall;
    private Set modulesToUninstall;
    private BDaemonPlatform targetPlatform;
    private HostState endStateFixed;
    private HostState endStateMutable;
    private InstallableCandidates candidates;
    private SolutionParameters solutionParms;
    private Array excludedInstallables;
    private Map statusByPartSpec;
    private BModuleContent newModuleContent;
    private BTcpIpHostSettings tcpIpChanges;
    private BTimeZone newOsTimeZone;
    private long processingFlags;
    private boolean isSolved;
    private int nStandalone;
    private InstallableRegistry registry;
    static /* synthetic */ Class class$com$tridium$install$part$BPart;
    static /* synthetic */ Class class$com$tridium$install$installable$BModuleInstallable;
    static /* synthetic */ Class class$com$tridium$install$BDependency;
    static /* synthetic */ Class class$com$tridium$install$installable$BInstallable;
    static /* synthetic */ Class class$java$lang$String;

    protected InstallScenario copy() {
        InstallableCandidates installableCandidates = this.candidates.newCopy();
        TreeSet treeSet = new TreeSet();
        treeSet.addAll(this.modulesToUninstall);
        return new InstallScenario(this.targetPlatform, this.toInstall.copy(), this.excludedInstallables.copy(), treeSet, this.endStateFixed, this.endStateMutable.copy(), installableCandidates, this.newModuleContent, this.tcpIpChanges, this.newOsTimeZone, this.processingFlags, this.solutionParms, this.registry);
    }

    public boolean hasChanges() {
        boolean bl = false;
        if (this.toInstall.size() > 0 || this.modulesToUninstall.size() > 0 || this.newModuleContent != null || this.tcpIpChanges != null || (this.processingFlags & 0x200000L) > 0L && !this.newOsTimeZone.isNull()) {
            bl = true;
        }
        return bl;
    }

    public BInstallable[] getToInstall() {
        return (BInstallable[])this.toInstall.trim();
    }

    public String[] getModulesToUninstall() {
        String[] stringArray = new String[this.modulesToUninstall.size()];
        this.modulesToUninstall.toArray(stringArray);
        return stringArray;
    }

    public InstallableCandidates getInstallableCandidates() {
        return this.candidates;
    }

    public BDependency[] getUnmetDependencies() {
        return this.candidates.getDependencies();
    }

    public UnmeetableDependency[] getUnmeetableDependencies() {
        return this.candidates.getUnmeetableDependencies(this);
    }

    public BDependency getFailedExclusion(BDependency bDependency) {
        return this.candidates.getFailedExclusion(bDependency, this);
    }

    public InstallableFilter getFailedFilter(BDependency bDependency) {
        return this.candidates.getFailedFilter(bDependency, this);
    }

    public boolean installableNotFound(BDependency bDependency) {
        return this.candidates.installableNotFound(bDependency, this);
    }

    public boolean isDependencyUnsolvable(BDependency bDependency) {
        return this.candidates.isDependencyUnsolvable(bDependency, this);
    }

    public BInstallable[] getExcludedInstallables() {
        return (BInstallable[])this.excludedInstallables.trim();
    }

    public BPart[] getParts() {
        Class clazz = class$com$tridium$install$part$BPart;
        if (clazz == null) {
            clazz = class$com$tridium$install$part$BPart = InstallScenario.class("[Lcom.tridium.install.part.BPart;", false);
        }
        Array array = new Array(clazz);
        array.addAll((Object[])this.endStateFixed.getParts());
        array.addAll((Object[])this.endStateMutable.getParts());
        return (BPart[])array.trim();
    }

    public BModuleContent getNewModuleContent() {
        return this.newModuleContent;
    }

    public BTcpIpHostSettings getTcpIpChanges() {
        return this.tcpIpChanges;
    }

    public BTimeZone getNewOsTimeZone() {
        return this.newOsTimeZone;
    }

    public long getProcessingFlags() {
        return this.processingFlags;
    }

    public BDaemonPlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    public BPartInstallStatus getPartStatus(BPart bPart) {
        return this.getPartStatus(bPart.getPartName(), bPart.getType().getTypeSpec());
    }

    public synchronized BPartInstallStatus getPartStatus(String string, BTypeSpec bTypeSpec) {
        BPartInstallStatus bPartInstallStatus;
        BComponent bComponent;
        if (this.candidates.size() > 0) {
            throw new IllegalStateException("Attempt to get part status from scenario with unmet dependencies");
        }
        if (this.excludedInstallables.size() > 0) {
            throw new IllegalStateException("Attempt to get part status from scenario with excluded installables");
        }
        PartSpec partSpec = new PartSpec(string, bTypeSpec);
        if (this.statusByPartSpec == null) {
            this.statusByPartSpec = new HashMap();
            Iterator iterator = this.modulesToUninstall.iterator();
            while (iterator.hasNext()) {
                this.statusByPartSpec.put(PartSpec.forModule((String)iterator.next()), BPartInstallStatus.uninstall);
            }
            int n = 0;
            while (n < this.toInstall.size()) {
                bComponent = (BInstallable)this.toInstall.get(n);
                BPart bPart = bComponent.getPart();
                if (bPart != null) {
                    BPart bPart2 = this.targetPlatform.getPart(bPart);
                    if (bPart2 == null) {
                        this.statusByPartSpec.put(bPart.getPartSpec(), BPartInstallStatus.install);
                    } else {
                        BVersion bVersion = bPart2.getVersion();
                        BVersion bVersion2 = bPart.getVersion();
                        switch (bVersion.checkVersionRequirement(bVersion2)) {
                            case 2: {
                                if (bPart2 instanceof BModulePart) {
                                    BModulePart bModulePart = (BModulePart)bPart2;
                                    BModulePart bModulePart2 = (BModulePart)bPart;
                                    if (bModulePart.getBuildAbsTime() != null && bModulePart2.getBuildAbsTime() != null) {
                                        int n2 = bModulePart2.getBuildAbsTime().compareTo((Object)bModulePart.getBuildAbsTime());
                                        if (n2 > 0) {
                                            this.statusByPartSpec.put(bPart.getPartSpec(), BPartInstallStatus.upgrade);
                                            break;
                                        }
                                        if (n2 < 0) {
                                            this.statusByPartSpec.put(bPart.getPartSpec(), BPartInstallStatus.downgrade);
                                            break;
                                        }
                                        this.statusByPartSpec.put(bPart.getPartSpec(), BPartInstallStatus.reinstall);
                                        break;
                                    }
                                    this.statusByPartSpec.put(bPart.getPartSpec(), BPartInstallStatus.reinstall);
                                    break;
                                }
                                this.statusByPartSpec.put(bPart.getPartSpec(), BPartInstallStatus.reinstall);
                                break;
                            }
                            case 8: 
                            case 16: {
                                this.statusByPartSpec.put(bPart.getPartSpec(), BPartInstallStatus.reinstall);
                                break;
                            }
                            case 4: {
                                this.statusByPartSpec.put(bPart.getPartSpec(), BPartInstallStatus.upgrade);
                                break;
                            }
                            default: {
                                this.statusByPartSpec.put(bPart.getPartSpec(), BPartInstallStatus.downgrade);
                            }
                        }
                    }
                }
                ++n;
            }
        }
        if ((bPartInstallStatus = (BPartInstallStatus)((Object)this.statusByPartSpec.get(partSpec))) == null) {
            bComponent = this.targetPlatform.getPart(string, bTypeSpec);
            bPartInstallStatus = bComponent == null ? BPartInstallStatus.notFound : BPartInstallStatus.noChange;
            this.statusByPartSpec.put(partSpec, bPartInstallStatus);
        }
        return bPartInstallStatus;
    }

    public static InstallScenario solve(BDaemonPlatform bDaemonPlatform, DaemonSessionTaskListener daemonSessionTaskListener, String[] stringArray, BDependency[] bDependencyArray, BInstallable[] bInstallableArray, InstallableRegistry installableRegistry) throws Exception {
        return InstallScenario.solve(bDaemonPlatform, stringArray, bDependencyArray, bInstallableArray, new SolutionParameters(daemonSessionTaskListener), installableRegistry);
    }

    public static InstallScenario solve(BDaemonPlatform bDaemonPlatform, String[] stringArray, BDependency[] bDependencyArray, BInstallable[] bInstallableArray, SolutionParameters solutionParameters, InstallableRegistry installableRegistry) throws Exception {
        return new InstallScenario(bDaemonPlatform, stringArray, bDependencyArray, bInstallableArray, BTimeZone.NULL, null, null, solutionParameters, installableRegistry).solve();
    }

    public InstallScenario solve() throws Exception {
        if (this.isSolved) {
            this.traceState("Already solved");
            return this;
        }
        if (this.candidates.size() == 0) {
            if (this.modulesToUninstall.size() == 0) {
                InstallScenario installScenario;
                BPart bPart;
                this.isSolved = true;
                this.traceState("Complete solution");
                if (!this.getTargetPlatform().meets(NRE_3_7) && this.endStateMutable.meets(NRE_3_7) && !this.endStateMutable.meets(PLATDIALUP_3_7) && (bPart = this.getTargetPlatform().getModuleList().getPart("platDialup")) != null && (installScenario = this.solve(this.solutionParms.listener, null, new BDependency[]{PLATDIALUP_3_7}, null, this.registry)).canCommit()) {
                    return installScenario;
                }
                return this;
            }
            BModulePart[] bModulePartArray = this.endStateMutable.getModules();
            int n = 0;
            while (n < bModulePartArray.length) {
                BInstallable bInstallable = this.registry.findInstallable(BDependency.forPart(bModulePartArray[n], BVersionRelation.exact), null);
                if (bInstallable == null) {
                    bInstallable = this.registry.findInstallable(BDependency.forModule(bModulePartArray[n].getPartName()), this.solutionParms.listener);
                }
                if (bInstallable != null) {
                    BDependency[] bDependencyArray = bInstallable.getAllDependencies();
                    int n2 = 0;
                    while (n2 < bDependencyArray.length) {
                        if (bDependencyArray[n2].getPartTypeSpec().equals((Object)BModulePart.TYPE.getTypeSpec()) && this.modulesToUninstall.contains(bDependencyArray[n2].getPartName())) {
                            this.addCandidates(bDependencyArray[n2]);
                            break;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            if (this.candidates.size() > 0) {
                this.traceState("Uninstalls break dependencies");
            } else {
                this.traceState("Complete solution");
            }
            this.isSolved = true;
            return this;
        }
        Object object = this.candidates.getFirstKey();
        BInstallable[] bInstallableArray = this.candidates.getCandidates(object);
        if (bInstallableArray.length == 0) {
            this.traceState("Incomplete solution");
            this.isSolved = true;
            return this;
        }
        log.trace("At least 1 candidate for " + object);
        InstallScenario installScenario = null;
        int n = 0;
        while (n < bInstallableArray.length) {
            BInstallable bInstallable = bInstallableArray[n];
            InstallScenario installScenario2 = this.copy();
            installScenario2.install(bInstallable, object);
            installScenario2 = installScenario2.solve();
            if (installScenario2.candidates.size() == 0) {
                return installScenario2;
            }
            if (installScenario == null || installScenario2.candidates.size() < installScenario.candidates.size()) {
                if (installScenario == null) {
                    log.trace(object + " candidate " + n + ": " + bInstallable.getInstallableFileName() + " is first result considered");
                } else {
                    log.trace(object + " candidate " + n + ": " + bInstallable.getInstallableFileName() + " beats best result");
                }
                installScenario = installScenario2;
            } else {
                log.trace(object + " candidate " + n + ": " + bInstallable.getInstallableFileName() + " isn't as good as best result, discarding");
            }
            ++n;
        }
        this.isSolved = true;
        return installScenario;
    }

    public boolean isSolved() {
        return this.isSolved;
    }

    public InstallableRegistry getInstallableRegistry() {
        return this.registry;
    }

    public InstallScenario solve(DaemonSessionTaskListener daemonSessionTaskListener, String[] stringArray, BDependency[] bDependencyArray, BInstallable[] bInstallableArray, InstallableRegistry installableRegistry) throws Exception {
        Class clazz;
        Class clazz2;
        if (this.excludedInstallables.size() > 0) {
            throw new IllegalStateException("Some installables are excluded");
        }
        Class clazz3 = class$java$lang$String;
        if (clazz3 == null) {
            clazz3 = class$java$lang$String = InstallScenario.class("[Ljava.lang.String;", false);
        }
        Array array = new Array(clazz3);
        array.addAll((Object[])this.getModulesToUninstall());
        if (stringArray != null) {
            array.addAll((Object[])stringArray);
        }
        if ((clazz2 = class$com$tridium$install$BDependency) == null) {
            clazz2 = class$com$tridium$install$BDependency = InstallScenario.class("[Lcom.tridium.install.BDependency;", false);
        }
        Array array2 = new Array(clazz2);
        array2.addAll((Object[])this.getUnmetDependencies());
        if (bDependencyArray != null) {
            array2.addAll((Object[])bDependencyArray);
        }
        if ((clazz = class$com$tridium$install$installable$BInstallable) == null) {
            clazz = class$com$tridium$install$installable$BInstallable = InstallScenario.class("[Lcom.tridium.install.installable.BInstallable;", false);
        }
        Array array3 = new Array(clazz);
        array3.addAll((Object[])this.getToInstall());
        if (bInstallableArray != null) {
            array3.addAll((Object[])bInstallableArray);
        }
        return new InstallScenario(this.getTargetPlatform(), (String[])array.trim(), (BDependency[])array2.trim(), (BInstallable[])array3.trim(), this.getNewOsTimeZone(), this.getTcpIpChanges(), this.getNewModuleContent(), this.solutionParms, installableRegistry).solve();
    }

    public boolean canCommit() {
        boolean bl = false;
        if (this.candidates.size() == 0 && this.excludedInstallables.size() == 0 && this.targetPlatform != null && (this.nStandalone == 0 || this.nStandalone == 1 && this.toInstall.size() == 1)) {
            bl = true;
        }
        return bl;
    }

    public void commit(DaemonSessionTaskListener daemonSessionTaskListener, ICancelHint iCancelHint, boolean bl) throws Exception {
        this.commit(daemonSessionTaskListener, new StoreCache(), iCancelHint, bl);
    }

    public void commit(DaemonSessionTaskListener daemonSessionTaskListener, ICancelHint iCancelHint) throws Exception {
        this.commit(daemonSessionTaskListener, new StoreCache(), iCancelHint, false);
    }

    public void commit(DaemonSessionTaskListener daemonSessionTaskListener, StoreCache storeCache, ICancelHint iCancelHint) throws Exception {
        this.commit(daemonSessionTaskListener, storeCache, iCancelHint, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit(DaemonSessionTaskListener daemonSessionTaskListener, StoreCache storeCache, ICancelHint iCancelHint, boolean bl) throws Exception {
        FileTransferMessageElement[] fileTransferMessageElementArray;
        BComponent bComponent;
        Object object;
        if (this.candidates.size() > 0) {
            throw new IllegalStateException("Cannot commit a scenario having unmet dependencies");
        }
        if (this.excludedInstallables.size() > 0) {
            throw new IllegalStateException("Cannot commit a scenario having excluded installables");
        }
        if (this.targetPlatform == null) {
            throw new IllegalStateException("Cannot commit a scenario having no target platform");
        }
        if (this.nStandalone > 2 || this.nStandalone == 1 && this.toInstall.size() > 1) {
            throw new IllegalStateException("Cannot commit a scenario having a standalone installable with any other installables");
        }
        if (daemonSessionTaskListener == null) {
            daemonSessionTaskListener = DaemonSessionTaskListener.NULL_TASK_LISTENER;
        }
        if ((this.processingFlags & 0x200000L) > 0L) {
            object = new DaemonSessionTask(Lexicon.make((String)"platform"), "InstallManifest.newOsTimeZone.title", "InstallManifest.newOsTimeZone.message", new Object[]{this.getNewOsTimeZone()});
            daemonSessionTaskListener.taskStarted((DaemonSessionTask)object);
            try {
                this.targetPlatform.getDaemonSession().sendMessage(new UpdateTimeMessage(null, null, TimeZoneUtil.makeCompatible(this.getNewOsTimeZone(), this.targetPlatform.getDaemonSession().getHostProperties().getTimezoneDayModeSupport())));
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                daemonSessionTaskListener.taskFinished((DaemonSessionTask)object);
                throw throwable;
            }
            {
                bComponent = null;
                daemonSessionTaskListener.taskFinished((DaemonSessionTask)object);
            }
        }
        if (!this.targetPlatform.meets(NRE_3_7) && this.endStateMutable.meets(NRE_3_7) && this.targetPlatform.getDaemonSession().getHostProperties().supportsServlet("dialup")) {
            this.targetPlatform.getDaemonSession().sendMessage(new DaemonMessage(){

                public final String getMessageString() {
                    return "dialup/stop";
                }
            });
        }
        if (storeCache == null) {
            storeCache = new StoreCache();
        }
        object = new FileTransferMessage(false, storeCache, this.targetPlatform.getDaemonSession().getFileSpace());
        if ((this.processingFlags & 0x100000L) > 0L && this.getNewModuleContent() != null) {
            DaemonSessionTask daemonSessionTask = new DaemonSessionTask(Lexicon.make((String)"platform"), "InstallManifest.newModuleContent.title", "InstallManifest.newModuleContent.message", new Object[]{this.getNewModuleContent()});
            daemonSessionTaskListener.taskStarted(daemonSessionTask);
            try {
                this.targetPlatform.getDaemonSession().sendMessage(new UpdateModuleContentMessage(this.getNewModuleContent()));
                this.targetPlatform.setModuleContent(this.getNewModuleContent());
            }
            catch (Throwable throwable) {
                Object var8_15 = null;
                daemonSessionTaskListener.taskFinished(daemonSessionTask);
                throw throwable;
            }
            {
                fileTransferMessageElementArray = null;
                daemonSessionTaskListener.taskFinished(daemonSessionTask);
            }
        }
        int n = 0;
        block6: while (true) {
            if (n >= this.toInstall.size()) break;
            bComponent = (BInstallable)this.toInstall.get(n);
            log.trace("Getting transfer elements for " + bComponent.getInstallableName());
            fileTransferMessageElementArray = bComponent.getTransferElements(this.targetPlatform, storeCache, iCancelHint, daemonSessionTaskListener);
            log.trace("Adding transfer elements for " + bComponent.getInstallableName());
            int n2 = 0;
            while (true) {
                if (n2 >= fileTransferMessageElementArray.length) {
                    ++n;
                    continue block6;
                }
                if (bl && fileTransferMessageElementArray[n2].getRequestMethod().equals("POST") && (fileTransferMessageElementArray[n2].getFilePath().getBody().equals("!daemon/daemon.properties") || fileTransferMessageElementArray[n2].getFilePath().getBody().equals("/niagara/daemon/daemon.properties"))) {
                    ((FileTransferMessage)object).addElement(this.revertAuthProperties(fileTransferMessageElementArray[n2], this.targetPlatform));
                } else {
                    ((FileTransferMessage)object).addElement(fileTransferMessageElementArray[n2]);
                }
                ++n2;
            }
            break;
        }
        Iterator iterator = this.modulesToUninstall.iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            bComponent = (BModulePart)this.targetPlatform.getPart((String)iterator.next(), BModulePart.TYPE.getTypeSpec(), daemonSessionTaskListener);
            if (bComponent == null) continue;
            ((FileTransferMessage)object).addElement(new DeleteFileTransferMessageElement(bComponent.getDestinationPath(), this.targetPlatform.getDaemonSession().getFileSpace()));
        }
        log.trace("Starting file transfer");
        boolean bl2 = DaemonFileUtil.transfer(this.targetPlatform.getDaemonSession(), (FileTransferMessage)object, iCancelHint, daemonSessionTaskListener);
        int n3 = 0;
        while (true) {
            if (n3 >= this.toInstall.size()) {
                if (bl2) break;
                throw new BajaRuntimeException("transfer failed");
            }
            ((BInstallable)this.toInstall.get(n3)).close();
            ++n3;
        }
        this.targetPlatform.getModuleList().reset();
    }

    /*
     * Unable to fully structure code
     */
    public static InstallScenario upgradeOutOfDate(InstallScenario var0, InstallableRegistry var1_1) throws Exception {
        if (var0.nStandalone > 0) {
            return var0;
        }
        if (var0.candidates.size() > 0) {
            throw new IllegalArgumentException("Scenario has unmet dependencies");
        }
        if (var0.excludedInstallables.size() > 0) {
            throw new IllegalArgumentException("Scenario has excluded installables");
        }
        var2_2 = var0;
        var3_3 = var2_2.getTargetPlatform();
        var3_3.checkSession(var0.getSolutionParameters().listener);
        var4_4 = new HashMap<String, BPart>();
        var5_5 = var2_2.getModulesToUninstall();
        var6_6 = 0;
        while (var6_6 < var5_5.length) {
            var4_4.put(var5_5[var6_6], null);
            ++var6_6;
        }
        var6_7 = var2_2.getToInstall();
        var7_8 = 0;
        while (var7_8 < var6_7.length) {
            var8_10 = var6_7[var7_8].getPart();
            if (var8_10 != null && var8_10 instanceof BModulePart) {
                var4_4.put(var8_10.getPartName(), var8_10);
            }
            ++var7_8;
        }
        var2_2 = var2_2.solve();
        v0 = InstallScenario.class$com$tridium$install$installable$BInstallable;
        if (v0 == null) {
            v0 = InstallScenario.class$com$tridium$install$installable$BInstallable = InstallScenario.class("[Lcom.tridium.install.installable.BInstallable;", false);
        }
        var7_9 = new Array(v0);
        var7_9.addAll((Object[])var2_2.getToInstall());
        var3_3.getModuleList().init(var0.getSolutionParameters().listener);
        var8_10 = new Digraph();
        var9_11 = var3_3.getModuleList().getModules().getProperties();
        if (true) ** GOTO lbl50
        do {
            if (!var8_10.hasVertex(var11_14 = (var10_12 = (BModuleInstallable)var9_11.get()).getModulePart().getPartName())) {
                var8_10.addVertex(var11_14);
            }
            var12_15 = var10_12.getAllDependencies();
            var13_16 = 0;
            while (var13_16 < var12_15.length) {
                if (var12_15[var13_16].getPartType().equals(BModulePart.TYPE)) {
                    var14_17 = var12_15[var13_16].getPartName();
                    if (!var8_10.hasVertex(var14_17)) {
                        var8_10.addVertex(var14_17);
                    }
                    var8_10.addEdge(var14_17, var11_14);
                }
                ++var13_16;
            }
lbl50:
            // 2 sources

            if ((v1 = InstallScenario.class$com$tridium$install$installable$BModuleInstallable) != null) continue;
            v1 = InstallScenario.class("[Lcom.tridium.install.installable.BModuleInstallable;", false);
        } while (var9_11.next(v1));
        var9_11 = var8_10.topologicalSort();
        var10_13 = 0;
        while (var10_13 < var9_11.length) {
            var11_14 = var3_3.getModuleList().getModuleInstallable(var9_11[var10_13].toString());
            if (var11_14 != null) {
                var2_2 = InstallScenario.checkModuleForUpgrades(var2_2, var11_14.getModulePart(), var4_4, var1_1);
            }
            ++var10_13;
        }
        return var2_2;
    }

    protected void addCandidates(BDependency bDependency) throws Exception {
        this.addCandidates(bDependency, this.candidates);
    }

    protected boolean addCandidates(BDependency bDependency, InstallableCandidates installableCandidates) throws Exception {
        if (installableCandidates.containsKey((Object)bDependency)) {
            boolean bl = false;
            if (installableCandidates.getCandidates((Object)bDependency).length > 0) {
                bl = true;
            }
            return bl;
        }
        installableCandidates.addAll(this.solutionParms.getAdditionalCandidates(this, bDependency));
        Class clazz = class$com$tridium$install$installable$BInstallable;
        if (clazz == null) {
            clazz = class$com$tridium$install$installable$BInstallable = InstallScenario.class("[Lcom.tridium.install.installable.BInstallable;", false);
        }
        Array array = new Array(clazz);
        if (bDependency.canSolveWith(this.solutionParms.solvers) && this.registry != null && this.nStandalone == 0) {
            ClosableCursor closableCursor = this.registry.getInstallables(bDependency, this.solutionParms.listener);
            while (closableCursor.next()) {
                BInstallable bInstallable = (BInstallable)closableCursor.get();
                if (!this.solutionParms.acceptInstallable(bInstallable) || bInstallable.getPart() == null || this.shouldExclude(bInstallable)) continue;
                boolean bl = false;
                BDependency[] bDependencyArray = bInstallable.getAllDependencies();
                int n = 0;
                while (n < bDependencyArray.length) {
                    Type type = bDependencyArray[n].getPartType();
                    if ((type == BArchPart.TYPE || type == BGenericPart.TYPE || type == BModelPart.TYPE || type == BOsPart.TYPE && !this.targetPlatform.getOsPart().isInstallable()) && !this.targetPlatform.meets(bDependencyArray[n])) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (bl) continue;
                array.add((Object)bInstallable);
                if (this.solutionParms.latestOnly) break;
            }
        }
        installableCandidates.set((Object)bDependency, (BInstallable[])array.trim());
        boolean bl = false;
        if (array.size() > 0) {
            bl = true;
        }
        return bl;
    }

    private final FileTransferMessageElement revertAuthProperties(FileTransferMessageElement fileTransferMessageElement, BDaemonPlatform bDaemonPlatform) throws Exception {
        Object object;
        BIFile bIFile = bDaemonPlatform.getDaemonSession().getFileSpace().findFile(fileTransferMessageElement.getFilePath());
        boolean bl = false;
        Properties properties = new Properties();
        properties.load(fileTransferMessageElement.getStream());
        boolean bl2 = false;
        if (properties.remove("authtype") != null || bl) {
            bl2 = true;
        }
        bl = bl2;
        boolean bl3 = false;
        if (properties.remove("user") != null || bl) {
            bl3 = true;
        }
        bl = bl3;
        boolean bl4 = false;
        if (properties.remove("usergroupsid") != null || bl) {
            bl4 = true;
        }
        bl = bl4;
        boolean bl5 = false;
        if (properties.remove("admingroupsid") != null || bl) {
            bl5 = true;
        }
        bl = bl5;
        boolean bl6 = false;
        if (properties.remove("password") != null || bl) {
            bl6 = true;
        }
        bl = bl6;
        boolean bl7 = false;
        if (properties.remove("stationIsAdmin") != null || bl) {
            bl7 = bl = true;
        }
        if (bIFile != null) {
            object = new Properties();
            ((Properties)object).load(bIFile.getInputStream());
            if (((Properties)object).getProperty("authtype") != null) {
                bl = true;
                properties.setProperty("authtype", ((Properties)object).getProperty("authtype"));
            }
            if (((Properties)object).getProperty("user") != null) {
                bl = true;
                properties.setProperty("user", ((Properties)object).getProperty("user"));
            }
            if (((Properties)object).getProperty("usergroupsid") != null) {
                bl = true;
                properties.setProperty("usergroupsid", ((Properties)object).getProperty("usergroupsid"));
            }
            if (((Properties)object).getProperty("admingroupsid") != null) {
                bl = true;
                properties.setProperty("admingroupsid", ((Properties)object).getProperty("admingroupsid"));
            }
            if (((Properties)object).getProperty("password") != null) {
                bl = true;
                properties.setProperty("password", ((Properties)object).getProperty("password"));
            }
            if (((Properties)object).getProperty("stationIsAdmin") != null) {
                bl = true;
                properties.setProperty("stationIsAdmin", ((Properties)object).getProperty("stationIsAdmin"));
            }
        }
        if (bl) {
            object = new ByteArrayOutputStream();
            properties.store((OutputStream)object, null);
            ((OutputStream)object).flush();
            ((ByteArrayOutputStream)object).close();
            return new ByteArrayFileTransferElement(fileTransferMessageElement.getFilePath(), ((ByteArrayOutputStream)object).toByteArray(), bDaemonPlatform.getDaemonSession().getFileSpace());
        }
        return fileTransferMessageElement;
    }

    protected void registerLocalInstallables(BInstallable bInstallable) {
        if (this.registry == LocalInstallableRegistry.getInstance()) {
            try {
                bInstallable.registerInstallableResources(this.solutionParms.listener);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void install(BInstallable bInstallable, Object object) throws Exception {
        Object object2;
        long l = Clock.ticks();
        log.trace("installing " + bInstallable.getInstallableFileName() + " to meet " + object);
        Class clazz = class$com$tridium$install$BDependency;
        if (clazz == null) {
            clazz = class$com$tridium$install$BDependency = InstallScenario.class("[Lcom.tridium.install.BDependency;", false);
        }
        Array array = new Array(clazz);
        this.candidates.removeKey(object);
        this.toInstall.add((Object)bInstallable);
        this.endStateMutable.add(bInstallable);
        this.registerLocalInstallables(bInstallable);
        long l2 = bInstallable.getProcessingFlags(this.targetPlatform, this.solutionParms.listener);
        if ((l2 & 0x100000L) > 0L) {
            this.newModuleContent = bInstallable.getNewModuleContent();
        }
        if ((l2 & 0x80000L) > 0L && bInstallable.getTcpIpChanges() != null && !bInstallable.getTcpIpChanges().getIsReadonly()) {
            this.tcpIpChanges = bInstallable.getTcpIpChanges();
        }
        if ((l2 & 0x200000L) > 0L) {
            this.newOsTimeZone = bInstallable.getNewOsTimeZone();
        }
        if ((l2 & 0x100000L) > 0L) {
            object2 = this.endStateMutable.getModules();
            int n = 0;
            while (n < ((BModulePart[])object2).length) {
                if (this.newModuleContent.getOrdinal() > object2[n].getArchiveContent().getOrdinal()) {
                    array.add((Object)BDependency.forPart(object2[n]));
                    this.endStateMutable.remove(object2[n]);
                }
                ++n;
            }
        }
        if ((l2 & (long)4) > 0L && (l2 & (long)2) == 0L && (this.processingFlags & (long)2) == 0L && !this.targetPlatform.meets(BAJA_3_5)) {
            l2 |= (long)2;
        }
        this.processingFlags |= l2;
        if (bInstallable instanceof BModuleInstallable) {
            this.modulesToUninstall.remove(bInstallable.getPart().getPartName());
        }
        array.addAll((Object[])bInstallable.getAllDependencies());
        object2 = new HashSet();
        InstallableCandidates installableCandidates = new InstallableCandidates();
        int n = 0;
        while (n < array.size()) {
            BDependency bDependency = (BDependency)((Object)array.get(n));
            if (!this.endStateFixed.meets(bDependency) && !this.endStateMutable.meets(bDependency)) {
                boolean bl = true;
                Object[] objectArray = this.candidates.getKeys();
                int n2 = 0;
                while (n2 < objectArray.length) {
                    if (objectArray[n2] instanceof BDependency) {
                        BDependency bDependency2 = (BDependency)((Object)objectArray[n2]);
                        BDependency.DependencySync dependencySync = BDependency.sync(bDependency2, bDependency);
                        if (dependencySync == BDependency.DEP_SYNC_KEEP_SECOND) {
                            object2.add(bDependency2);
                            break;
                        }
                        if (dependencySync == BDependency.DEP_SYNC_KEEP_FIRST) {
                            bl = false;
                            break;
                        }
                        if (dependencySync != BDependency.DEP_SYNC_NO_CHANGE && dependencySync != BDependency.DEP_SYNC_CONFLICT) {
                            object2.add(bDependency2);
                            bDependency = dependencySync.mergedResult;
                            break;
                        }
                    }
                    ++n2;
                }
                if (bl) {
                    this.addCandidates(bDependency, installableCandidates);
                }
            }
            ++n;
        }
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            this.candidates.removeKey(iterator.next());
        }
        this.candidates.addAll(installableCandidates);
        log.trace("install exits " + (Clock.ticks() - l) + "ms");
    }

    public boolean shouldExclude(BInstallable bInstallable) {
        boolean bl = false;
        if (this.getFailedExclusion(bInstallable) != null) {
            bl = true;
        }
        return bl;
    }

    public BDependency getFailedExclusion(BInstallable bInstallable) {
        BDependency[] bDependencyArray = bInstallable.getAllExclusions();
        int n = 0;
        while (n < bDependencyArray.length) {
            if (this.endStateFixed.meets(bDependencyArray[n]) || this.endStateMutable.meets(bDependencyArray[n])) {
                return bDependencyArray[n];
            }
            ++n;
        }
        BPart bPart = bInstallable.getPart();
        if (bPart != null) {
            int n2 = 0;
            while (n2 < this.toInstall.size()) {
                bDependencyArray = ((BInstallable)this.toInstall.get(n2)).getAllExclusions();
                int n3 = 0;
                while (n3 < bDependencyArray.length) {
                    if (bPart.meets(bDependencyArray[n3])) {
                        return bDependencyArray[n3];
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        return null;
    }

    protected void traceState(String string) {
        int n;
        log.trace(string);
        BPart[] bPartArray = this.getParts();
        if (bPartArray.length == 0) {
            log.trace("  no parts");
        } else {
            log.trace("  parts:");
            n = 0;
            while (n < bPartArray.length) {
                log.trace("    " + (Object)((Object)bPartArray[n]));
                ++n;
            }
        }
        if (this.toInstall.size() == 0 && this.modulesToUninstall.size() == 0) {
            log.trace("  no actions");
        } else {
            log.trace("  actions:");
            n = 0;
            while (n < this.toInstall.size()) {
                log.trace("   install " + ((BInstallable)this.toInstall.get(n)).getInstallableFileName());
                ++n;
            }
            Iterator iterator = this.modulesToUninstall.iterator();
            while (iterator.hasNext()) {
                log.trace("   uninstall module " + iterator.next());
            }
        }
        if (this.candidates.size() == 0) {
            log.trace("  no unresolved dependencies");
        } else {
            log.trace("  unresolved dependencies:");
            BDependency[] bDependencyArray = this.candidates.getDependencies();
            int n2 = 0;
            while (n2 < bDependencyArray.length) {
                log.trace("    " + (Object)((Object)bDependencyArray[n2]));
                ++n2;
            }
        }
        if (this.excludedInstallables.size() == 0) {
            log.trace("  no excluded installables");
        } else {
            log.trace("  excluded installables:");
            int n3 = 0;
            while (n3 < this.excludedInstallables.size()) {
                log.trace("   " + ((BInstallable)this.excludedInstallables.get(n3)).getInstallableFileName());
                ++n3;
            }
        }
    }

    private static final InstallScenario checkModuleForUpgrades(InstallScenario installScenario, BModulePart bModulePart, Map map, InstallableRegistry installableRegistry) throws Exception {
        if (map.containsKey(bModulePart.getPartName()) || installScenario.nStandalone > 0) {
            return installScenario;
        }
        BDependency bDependency = BDependency.forPart(bModulePart, BVersionRelation.minimum);
        ClosableCursor closableCursor = installableRegistry.getInstallables(bDependency, installScenario.getSolutionParameters().listener);
        while (closableCursor.next()) {
            Object object;
            BModuleInstallable bModuleInstallable = (BModuleInstallable)closableCursor.get();
            if (!((BModulePart)bModuleInstallable.getPart()).isUpgradeFor(bModulePart)) continue;
            boolean bl = true;
            BDependency[] bDependencyArray = bModuleInstallable.getAllDependencies();
            int n = 0;
            while (n < bDependencyArray.length) {
                if (map.containsKey(bDependencyArray[n].getPartName())) {
                    object = (BModulePart)((Object)map.get(bDependencyArray[n].getPartName()));
                    if (object == null || !object.meets(bDependencyArray[n])) {
                        bl = false;
                        break;
                    }
                } else if (!(bDependencyArray[n].canSolveWith(installScenario.getSolutionParameters().solvers) || installScenario.endStateMutable.meets(bDependencyArray[n]) || installScenario.endStateFixed.meets(bDependencyArray[n]))) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (bl) {
                BInstallable[] bInstallableArray = installScenario.getToInstall();
                object = new BInstallable[bInstallableArray.length + 1];
                object[0] = bModuleInstallable;
                System.arraycopy(bInstallableArray, 0, object, 1, bInstallableArray.length);
                InstallScenario installScenario2 = new InstallScenario(installScenario.getTargetPlatform(), installScenario.getModulesToUninstall(), installScenario.getUnmetDependencies(), (BInstallable[])object, installScenario.getNewOsTimeZone(), installScenario.getTcpIpChanges(), installScenario.getNewModuleContent(), installScenario.getSolutionParameters(), installableRegistry).solve();
                if (installScenario2.canCommit()) {
                    map.put(bModulePart.getPartName(), bModuleInstallable.getModulePart());
                    return installScenario2;
                }
            }
            if (installScenario.getSolutionParameters().latestOnly) break;
        }
        closableCursor.close();
        map.put(bModulePart.getPartName(), bModulePart);
        return installScenario;
    }

    public SolutionParameters getSolutionParameters() {
        return this.solutionParms;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.statusByPartSpec = null;
        this.newModuleContent = null;
        this.tcpIpChanges = null;
        this.newOsTimeZone = BTimeZone.NULL;
        this.processingFlags = 0L;
        this.isSolved = false;
        this.nStandalone = 0;
    }

    public InstallScenario(BDaemonPlatform bDaemonPlatform, DaemonSessionTaskListener daemonSessionTaskListener, String[] stringArray, BDependency[] bDependencyArray, BInstallable[] bInstallableArray, InstallableRegistry installableRegistry) throws Exception {
        this(bDaemonPlatform, stringArray, bDependencyArray, bInstallableArray, BTimeZone.NULL, null, null, new SolutionParameters(daemonSessionTaskListener), installableRegistry);
    }

    public InstallScenario(BDaemonPlatform bDaemonPlatform, DaemonSessionTaskListener daemonSessionTaskListener, String[] stringArray, BDependency[] bDependencyArray, BInstallable[] bInstallableArray, BTimeZone bTimeZone, BTcpIpHostSettings bTcpIpHostSettings, BModuleContent bModuleContent, InstallableRegistry installableRegistry) throws Exception {
        this(bDaemonPlatform, stringArray, bDependencyArray, bInstallableArray, bTimeZone, bTcpIpHostSettings, bModuleContent, new SolutionParameters(daemonSessionTaskListener), installableRegistry);
    }

    /*
     * Unable to fully structure code
     */
    public InstallScenario(BDaemonPlatform var1_1, String[] var2_2, BDependency[] var3_3, BInstallable[] var4_4, BTimeZone var5_5, BTcpIpHostSettings var6_6, BModuleContent var7_7, SolutionParameters var8_8, InstallableRegistry var9_9) throws Exception {
        block27: {
            block26: {
                super();
                this.this();
                this.registry = var9_9;
                this.solutionParms = var8_8;
                if (var8_8 == null) {
                    throw new IllegalArgumentException("solutionParms may not be null");
                }
                this.targetPlatform = var1_1;
                this.newOsTimeZone = var5_5 == null ? BTimeZone.NULL : var5_5;
                this.tcpIpChanges = var6_6;
                this.newModuleContent = var7_7;
                if (var1_1 != null) {
                    var1_1.checkSession(var8_8.listener);
                    var1_1.getModuleList().init(var8_8.listener);
                    if (var7_7 != null && var7_7 != var1_1.getModuleContent()) {
                        this.processingFlags |= 0x100000L;
                    }
                }
                this.endStateFixed = new HostState();
                if (var1_1 == null) break block26;
                this.endStateFixed.add(var1_1.getArchPart());
                this.endStateFixed.add(var1_1.getBrandPart());
                this.endStateFixed.add(var1_1.getModelPart());
                var10_10 = var1_1.getOtherParts().getProperties();
                if (true) ** GOTO lbl25
                do {
                    this.endStateFixed.add((BPart)var10_10.get());
lbl25:
                    // 2 sources

                    if ((v0 = InstallScenario.class$com$tridium$install$part$BPart) != null) continue;
                    v0 = InstallScenario.class("[Lcom.tridium.install.part.BPart;", false);
                } while (var10_10.next(v0));
            }
            this.endStateMutable = new HostState();
            if (var1_1 == null) break block27;
            this.endStateMutable.add(var1_1.getOsPart());
            this.endStateMutable.add(var1_1.getNrePart());
            this.endStateMutable.add(var1_1.getVmPart());
            var10_10 = var1_1.getModuleList().getModules().getProperties();
            if (true) ** GOTO lbl38
            do {
                this.endStateMutable.add((BModuleInstallable)var10_10.get());
lbl38:
                // 2 sources

                if ((v1 = InstallScenario.class$com$tridium$install$installable$BModuleInstallable) != null) continue;
                v1 = InstallScenario.class("[Lcom.tridium.install.installable.BModuleInstallable;", false);
            } while (var10_10.next(v1));
        }
        this.modulesToUninstall = new TreeSet<E>();
        if (var2_2 != null) {
            var10_11 = 0;
            while (var10_11 < var2_2.length) {
                this.processingFlags |= (long)2;
                this.endStateMutable.remove(var2_2[var10_11]);
                this.modulesToUninstall.add(var2_2[var10_11]);
                ++var10_11;
            }
        }
        if (var3_3 == null) {
            v2 = InstallScenario.class$com$tridium$install$BDependency;
            if (v2 == null) {
                v2 = InstallScenario.class$com$tridium$install$BDependency = InstallScenario.class("[Lcom.tridium.install.BDependency;", false);
            }
            var10_12 = new Array(v2);
        } else {
            var10_12 = new Array((Object[])var3_3);
        }
        if ((v3 = InstallScenario.class$com$tridium$install$installable$BInstallable) == null) {
            v3 = InstallScenario.class$com$tridium$install$installable$BInstallable = InstallScenario.class("[Lcom.tridium.install.installable.BInstallable;", false);
        }
        this.toInstall = new Array(v3);
        v4 = InstallScenario.class$com$tridium$install$installable$BInstallable;
        if (v4 == null) {
            v4 = InstallScenario.class$com$tridium$install$installable$BInstallable = InstallScenario.class("[Lcom.tridium.install.installable.BInstallable;", false);
        }
        this.excludedInstallables = new Array(v4);
        this.nStandalone = 0;
        if (var4_4 != null) {
            var11_13 = 0;
            while (var11_13 < var4_4.length) {
                if (this.shouldExclude(var4_4[var11_13])) {
                    this.excludedInstallables.add((Object)var4_4[var11_13]);
                } else {
                    if (var4_4[var11_13].getIsStandalone()) {
                        ++this.nStandalone;
                    }
                    this.toInstall.add((Object)var4_4[var11_13]);
                    var12_16 = var4_4[var11_13].getProcessingFlags(var1_1, var8_8.listener);
                    if ((var12_16 & 0x100000L) > 0L) {
                        this.newModuleContent = var4_4[var11_13].getNewModuleContent();
                    }
                    if ((var12_16 & 524288L) > 0L && var4_4[var11_13].getTcpIpChanges() != null && !var4_4[var11_13].getTcpIpChanges().getIsReadonly()) {
                        this.tcpIpChanges = var4_4[var11_13].getTcpIpChanges();
                    }
                    if ((var12_16 & 0x200000L) > 0L) {
                        this.newOsTimeZone = var4_4[var11_13].getNewOsTimeZone();
                    }
                    if ((var12_16 & (long)4) > 0L && (var12_16 & (long)2) == 0L && (this.processingFlags & (long)2) == 0L && !var1_1.meets(InstallScenario.BAJA_3_5)) {
                        var12_16 |= (long)2;
                    }
                    this.processingFlags |= var12_16;
                    this.endStateMutable.add(var4_4[var11_13]);
                    this.registerLocalInstallables(var4_4[var11_13]);
                    var10_12.addAll((Object[])var4_4[var11_13].getAllDependencies());
                }
                ++var11_13;
            }
        }
        if ((this.processingFlags & 0x100000L) > 0L) {
            var11_14 = this.endStateMutable.getModules();
            var12_17 = 0;
            while (var12_17 < var11_14.length) {
                if (this.newModuleContent.getOrdinal() > var11_14[var12_17].getArchiveContent().getOrdinal()) {
                    var10_12.add((Object)BDependency.forPart(var11_14[var12_17]));
                    this.endStateMutable.remove(var11_14[var12_17]);
                }
                ++var12_17;
            }
        }
        var10_12 = new Array((Object[])BDependency.merge((BDependency[])var10_12.trim()));
        this.candidates = new InstallableCandidates();
        var11_15 = 0;
        while (var11_15 < var10_12.size()) {
            var12_19 = (BDependency)var10_12.get(var11_15);
            if (!this.endStateFixed.meets(var12_19) && !this.endStateMutable.meets(var12_19)) {
                this.addCandidates(var12_19);
            }
            ++var11_15;
        }
        this.traceState("Initial state");
    }

    protected InstallScenario(BDaemonPlatform bDaemonPlatform, Array array, Array array2, Set set, HostState hostState, HostState hostState2, InstallableCandidates installableCandidates, BModuleContent bModuleContent, BTcpIpHostSettings bTcpIpHostSettings, BTimeZone bTimeZone, long l, SolutionParameters solutionParameters, InstallableRegistry installableRegistry) {
        this.this();
        this.targetPlatform = bDaemonPlatform;
        this.toInstall = array;
        this.excludedInstallables = array2;
        this.modulesToUninstall = set;
        this.endStateFixed = hostState;
        this.endStateMutable = hostState2;
        this.candidates = installableCandidates;
        this.registry = installableRegistry;
        this.newModuleContent = bModuleContent;
        this.tcpIpChanges = bTcpIpHostSettings;
        this.solutionParms = solutionParameters;
        this.newOsTimeZone = bTimeZone == null ? BTimeZone.NULL : bTimeZone;
        this.processingFlags = l;
        this.nStandalone = 0;
        int n = 0;
        while (n < array.size()) {
            if (((BInstallable)array.get(n)).getIsStandalone()) {
                ++this.nStandalone;
            }
            ++n;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class HostState {
        private Map partsByType;
        static /* synthetic */ Class class$com$tridium$install$part$BPart;

        public HostState copy() {
            HostState hostState = new HostState();
            Iterator iterator = this.partsByType.keySet().iterator();
            while (iterator.hasNext()) {
                BTypeSpec bTypeSpec = (BTypeSpec)iterator.next();
                if (this.isUniquePartType(bTypeSpec)) {
                    hostState.add((BPart)((Object)this.partsByType.get(bTypeSpec)));
                    continue;
                }
                Map map = (Map)this.partsByType.get(bTypeSpec);
                Iterator iterator2 = map.values().iterator();
                while (iterator2.hasNext()) {
                    hostState.add((BPart)((Object)iterator2.next()));
                }
            }
            return hostState;
        }

        public void add(BInstallable bInstallable) {
            BPart bPart = bInstallable.getPart();
            if (bPart != null) {
                this.add(bPart);
            }
        }

        public void add(BPart bPart) {
            if (bPart != null) {
                if (this.isUniquePartType(bPart.getType().getTypeSpec())) {
                    this.partsByType.put(bPart.getType().getTypeSpec(), bPart);
                } else {
                    HashMap<String, BPart> hashMap = (HashMap<String, BPart>)this.partsByType.get(bPart.getType().getTypeSpec());
                    if (hashMap == null) {
                        hashMap = new HashMap<String, BPart>();
                        this.partsByType.put(bPart.getType().getTypeSpec(), hashMap);
                    }
                    hashMap.put(bPart.getPartName(), bPart);
                }
            }
        }

        public void remove(BInstallable bInstallable) {
            if (bInstallable != null) {
                this.remove(bInstallable.getPart());
            }
        }

        public void remove(BPart bPart) {
            if (bPart != null) {
                if (this.isUniquePartType(bPart.getType().getTypeSpec())) {
                    BPart bPart2 = (BPart)((Object)this.partsByType.get(bPart.getType().getTypeSpec()));
                    if (bPart2 != null && bPart2.equivalent((Object)bPart)) {
                        this.partsByType.remove(bPart.getType().getTypeSpec());
                    }
                } else {
                    Map map = (Map)this.partsByType.get(bPart.getType().getTypeSpec());
                    if (map != null) {
                        map.remove(bPart.getPartName());
                    }
                }
            }
        }

        public void remove(String string) {
            Iterator iterator = this.partsByType.keySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                BTypeSpec bTypeSpec = (BTypeSpec)iterator.next();
                if (this.isUniquePartType(bTypeSpec)) {
                    object = (BPart)((Object)this.partsByType.get(bTypeSpec));
                    if (!object.getPartName().equals(string)) continue;
                    this.partsByType.remove(bTypeSpec);
                    return;
                }
                object = (Map)this.partsByType.get(bTypeSpec);
                if (object.remove(string) == null) continue;
                return;
            }
        }

        public boolean meets(BDependency bDependency) {
            if (this.isUniquePartType(bDependency.getPartTypeSpec())) {
                BPart bPart = (BPart)((Object)this.partsByType.get(bDependency.getPartTypeSpec()));
                boolean bl = false;
                if (bPart != null && bPart.meets(bDependency)) {
                    bl = true;
                }
                return bl;
            }
            Map map = (Map)this.partsByType.get(bDependency.getPartTypeSpec());
            if (map != null) {
                if (BPart.isWildcardName(bDependency.getPartName())) {
                    Iterator iterator = map.values().iterator();
                    while (iterator.hasNext()) {
                        BPart bPart = (BPart)((Object)iterator.next());
                        if (!bPart.meets(bDependency)) continue;
                        return true;
                    }
                } else {
                    BPart bPart = (BPart)((Object)map.get(bDependency.getPartName()));
                    if (bPart != null && bPart.meets(bDependency)) {
                        return true;
                    }
                }
            }
            return false;
        }

        public BModulePart[] getModules() {
            Map map = (Map)this.partsByType.get(BModulePart.TYPE.getTypeSpec());
            if (map == null) {
                return new BModulePart[0];
            }
            BModulePart[] bModulePartArray = new BModulePart[map.size()];
            int n = 0;
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                bModulePartArray[n++] = (BModulePart)((Object)iterator.next());
            }
            return bModulePartArray;
        }

        private final boolean isUniquePartType(BTypeSpec bTypeSpec) {
            boolean bl = false;
            if (!bTypeSpec.equals((Object)BModulePart.TYPE.getTypeSpec()) && (bTypeSpec.equals((Object)BArchPart.TYPE.getTypeSpec()) || bTypeSpec.equals((Object)BOsPart.TYPE.getTypeSpec()) || bTypeSpec.equals((Object)BNrePart.TYPE.getTypeSpec()) || bTypeSpec.equals((Object)BBrandPart.TYPE.getTypeSpec()) || bTypeSpec.equals((Object)BVmPart.TYPE.getTypeSpec()) || bTypeSpec.equals((Object)BModelPart.TYPE.getTypeSpec()))) {
                bl = true;
            }
            return bl;
        }

        public BPart[] getParts() {
            Class clazz = class$com$tridium$install$part$BPart;
            if (clazz == null) {
                clazz = class$com$tridium$install$part$BPart = HostState.class("[Lcom.tridium.install.part.BPart;", false);
            }
            Array array = new Array(clazz);
            Iterator iterator = this.partsByType.keySet().iterator();
            while (iterator.hasNext()) {
                BTypeSpec bTypeSpec = (BTypeSpec)iterator.next();
                if (this.isUniquePartType(bTypeSpec)) {
                    array.add(this.partsByType.get(bTypeSpec));
                    continue;
                }
                Map map = (Map)this.partsByType.get(bTypeSpec);
                array.addAll(map.values());
            }
            return (BPart[])array.trim();
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private final /* synthetic */ void this() {
            this.partsByType = new HashMap();
        }

        public HostState() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class UpdateModuleContentMessage
    extends XmlResponseMessage {
        private BModuleContent flag;

        public String getMessageString() {
            return "updatedaemon?installFlag=" + this.flag.getTag();
        }

        public UpdateModuleContentMessage(BModuleContent bModuleContent) {
            this.flag = bModuleContent;
        }
    }
}

