/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.types;

import com.tridium.nrio.points.BNrioCounterInputProxyExt;
import com.tridium.nrio.types.BFixedWindowRateType;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSlidingWindowRateType
extends BFixedWindowRateType {
    public static final Property windows = BSlidingWindowRateType.newProperty((int)0, (int)6, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)2)));
    public static final Type TYPE;
    private Queue queue;
    private long lastTicks;
    private Clock.Ticket ticket;
    static /* synthetic */ Class class$com$tridium$nrio$types$BSlidingWindowRateType;

    public int getWindows() {
        return this.getInt(windows);
    }

    public void setWindows(int n) {
        this.setInt(windows, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning()) {
            if (property.equals((Object)windows)) {
                this.resizeQueue();
                this.resetRate();
                if (this.ticket != null) {
                    this.ticket.cancel();
                }
                this.ticket = Clock.schedulePeriodically((BComponent)this.getCounterProxy(), (BAbsTime)BAbsTime.now(), (BRelTime)BRelTime.make((long)this.getWindowSize()), (Action)BNrioCounterInputProxyExt.recalculateRate, null);
            }
            if (property.equals((Object)interval)) {
                this.resetRate();
                if (this.ticket != null) {
                    this.ticket.cancel();
                }
                this.ticket = Clock.schedulePeriodically((BComponent)this.getCounterProxy(), (BAbsTime)BAbsTime.now(), (BRelTime)BRelTime.make((long)this.getWindowSize()), (Action)BNrioCounterInputProxyExt.recalculateRate, null);
            }
        }
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.resizeQueue();
        this.resetRate();
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedulePeriodically((BComponent)this.getCounterProxy(), (BAbsTime)BAbsTime.now(), (BRelTime)BRelTime.make((long)this.getWindowSize()), (Action)BNrioCounterInputProxyExt.recalculateRate, null);
    }

    public void stopped() throws Exception {
        super.stopped();
        this.resetRate();
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = null;
    }

    public synchronized void resetRate() {
        this.queue.clear();
        this.lastTicks = 0L;
        if (this.getCounterProxy() != null) {
            this.getCounterProxy().setStale(true, null);
        }
    }

    public synchronized BStatusNumeric calculateRate(long l) {
        CountSample countSample;
        BStatusNumeric bStatusNumeric = null;
        long l2 = Clock.ticks();
        if (this.lastTicks == 0L) {
            this.lastTicks = l2;
            CountSample countSample2 = new CountSample(l2, l);
            this.queue.enqueue((Object)countSample2);
            return null;
        }
        long l3 = l2 - this.lastTicks;
        if (this.queue.size() == this.getWindows()) {
            countSample = (CountSample)this.queue.dequeue();
            long l4 = l - countSample.getCount();
            float f = (float)(l2 - countSample.getTicks()) / 1000.0f;
            float f2 = (float)l4 / f;
            bStatusNumeric = new BStatusNumeric((double)(f2 *= this.getScale()));
            this.getCounterProxy().setRateCalcTime(BAbsTime.now());
        }
        countSample = new CountSample(l2, l);
        this.queue.enqueue((Object)countSample);
        this.lastTicks = l2;
        if (bStatusNumeric == null) {
            bStatusNumeric = (BStatusNumeric)this.getCounterProxy().getReadValue();
        }
        return bStatusNumeric;
    }

    private final synchronized void resizeQueue() {
        Queue queue = new Queue(this.getWindows());
        if (this.queue != null) {
            int n = 0;
            while (n < this.queue.size()) {
                queue.enqueue(this.queue.dequeue());
                ++n;
            }
        }
        this.queue = queue;
    }

    private final synchronized long getWindowSize() {
        return this.getInterval().getSeconds() / this.getWindows() * 1000;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.queue = new Queue(6);
        this.lastTicks = 0L;
        this.ticket = null;
    }

    public BSlidingWindowRateType() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nrio$types$BSlidingWindowRateType;
        if (clazz == null) {
            clazz = class$com$tridium$nrio$types$BSlidingWindowRateType = BSlidingWindowRateType.class("[Lcom.tridium.nrio.types.BSlidingWindowRateType;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CountSample {
        private long ticks;
        private long count;

        public long getTicks() {
            return this.ticks;
        }

        public long getCount() {
            return this.count;
        }

        public String toString() {
            return " tx:" + this.ticks + ",cnt:" + this.count;
        }

        public CountSample(long l, long l2) {
            this.ticks = l;
            this.count = l2;
        }
    }
}

