/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.types;

import com.tridium.nrio.points.BNrioCounterInputProxyExt;
import com.tridium.nrio.types.BAbstractRateType;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BFixedWindowRateType
extends BAbstractRateType {
    public static final Property interval = BFixedWindowRateType.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)60), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.FALSE, (String)"min", (BIDataValue)BRelTime.make((long)1000L)));
    public static final Type TYPE;
    private long lastCount;
    private long lastTicks;
    private Clock.Ticket ticket;
    static /* synthetic */ Class class$com$tridium$nrio$types$BFixedWindowRateType;

    public BRelTime getInterval() {
        return (BRelTime)this.get(interval);
    }

    public void setInterval(BRelTime bRelTime) {
        this.set(interval, (BValue)bRelTime, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.resetRate();
        this.resetClockTicket();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.resetRate();
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = null;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && property.equals((Object)interval)) {
            this.resetRate();
            this.resetClockTicket();
        }
    }

    public synchronized void resetRate() {
        this.lastCount = 0L;
        this.lastTicks = 0L;
        if (this.getCounterProxy() != null) {
            this.getCounterProxy().setStale(true, null);
        }
    }

    public synchronized BStatusNumeric calculateRate(long l) {
        if (this.ticket == null) {
            this.resetClockTicket();
        }
        if (!this.ticket.isExpired()) {
            return new BStatusNumeric(this.getCounterProxy().getRate());
        }
        this.resetClockTicket();
        long l2 = Clock.ticks();
        if (this.lastTicks == 0L) {
            this.lastTicks = l2;
            this.lastCount = l;
            return null;
        }
        long l3 = l2 - this.lastTicks;
        float f = 1000.0f * (float)(l - this.lastCount) / (float)l3;
        this.lastTicks = l2;
        this.lastCount = l;
        BStatusNumeric bStatusNumeric = new BStatusNumeric((double)(f *= this.getScale()));
        this.getCounterProxy().setRateCalcTime(BAbsTime.now());
        return bStatusNumeric;
    }

    private final void resetClockTicket() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedule((BComponent)this.getCounterProxy(), (BRelTime)this.getInterval(), (Action)BNrioCounterInputProxyExt.recalculateRate, null);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lastCount = 0L;
        this.lastTicks = 0L;
        this.ticket = null;
    }

    public BFixedWindowRateType() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nrio$types$BFixedWindowRateType;
        if (clazz == null) {
            clazz = class$com$tridium$nrio$types$BFixedWindowRateType = BFixedWindowRateType.class("[Lcom.tridium.nrio.types.BFixedWindowRateType;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

