/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.nrio.messages.NrioInputStream;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.messages.NrioOutputStream;
import com.tridium.nrio.messages.NrioReceivedMessage;
import com.tridium.nrio.messages.NrioResponse;
import java.io.OutputStream;
import javax.baja.util.ByteArrayUtil;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NrioMessage
extends Message
implements NrioMessageConst {
    protected int address;
    protected int length;
    protected int type;
    protected int status;
    protected byte[] data;

    public int getAddress() {
        return this.address;
    }

    public int getLength() {
        return this.length;
    }

    public int getType() {
        return this.type;
    }

    public int getStatus() {
        return this.status;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isOk() {
        boolean bl = false;
        if (this.status == 0) {
            bl = true;
        }
        return bl;
    }

    public void setAddress(int n) {
        this.address = n;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public void write(OutputStream outputStream) {
        try {
            byte[] byArray = this.getByteArray();
            outputStream.write(byArray);
        }
        catch (Exception exception) {}
    }

    public byte[] getByteArray() {
        NrioOutputStream nrioOutputStream = new NrioOutputStream();
        nrioOutputStream.write(this.address);
        nrioOutputStream.write(2 + this.data.length);
        nrioOutputStream.write(this.type);
        nrioOutputStream.write(this.status);
        int n = 0;
        while (n < this.data.length) {
            nrioOutputStream.write(this.data[n]);
            ++n;
        }
        return nrioOutputStream.toByteArray();
    }

    public Message toResponse(ReceivedMessage receivedMessage) {
        NrioReceivedMessage nrioReceivedMessage = (NrioReceivedMessage)receivedMessage;
        NrioResponse nrioResponse = new NrioResponse();
        nrioResponse.readResponse(nrioReceivedMessage.getBytes(), nrioReceivedMessage.getLength());
        return nrioResponse;
    }

    public NrioInputStream readResponse(NrioReceivedMessage nrioReceivedMessage) {
        return this.decodeFromBytes(nrioReceivedMessage.getBytes(), nrioReceivedMessage.getLength());
    }

    public NrioInputStream decodeFromBytes(byte[] byArray, int n) {
        NrioInputStream nrioInputStream = new NrioInputStream(byArray, 0, n);
        this.address = nrioInputStream.read() & 0xFF;
        this.length = nrioInputStream.read() & 0xFF;
        this.type = nrioInputStream.read() & 0xFF;
        this.status = nrioInputStream.read() & 0xFF;
        this.data = new byte[nrioInputStream.available()];
        int n2 = 0;
        while (n2 < this.data.length) {
            this.data[n2] = (byte)(nrioInputStream.read() & 0xFF);
            ++n2;
        }
        nrioInputStream = new NrioInputStream(this.data);
        return nrioInputStream;
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NrioMessage       = " + TextUtil.getClassName(this.getClass()));
        stringBuffer.append("\n  address = " + Integer.toHexString(this.address));
        stringBuffer.append("\n  length  = " + Integer.toHexString(this.length));
        stringBuffer.append("\n  type    = " + Integer.toHexString(this.type));
        stringBuffer.append("\n  status  = " + Integer.toHexString(this.status));
        stringBuffer.append("\n  data    = " + ByteArrayUtil.toHexString((byte[])this.data));
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.data = new byte[0];
    }

    public NrioMessage() {
        this.this();
    }

    public NrioMessage(int n, int n2, byte[] byArray) {
        this.this();
        this.address = n;
        this.type = n2;
        this.status = 0;
        this.data = byArray;
    }
}

