/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioDeviceFolder;
import com.tridium.nrio.comm.NrioComm;
import com.tridium.nrio.comm.NrioUnsolicitedReceive;
import com.tridium.nrio.components.BNrioLearnDeviceEntry;
import com.tridium.nrio.components.BSdiValueConfig;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;
import com.tridium.nrio.job.BNrioLearnDevicesJob;
import com.tridium.nrio.job.BUpgradeFirmwareJob;
import com.tridium.nrio.messages.NrioMessage;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.messages.NrioReceivedMessage;
import com.tridium.nrio.messages.PingMessage;
import com.tridium.nrio.messages.ReadBuildInfoMessage;
import com.tridium.nrio.messages.ReadInfoMemoryMessage;
import com.tridium.nrio.messages.ResetMessage;
import com.tridium.nrio.messages.WriteConfigMessage;
import com.tridium.nrio.messages.WriteDOMessage;
import com.tridium.nrio.points.BNrioPointDeviceExt;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.baja.driver.BDevice;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BSerialBaudRate;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BModule;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNrioNetwork
extends BBasicNetwork
implements Runnable,
NrioMessageConst {
    public static final Property monitor = BNrioNetwork.newProperty((int)0, (BValue)BNrioNetwork.makePingMonitor(BRelTime.makeSeconds((int)30)), null);
    public static final Property portName = BNrioNetwork.newProperty((int)64, (String)"COM2", null);
    public static final Property trunk = BNrioNetwork.newProperty((int)64, (int)1, null);
    public static final Property baudRate = BNrioNetwork.newProperty((int)1, (BValue)BSerialBaudRate.baud115200, null);
    public static final Property sdiValueConfig = BNrioNetwork.newProperty((int)0, (BValue)new BSdiValueConfig(), null);
    public static final Property maxDevices = BNrioNetwork.newProperty((int)7, (int)0, null);
    public static final Property writeThreadSleepTime = BNrioNetwork.newProperty((int)4, (int)100, null);
    public static final Property unsolicitedMsgCount = BNrioNetwork.newProperty((int)3, (long)0L, null);
    public static final Property unsolicitedProcessTime = BNrioNetwork.newProperty((int)3, (int)0, null);
    public static final Property unsolicitedMessageRate = BNrioNetwork.newProperty((int)3, (float)0.0f, null);
    public static final Action submitDeviceDiscoveryJob = BNrioNetwork.newAction((int)4, null);
    public static final Action upgradeFirmware = BNrioNetwork.newAction((int)4, null);
    public static final Action winkDevice = BNrioNetwork.newAction((int)4, (BValue)BInteger.make((int)0), null);
    public static final Action enableWinking = BNrioNetwork.newAction((int)4, (BValue)new BNrioLearnDeviceEntry(), null);
    public static final Action disableWinking = BNrioNetwork.newAction((int)4, (BValue)new BNrioLearnDeviceEntry(), null);
    public static final Type TYPE;
    protected static byte[] NULL_BA;
    public static Lexicon lex;
    public Vector devices;
    private NrioUnsolicitedReceive unsolicitedReceive;
    private NrioComm nrioComm;
    private Thread wrThread;
    public boolean isSecurityLicensed;
    public boolean isNrioLicensed;
    private boolean downLoadInProcess;
    private boolean timeToDie;
    private boolean isStarted;
    public int logicalAddressMap;
    private long replyTicks;
    static /* synthetic */ Class class$com$tridium$nrio$BNrioNetwork;

    public static BPingMonitor makePingMonitor(BRelTime bRelTime) {
        BPingMonitor bPingMonitor = new BPingMonitor();
        bPingMonitor.setPingFrequency(bRelTime);
        return bPingMonitor;
    }

    public String getPortName() {
        return this.getString(portName);
    }

    public void setPortName(String string) {
        this.setString(portName, string, null);
    }

    public int getTrunk() {
        return this.getInt(trunk);
    }

    public void setTrunk(int n) {
        this.setInt(trunk, n, null);
    }

    public BBaudRate getBaudRate() {
        return (BBaudRate)this.get(baudRate);
    }

    public void setBaudRate(BBaudRate bBaudRate) {
        this.set(baudRate, (BValue)bBaudRate, null);
    }

    public BSdiValueConfig getSdiValueConfig() {
        return (BSdiValueConfig)this.get(sdiValueConfig);
    }

    public void setSdiValueConfig(BSdiValueConfig bSdiValueConfig) {
        this.set(sdiValueConfig, (BValue)bSdiValueConfig, null);
    }

    public int getMaxDevices() {
        return this.getInt(maxDevices);
    }

    public void setMaxDevices(int n) {
        this.setInt(maxDevices, n, null);
    }

    public long getWriteThreadSleepTime() {
        return this.getLong(writeThreadSleepTime);
    }

    public void setWriteThreadSleepTime(long l) {
        this.setLong(writeThreadSleepTime, l, null);
    }

    public long getUnsolicitedMsgCount() {
        return this.getLong(unsolicitedMsgCount);
    }

    public void setUnsolicitedMsgCount(long l) {
        this.setLong(unsolicitedMsgCount, l, null);
    }

    public int getUnsolicitedProcessTime() {
        return this.getInt(unsolicitedProcessTime);
    }

    public void setUnsolicitedProcessTime(int n) {
        this.setInt(unsolicitedProcessTime, n, null);
    }

    public float getUnsolicitedMessageRate() {
        return this.getFloat(unsolicitedMessageRate);
    }

    public void setUnsolicitedMessageRate(float f) {
        this.setFloat(unsolicitedMessageRate, f, null);
    }

    public BOrd submitDeviceDiscoveryJob() {
        return (BOrd)this.invoke(submitDeviceDiscoveryJob, null, null);
    }

    public BOrd upgradeFirmware() {
        return (BOrd)this.invoke(upgradeFirmware, null, null);
    }

    public void winkDevice(BInteger bInteger) {
        this.invoke(winkDevice, (BValue)bInteger, null);
    }

    public void enableWinking(BNrioLearnDeviceEntry bNrioLearnDeviceEntry) {
        this.invoke(enableWinking, (BValue)bNrioLearnDeviceEntry, null);
    }

    public void disableWinking(BNrioLearnDeviceEntry bNrioLearnDeviceEntry) {
        this.invoke(disableWinking, (BValue)bNrioLearnDeviceEntry, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if ((property.equals((Object)portName) || property.equals((Object)trunk)) && (NrioComm)this.getComm() != null) {
            ((NrioComm)this.getComm()).resetCommPort();
        }
    }

    public int getWriteThreadPriority() {
        return 5;
    }

    public int getReadThreadPriority() {
        return 5;
    }

    public void setWriteThreadPriority(int n) {
        if (this.wrThread.getPriority() != n) {
            this.getLog().trace("thread priority changed from " + this.wrThread.getPriority() + " to " + n);
            this.wrThread.setPriority(n);
        }
    }

    public void setReadThreadPriority(int n) {
        this.getUnsolicitedReceive().setThreadPriority(n);
    }

    public BINavNode[] getNavChildren() {
        BComponent bComponent;
        this.loadSlots();
        BComponent[] bComponentArray = new BComponent[this.getSlotCount()];
        SlotCursor slotCursor = this.getProperties();
        int n = 0;
        while (slotCursor.nextComponent()) {
            bComponent = (BComponent)slotCursor.get();
            if (Flags.isHidden((BComplex)this, (Slot)slotCursor.property()) || !bComponent.isNavChild() || bComponent.getPropertyInParent().isFrozen() && !(bComponent instanceof BNrioDevice)) continue;
            bComponentArray[n++] = bComponent;
            bComponent = null;
        }
        bComponent = new BComponent[n];
        System.arraycopy(bComponentArray, 0, bComponent, 0, n);
        bComponentArray = null;
        slotCursor = null;
        return bComponent;
    }

    public Type getDeviceType() {
        return BNrioDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BNrioDeviceFolder.TYPE;
    }

    public final Feature getLicenseFeature() {
        Feature feature = null;
        if (this.getType().getModule().getModuleName().equals("accessDriver")) {
            try {
                feature = Sys.getLicenseManager().getFeature("tridium", "accessControl");
            }
            catch (Exception exception) {}
            if (feature != null) {
                this.isSecurityLicensed = true;
                return feature;
            }
            this.isSecurityLicensed = false;
            throw new FeatureNotLicensedException("accessControl");
        }
        try {
            feature = Sys.getLicenseManager().getFeature("tridium", "nrio");
        }
        catch (Exception exception) {}
        if (feature != null) {
            this.isNrioLicensed = true;
            return feature;
        }
        this.isNrioLicensed = false;
        throw new FeatureNotLicensedException("nrio");
    }

    protected Comm makeComm() {
        return new NrioComm(this);
    }

    public void started() throws Exception {
        BIFile[] bIFileArray;
        if (!this.isSecurityLicensed && !this.isNrioLicensed) {
            this.getLog().error("network not starting because it is not licensed!");
            return;
        }
        super.started();
        BModule bModule = TYPE.getModule();
        BIFile bIFile = bModule.findFile(new FilePath("/com/tridium/nrio/download"));
        if (bIFile == null) {
            System.out.println("could not fine down load directory");
        }
        if ((bIFileArray = bModule.getChildren(bIFile)) != null) {
            int n = 0;
            while (n < bIFileArray.length) {
                String string = bIFileArray[n].getFileName();
                try {
                    String string2 = string.substring(1, 5);
                    String string3 = string.substring(6, string.indexOf(46));
                    int n2 = string3.indexOf(95);
                    String string4 = string3.substring(0, n2);
                    String string5 = string3.substring(n2 + 1);
                    if (this.get("T" + string2) == null) {
                        this.add("T" + string2, (BValue)BString.make((String)(string4 + '.' + string5)), 5);
                    } else {
                        this.set("T" + string2, (BValue)BString.make((String)(string4 + '.' + string5)));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
        }
        this.timeToDie = false;
        this.wrThread = new Thread((Runnable)this, "NrioWrThread" + this.getTrunk());
        this.wrThread.setPriority(this.getWriteThreadPriority());
        this.wrThread.start();
        this.setMaxDevices(this.getLicenseMaxDevices());
        this.isStarted = true;
    }

    public void stopped() throws Exception {
        this.isStarted = false;
        this.timeToDie = true;
        this.wrThread.interrupt();
        super.stopped();
    }

    public final int getLicenseMaxDevices() {
        Feature feature = this.getLicenseFeature();
        String string = feature.get("device.limit");
        if (string == null) {
            return 0;
        }
        if (string.equals("none")) {
            return 16;
        }
        return feature.geti("device.limit", 0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startComm() throws Exception {
        String string;
        block6: {
            try {
                super.startComm();
                this.nrioComm = (NrioComm)this.getComm();
                this.startUnsolicitedReceive();
                this.initLogicalAddressMap();
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                String string2 = ((NrioComm)this.getComm()).getCommInitError();
                if (string2 == null) {
                    this.configOk();
                    throw throwable;
                }
                this.configFail(string2);
                throw throwable;
            }
            {
                Object var2_4 = null;
                string = ((NrioComm)this.getComm()).getCommInitError();
                if (string != null) break block6;
            }
            this.configOk();
            return;
        }
        this.configFail(string);
    }

    public void stopComm() throws Exception {
        this.stopUnsolicitedReceive();
        super.stopComm();
    }

    public NrioUnsolicitedReceive getUnsolicitedReceive() {
        return this.unsolicitedReceive;
    }

    public void startUnsolicitedReceive() {
        this.unsolicitedReceive = new NrioUnsolicitedReceive(this);
        this.unsolicitedReceive.init();
        ((NrioComm)this.getComm()).registerListener(this.unsolicitedReceive);
        this.unsolicitedReceive.start();
    }

    public void stopUnsolicitedReceive() {
        try {
            if (this.unsolicitedReceive != null) {
                this.unsolicitedReceive.stop();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initNetwork() {
    }

    public Vector discover() {
        return ((NrioComm)this.getComm()).discover();
    }

    public void enablePolling(int n) {
        if (n == 0) {
            this.getLog().message("cannot enable polling on address 0 !!!");
            return;
        }
        ((NrioComm)this.getComm()).enablePolling(n);
    }

    public void disablePolling(int n) {
        if (n == 0) {
            this.getLog().message("cannot disable polling on address 0 !!!");
            return;
        }
        ((NrioComm)this.getComm()).disablePolling(n);
    }

    public NrioMessage sendReset(int n) {
        return this.sendNrioMessage(new ResetMessage(n));
    }

    public String readBuildInfo(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        ReadBuildInfoMessage readBuildInfoMessage = new ReadBuildInfoMessage(n);
        NrioMessage nrioMessage = this.sendNrioMessage(readBuildInfoMessage);
        if (nrioMessage.getStatus() != 0) {
            nrioMessage = this.sendNrioMessage(readBuildInfoMessage);
        }
        if (nrioMessage.getStatus() == 0) {
            stringBuffer.append(nrioMessage.getData()[0] & 0xFF);
            stringBuffer.append('.');
            stringBuffer.append(nrioMessage.getData()[1] & 0xFF);
        }
        return stringBuffer.toString();
    }

    public void readInfoMemory(int n) {
        ReadInfoMemoryMessage readInfoMemoryMessage = new ReadInfoMemoryMessage(n);
        NrioMessage nrioMessage = this.sendNrioMessage(readInfoMemoryMessage);
        if (nrioMessage.getStatus() != 0) {
            return;
        }
        byte[] byArray = nrioMessage.getData();
        System.out.println("             nodeAddr = " + (byArray[0] & 0xFF));
        System.out.println("       numMsgsOurAddr = " + (byArray[1] & 0xFF));
        System.out.println("          numMsgsRcvd = " + (byArray[2] & 0xFF));
        System.out.println("       numBadMsgsRcvd = " + (byArray[3] & 0xFF));
        System.out.println("   numMsgsTransmitted = " + (byArray[4] & 0xFF));
        System.out.println(" numIOStatusCrcErrors = " + (byArray[5] & 0xFF));
        System.out.println("numCardReadsProcessed = " + (byArray[6] & 0xFF));
        System.out.println("  numCardReadsXmitted = " + (byArray[7] & 0xFF));
        System.out.println("    numCardReadErrors = " + (byArray[8] & 0xFF));
        System.out.println("    num485ResetsOnRcv = " + (byArray[9] & 0xFF));
        System.out.println("       lastResetState = " + (byArray[10] & 0xFF));
    }

    public byte[] sendRequest(byte[] byArray) {
        return ((NrioComm)this.getComm()).sendRequest(byArray);
    }

    public NrioMessage sendNrioMessage(NrioMessage nrioMessage) {
        Object object;
        if (this.downLoadInProcess) {
            nrioMessage.setStatus(255);
            return nrioMessage;
        }
        byte[] byArray = nrioMessage.getByteArray();
        if (nrioMessage.getType() == 6 && (object = this.getConfigLog()).isTraceOn()) {
            object.trace("Writing config data to device: " + byArray[0]);
        }
        object = this.sendRequest(byArray);
        return (NrioMessage)nrioMessage.toResponse(new NrioReceivedMessage((byte[])object, ((Log)object).length, null));
    }

    public NrioMessage sendDownLoadMessage(NrioMessage nrioMessage, int n) {
        int n2 = 0;
        while (n2 <= n) {
            byte[] byArray = this.sendRequest(nrioMessage.getByteArray());
            NrioMessage nrioMessage2 = (NrioMessage)nrioMessage.toResponse(new NrioReceivedMessage(byArray, byArray.length, null));
            if (nrioMessage2 != null && nrioMessage2.isOk()) {
                return nrioMessage2;
            }
            if (n2 > 0) {
                System.out.println("sendDownLoadMessage error - retrying " + n2 + " times");
            } else if (n > 0) {
                System.out.println("sendDownLoadMessage error - returning null");
            }
            ++n2;
        }
        return null;
    }

    public static BNrioPointDeviceExt getDeviceExt(BComponent bComponent) {
        BComplex bComplex = bComponent.getParent();
        while (!(bComplex instanceof BNrioPointDeviceExt)) {
            if ((bComplex = bComplex.getParent()) != null) continue;
            return null;
        }
        return (BNrioPointDeviceExt)bComplex;
    }

    public BNrioDevice[] getNrioDevices() {
        return (BNrioDevice[])this.getDevices();
    }

    public BNrioDevice getDevice(byte[] byArray) {
        BBlob bBlob = BBlob.make((byte[])byArray);
        BDevice[] bDeviceArray = this.getDevices();
        int n = 0;
        while (n < bDeviceArray.length) {
            if (bDeviceArray[n] instanceof BNrioDevice && ((BNrioDevice)bDeviceArray[n]).getUid().equals((Object)bBlob)) {
                return (BNrioDevice)bDeviceArray[n];
            }
            ++n;
        }
        return null;
    }

    public void addDevice(BNrioDevice bNrioDevice) {
        if (!this.devices.contains((Object)bNrioDevice)) {
            this.devices.add(bNrioDevice);
        }
    }

    public void removeDevice(int n) {
        int n2 = 0;
        while (n2 < this.devices.size()) {
            if (this.devices.elementAt(n2) instanceof BNrioDevice && ((BNrioDevice)((Object)this.devices.elementAt(n2))).getAddress() == n) {
                this.devices.remove(n2);
                return;
            }
            ++n2;
        }
        System.out.println("could not find device to remove: address = " + n + ", size = " + this.devices.size());
    }

    public BNrioDevice getDevice(int n) {
        int n2 = 0;
        while (n2 < this.devices.size()) {
            if (this.devices.elementAt(n2) instanceof BNrioDevice && ((BNrioDevice)((Object)this.devices.elementAt(n2))).getAddress() == n) {
                return (BNrioDevice)((Object)this.devices.elementAt(n2));
            }
            ++n2;
        }
        return null;
    }

    public void doEnableWinking(BNrioLearnDeviceEntry bNrioLearnDeviceEntry) {
        if (this.isDownLoadInProcess()) {
            return;
        }
        this.getLog().trace(">>> BNrioDevice(" + this.getName() + ").doEnableWinking");
        PingMessage pingMessage = new PingMessage(bNrioLearnDeviceEntry.getAddress(), bNrioLearnDeviceEntry.getUid().copyBytes(), bNrioLearnDeviceEntry.getDeviceType());
        this.sendNrioMessage(pingMessage);
        WriteConfigMessage writeConfigMessage = new WriteConfigMessage(bNrioLearnDeviceEntry.getAddress(), 514);
        this.sendNrioMessage(writeConfigMessage);
        this.enablePolling(bNrioLearnDeviceEntry.getAddress());
    }

    public void doDisableWinking(BNrioLearnDeviceEntry bNrioLearnDeviceEntry) {
        WriteDOMessage writeDOMessage = new WriteDOMessage(bNrioLearnDeviceEntry.getAddress(), 0);
        this.sendNrioMessage(writeDOMessage);
        this.disablePolling(bNrioLearnDeviceEntry.getAddress());
    }

    public void doWinkDevice(BInteger bInteger) {
        int n = bInteger.getInt() >> 8;
        int n2 = (bInteger.getInt() & 0xFF) << 8;
        WriteDOMessage writeDOMessage = new WriteDOMessage(n, n2);
        this.sendNrioMessage(writeDOMessage);
    }

    public BOrd doSubmitDeviceDiscoveryJob() {
        if (this.getStatus().isDisabled()) {
            return null;
        }
        BNrioLearnDevicesJob bNrioLearnDevicesJob = new BNrioLearnDevicesJob(this);
        return bNrioLearnDevicesJob.submit(null);
    }

    public BOrd doUpgradeFirmware() {
        if (this.getStatus().isDisabled()) {
            return null;
        }
        BUpgradeFirmwareJob bUpgradeFirmwareJob = new BUpgradeFirmwareJob(this);
        return bUpgradeFirmwareJob.submit(null);
    }

    public void setDownLoadInProcess(boolean bl) {
        this.downLoadInProcess = bl;
        BDevice[] bDeviceArray = this.getDevices();
        int n = 0;
        while (n < bDeviceArray.length) {
            if (bDeviceArray[n] instanceof BNrioDevice) {
                if (bl) {
                    ((BNrioDevice)bDeviceArray[n]).doDisablePolling();
                } else if (!((BNrioDevice)bDeviceArray[n]).isDisabled()) {
                    ((BNrioDevice)bDeviceArray[n]).doEnablePolling();
                }
            }
            ++n;
        }
    }

    public boolean isDownLoadInProcess() {
        return this.downLoadInProcess;
    }

    public void initLogicalAddressMap() {
        int n = 1;
        while (n <= 16) {
            this.logicalAddressMap = this.getDevice(n) != null ? (this.logicalAddressMap |= 1 << n) : (this.logicalAddressMap &= ~(1 << n));
            ++n;
        }
    }

    public int getLogicalAddress(byte[] byArray) {
        BNrioDevice bNrioDevice = this.getDevice(byArray);
        if (bNrioDevice == null) {
            return -1;
        }
        return bNrioDevice.getAddress();
    }

    public int getFreeAddress(boolean bl) {
        int n = 1;
        int n2 = 16;
        int n3 = n;
        while (n3 <= n2) {
            if ((this.logicalAddressMap & 1 << n3) == 0) {
                this.logicalAddressMap |= 1 << n3;
                return n3;
            }
            ++n3;
        }
        n2 = 16;
        n3 = n;
        while (n3 <= n2) {
            if (this.getDevice(n3) == null) {
                System.out.println("getDevice(" + n3 + ") is not mounted yet");
                return -1;
            }
            System.out.println("getDevice(" + n3 + ").isDown() =  " + this.getDevice(n3).isDown());
            if (this.getDevice(n3).isDown()) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public void clearAddressUsed(int n) {
        this.logicalAddressMap &= ~(1 << n);
    }

    public BIFile getFirmwareFile(BNrioDeviceTypeEnum bNrioDeviceTypeEnum) {
        BModule bModule = TYPE.getModule();
        BIFile bIFile = bModule.findFile(new FilePath("/com/tridium/nrio/download"));
        if (bIFile == null) {
            System.out.println("could not fine down load directory");
            return null;
        }
        BIFile[] bIFileArray = bModule.getChildren(bIFile);
        String string = null;
        if (bNrioDeviceTypeEnum.equals((Object)BNrioDeviceTypeEnum.remoteReader)) {
            string = "2030";
        } else if (bNrioDeviceTypeEnum.equals((Object)BNrioDeviceTypeEnum.remoteInputOutput)) {
            string = "2034";
        } else if (bNrioDeviceTypeEnum.equals((Object)BNrioDeviceTypeEnum.baseBoardReader)) {
            string = "2029";
        } else if (bNrioDeviceTypeEnum.equals((Object)BNrioDeviceTypeEnum.io16)) {
            string = "2041";
        }
        if (string == null) {
            return null;
        }
        int n = 0;
        while (n < bIFileArray.length) {
            if (bIFileArray[n].getFileName().indexOf(string) > 0) {
                return bIFileArray[n];
            }
            ++n;
        }
        return null;
    }

    public void run() {
        try {
            Thread.sleep(20000L);
        }
        catch (Exception exception) {}
        BDevice[] bDeviceArray = this.getDevices();
        long l = Clock.ticks();
        while (!this.timeToDie) {
            try {
                if (Clock.ticks() - l > 30000L) {
                    bDeviceArray = this.getDevices();
                    l = Clock.ticks();
                    if (this.wrThread.getPriority() != this.getWriteThreadPriority()) {
                        this.wrThread.setPriority(this.getWriteThreadPriority());
                    }
                }
                int n = 0;
                while (n < bDeviceArray.length) {
                    if (bDeviceArray[n] != null && bDeviceArray[n] instanceof BNrioDevice && bDeviceArray[n].isRunning() && !bDeviceArray[n].isDown() && !bDeviceArray[n].isFault() && !bDeviceArray[n].isDisabled()) {
                        ((BNrioDevice)bDeviceArray[n]).doWriteDoValues();
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                System.out.println("WriteDoValues caught Exception: " + exception);
            }
            try {
                Thread.sleep(this.getWriteThreadSleepTime());
            }
            catch (Exception exception) {}
        }
    }

    public void interruptWriteThread() {
        this.wrThread.interrupt();
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        try {
            Object object;
            Object object2;
            spyWriter.startProps();
            spyWriter.trTitle((Object)"NrioUnsolicited", 1);
            spyWriter.prop((Object)"Message Count", (Object)new Long(this.getUnsolicitedMsgCount()));
            spyWriter.prop((Object)"Process Time(ms)", (Object)new Integer(this.getUnsolicitedProcessTime()));
            spyWriter.prop((Object)"Message Rate", (Object)new Float(this.getUnsolicitedMessageRate()));
            spyWriter.prop((Object)"DroppedByteCount", (Object)new Long(this.getUnsolicitedReceive().getDroppedByteCount()));
            spyWriter.endProps();
            spyWriter.startProps();
            spyWriter.trTitle((Object)"NrioNetwork Device Cache", 1);
            int n = 0;
            while (n < this.devices.size()) {
                object2 = (BNrioDevice)((Object)this.devices.elementAt(n));
                object = "logicalAddr " + ((BNrioDevice)((Object)object2)).getAddress() + ": ";
                spyWriter.prop(object, (Object)object2.getSlotPath());
                ++n;
            }
            spyWriter.endProps();
            spyWriter.startProps();
            spyWriter.trTitle((Object)"NrioNetwork Device Polling Data", 1);
            spyWriter.endProps();
            Runtime runtime = Runtime.getRuntime();
            object2 = runtime.exec("cat /dev/actrl" + this.getTrunk());
            object = ((Process)object2).getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            spyWriter.w((Object)"<pre>\n");
            String string = this.convertBogusChars(bufferedReader.readLine());
            while (string != null) {
                spyWriter.safe(string).w((Object)"\n");
                string = this.convertBogusChars(bufferedReader.readLine());
            }
            spyWriter.w((Object)"</pre>\n");
            bufferedReader.close();
            inputStreamReader.close();
            ((InputStream)object).close();
        }
        catch (Exception exception) {}
        spyWriter.endProps();
    }

    private final String convertBogusChars(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '\t') {
                stringBuffer.append("        ");
            } else if (cArray[n] != '\u0000') {
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public Log getConfigLog() {
        return Log.getLog((String)(this.getName() + ".config"));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.devices = new Vector();
        this.unsolicitedReceive = null;
        this.nrioComm = null;
        this.isSecurityLicensed = false;
        this.isNrioLicensed = false;
        this.downLoadInProcess = false;
        this.timeToDie = true;
        this.isStarted = false;
        this.logicalAddressMap = 0;
        this.replyTicks = 0L;
    }

    public BNrioNetwork() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nrio$BNrioNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$nrio$BNrioNetwork = BNrioNetwork.class("[Lcom.tridium.nrio.BNrioNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        NULL_BA = new byte[0];
        Class clazz2 = class$com$tridium$nrio$BNrioNetwork;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$nrio$BNrioNetwork = BNrioNetwork.class("[Lcom.tridium.nrio.BNrioNetwork;", false);
        }
        lex = Lexicon.make((Class)clazz2);
    }
}

