/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio;

import com.tridium.basicdriver.BBasicDevice;
import com.tridium.nrio.BNrioDeviceFolder;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.components.BIoStatus;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;
import com.tridium.nrio.messages.ClearInfoMemoryMessage;
import com.tridium.nrio.messages.NrioDeviceIoStatus;
import com.tridium.nrio.messages.NrioMessage;
import com.tridium.nrio.messages.NrioReceivedMessage;
import com.tridium.nrio.messages.PingMessage;
import com.tridium.nrio.messages.PingResponse;
import com.tridium.nrio.messages.ReadInfoMemoryMessage;
import com.tridium.nrio.messages.SetLogicalAddressMessage;
import com.tridium.nrio.points.BNrioPointDeviceExt;
import com.tridium.nrio.points.BNrioProxyExt;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.driver.point.BProxyExt;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNrioDevice
extends BBasicDevice {
    static byte[] defaultUid = new byte[6];
    public static final Action download = BNrioDevice.newAction((int)20, (BValue)new BDownloadParameters(), null);
    public static final Action upload = BNrioDevice.newAction((int)20, (BValue)new BUploadParameters(), null);
    public static final Property address = BNrioDevice.newProperty((int)65, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)16));
    public static final Property deviceType = BNrioDevice.newProperty((int)1, (BValue)BNrioDeviceTypeEnum.none, null);
    public static final Property uid = BNrioDevice.newProperty((int)65, (BValue)BBlob.make((byte[])defaultUid), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"nrio:FlexBlobFE")));
    public static final Property installedVersion = BNrioDevice.newProperty((int)65, (String)"", null);
    public static final Property availableVersion = BNrioDevice.newProperty((int)1, (String)"", null);
    public static final Property winkOutput = BNrioDevice.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt(null, (int)1, (int)8));
    public static final Property winkDuration = BNrioDevice.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)10), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeSeconds((int)60), (String)"min", (BIDataValue)BRelTime.makeSeconds((int)5)));
    public static final Property points = BNrioDevice.newProperty((int)0, (BValue)new BNrioPointDeviceExt(), null);
    public static final Property ioStatus = BNrioDevice.newProperty((int)65, (BValue)new BIoStatus(), null);
    public static final Action winkDevice = BNrioDevice.newAction((int)0, null);
    public static final Action winkTimeout = BNrioDevice.newAction((int)4, null);
    public static final Action winkCancel = BNrioDevice.newAction((int)4, null);
    public static final Action enablePolling = BNrioDevice.newAction((int)4, null);
    public static final Action disablePolling = BNrioDevice.newAction((int)4, null);
    public static final Action setPingOk = BNrioDevice.newAction((int)4, null);
    public static final Action setAddressAndPing = BNrioDevice.newAction((int)4, null);
    public static final Action dumpIoMap = BNrioDevice.newAction((int)4, null);
    public static final Action readInfoMemory = BNrioDevice.newAction((int)4, null);
    public static final Action clearInfoMemory = BNrioDevice.newAction((int)4, null);
    public static final Type TYPE;
    private boolean winkActive;
    private Clock.Ticket winkDurationTicket;
    private boolean winkOutState;
    private Clock.Ticket winkTicket;
    private NrioMessage statusMessage;
    private NrioDeviceIoStatus lastIoStatus;
    private BNrioNetwork accessNet;
    private boolean isPollingActive;
    private boolean firstPing;
    static /* synthetic */ Class class$com$tridium$nrio$BNrioDevice;

    public int getAddress() {
        return this.getInt(address);
    }

    public void setAddress(int n) {
        this.setInt(address, n, null);
    }

    public BNrioDeviceTypeEnum getDeviceType() {
        return (BNrioDeviceTypeEnum)this.get(deviceType);
    }

    public void setDeviceType(BNrioDeviceTypeEnum bNrioDeviceTypeEnum) {
        this.set(deviceType, (BValue)bNrioDeviceTypeEnum, null);
    }

    public BBlob getUid() {
        return (BBlob)this.get(uid);
    }

    public void setUid(BBlob bBlob) {
        this.set(uid, (BValue)bBlob, null);
    }

    public String getInstalledVersion() {
        return this.getString(installedVersion);
    }

    public void setInstalledVersion(String string) {
        this.setString(installedVersion, string, null);
    }

    public String getAvailableVersion() {
        return this.getString(availableVersion);
    }

    public void setAvailableVersion(String string) {
        this.setString(availableVersion, string, null);
    }

    public int getWinkOutput() {
        return this.getInt(winkOutput);
    }

    public void setWinkOutput(int n) {
        this.setInt(winkOutput, n, null);
    }

    public BRelTime getWinkDuration() {
        return (BRelTime)this.get(winkDuration);
    }

    public void setWinkDuration(BRelTime bRelTime) {
        this.set(winkDuration, (BValue)bRelTime, null);
    }

    public BNrioPointDeviceExt getPoints() {
        return (BNrioPointDeviceExt)this.get(points);
    }

    public void setPoints(BNrioPointDeviceExt bNrioPointDeviceExt) {
        this.set(points, (BValue)bNrioPointDeviceExt, null);
    }

    public BStruct getIoStatus() {
        return (BStruct)this.get(ioStatus);
    }

    public void setIoStatus(BStruct bStruct) {
        this.set(ioStatus, (BValue)bStruct, null);
    }

    public void winkDevice() {
        this.invoke(winkDevice, null, null);
    }

    public void winkTimeout() {
        this.invoke(winkTimeout, null, null);
    }

    public void winkCancel() {
        this.invoke(winkCancel, null, null);
    }

    public void enablePolling() {
        this.invoke(enablePolling, null, null);
    }

    public void disablePolling() {
        this.invoke(disablePolling, null, null);
    }

    public void setPingOk() {
        this.invoke(setPingOk, null, null);
    }

    public void setAddressAndPing() {
        this.invoke(setAddressAndPing, null, null);
    }

    public void dumpIoMap() {
        this.invoke(dumpIoMap, null, null);
    }

    public void readInfoMemory() {
        this.invoke(readInfoMemory, null, null);
    }

    public void clearInfoMemory() {
        this.invoke(clearInfoMemory, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        BNrioDeviceTypeEnum bNrioDeviceTypeEnum = this.getDeviceType();
        this.accessNet = (BNrioNetwork)this.getNetwork();
        try {
            if (bNrioDeviceTypeEnum.equals((Object)BNrioDeviceTypeEnum.remoteReader)) {
                this.setAvailableVersion(((BString)this.accessNet.get("T2030")).getString());
            } else if (bNrioDeviceTypeEnum.equals((Object)BNrioDeviceTypeEnum.remoteInputOutput)) {
                this.setAvailableVersion(((BString)this.accessNet.get("T2034")).getString());
            } else if (bNrioDeviceTypeEnum.equals((Object)BNrioDeviceTypeEnum.baseBoardReader)) {
                this.setAvailableVersion(((BString)this.accessNet.get("T2029")).getString());
            } else if (bNrioDeviceTypeEnum.equals((Object)BNrioDeviceTypeEnum.io16)) {
                this.setAvailableVersion(((BString)this.accessNet.get("T2041")).getString());
            } else {
                this.setAvailableVersion("");
            }
        }
        catch (Exception exception) {
            this.setAvailableVersion("");
        }
        this.setIsRemote(bNrioDeviceTypeEnum.equals((Object)BNrioDeviceTypeEnum.baseBoardReader) ^ true);
        this.setFlags((Slot)upload, this.getFlags((Slot)upload) | 4);
        this.setFlags((Slot)download, this.getFlags((Slot)download) | 4);
        if (this.isUidDefault()) {
            this.configFail("Invalid UID: Do Discover and Match.");
        } else {
            this.configOk();
        }
        this.accessNet.addDevice(this);
    }

    public void stopped() throws Exception {
        try {
            this.accessNet.removeDevice(this.getAddress());
            this.doDisablePolling();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isUidDefault() {
        byte[] byArray = this.getUid().copyBytes();
        if (byArray.length != defaultUid.length) {
            return false;
        }
        int n = 0;
        while (n < defaultUid.length) {
            if (byArray[n] != defaultUid[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Type getNetworkType() {
        return BNrioNetwork.TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        boolean bl = false;
        if (bComponent instanceof BNrioDeviceFolder || bComponent instanceof BNrioNetwork) {
            bl = true;
        }
        return bl;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)enabled)) {
            if (!this.getEnabled()) {
                this.disablePolling();
            } else {
                this.enablePolling();
            }
        } else if (property.equals((Object)uid)) {
            if (this.isUidDefault()) {
                this.configFail("Invalid UID: Do Discover and Match.");
            } else {
                this.configOk();
            }
        }
    }

    public boolean getFirstPing() {
        return this.firstPing;
    }

    public void doPing() {
        if (!this.isRunning()) {
            return;
        }
        BNrioNetwork bNrioNetwork = (BNrioNetwork)this.getNetwork();
        if (bNrioNetwork.isDownLoadInProcess()) {
            return;
        }
        if (this.isFault()) {
            return;
        }
        PingMessage pingMessage = new PingMessage(this.getAddress(), this.getUid().copyBytes(), this.getDeviceType());
        PingResponse pingResponse = (PingResponse)bNrioNetwork.sendNrioMessage(pingMessage);
        int n = pingResponse.getStatus();
        if (n == 255) {
            return;
        }
        if (n != 0) {
            this.pingFail("PingMessage error: " + n);
        } else if (this.isDown() || this.firstPing) {
            n = this.sendWriteConfig();
            if (n == 0) {
                this.doEnablePolling();
                this.firstPing = false;
                this.pingOk();
                this.readBuildInfo();
                return;
            }
            this.pingFail("WriteConfig error: " + n);
        } else {
            this.doEnablePolling();
            if (this.getInstalledVersion().startsWith("up", 0)) {
                this.readBuildInfo();
            }
            this.pingOk();
        }
    }

    public void readBuildInfo() {
        BNrioNetwork bNrioNetwork = (BNrioNetwork)this.getNetwork();
        bNrioNetwork.getLog().trace(">>> BNrioDevice(" + this.getName() + ").readBuildInfo");
        String string = bNrioNetwork.readBuildInfo(this.getAddress());
        bNrioNetwork.getLog().trace(">>> BNrioDevice(" + this.getName() + ").device version =" + string);
        this.setInstalledVersion(string);
    }

    public void doEnablePolling() {
        BNrioNetwork bNrioNetwork = (BNrioNetwork)this.getNetwork();
        if (this.isFault()) {
            this.isPollingActive = false;
            bNrioNetwork.getLog().message(">>> BNrioDevice(" + this.getName() + ") polling is not enabled because of fault condition");
        }
        bNrioNetwork.getLog().trace(">>> BNrioDevice(" + this.getName() + ") pollingEnabled");
        bNrioNetwork.enablePolling(this.getAddress());
        this.isPollingActive = true;
    }

    public void doDisablePolling() {
        BNrioNetwork bNrioNetwork = (BNrioNetwork)this.getNetwork();
        bNrioNetwork.getLog().trace(">>> BNrioDevice(" + this.getName() + ") pollingDisabled");
        bNrioNetwork.disablePolling(this.getAddress());
        this.isPollingActive = false;
        this.firstPing = true;
    }

    public void pingFail(String string) {
        this.firstPing = true;
        super.pingFail(string);
    }

    public void doDumpIoMap() {
    }

    public void doWinkDevice() {
        this.winkDurationTicket = this.setTimer(this.winkDurationTicket, this.getWinkDuration(), winkCancel);
        int n = this.getWinkOutput();
        this.winkTicket = this.setTimer(this.winkTicket, BRelTime.makeSeconds((int)1), winkTimeout);
        this.setDoValue(true, n);
        this.winkOutState = true;
        this.winkActive = true;
        this.setFlags((Slot)winkDevice, this.getFlags((Slot)winkDevice) | 4);
        this.setFlags((Slot)winkCancel, this.getFlags((Slot)winkCancel) & 0xFFFFFFFB);
    }

    public void doWinkTimeout() {
        if (this.winkActive) {
            this.setDoValue(this.winkOutState ^ true, this.getWinkOutput());
            this.winkOutState ^= true;
        }
    }

    public void doWinkCancel() {
        this.winkActive = false;
        this.cancelTimer(this.winkTicket);
        this.cancelTimer(this.winkDurationTicket);
        this.setDoValue(false, this.getWinkOutput());
        this.setFlags((Slot)winkDevice, this.getFlags((Slot)winkDevice) & 0xFFFFFFFB);
        this.setFlags((Slot)winkCancel, this.getFlags((Slot)winkCancel) | 4);
    }

    public void doSetPingOk() {
        this.pingOk();
    }

    public int doWriteDoValues() {
        return -1;
    }

    public int setDoValue(boolean bl, int n) {
        return -1;
    }

    public void processStatusMessage(NrioReceivedMessage nrioReceivedMessage) {
    }

    public void updateProxyValues() {
    }

    public void setIsRemote(boolean bl) {
    }

    public boolean getIsRemote() {
        return true;
    }

    public int sendWriteConfig() {
        return 0;
    }

    public BControlPoint checkForProxyExtConflicts(BControlPoint bControlPoint) {
        if (!(bControlPoint.getProxyExt() instanceof BNrioProxyExt)) {
            return null;
        }
        BNrioProxyExt bNrioProxyExt = (BNrioProxyExt)bControlPoint.getProxyExt();
        BControlPoint[] bControlPointArray = this.getPoints().getPoints();
        int n = 0;
        while (n < bControlPointArray.length) {
            BNrioProxyExt bNrioProxyExt2;
            if ((bControlPointArray[n].getHandle() == null || bControlPoint.getHandle() == null || !bControlPointArray[n].getHandle().equals(bControlPoint.getHandle())) && (bNrioProxyExt2 = (BNrioProxyExt)bControlPointArray[n].getProxyExt()).getEnabled() && bNrioProxyExt.getEnabled() && bNrioProxyExt2.getInstance() == bNrioProxyExt.getInstance() && bNrioProxyExt2.getIsSdi() == bNrioProxyExt.getIsSdi() && bControlPoint.isWritablePoint() == bControlPointArray[n].isWritablePoint()) {
                return bControlPointArray[n];
            }
            ++n;
        }
        return null;
    }

    public void processIoStatusMessage(NrioMessage nrioMessage) {
    }

    public NrioDeviceIoStatus getLastIoStatus() {
        return this.lastIoStatus;
    }

    public void doReadInfoMemory() {
        try {
            ReadInfoMemoryMessage readInfoMemoryMessage = new ReadInfoMemoryMessage(this.getAddress());
            NrioMessage nrioMessage = this.accessNet.sendNrioMessage(readInfoMemoryMessage);
            if (nrioMessage.getStatus() != 0) {
                return;
            }
            byte[] byArray = nrioMessage.getData();
            System.out.println("             nodeAddr = " + (byArray[0] & 0xFF));
            System.out.println("       numMsgsOurAddr = " + (byArray[1] & 0xFF));
            System.out.println("          numMsgsRcvd = " + (byArray[2] & 0xFF));
            System.out.println("       numBadMsgsRcvd = " + (byArray[3] & 0xFF));
            System.out.println("   numMsgsTransmitted = " + (byArray[4] & 0xFF));
            System.out.println(" numIOStatusCrcErrors = " + (byArray[5] & 0xFF));
            System.out.println("numCardReadsProcessed = " + (byArray[6] & 0xFF));
            System.out.println("  numCardReadsXmitted = " + (byArray[7] & 0xFF));
            System.out.println("    numCardReadErrors = " + (byArray[8] & 0xFF));
            System.out.println("    num485ResetsOnRcv = " + (byArray[9] & 0xFF));
            System.out.println("       lastResetState = " + (byArray[10] & 0xFF));
        }
        catch (Exception exception) {
            System.out.println("doReadInfoMemory caught exception: " + exception);
        }
    }

    public void doClearInfoMemory() {
        try {
            ClearInfoMemoryMessage clearInfoMemoryMessage = new ClearInfoMemoryMessage(this.getAddress());
            NrioMessage nrioMessage = this.accessNet.sendNrioMessage(clearInfoMemoryMessage);
            if (nrioMessage.getStatus() != 0) {
                System.out.println("ClearInfoMemory request returned error: " + nrioMessage.getStatus());
            } else {
                System.out.println("ClearInfoMemory request was successful");
            }
        }
        catch (Exception exception) {
            System.out.println("doReadInfoMemory caught exception: " + exception);
        }
    }

    public void doSetAddressAndPing() {
        int n = this.getAddress();
        byte[] byArray = this.getUid().copyBytes();
        int n2 = this.getDeviceType().getRawInt();
        SetLogicalAddressMessage setLogicalAddressMessage = new SetLogicalAddressMessage(n, byArray);
        NrioMessage nrioMessage = this.accessNet.sendNrioMessage(setLogicalAddressMessage);
        if (nrioMessage.getStatus() != 0) {
            return;
        }
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {}
        PingMessage pingMessage = new PingMessage(n, byArray, n2);
        PingResponse pingResponse = (PingResponse)this.accessNet.sendNrioMessage(pingMessage);
    }

    private final Clock.Ticket setTimer(Clock.Ticket ticket, BRelTime bRelTime, Action action) {
        if (ticket != null) {
            ticket.cancel();
        }
        return Clock.schedulePeriodically((BComponent)this, (BRelTime)bRelTime, (Action)action, null);
    }

    private final void cancelTimer(Clock.Ticket ticket) {
        if (ticket != null) {
            ticket.cancel();
        }
    }

    public BOrd[] getUsedRelayArray() {
        return null;
    }

    public BOrd[] getUsedDiArray() {
        return null;
    }

    public BOrd[] getUsedSdiArray() {
        return null;
    }

    public BOrd[] getUsedRelayArray(int n) {
        BOrd[] bOrdArray = new BOrd[n];
        BControlPoint[] bControlPointArray = this.getPoints().getPoints();
        int n2 = 0;
        while (n2 < bControlPointArray.length) {
            int n3;
            BProxyExt bProxyExt = (BProxyExt)bControlPointArray[n2].getProxyExt();
            if (bProxyExt instanceof BNrioProxyExt && bControlPointArray[n2] instanceof BBooleanWritable && bProxyExt.getEnabled() && (n3 = ((BNrioProxyExt)bProxyExt).getInstance()) > 0 && n3 <= bOrdArray.length) {
                bOrdArray[n3 - 1] = bControlPointArray[n2].getSlotPathOrd();
            }
            ++n2;
        }
        return bOrdArray;
    }

    public BOrd[] getUsedDiArray(int n) {
        BOrd[] bOrdArray = new BOrd[n];
        BControlPoint[] bControlPointArray = this.getPoints().getPoints();
        int n2 = 0;
        while (n2 < bControlPointArray.length) {
            BProxyExt bProxyExt = (BProxyExt)bControlPointArray[n2].getProxyExt();
            if (bProxyExt instanceof BNrioProxyExt && bControlPointArray[n2] instanceof BBooleanPoint && !bControlPointArray[n2].isWritablePoint() && !((BNrioProxyExt)bProxyExt).getIsSdi() && bProxyExt.getEnabled()) {
                try {
                    int n3 = ((BNrioProxyExt)bProxyExt).getInstance();
                    if (n3 > 0 && n3 <= bOrdArray.length) {
                        bOrdArray[n3 - 1] = bControlPointArray[n2].getSlotPathOrd();
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        return bOrdArray;
    }

    public BOrd[] getUsedSdiArray(int n) {
        BOrd[] bOrdArray = new BOrd[n];
        BControlPoint[] bControlPointArray = this.getPoints().getPoints();
        int n2 = 0;
        while (n2 < bControlPointArray.length) {
            int n3;
            BProxyExt bProxyExt = (BProxyExt)bControlPointArray[n2].getProxyExt();
            if (bProxyExt instanceof BNrioProxyExt && bControlPointArray[n2] instanceof BBooleanPoint && !bControlPointArray[n2].isWritablePoint() && ((BNrioProxyExt)bProxyExt).getIsSdi() && bProxyExt.getEnabled() && (n3 = ((BNrioProxyExt)bProxyExt).getInstance()) > 0 && n3 <= bOrdArray.length) {
                bOrdArray[n3 - 1] = bControlPointArray[n2].getSlotPathOrd();
            }
            ++n2;
        }
        return bOrdArray;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.winkActive = false;
        this.winkOutState = false;
        this.statusMessage = new NrioMessage();
        this.lastIoStatus = new NrioDeviceIoStatus();
        this.isPollingActive = false;
        this.firstPing = true;
    }

    public BNrioDevice() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nrio$BNrioDevice;
        if (clazz == null) {
            clazz = class$com$tridium$nrio$BNrioDevice = BNrioDevice.class("[Lcom.tridium.nrio.BNrioDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

