/*
 * Decompiled with CFR 0.152.
 */
package com.jci.jciAutoImport;

import com.jci.jciAutoImport.BJciAutoDeviceAdd;
import com.jci.jciAutoImport.BJciAutoEquipmentAdd;
import com.jci.jciAutoImport.BJciAutoGroupAdd;
import com.jci.jciAutoImport.BJciAutoNetworkAdd;
import com.jci.jciAutoImport.BJciAutoScheduleAdd;
import com.jci.jciAutoImport.BJciAutoSpacesAdd;
import com.jci.jciBacnetParser.ui.BJciBacnetImportManager;
import com.jci.jciFxDriver.BJciDeviceMixIn;
import com.jci.jciFxDriver.BResourceFileInformation;
import com.jci.jciFxDriver.appliance.BJciApplianceApp;
import com.jci.jciFxDriver.appliance.BJciLinkFolder;
import com.jci.jciFxDriver.appliance.BJciPointGroup;
import com.jci.jciFxDriver.appliance.BJciPointGroupFolder;
import com.jci.jciFxDriver.appliance.BJciPointGroupPoint;
import com.jci.jciFxDriver.enums.BJciPctAhuConfigTypes;
import com.jci.jciFxDriver.enums.BJciPctCentralCoolingConfigTypes;
import com.jci.jciFxDriver.enums.BJciPctSystemTypes;
import com.jci.jciFxDriver.enums.BJciPctVavConfigTypes;
import com.jci.jciMeters.BJciBacnetDeviceEnergyMeter;
import com.jci.jciMeters.BJciModbusAsyncDeviceEnergyMeter;
import com.jci.jciMeters.BJciModbusTCPDeviceEnergyMeter;
import com.jci.jciMeters.utilities.JciMeterSelectionSupport;
import com.jci.jciN2Parser.ui.BJciN2ImportManager;
import com.jci.jciSpaces.BJciEquipmentLocatedInSpace;
import com.jci.jciSpaces.BJciEquipmentNode;
import com.jci.jciSpaces.BJciEquipmentRoot;
import com.jci.jciSpaces.BJciEquipmentServedBy;
import com.jci.jciSpaces.BJciSpaceNode;
import com.jci.jciSpaces.BJciSpaceRoot;
import com.jci.jciSpaces.BJciSpaceServedBy;
import com.tridium.bacnet.enums.BBacnetMstpBaudRate;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.link.BBacnetLinkLayer;
import com.tridium.bacnet.stack.link.mstp.BBacnetMstpLinkLayer;
import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.stack.network.BNetworkPort;
import com.tridium.jcin2.BJciDx9100Device;
import com.tridium.jcin2.BJciN2BDevice;
import com.tridium.jcin2.BJciN2Device;
import com.tridium.jcin2.BJciN2Network;
import com.tridium.jcin2.BJciN2ODevice;
import com.tridium.jcin2.BJciTc9100Device;
import com.tridium.jcin2.BJciXt9100Device;
import com.tridium.modbusAsync.BModbusAsyncDevice;
import com.tridium.modbusAsync.BModbusAsyncNetwork;
import com.tridium.modbusTcp.BModbusTcpDevice;
import com.tridium.modbusTcp.BModbusTcpNetwork;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.point.BBacnetPointDeviceExt;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.BDriverContainer;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BSerialBaudRate;
import javax.baja.serial.BSerialHelper;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.BFolder;
import javax.baja.util.BNameMap;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BJciAutoImport
extends BComponent {
    public static final Property enabled = BJciAutoImport.newProperty((int)0, (boolean)true, null);
    public static final Property status = BJciAutoImport.newProperty((int)1, (BValue)BStatus.make((int)0), null);
    public static final Property faultCause = BJciAutoImport.newProperty((int)1, (String)"", null);
    public static final Property trace = BJciAutoImport.newProperty((int)0, (boolean)true, null);
    public static final Property workbenchDir = BJciAutoImport.newProperty((int)1, (String)"", null);
    public static final Property workbenchDirOrd = BJciAutoImport.newProperty((int)1, (BValue)BOrd.NULL, null);
    public static final Property resourceDir = BJciAutoImport.newProperty((int)1, (String)"", null);
    public static final Property resourceDirOrd = BJciAutoImport.newProperty((int)1, (BValue)BOrd.NULL, null);
    public static final Property libraryDir = BJciAutoImport.newProperty((int)1, (String)"", null);
    public static final Property libraryDirOrd = BJciAutoImport.newProperty((int)1, (BValue)BOrd.NULL, null);
    public static final Property spaceImageDir = BJciAutoImport.newProperty((int)1, (String)"", null);
    public static final Property spaceImageDirOrd = BJciAutoImport.newProperty((int)1, (BValue)BOrd.NULL, null);
    public static final Property networkImportCount = BJciAutoImport.newProperty((int)1, (int)0, null);
    public static final Property deviceImportCount = BJciAutoImport.newProperty((int)1, (int)0, null);
    public static final Property scheduleImportCount = BJciAutoImport.newProperty((int)1, (int)0, null);
    public static final Property groupImportCount = BJciAutoImport.newProperty((int)1, (int)0, null);
    public static final Action runAutoImport = BJciAutoImport.newAction((int)0, null);
    public static final Action runReadImportFile = BJciAutoImport.newAction((int)0, null);
    public static final Action clearImportInfo = BJciAutoImport.newAction((int)0, null);
    public static final Type TYPE;
    static final int STRING = 0;
    static final int UNSIGNEDSHORT = 1;
    static final int BOOLEAN = 2;
    static final int ENUM = 3;
    static final int FLOAT = 4;
    static final int BACOID = 5;
    static final int LISTOF = 6;
    static final int UNSIGNEDBYTE = 7;
    static final int ARRAY = 8;
    static final int NOSUBTYPE = -1;
    static final String STRING_STR = "string";
    static final String UNSIGNEDSHORT_STR = "unsignedShort";
    static final String BOOLEAN_STR = "boolean";
    static final String ENUM_STR = "enum";
    static final String FLOAT_STR = "float";
    static final String SET_STR = "set";
    static final String DATA_STR = "data";
    static final String BACOID_STR = "BACoid";
    static final String LISTOF_STR = "listof";
    static final String UNSIGNEDBYTE_STR = "unsignedByte";
    static final String ARRAY_STR = "array";
    static final String CONTROL_SEQUENCE_CLASS_ID = "575";
    static final String UNIT_SET_PROPERTY = "3503";
    static final String STANDARD_VERSION_PROPERTY = "3671";
    static final String SYSTEM_TYPE_PROPERTY = "3900";
    static final String APPLICATION_MAPPED_PROPERTY = "3912";
    static final String SYSTEM_CONFIGURATION_PROPERTY = "3899";
    static final int UNIT_SET_PROPERTY_TYPE = 3;
    static final int STANDARD_VERSION_PROPERTY_TYPE = 0;
    static final int SYSTEM_TYPE_PROPERTY_TYPE = 1;
    static final int APPLICATION_MAPPED_PROPERTY_TYPE = 2;
    static final int SYSTEM_CONFIGURATION_PROPERTY_TYPE = 1;
    static final String ID_STR = "id";
    private static final String OBJECTINSTANCENUM = "75";
    static final String COLON_STR = ":";
    static final String COMMA_STR = ",";
    static final String NOT_SIGN_STR = "!";
    static final String QUESTIONMARK = "?";
    private static final int MFM = 159;
    private static final int MFR = 145;
    private static final int MCR = 161;
    private static final int MCM = 160;
    private static final int GATEWAY = 0;
    private static final int DEVICE_TYPE = 1;
    private static final String DEFAULT_SYSTEM_TYPE = "StatGateway";
    static final Lexicon lex;
    public HashMap allBacoids;
    protected HashMap librarygraphicfiles;
    XParser xparSysLibFile;
    int ipNetworkNbr;
    JciMeterSelectionSupport selectsupport;
    BJciBacnetDeviceEnergyMeter em2000Master;
    BJciModbusAsyncDeviceEnergyMeter em1000Master;
    BJciModbusTCPDeviceEnergyMeter em3000Master;
    boolean haveMeterDevices;
    boolean haveMeterMasters;
    public HashMap allDevTypes;
    String spaceRootName;
    String equipmentRootName;
    static /* synthetic */ Class class$com$jci$jciAutoImport$BJciAutoImport;
    static /* synthetic */ Class class$com$jci$jciAutoImport$BJciAutoNetworkAdd;
    static /* synthetic */ Class class$com$jci$jciAutoImport$BJciAutoDeviceAdd;
    static /* synthetic */ Class class$com$jci$jciAutoImport$BJciAutoScheduleAdd;
    static /* synthetic */ Class class$com$jci$jciAutoImport$BJciAutoGroupAdd;
    static /* synthetic */ Class class$com$jci$jciAutoImport$BJciAutoSpacesAdd;
    static /* synthetic */ Class class$com$jci$jciSpaces$BJciSpaceNode;
    static /* synthetic */ Class class$com$jci$jciAutoImport$BJciAutoEquipmentAdd;
    static /* synthetic */ Class class$com$jci$jciSpaces$BJciEquipmentNode;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public boolean getTrace() {
        return this.getBoolean(trace);
    }

    public void setTrace(boolean bl) {
        this.setBoolean(trace, bl, null);
    }

    public String getWorkbenchDir() {
        return this.getString(workbenchDir);
    }

    public void setWorkbenchDir(String string) {
        this.setString(workbenchDir, string, null);
    }

    public BOrd getWorkbenchDirOrd() {
        return (BOrd)this.get(workbenchDirOrd);
    }

    public void setWorkbenchDirOrd(BOrd bOrd) {
        this.set(workbenchDirOrd, (BValue)bOrd, null);
    }

    public String getResourceDir() {
        return this.getString(resourceDir);
    }

    public void setResourceDir(String string) {
        this.setString(resourceDir, string, null);
    }

    public BOrd getResourceDirOrd() {
        return (BOrd)this.get(resourceDirOrd);
    }

    public void setResourceDirOrd(BOrd bOrd) {
        this.set(resourceDirOrd, (BValue)bOrd, null);
    }

    public String getLibraryDir() {
        return this.getString(libraryDir);
    }

    public void setLibraryDir(String string) {
        this.setString(libraryDir, string, null);
    }

    public BOrd getLibraryDirOrd() {
        return (BOrd)this.get(libraryDirOrd);
    }

    public void setLibraryDirOrd(BOrd bOrd) {
        this.set(libraryDirOrd, (BValue)bOrd, null);
    }

    public String getSpaceImageDir() {
        return this.getString(spaceImageDir);
    }

    public void setSpaceImageDir(String string) {
        this.setString(spaceImageDir, string, null);
    }

    public BOrd getSpaceImageDirOrd() {
        return (BOrd)this.get(spaceImageDirOrd);
    }

    public void setSpaceImageDirOrd(BOrd bOrd) {
        this.set(spaceImageDirOrd, (BValue)bOrd, null);
    }

    public int getNetworkImportCount() {
        return this.getInt(networkImportCount);
    }

    public void setNetworkImportCount(int n) {
        this.setInt(networkImportCount, n, null);
    }

    public int getDeviceImportCount() {
        return this.getInt(deviceImportCount);
    }

    public void setDeviceImportCount(int n) {
        this.setInt(deviceImportCount, n, null);
    }

    public int getScheduleImportCount() {
        return this.getInt(scheduleImportCount);
    }

    public void setScheduleImportCount(int n) {
        this.setInt(scheduleImportCount, n, null);
    }

    public int getGroupImportCount() {
        return this.getInt(groupImportCount);
    }

    public void setGroupImportCount(int n) {
        this.setInt(groupImportCount, n, null);
    }

    public void runAutoImport() {
        this.invoke(runAutoImport, null, null);
    }

    public void runReadImportFile() {
        this.invoke(runReadImportFile, null, null);
    }

    public void clearImportInfo() {
        this.invoke(clearImportInfo, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void tracemessage(String string) {
        if (this.getTrace()) {
            System.out.println(string);
        }
    }

    public void started() throws Exception {
        this.tracemessage("jciAutoImport STARTED");
        this.tracemessage("jciAutoImport STARTED, parent = " + this.getParent().getParentComponent());
        BComponent bComponent = this.getParent().getParentComponent();
        this.tracemessage("jciAutoImport STARTED, parent ORD = " + bComponent.getSlotPathOrd());
        this.setStatus(BStatus.nullStatus);
        this.setNetworkImportCount(0);
        this.setDeviceImportCount(0);
        this.setScheduleImportCount(0);
        this.setGroupImportCount(0);
        if (this.getEnabled()) {
            this.tracemessage("jciAutoImport STARTED, Enabled!");
            this.doClearImportInfo();
            this.doRunReadImportFile();
            this.doRunAutoImport();
            try {
                BOrd bOrd = BOrd.make((String)"station:|slot:/fxApp");
                BComponent bComponent2 = bOrd.get((BObject)this).asComponent();
                bComponent2.remove("autoImport");
                Sys.getStation().save();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        super.started();
    }

    public void doNetworkImport() {
        try {
            BJciAutoNetworkAdd bJciAutoNetworkAdd = null;
            Class clazz = class$com$jci$jciAutoImport$BJciAutoNetworkAdd;
            if (clazz == null) {
                clazz = class$com$jci$jciAutoImport$BJciAutoNetworkAdd = BJciAutoImport.class("[Lcom.jci.jciAutoImport.BJciAutoNetworkAdd;", false);
            }
            Object[] objectArray = this.getChildren(clazz);
            int n = 0;
            while (n < objectArray.length) {
                bJciAutoNetworkAdd = (BJciAutoNetworkAdd)((Object)objectArray[n]);
                String string = bJciAutoNetworkAdd.getNetworkType();
                String string2 = SlotPath.escape((String)bJciAutoNetworkAdd.getNetworkName());
                this.tracemessage("jciAutoImport doNetworkImport, Add Network: " + string2);
                if (string.equalsIgnoreCase("N2")) {
                    this.addN2Network(bJciAutoNetworkAdd);
                }
                if (string.equalsIgnoreCase("MSTP") || string.equalsIgnoreCase("BACNET IP")) {
                    this.addBacnetNetwork(bJciAutoNetworkAdd, string.toUpperCase());
                }
                if (string.equalsIgnoreCase("MODBUS ASYNC")) {
                    this.addModbusAsyncNetwork(bJciAutoNetworkAdd);
                }
                if (string.equalsIgnoreCase("MODBUS TCP")) {
                    this.addModbusTCPNetwork(bJciAutoNetworkAdd);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doDeviceImport() {
        try {
            this.tracemessage("jciAutoImport, doDeviceImport, getting DEVs");
            Class clazz = class$com$jci$jciAutoImport$BJciAutoDeviceAdd;
            if (clazz == null) {
                clazz = class$com$jci$jciAutoImport$BJciAutoDeviceAdd = BJciAutoImport.class("[Lcom.jci.jciAutoImport.BJciAutoDeviceAdd;", false);
            }
            Object[] objectArray = this.getChildren(clazz);
            if (this.haveMeterDevices) {
                this.haveMeterMasters = this.checkForMeters();
                if (this.haveMeterMasters) {
                    this.em1000Master = (BJciModbusAsyncDeviceEnergyMeter)this.selectsupport.getMeterMaster(0);
                    this.em2000Master = (BJciBacnetDeviceEnergyMeter)this.selectsupport.getMeterMaster(1);
                    this.em3000Master = (BJciModbusTCPDeviceEnergyMeter)this.selectsupport.getMeterMaster(2);
                }
            }
            int n = 0;
            while (n < objectArray.length) {
                BJciAutoDeviceAdd bJciAutoDeviceAdd = (BJciAutoDeviceAdd)((Object)objectArray[n]);
                String string = bJciAutoDeviceAdd.getNetworkName();
                String string2 = bJciAutoDeviceAdd.getDeviceName();
                String string3 = bJciAutoDeviceAdd.getDeviceAddress();
                String string4 = bJciAutoDeviceAdd.getN2DeviceType();
                BOrd bOrd = bJciAutoDeviceAdd.getResourceFileOrd();
                BOrd bOrd2 = bJciAutoDeviceAdd.getLibraryFileOrd();
                String string5 = bJciAutoDeviceAdd.getResourceFileName();
                String string6 = bJciAutoDeviceAdd.getAltResourceFilePath();
                String string7 = bJciAutoDeviceAdd.getLibraryFileName();
                String string8 = bJciAutoDeviceAdd.getBacnetDeviceId();
                BJciAutoNetworkAdd bJciAutoNetworkAdd = this.getNetworkInfo(string);
                if (bJciAutoNetworkAdd != null) {
                    int n2 = bJciAutoNetworkAdd.getNetworkNumber();
                    String string9 = bJciAutoNetworkAdd.getNetworkType();
                    if (string9.equalsIgnoreCase("N2")) {
                        this.addN2Device(bJciAutoDeviceAdd, string, string2, string4, this.getDeviceAddressFromAddrStr(string3, string9), bOrd, bOrd2);
                    }
                    if (string9.equalsIgnoreCase("MSTP")) {
                        if (string4.startsWith("EM2000")) {
                            this.addBACnetIPDevice(bJciAutoDeviceAdd, string, n2, string2, string4, this.getDeviceAddressFromAddrStr(string3, string9), bOrd, bOrd2, string8);
                        } else {
                            this.addMstpDevice(bJciAutoDeviceAdd, string, n2, string2, this.getDeviceAddressFromAddrStr(string3, string9), n2, bOrd, bOrd2, string8);
                        }
                    }
                    if (string9.equalsIgnoreCase("MODBUS ASYNC")) {
                        System.out.println("add modbus async device");
                        this.addModBusAsyncDevice(bJciAutoDeviceAdd, string, string2, string4, this.getDeviceAddressFromAddrStr(string3, string9));
                    }
                    if (string9.equalsIgnoreCase("MODBUS TCP")) {
                        System.out.println("add modbus tcp device");
                        this.addModBusTCPDevice(bJciAutoDeviceAdd, string, string2, string4, this.getDeviceAddressFromAddrStr(string8, string9), string3);
                    }
                    if (string9.equalsIgnoreCase("BACNET IP")) {
                        System.out.println("add bacnet ip device");
                        this.addBACnetIPDevice(bJciAutoDeviceAdd, string, n2, string2, string4, this.getDeviceAddressFromAddrStr(string8, string9), bOrd, bOrd2, string3);
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getDeviceAddressFromAddrStr(String string, String string2) {
        int n = 1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("getDeviceAddressFromAddrStr, ERROR in converting address: " + string);
            numberFormatException.printStackTrace();
        }
        if (string2.equalsIgnoreCase("N2") && n >= 1 && n <= 255) {
            return n;
        }
        if (string2.equalsIgnoreCase("MODBUS TCP") && n >= 1 && n <= 247) {
            return n;
        }
        if (string2.equalsIgnoreCase("MSTP")) {
            return n;
        }
        if (string2.equalsIgnoreCase("MODBUS ASYNC")) {
            return n;
        }
        if (string2.equalsIgnoreCase("BACNET IP")) {
            return n;
        }
        return n;
    }

    public BJciAutoNetworkAdd getNetworkInfo(String string) {
        this.tracemessage("jciAutoImport, getNetworkInfo, getting NETs");
        BJciAutoNetworkAdd bJciAutoNetworkAdd = null;
        Class clazz = class$com$jci$jciAutoImport$BJciAutoNetworkAdd;
        if (clazz == null) {
            clazz = class$com$jci$jciAutoImport$BJciAutoNetworkAdd = BJciAutoImport.class("[Lcom.jci.jciAutoImport.BJciAutoNetworkAdd;", false);
        }
        Object[] objectArray = this.getChildren(clazz);
        int n = 0;
        while (n < objectArray.length) {
            BJciAutoNetworkAdd bJciAutoNetworkAdd2 = (BJciAutoNetworkAdd)((Object)objectArray[n]);
            if (bJciAutoNetworkAdd2.getNetworkName().equalsIgnoreCase(string)) {
                bJciAutoNetworkAdd = bJciAutoNetworkAdd2;
                break;
            }
            ++n;
        }
        return bJciAutoNetworkAdd;
    }

    public void addN2Device(BJciAutoDeviceAdd bJciAutoDeviceAdd, String string, String string2, String string3, int n, BOrd bOrd, BOrd bOrd2) {
        BJciN2Network bJciN2Network = (BJciN2Network)this.getDeviceNetworkByName(string);
        BJciXt9100Device bJciXt9100Device = null;
        this.tracemessage("jciAutoImport, addN2Device, name = " + string2 + ", device addr = " + n + ", file = " + bOrd.toString());
        if (string3.startsWith("XTM")) {
            bJciXt9100Device = new BJciXt9100Device();
        }
        if (string3.startsWith("TC")) {
            bJciXt9100Device = new BJciTc9100Device();
        }
        if (string3.startsWith("DX")) {
            bJciXt9100Device = new BJciDx9100Device();
        }
        if (string3.startsWith("VMA")) {
            bJciXt9100Device = new BJciN2BDevice();
        }
        if (string3.startsWith("AHU")) {
            bJciXt9100Device = new BJciN2ODevice();
        }
        if (string3.startsWith("FX")) {
            bJciXt9100Device = new BJciN2ODevice();
        }
        if (string3.startsWith("MIG")) {
            bJciXt9100Device = new BJciN2ODevice();
        }
        if (string3.startsWith("PHX")) {
            bJciXt9100Device = new BJciN2ODevice();
        }
        if (string3.startsWith("TEC")) {
            bJciXt9100Device = new BJciN2ODevice();
        }
        if (string3.startsWith("UNT")) {
            bJciXt9100Device = new BJciN2ODevice();
        }
        if (string3.startsWith("VAV")) {
            bJciXt9100Device = new BJciN2ODevice();
        }
        if (string3.startsWith("VND")) {
            bJciXt9100Device = new BJciN2ODevice();
        }
        if (bJciXt9100Device == null) {
            bJciXt9100Device = new BJciN2ODevice();
        }
        if (bJciXt9100Device != null) {
            bJciXt9100Device.setAddress(n);
            bJciXt9100Device.setControllerType(string3);
            bJciN2Network.add(string2, (BValue)bJciXt9100Device);
            BJciN2Device bJciN2Device = null;
            BDevice[] bDeviceArray = bJciN2Network.getDevices();
            int n2 = 0;
            while (n2 < bDeviceArray.length) {
                if (bDeviceArray[n2].getName().equalsIgnoreCase(string2)) {
                    bJciN2Device = (BJciN2Device)bDeviceArray[n2];
                    bJciAutoDeviceAdd.setDeviceOrd(bJciN2Device.getSlotPathOrd());
                    break;
                }
                ++n2;
            }
            if (!bOrd.isNull()) {
                BResourceFileInformation bResourceFileInformation = ((BJciDeviceMixIn)bJciN2Device.getMixIn(BJciDeviceMixIn.TYPE)).getResourceFileInfo();
                bResourceFileInformation.setResourceFile(bOrd);
                String string4 = this.doFieldResourceFileChanged(bResourceFileInformation);
                BOrd bOrd3 = BOrd.NULL;
                if (string4.length() > 0) {
                    bOrd3 = BOrd.make((String)string4);
                }
                this.tracemessage("jciAutoImport, libFile = " + string4 + ", ORD = " + bOrd3);
                bResourceFileInformation.setSystemLibraryFile(bOrd3);
                ((BJciDeviceMixIn)bJciN2Device.getMixIn(BJciDeviceMixIn.TYPE)).setResourceFileInfo(bResourceFileInformation);
                BJciDeviceMixIn bJciDeviceMixIn = (BJciDeviceMixIn)bJciN2Device.getMixIn(BJciDeviceMixIn.TYPE);
                BJciN2ImportManager bJciN2ImportManager = new BJciN2ImportManager();
                bJciN2ImportManager.setParserN2Network(bJciN2Network);
                String string5 = bJciN2ImportManager.importN2Device(bJciN2Device, bJciDeviceMixIn);
                bJciDeviceMixIn.setCreateNewGraphicFile(true);
                bJciDeviceMixIn.doCreateGraphic((BDevice)bJciN2Device);
                bJciDeviceMixIn.setCreateHxGraphicFile(true);
                bJciDeviceMixIn.doCreateHxGraphic((BDevice)bJciN2Device);
                bJciDeviceMixIn.setCleanGraphic(true);
                bJciDeviceMixIn.setUpdateActionMenus(true);
            }
        }
    }

    public void addModBusAsyncDevice(BJciAutoDeviceAdd bJciAutoDeviceAdd, String string, String string2, String string3, int n) {
        BModbusAsyncDevice bModbusAsyncDevice;
        BModbusAsyncNetwork bModbusAsyncNetwork = (BModbusAsyncNetwork)this.getDeviceNetworkByName(string);
        this.tracemessage("jciAutoImport, addModBusAsyncDevice, name = " + string2 + ", device addr = " + n + " ctrltype " + string3);
        if (string3.startsWith("EM1000")) {
            if (this.em1000Master != null) {
                System.out.println("have the em1000 meter master");
                bModbusAsyncDevice = (BJciModbusAsyncDeviceEnergyMeter)this.em1000Master.newCopy();
            } else {
                System.out.println("do not have em1000 meter master");
                bModbusAsyncDevice = new BJciModbusAsyncDeviceEnergyMeter();
            }
        } else {
            System.out.println("modbus async not a meter");
            bModbusAsyncDevice = new BModbusAsyncDevice();
        }
        if (bModbusAsyncDevice != null) {
            bModbusAsyncDevice.setDeviceAddress(n);
            bModbusAsyncNetwork.add(string2, (BValue)bModbusAsyncDevice);
        }
        BModbusAsyncDevice bModbusAsyncDevice2 = null;
        BDevice[] bDeviceArray = bModbusAsyncNetwork.getDevices();
        int n2 = 0;
        while (n2 < bDeviceArray.length) {
            if (bDeviceArray[n2].getName().equalsIgnoreCase(string2)) {
                bModbusAsyncDevice2 = (BModbusAsyncDevice)bDeviceArray[n2];
                bJciAutoDeviceAdd.setDeviceOrd(bModbusAsyncDevice2.getSlotPathOrd());
                break;
            }
            ++n2;
        }
    }

    public void addModBusTCPDevice(BJciAutoDeviceAdd bJciAutoDeviceAdd, String string, String string2, String string3, int n, String string4) {
        int n2;
        Object object;
        Object object2;
        BModbusTcpDevice bModbusTcpDevice;
        BModbusTcpNetwork bModbusTcpNetwork = (BModbusTcpNetwork)this.getDeviceNetworkByName(string);
        this.tracemessage("jciAutoImport, addModBusTCPDevice, name = " + string2 + ", device addr = " + n + ", ctrltype: " + string3 + ", TCPaddr: " + string4);
        if (string3.startsWith("EM3000")) {
            if (this.em3000Master != null) {
                System.out.println("have the em3000 meter master");
                bModbusTcpDevice = (BJciModbusTCPDeviceEnergyMeter)this.em3000Master.newCopy();
            } else {
                System.out.println("do not have the em3000 meter master");
                bModbusTcpDevice = new BJciModbusTCPDeviceEnergyMeter();
            }
        } else {
            System.out.println("not a meter");
            bModbusTcpDevice = new BModbusTcpDevice();
        }
        if (bModbusTcpDevice != null) {
            bModbusTcpDevice.setDeviceAddress(n);
            object2 = this.getIpAddressforDevice(string4, "MODBUS TCP");
            object = "" + (object2[0] & 0xFF) + '.' + (object2[1] & 0xFF) + '.' + (object2[2] & 0xFF) + '.' + (object2[3] & 0xFF);
            n2 = object2[4] & 0xFF;
            int n3 = object2[5] & 0xFF;
            int n4 = n2 * 256 + n3;
            System.out.println("addModBusTCPDevice, IP: " + (String)object + ", Port: " + n4);
            bModbusTcpDevice.setIpAddress((String)object);
            bModbusTcpDevice.setPort(n4);
            bModbusTcpNetwork.add(string2, (BValue)bModbusTcpDevice);
        }
        object2 = null;
        object = bModbusTcpNetwork.getDevices();
        n2 = 0;
        while (n2 < ((BDevice[])object).length) {
            if (object[n2].getName().equalsIgnoreCase(string2)) {
                object2 = (BModbusTcpDevice)object[n2];
                bJciAutoDeviceAdd.setDeviceOrd(object2.getSlotPathOrd());
                break;
            }
            ++n2;
        }
    }

    public void addBACnetIPDevice(BJciAutoDeviceAdd bJciAutoDeviceAdd, String string, int n, String string2, String string3, int n2, BOrd bOrd, BOrd bOrd2, String string4) {
        Object[] objectArray;
        BBacnetAddress bBacnetAddress;
        BBacnetDevice bBacnetDevice;
        BBacnetNetwork bBacnetNetwork = (BBacnetNetwork)this.getDeviceNetworkByName(string);
        this.tracemessage("jciAutoImport, addBACnetIPDevice, name = " + string2 + ", device addr = " + n2 + " ctrltype " + string3 + ", ResFile: " + bOrd.toString());
        if (string3.startsWith("EM2000")) {
            if (this.em2000Master != null) {
                System.out.println("have the em2000 meter master");
                bBacnetDevice = (BJciBacnetDeviceEnergyMeter)this.em2000Master.newCopy();
            } else {
                System.out.println("do not have the em2000 meter master");
                bBacnetDevice = new BJciBacnetDeviceEnergyMeter();
            }
        } else {
            System.out.println("not a meter");
            bBacnetDevice = new BBacnetDevice();
        }
        if (bBacnetDevice != null) {
            bBacnetAddress = new BBacnetAddress();
            bBacnetAddress.setAddressType(2);
            objectArray = this.getIpAddressforDevice(string4, "BACnet IP");
            BBacnetOctetString bBacnetOctetString = BBacnetOctetString.make((byte[])objectArray);
            bBacnetAddress.setMacAddress(bBacnetOctetString);
            bBacnetAddress.setNetworkNumber(n);
            bBacnetDevice.setAddress(bBacnetAddress);
            bBacnetDevice.setObjectId(BBacnetObjectIdentifier.make((int)8, (int)n2), null);
            try {
                bBacnetNetwork.add(string2, (BValue)bBacnetDevice);
            }
            catch (Exception exception) {
                System.out.println("addBACnetIPDevice Exception: " + exception.getMessage());
            }
        }
        bBacnetAddress = null;
        objectArray = bBacnetNetwork.getDevices();
        int n3 = 0;
        while (n3 < objectArray.length) {
            if (objectArray[n3].getName().equalsIgnoreCase(string2)) {
                bBacnetAddress = (BBacnetDevice)objectArray[n3];
                bJciAutoDeviceAdd.setDeviceOrd(bBacnetAddress.getSlotPathOrd());
                break;
            }
            ++n3;
        }
        if (!bOrd.isNull()) {
            BResourceFileInformation bResourceFileInformation = ((BJciDeviceMixIn)bBacnetAddress.getMixIn(BJciDeviceMixIn.TYPE)).getResourceFileInfo();
            bResourceFileInformation.setResourceFile(bOrd);
            String string5 = this.doFieldResourceFileChanged(bResourceFileInformation);
            BOrd bOrd3 = BOrd.make((String)string5);
            this.tracemessage("jciAutoImport, libFile = " + string5 + ", ORD = " + bOrd3);
            bResourceFileInformation.setSystemLibraryFile(bOrd3);
            bResourceFileInformation.setGraphicsType("kitPxGraphics");
            ((BJciDeviceMixIn)bBacnetAddress.getMixIn(BJciDeviceMixIn.TYPE)).setResourceFileInfo(bResourceFileInformation);
            BJciDeviceMixIn bJciDeviceMixIn = (BJciDeviceMixIn)bBacnetAddress.getMixIn(BJciDeviceMixIn.TYPE);
            bJciDeviceMixIn.setResourceFileInfo(bResourceFileInformation);
            if (bOrd.toString().endsWith(".csv")) {
                bJciDeviceMixIn.setCreateNewGraphicFile(true);
                bJciDeviceMixIn.setCreateHxGraphicFile(true);
                bJciDeviceMixIn.doCreateGraphic((BDevice)bBacnetAddress);
                bJciDeviceMixIn.doCreateHxGraphic((BDevice)bBacnetAddress);
            }
            BJciBacnetImportManager bJciBacnetImportManager = new BJciBacnetImportManager();
            bJciBacnetImportManager.BacNetNetwork = bBacnetNetwork;
            String string6 = "";
            try {
                string6 = bJciBacnetImportManager.importBacNetDevice((BBacnetDevice)bBacnetAddress, bJciDeviceMixIn);
                bJciDeviceMixIn.setCreateNewGraphicFile(true);
                bJciDeviceMixIn.setCreateHxGraphicFile(true);
                bJciDeviceMixIn.setCleanGraphic(true);
                bJciDeviceMixIn.setUpdateActionMenus(true);
                bJciDeviceMixIn.doCreateGraphic((BDevice)bBacnetAddress);
                bJciDeviceMixIn.doCreateHxGraphic((BDevice)bBacnetAddress);
            }
            catch (Exception exception) {
                System.out.println("addBACnetIPDevice Import Exception: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public byte[] getIpAddressforDevice(String string, String string2) {
        System.out.println("getIpAddressforDevice, IP Str: " + string + ", Network Type: " + string2);
        byte[] byArray = new byte[6];
        byArray[0] = 10;
        byArray[3] = 1;
        byArray[4] = -70;
        byArray[5] = -64;
        byte[] byArray2 = byArray;
        try {
            String[] stringArray = TextUtil.split((String)string, (char)'.');
            if (stringArray.length == 4) {
                String[] stringArray2;
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                int n3 = Integer.parseInt(stringArray[2]);
                int n4 = 0;
                int n5 = 47808;
                int n6 = 186;
                int n7 = 192;
                if (string2.equalsIgnoreCase("MODBUS TCP")) {
                    n5 = 502;
                    n6 = 1;
                    n7 = 247;
                }
                if ((stringArray2 = TextUtil.split((String)stringArray[3], (char)':')).length == 2) {
                    n4 = Integer.parseInt(stringArray2[0]);
                    String string3 = stringArray2[1];
                    if (string3.indexOf("x") > -1) {
                        string3 = string3.substring(string3.indexOf("x") + 1, string3.length());
                        n5 = Integer.parseInt(string3, 16);
                        System.out.println("getIpAddressforDevice, Port Str: " + stringArray2[1] + ", Hex Port: " + n5);
                    } else {
                        n5 = Integer.parseInt(stringArray2[1]);
                        System.out.println("getIpAddressforDevice, Port Str: " + stringArray2[1] + ", Dec Port: " + n5);
                    }
                } else {
                    n4 = Integer.parseInt(stringArray[3]);
                }
                n6 = n5 / 256;
                n7 = n5 % 256;
                byArray2[4] = (byte)n6;
                byArray2[5] = (byte)n7;
                System.out.println("getIpAddressforDevice, Port: " + n5 + ", HB: " + n6 + ", LB: " + n7);
                int n8 = n6 * 256 + n7;
                System.out.println("getIpAddressforDevice, IP: " + n + '.' + n2 + '.' + n3 + '.' + n4 + ':' + n8 + ", HB: " + byArray2[4] + ", LB: " + byArray2[5]);
                if (n >= 0 && n < 256 && n2 >= 0 && n2 < 256 && n3 >= 0 && n3 < 256 && n4 >= 0 && n4 < 256) {
                    byArray2[0] = (byte)n;
                    byArray2[1] = (byte)n2;
                    byArray2[2] = (byte)n3;
                    byArray2[3] = (byte)n4;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("getIpAddressforDevice, ERROR, input IP: " + string);
            numberFormatException.printStackTrace();
        }
        return byArray2;
    }

    public boolean checkForMeters() {
        BOrd bOrd = BOrd.make((String)"module://jciMeters/module.palette");
        this.selectsupport = new JciMeterSelectionSupport(bOrd);
        this.selectsupport.loadPaletteInfo();
        return this.selectsupport.loadMeterMasters();
    }

    public void addDemoPoints(BDevice bDevice) {
        try {
            BControlPoint bControlPoint;
            BBacnetPointDeviceExt bBacnetPointDeviceExt = null;
            if (bDevice instanceof BBacnetDevice) {
                bBacnetPointDeviceExt = ((BBacnetDevice)bDevice).getPoints();
            }
            if (bDevice instanceof BJciN2Device) {
                bBacnetPointDeviceExt = ((BJciN2Device)bDevice).getPoints();
            }
            BOrd bOrd = BOrd.make((String)"station:|slot:/fxApp/customControl");
            BFolder bFolder = (BFolder)bOrd.get((BObject)this).asComponent();
            BControlPoint bControlPoint2 = (BControlPoint)bFolder.get("FakePoint");
            BControlPoint bControlPoint3 = (BControlPoint)bFolder.get("FakeAlarm");
            BNumericPoint bNumericPoint = (BNumericPoint)bFolder.get("Random");
            BNumericPoint bNumericPoint2 = (BNumericPoint)bFolder.get("SineWave");
            if (bControlPoint2 != null) {
                bBacnetPointDeviceExt.add("FakePoint", bControlPoint2.newCopy());
                bControlPoint = (BControlPoint)bBacnetPointDeviceExt.get("FakePoint");
                if (bNumericPoint2 != null) {
                    this.doLink((BComponent)bNumericPoint2, "out", (BComponent)bControlPoint, "in16");
                }
            }
            if (bControlPoint3 != null) {
                bBacnetPointDeviceExt.add("FakeAlarm", bControlPoint3.newCopy());
                bControlPoint = (BControlPoint)bBacnetPointDeviceExt.get("FakeAlarm");
                if (bNumericPoint != null) {
                    this.doLink((BComponent)bNumericPoint, "out", (BComponent)bControlPoint, "in16");
                }
            }
        }
        catch (Exception exception) {
            this.tracemessage("jciAutoImport, addDemoPoints EXCEPTION");
            exception.printStackTrace();
        }
    }

    public void addMstpDevice(BJciAutoDeviceAdd bJciAutoDeviceAdd, String string, int n, String string2, int n2, int n3, BOrd bOrd, BOrd bOrd2, String string3) {
        block7: {
            try {
                BBacnetOctetString bBacnetOctetString;
                Object object;
                String string4;
                BBacnetNetwork bBacnetNetwork = (BBacnetNetwork)this.getDeviceNetworkByName(string);
                BBacnetDevice bBacnetDevice = null;
                bBacnetDevice = new BBacnetDevice();
                if (bBacnetDevice == null) break block7;
                try {
                    bBacnetNetwork.add(string2, (BValue)bBacnetDevice);
                }
                catch (Exception exception) {
                    System.out.println("addMstpDevice Exception: " + exception.getMessage());
                }
                BBacnetDevice bBacnetDevice2 = null;
                BDevice[] bDeviceArray = bBacnetNetwork.getDevices();
                int n4 = 0;
                while (n4 < bDeviceArray.length) {
                    if (bDeviceArray[n4].getName().equalsIgnoreCase(string2)) {
                        bBacnetDevice2 = (BBacnetDevice)bDeviceArray[n4];
                        string4 = new BBacnetAddress();
                        string4.setAddressType(3);
                        object = new byte[]{(byte)n2};
                        bBacnetOctetString = BBacnetOctetString.make((byte[])object);
                        string4.setMacAddress(bBacnetOctetString);
                        string4.setNetworkNumber(n);
                        bBacnetDevice2.setAddress((BBacnetAddress)string4);
                        int n5 = string3 == "" ? (n2 > 99 ? n * 1000 + n2 : n * 100 + n2) : Integer.parseInt(string3);
                        bBacnetDevice2.setObjectId(BBacnetObjectIdentifier.make((int)8, (int)n5), null);
                        bJciAutoDeviceAdd.setDeviceOrd(bBacnetDevice2.getSlotPathOrd());
                        this.tracemessage("jciAutoImport ADDED device OBJID = " + bBacnetDevice2.getObjectId());
                        break;
                    }
                    ++n4;
                }
                if (!bOrd.isNull()) {
                    BResourceFileInformation bResourceFileInformation = ((BJciDeviceMixIn)bBacnetDevice2.getMixIn(BJciDeviceMixIn.TYPE)).getResourceFileInfo();
                    bResourceFileInformation.setResourceFile(bOrd);
                    string4 = this.doFieldResourceFileChanged(bResourceFileInformation);
                    object = BOrd.make((String)string4);
                    this.tracemessage("jciAutoImport, libFile = " + string4 + ", ORD = " + object);
                    bResourceFileInformation.setSystemLibraryFile(object);
                    ((BJciDeviceMixIn)bBacnetDevice2.getMixIn(BJciDeviceMixIn.TYPE)).setResourceFileInfo(bResourceFileInformation);
                    bBacnetOctetString = (BJciDeviceMixIn)bBacnetDevice2.getMixIn(BJciDeviceMixIn.TYPE);
                    BJciBacnetImportManager bJciBacnetImportManager = new BJciBacnetImportManager();
                    bJciBacnetImportManager.BacNetNetwork = bBacnetNetwork;
                    String string5 = bJciBacnetImportManager.importBacNetDevice(bBacnetDevice2, (BJciDeviceMixIn)bBacnetOctetString);
                    bBacnetOctetString.setCreateNewGraphicFile(true);
                    bBacnetOctetString.doCreateGraphic((BDevice)bBacnetDevice2);
                    bBacnetOctetString.setCreateHxGraphicFile(true);
                    bBacnetOctetString.doCreateHxGraphic((BDevice)bBacnetDevice2);
                    bBacnetOctetString.setCleanGraphic(true);
                    bBacnetOctetString.setUpdateActionMenus(true);
                }
                this.addDemoPoints((BDevice)bBacnetDevice2);
            }
            catch (Exception exception) {
                this.tracemessage("ERROR adding Bacnet device: " + string2);
                exception.printStackTrace();
            }
        }
    }

    private final void doLink(BComponent bComponent, String string, BComponent bComponent2, String string2) {
        try {
            Slot slot = bComponent.getSlot(string);
            Slot slot2 = bComponent2.getSlot(string2);
            LinkCheck linkCheck = bComponent2.checkLink(bComponent, slot, slot2, null);
            if (linkCheck.isValid()) {
                BLink bLink = bComponent2.makeLink(bComponent, slot, slot2, null);
                bComponent2.add(null, (BValue)bLink);
                bLink.activate();
            } else {
                this.tracemessage("Invalid link = " + linkCheck.getInvalidReason());
            }
        }
        catch (Exception exception) {
            this.tracemessage("Link failed:");
            this.tracemessage("  " + bComponent.getNavOrd() + '.' + string + " -> " + bComponent2.getNavOrd() + '.' + string2);
            this.tracemessage("  " + exception);
        }
    }

    public boolean loadImportFile(String string, BJciAutoImport bJciAutoImport) {
        if (string == "") {
            string = "file:^importInfo.txt";
        }
        this.tracemessage("loadImportFile, input file = " + string);
        int n = string.indexOf("file:");
        string = string.substring(n + 5);
        this.tracemessage("loadImportFile, new fname = " + string);
        FilePath filePath = new FilePath(string);
        this.tracemessage("loadImportFile,   FilePath = " + filePath);
        BFileSpace bFileSpace = (BFileSpace)BOrd.make((String)"file:").get((BObject)this);
        this.tracemessage("loadImportFile,  FileSpace = " + bFileSpace);
        BIFile bIFile = null;
        bIFile = bFileSpace.findFile(filePath);
        String[] stringArray = new String[]{};
        if (bIFile != null) {
            stringArray = new String[50];
            long l = bIFile.getSize();
            this.tracemessage("loadImportFile,  File Size = " + l);
            int n2 = (int)Math.round((double)(l / 40L) * 0.1);
            if (n2 > 50) {
                stringArray = new String[n2];
                this.tracemessage("loadImportFile, Nbr Lines = " + n2);
            }
            try {
                stringArray = FileUtil.readLines((BIFile)bIFile);
                int n3 = 0;
                while (n3 < stringArray.length) {
                    String string2 = stringArray[n3];
                    this.addImportInfo(string2, bJciAutoImport);
                    ++n3;
                }
            }
            catch (Exception exception) {
                stringArray = new String[]{string + " NOT Found"};
                this.tracemessage("loadImportFile FILE ERROR = " + exception.getMessage());
                exception.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private final void addImportInfo(String string, BJciAutoImport bJciAutoImport) {
        String string2;
        String string3;
        String string4;
        Object object;
        Object object2;
        String string5;
        this.tracemessage("addImportInfo, text: " + string);
        String[] stringArray = new String[10];
        stringArray = TextUtil.split((String)string, (char)',');
        String string6 = "";
        if (stringArray[0].equalsIgnoreCase("WorkbenchDir")) {
            this.setWorkbenchDir(stringArray[1]);
        }
        if (stringArray[0].equalsIgnoreCase("ResourceDir")) {
            this.setResourceDir(stringArray[1]);
        }
        if (stringArray[0].equalsIgnoreCase("LibraryDir")) {
            this.setLibraryDir(stringArray[1]);
        }
        if (stringArray[0].equalsIgnoreCase("ImagesDir")) {
            this.setSpaceImageDir(stringArray[1]);
        }
        if (stringArray[0].equalsIgnoreCase("Network")) {
            string6 = SlotPath.escape((String)stringArray[2]);
            if (bJciAutoImport.get(string6) == null) {
                string5 = stringArray[1];
                object2 = new BJciAutoNetworkAdd(string6, string5, stringArray[3], stringArray[4], stringArray[5], "");
                bJciAutoImport.add(string6, (BValue)object2);
            } else {
                this.tracemessage("addNetwork, Name: " + string6 + " already ADDED ");
            }
        }
        if (stringArray[0].equalsIgnoreCase("Device")) {
            string6 = SlotPath.escape((String)stringArray[2]);
            string5 = stringArray[3];
            if (bJciAutoImport.get(string6) == null) {
                object2 = SlotPath.escape((String)stringArray[1]);
                object = new BJciAutoDeviceAdd((String)object2, string6, string5, stringArray[5], stringArray[6], stringArray[7], stringArray[8], stringArray[9], stringArray[10]);
                if (!this.haveMeterDevices && stringArray[7] != null && stringArray[7].toUpperCase().startsWith("EM")) {
                    this.haveMeterDevices = true;
                }
                if (((BJciAutoDeviceAdd)((Object)object)).getResourceFileName().length() > 0) {
                    ((BJciAutoDeviceAdd)((Object)object)).setResourceFileOrd(this.makeFileOrd(this.getResourceDir(), ((BJciAutoDeviceAdd)((Object)object)).getAltResourceFilePath(), ((BJciAutoDeviceAdd)((Object)object)).getResourceFileName()));
                } else {
                    ((BJciAutoDeviceAdd)((Object)object)).setResourceFileOrd(BOrd.NULL);
                }
                if (((BJciAutoDeviceAdd)((Object)object)).getLibraryFileName().length() > 0) {
                    ((BJciAutoDeviceAdd)((Object)object)).setLibraryFileOrd(this.makeFileOrd(this.getLibraryDir(), "", ((BJciAutoDeviceAdd)((Object)object)).getLibraryFileName()));
                } else {
                    ((BJciAutoDeviceAdd)((Object)object)).setLibraryFileOrd(BOrd.NULL);
                }
                String string7 = "";
                string7 = object2 + '_' + string6;
                bJciAutoImport.add(string7, (BValue)object);
            } else {
                this.tracemessage("addDevice, Name: " + string6 + " already ADDED ");
            }
        }
        if (stringArray[0].equalsIgnoreCase("Schedule")) {
            string6 = SlotPath.escape((String)stringArray[2]);
            if (bJciAutoImport.get(string6) == null) {
                bJciAutoImport.add(string6, (BValue)new BJciAutoScheduleAdd(stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5]));
            } else {
                bJciAutoImport.add(string6 + '?', (BValue)new BJciAutoScheduleAdd(stringArray[1], stringArray[2] + '?', stringArray[3], stringArray[4], stringArray[5]));
                this.tracemessage("addSchedule, Name: " + stringArray[2] + " already ADDED ");
            }
        }
        if (stringArray[0].equalsIgnoreCase("Group")) {
            string6 = SlotPath.escape((String)stringArray[1]);
            if (bJciAutoImport.get(string6) == null) {
                bJciAutoImport.add(string6, (BValue)new BJciAutoGroupAdd(stringArray[1], stringArray[2]));
            } else {
                bJciAutoImport.add(string6 + '?', (BValue)new BJciAutoGroupAdd(stringArray[1] + '?', stringArray[2]));
                this.tracemessage("addGroup, Name: " + stringArray[1] + " already ADDED ");
            }
        }
        if (stringArray[0].equalsIgnoreCase("Equipment")) {
            int n;
            int n2;
            int n3;
            int n4;
            string6 = "equip" + stringArray[1];
            try {
                n4 = Integer.valueOf(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                n4 = 3;
            }
            try {
                n3 = Integer.valueOf(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                n3 = 3;
            }
            try {
                n2 = Integer.valueOf(stringArray[5]);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            try {
                n = Integer.valueOf(stringArray[7]);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            string4 = TextUtil.trimRight((String)stringArray[3]);
            string3 = TextUtil.trimRight((String)stringArray[4]);
            string2 = TextUtil.trimRight((String)stringArray[6]);
            String string8 = TextUtil.trimRight((String)stringArray[9]);
            String string9 = TextUtil.trimRight((String)stringArray[10]);
            if (bJciAutoImport.get(string6) == null) {
                bJciAutoImport.add(string6, (BValue)new BJciAutoEquipmentAdd(n4, n3, string4, string3, n2, string2, n, string8, string9));
            } else {
                bJciAutoImport.add(string6 + '?', (BValue)new BJciAutoEquipmentAdd());
                this.tracemessage("addEquipment, Name: " + stringArray[3] + ' ' + stringArray[4] + " already ADDED ");
            }
        }
        if (stringArray[0].equalsIgnoreCase("Space")) {
            int n;
            int n5;
            string6 = "space" + stringArray[1];
            try {
                n5 = Integer.valueOf(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                n5 = 0;
            }
            try {
                n = Integer.valueOf(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                n = 3;
            }
            object = stringArray[3];
            String string10 = TextUtil.trimRight((String)stringArray[4]);
            try {
                string4 = stringArray[5];
            }
            catch (NumberFormatException numberFormatException) {
                string4 = "";
            }
            string3 = TextUtil.trimRight((String)stringArray[6]);
            string2 = TextUtil.trimRight((String)stringArray[7]);
            if (bJciAutoImport.get(string6) == null) {
                bJciAutoImport.add(string6, (BValue)new BJciAutoSpacesAdd(n5, n, (String)object, string10, string4, string2));
            } else {
                bJciAutoImport.add(string6 + '?', (BValue)new BJciAutoSpacesAdd());
                this.tracemessage("addSpace, Name: " + stringArray[1] + " already ADDED ");
            }
        }
    }

    public void addSchedules() {
        BJciLinkFolder bJciLinkFolder = null;
        try {
            BOrd bOrd = BOrd.make((String)"station:|slot:/fxApp/linkFolder");
            BComponent bComponent = bOrd.get((BObject)this).asComponent();
            bJciLinkFolder = (BJciLinkFolder)bComponent;
            BJciAutoScheduleAdd bJciAutoScheduleAdd = null;
            Class clazz = class$com$jci$jciAutoImport$BJciAutoScheduleAdd;
            if (clazz == null) {
                clazz = class$com$jci$jciAutoImport$BJciAutoScheduleAdd = BJciAutoImport.class("[Lcom.jci.jciAutoImport.BJciAutoScheduleAdd;", false);
            }
            Object[] objectArray = this.getChildren(clazz);
            int n = 0;
            while (n < objectArray.length) {
                BFacets bFacets;
                BBooleanSchedule bBooleanSchedule;
                bJciAutoScheduleAdd = (BJciAutoScheduleAdd)((Object)objectArray[n]);
                String string = bJciAutoScheduleAdd.getScheduleType();
                String string2 = bJciAutoScheduleAdd.getScheduleName();
                String string3 = bJciAutoScheduleAdd.getScheduleUnits();
                String string4 = bJciAutoScheduleAdd.getScheduleDefault();
                String string5 = bJciAutoScheduleAdd.getScheduleTimes();
                if (string2 == "") {
                    string2 = lex.getText("autoImport.schedule");
                }
                if (string2.endsWith(QUESTIONMARK)) {
                    string2 = TextUtil.replace((String)string2, (String)QUESTIONMARK, (String)"");
                    string2 = SlotPath.escape((String)string2) + '?';
                } else {
                    string2 = SlotPath.escape((String)bJciAutoScheduleAdd.getScheduleName());
                }
                this.tracemessage("addSchedules, Name: " + string2 + ", Type: " + string);
                if (string.equalsIgnoreCase("Boolean")) {
                    bBooleanSchedule = new BBooleanSchedule();
                    bFacets = this.makeBooleanFacets(string3);
                    bBooleanSchedule.setFacets(bFacets);
                    boolean bl = bFacets.getb(string4, false);
                    bBooleanSchedule.setDefaultOutput((BStatusValue)new BStatusBoolean(bl));
                    this.tracemessage("addSchedules, BOOLEAN, Name: " + string2);
                    this.addBooleanScheduleTimes(bBooleanSchedule, string5);
                    bJciLinkFolder.add(string2, (BValue)bBooleanSchedule);
                }
                if (string.equalsIgnoreCase("Enum") || string.equalsIgnoreCase("Enumeration")) {
                    bBooleanSchedule = new BEnumSchedule();
                    bFacets = this.makeEnumFacets(string3);
                    bBooleanSchedule.setFacets(bFacets);
                    BEnumRange bEnumRange = (BEnumRange)bFacets.getFacets().get("range");
                    BEnum bEnum = bEnumRange.get(string4);
                    bBooleanSchedule.setDefaultOutput((BStatusValue)new BStatusEnum(bEnum));
                    this.tracemessage("addSchedules, ENUM, Name: " + string2);
                    bJciLinkFolder.add(string2, (BValue)bBooleanSchedule);
                    this.addEnumScheduleTimes((BEnumSchedule)bBooleanSchedule, string5);
                }
                if (string.equalsIgnoreCase("Numeric")) {
                    bBooleanSchedule = new BNumericSchedule();
                    bBooleanSchedule.setFacets(this.makeNumericFacets(string3));
                    double d = BDouble.make((String)"0").getDouble();
                    try {
                        d = BDouble.make((String)string4).getDouble();
                    }
                    catch (Exception exception) {
                        this.tracemessage("addSchedules, NUMERIC value decode error, use default: " + d);
                    }
                    bBooleanSchedule.setDefaultOutput((BStatusValue)new BStatusNumeric(d));
                    this.tracemessage("addSchedules, NUMERIC, Name: " + string2);
                    bJciLinkFolder.add(string2, (BValue)bBooleanSchedule);
                    this.addNumericScheduleTimes((BNumericSchedule)bBooleanSchedule, string5);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.tracemessage("addSchedules After Add EXCEPTION");
            exception.printStackTrace();
        }
    }

    public void addNumericScheduleTimes(BNumericSchedule bNumericSchedule, String string) {
        String[] stringArray = TextUtil.split((String)string, (char)';');
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            String string3 = stringArray[n + 1];
            String string4 = stringArray[n + 2];
            String string5 = stringArray[n + 3];
            this.tracemessage("addNumericScheduleTimes for: " + string2 + ", from: " + string3 + ", to: " + string4 + ", value: " + string5);
            try {
                double d;
                try {
                    d = BDouble.make((String)string5).getDouble();
                }
                catch (Exception exception) {
                    d = 0.0;
                }
                BStatusNumeric bStatusNumeric = new BStatusNumeric(d);
                BTime bTime = this.makeTimeValue(string3);
                BTime bTime2 = this.makeTimeValue(string4);
                BTimeSchedule bTimeSchedule = new BTimeSchedule(bTime, bTime2, (BStatusValue)bStatusNumeric);
                if (string2.equalsIgnoreCase("Sunday")) {
                    bNumericSchedule.get(BWeekday.sunday).add(bTimeSchedule);
                }
                if (string2.equalsIgnoreCase("Monday")) {
                    bNumericSchedule.get(BWeekday.monday).add(bTimeSchedule);
                }
                if (string2.equalsIgnoreCase("Tuesday")) {
                    bNumericSchedule.get(BWeekday.tuesday).add(bTimeSchedule);
                }
                if (string2.equalsIgnoreCase("Wednesday")) {
                    bNumericSchedule.get(BWeekday.wednesday).add(bTimeSchedule);
                }
                if (string2.equalsIgnoreCase("Thursday")) {
                    bNumericSchedule.get(BWeekday.thursday).add(bTimeSchedule);
                }
                if (string2.equalsIgnoreCase("Friday")) {
                    bNumericSchedule.get(BWeekday.friday).add(bTimeSchedule);
                }
                if (string2.equalsIgnoreCase("Saturday")) {
                    bNumericSchedule.get(BWeekday.saturday).add(bTimeSchedule);
                }
                if (string2.equalsIgnoreCase("Mon-Fri")) {
                    bNumericSchedule.get(BWeekday.monday).add(bTimeSchedule);
                    bNumericSchedule.get(BWeekday.tuesday).add((BTimeSchedule)bTimeSchedule.newCopy());
                    bNumericSchedule.get(BWeekday.wednesday).add((BTimeSchedule)bTimeSchedule.newCopy());
                    bNumericSchedule.get(BWeekday.thursday).add((BTimeSchedule)bTimeSchedule.newCopy());
                    bNumericSchedule.get(BWeekday.friday).add((BTimeSchedule)bTimeSchedule.newCopy());
                }
            }
            catch (Exception exception) {
                System.out.println("ERROR in addNumericScheduleTimes = " + exception.getMessage());
                exception.printStackTrace();
            }
            n += 4;
        }
    }

    public void addBooleanScheduleTimes(BBooleanSchedule bBooleanSchedule, String string) {
        String[] stringArray = TextUtil.split((String)string, (char)';');
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            String string3 = stringArray[n + 1];
            String string4 = stringArray[n + 2];
            String string5 = stringArray[n + 3];
            this.tracemessage("addBooleanScheduleTimes for: " + string2 + ", from: " + string3 + ", to: " + string4 + ", value: " + string5);
            try {
                BFacets bFacets = bBooleanSchedule.getFacets();
                boolean bl = false;
                if (bFacets.gets("trueText", "").equalsIgnoreCase(string5)) {
                    bl = true;
                }
                BStatusBoolean bStatusBoolean = new BStatusBoolean(bl);
                BTime bTime = this.makeTimeValue(string3);
                BTime bTime2 = this.makeTimeValue(string4);
                BTimeSchedule bTimeSchedule = new BTimeSchedule(bTime, bTime2, (BStatusValue)bStatusBoolean);
                if (string2.equalsIgnoreCase("Sunday")) {
                    bBooleanSchedule.get(BWeekday.sunday).add(bTimeSchedule);
                }
                if (string2.equalsIgnoreCase("Monday")) {
                    bBooleanSchedule.get(BWeekday.monday).add(bTimeSchedule);
                }
                if (string2.equalsIgnoreCase("Tuesday")) {
                    bBooleanSchedule.get(BWeekday.tuesday).add(bTimeSchedule);
                }
                if (string2.equalsIgnoreCase("Wednesday")) {
                    bBooleanSchedule.get(BWeekday.wednesday).add(bTimeSchedule);
                }
                if (string2.equalsIgnoreCase("Thursday")) {
                    bBooleanSchedule.get(BWeekday.thursday).add(bTimeSchedule);
                }
                if (string2.equalsIgnoreCase("Friday")) {
                    bBooleanSchedule.get(BWeekday.friday).add(bTimeSchedule);
                }
                if (string2.equalsIgnoreCase("Saturday")) {
                    bBooleanSchedule.get(BWeekday.saturday).add(bTimeSchedule);
                }
                if (string2.equalsIgnoreCase("Mon-Fri")) {
                    bBooleanSchedule.get(BWeekday.monday).add(bTimeSchedule);
                    bBooleanSchedule.get(BWeekday.tuesday).add((BTimeSchedule)bTimeSchedule.newCopy());
                    bBooleanSchedule.get(BWeekday.wednesday).add((BTimeSchedule)bTimeSchedule.newCopy());
                    bBooleanSchedule.get(BWeekday.thursday).add((BTimeSchedule)bTimeSchedule.newCopy());
                    bBooleanSchedule.get(BWeekday.friday).add((BTimeSchedule)bTimeSchedule.newCopy());
                }
            }
            catch (Exception exception) {
                System.out.println("ERROR in addBooleanScheduleTimes = " + exception.getMessage());
                exception.printStackTrace();
            }
            n += 4;
        }
    }

    public void addEnumScheduleTimes(BEnumSchedule bEnumSchedule, String string) {
        String[] stringArray = TextUtil.split((String)string, (char)';');
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            String string3 = stringArray[n + 1];
            String string4 = stringArray[n + 2];
            String string5 = stringArray[n + 3];
            this.tracemessage("addEnumScheduleTimes for: " + string2 + ", from: " + string3 + ", to: " + string4 + ", value: " + string5);
            try {
                BFacets bFacets = bEnumSchedule.getFacets();
                BEnumRange bEnumRange = (BEnumRange)bFacets.getFacets().get("range");
                BEnum bEnum = bEnumRange.get(string5);
                BStatusEnum bStatusEnum = new BStatusEnum(bEnum);
                BTime bTime = this.makeTimeValue(string3);
                BTime bTime2 = this.makeTimeValue(string4);
                BTimeSchedule bTimeSchedule = new BTimeSchedule(bTime, bTime2, (BStatusValue)bStatusEnum);
                if (string2.equalsIgnoreCase("Sunday")) {
                    bEnumSchedule.get(BWeekday.sunday).add(bTimeSchedule);
                }
                if (string2.equalsIgnoreCase("Monday")) {
                    bEnumSchedule.get(BWeekday.monday).add(bTimeSchedule);
                }
                if (string2.equalsIgnoreCase("Tuesday")) {
                    bEnumSchedule.get(BWeekday.tuesday).add(bTimeSchedule);
                }
                if (string2.equalsIgnoreCase("Wednesday")) {
                    bEnumSchedule.get(BWeekday.wednesday).add(bTimeSchedule);
                }
                if (string2.equalsIgnoreCase("Thursday")) {
                    bEnumSchedule.get(BWeekday.thursday).add(bTimeSchedule);
                }
                if (string2.equalsIgnoreCase("Friday")) {
                    bEnumSchedule.get(BWeekday.friday).add(bTimeSchedule);
                }
                if (string2.equalsIgnoreCase("Saturday")) {
                    bEnumSchedule.get(BWeekday.saturday).add(bTimeSchedule);
                }
                if (string2.equalsIgnoreCase("Mon-Fri")) {
                    bEnumSchedule.get(BWeekday.monday).add(bTimeSchedule);
                    bEnumSchedule.get(BWeekday.tuesday).add((BTimeSchedule)bTimeSchedule.newCopy());
                    bEnumSchedule.get(BWeekday.wednesday).add((BTimeSchedule)bTimeSchedule.newCopy());
                    bEnumSchedule.get(BWeekday.thursday).add((BTimeSchedule)bTimeSchedule.newCopy());
                    bEnumSchedule.get(BWeekday.friday).add((BTimeSchedule)bTimeSchedule.newCopy());
                }
            }
            catch (Exception exception) {
                System.out.println("ERROR in addEnumScheduleTimes = " + exception.getMessage());
                exception.printStackTrace();
            }
            n += 4;
        }
    }

    public BTime makeTimeValue(String string) {
        BTime bTime = BTime.make((int)0, (int)0, (int)0);
        try {
            boolean bl = string.endsWith("PM");
            String string2 = string.substring(0, 2);
            String string3 = string.substring(3, 5);
            int n = BInteger.make((String)string3).getInt();
            int n2 = BInteger.make((String)string2).getInt();
            if (bl) {
                if (n2 != 12) {
                    n2 += 12;
                }
            } else if (n2 == 12) {
                n2 = 0;
            }
            bTime = BTime.make((int)n2, (int)n, (int)0);
        }
        catch (Exception exception) {
            System.out.println("ERROR in makeTimeValue = " + exception.getMessage());
            exception.printStackTrace();
        }
        return bTime;
    }

    public void addGroups() {
        BJciPointGroup bJciPointGroup = null;
        try {
            BOrd bOrd = BOrd.make((String)"station:|slot:/fxApp/pointGroupHome");
            BComponent bComponent = bOrd.get((BObject)this).asComponent();
            bJciPointGroup = (BJciPointGroup)bComponent;
            BJciAutoGroupAdd bJciAutoGroupAdd = null;
            Class clazz = class$com$jci$jciAutoImport$BJciAutoGroupAdd;
            if (clazz == null) {
                clazz = class$com$jci$jciAutoImport$BJciAutoGroupAdd = BJciAutoImport.class("[Lcom.jci.jciAutoImport.BJciAutoGroupAdd;", false);
            }
            Object[] objectArray = this.getChildren(clazz);
            int n = 0;
            while (n < objectArray.length) {
                bJciAutoGroupAdd = (BJciAutoGroupAdd)((Object)objectArray[n]);
                String string = bJciAutoGroupAdd.getGroupName();
                String string2 = bJciAutoGroupAdd.getPointNamePattern();
                if (string == "") {
                    string = lex.getText("autoImport.group");
                }
                if (string.endsWith(QUESTIONMARK)) {
                    string = TextUtil.replace((String)string, (String)QUESTIONMARK, (String)"");
                    string = SlotPath.escape((String)string) + '?';
                } else {
                    string = SlotPath.escape((String)bJciAutoGroupAdd.getGroupName());
                }
                bJciPointGroup.add(string, (BValue)new BJciPointGroupFolder());
                String string3 = "";
                string3 = bJciPointGroup.getChildComponents()[bJciPointGroup.getChildComponents().length - 1].getName();
                this.addPointsToGroup(bJciPointGroup, string3, string2);
                ++n;
            }
        }
        catch (Exception exception) {
            this.tracemessage("addGroups After Add EXCEPTION");
            exception.printStackTrace();
        }
    }

    public void addPointsToGroup(BJciPointGroup bJciPointGroup, String string, String string2) {
        if (string2 == "") {
            return;
        }
        BJciPointGroupFolder bJciPointGroupFolder = null;
        try {
            BOrd bOrd = BOrd.make((String)("station:|slot:/fxApp/pointGroupHome/" + string));
            BComponent bComponent = bOrd.get((BObject)this).asComponent();
            bJciPointGroupFolder = (BJciPointGroupFolder)bComponent;
            String string3 = "station:|slot:/|bql:select slotPathOrd, displayName, parent.parent.displayName as 'parent'  from control:ControlPoint where displayName = '" + string2 + '\'';
            BOrd bOrd2 = BOrd.make((String)string3);
            BITable bITable = (BITable)bOrd2.resolve((BObject)this).get();
            int n = bITable.size();
            Column column = bITable.getColumns().get(0);
            Column column2 = bITable.getColumns().get(1);
            Column column3 = bITable.getColumns().get(2);
            int n2 = 0;
            while (n2 < n) {
                String string4 = bITable.getString(n2, column);
                String string5 = bITable.getString(n2, column2);
                String string6 = bITable.getString(n2, column3);
                String string7 = SlotPath.escape((String)(string6 + '_' + string5));
                BJciPointGroupPoint bJciPointGroupPoint = new BJciPointGroupPoint();
                bJciPointGroupPoint.setPointOrd(BOrd.make((String)string4));
                this.tracemessage("addPointsToGroup, grpName: " + string + ", Name: " + string7 + ", ORD: " + string4);
                bJciPointGroupFolder.add(string7 + '?', (BValue)bJciPointGroupPoint);
                ++n2;
            }
        }
        catch (Exception exception) {
            this.tracemessage("addPointsToGroup After Add EXCEPTION");
            exception.printStackTrace();
        }
    }

    public void addSpaces() {
        String string = this.getSpaceImageDir();
        String string2 = Sys.getStation().getStationName();
        this.copySpaceImageFolder(string, string2);
        BJciApplianceApp bJciApplianceApp = null;
        BJciSpaceRoot bJciSpaceRoot = null;
        BJciSpaceNode bJciSpaceNode = null;
        try {
            Object[] objectArray;
            BOrd bOrd = BOrd.make((String)"station:|slot:/fxApp");
            BComponent bComponent = bOrd.get((BObject)this).asComponent();
            bJciApplianceApp = (BJciApplianceApp)bComponent;
            BJciAutoSpacesAdd bJciAutoSpacesAdd = null;
            Class clazz = class$com$jci$jciAutoImport$BJciAutoSpacesAdd;
            if (clazz == null) {
                clazz = class$com$jci$jciAutoImport$BJciAutoSpacesAdd = BJciAutoImport.class("[Lcom.jci.jciAutoImport.BJciAutoSpacesAdd;", false);
            }
            if ((objectArray = this.getChildren(clazz)).length > 0) {
                Object[] objectArray2;
                bJciAutoSpacesAdd = (BJciAutoSpacesAdd)((Object)objectArray[0]);
                String string3 = bJciAutoSpacesAdd.getSpaceType();
                String string4 = bJciAutoSpacesAdd.getSpaceName();
                int n = bJciAutoSpacesAdd.getSpaceId();
                int n2 = bJciAutoSpacesAdd.getParentId();
                String string5 = bJciAutoSpacesAdd.getServedBy();
                String string6 = bJciAutoSpacesAdd.getSpaceImageName();
                this.spaceRootName = string4;
                this.tracemessage("addSpaces, ID: " + n + ", PID: " + n2 + ", Name: " + string4 + ", Type: " + string3 + ", servedBy: " + string5);
                bJciSpaceRoot = new BJciSpaceRoot(string4);
                bJciSpaceRoot.setSpaceType(string3);
                bJciSpaceRoot.setNodePath(this.spaceRootName);
                bJciApplianceApp.add("spaceRoot", (BValue)bJciSpaceRoot);
                BNameMap bNameMap = BNameMap.DEFAULT;
                BValue bValue = bJciApplianceApp.get("displayNames");
                if (bValue == null) {
                    bNameMap = BNameMap.make((BNameMap)bNameMap, (String)"spaceRoot", (String)string4);
                    int n3 = 260;
                    bJciApplianceApp.add("displayNames", (BValue)bNameMap, n3);
                } else {
                    bNameMap = (BNameMap)bValue;
                    bNameMap = BNameMap.make((BNameMap)bNameMap, (String)"spaceRoot", (String)string4);
                    bJciApplianceApp.set("displayNames", (BValue)bNameMap);
                }
                bJciAutoSpacesAdd.setSpaceAdded(true);
                Class clazz2 = class$com$jci$jciSpaces$BJciSpaceNode;
                if (clazz2 == null) {
                    clazz2 = class$com$jci$jciSpaces$BJciSpaceNode = BJciAutoImport.class("[Lcom.jci.jciSpaces.BJciSpaceNode;", false);
                }
                if ((objectArray2 = bJciApplianceApp.getChildren(clazz2)).length > 0) {
                    bJciSpaceNode = (BJciSpaceNode)objectArray2[0];
                    bJciAutoSpacesAdd.setSpaceOrd(bJciSpaceNode.getSlotPathOrd());
                    String string7 = "";
                    if (string6.length() > 0) {
                        string6 = this.checkForFullImagePath(string6, string, string2);
                        string7 = "file:^Graphics/Images/" + string6;
                        bJciSpaceNode.setSpaceImage(BImage.make((String)string7));
                    }
                    this.addServedByNodes(bJciSpaceNode, string5);
                }
                this.addSpaceNode(objectArray, bJciAutoSpacesAdd, bJciSpaceNode);
                bJciSpaceNode.doBuildAllSpaceGraphics();
            } else {
                this.tracemessage("addSpaces, NO SPACE NODES to Add ");
            }
        }
        catch (Exception exception) {
            this.tracemessage("addSpace After Add EXCEPTION");
            exception.printStackTrace();
        }
    }

    public String checkForFullImagePath(String string, String string2, String string3) {
        String string4 = TextUtil.replace((String)string, (String)"\\", (String)"/");
        int n = string4.lastIndexOf("/");
        System.out.println("checkForFullImagePath, imageFile = " + string + ", lastSlash: " + n);
        if (n > -1) {
            String string5 = string4.substring(n + 1, string4.length());
            String string6 = Sys.getBajaHome().getPath() + "\\stations\\" + string3 + "\\Graphics\\Images\\" + string5;
            System.out.println("checkForFullImagePath, Source File = " + string4 + " TO Dest File = " + string6);
            File file = new File(string4);
            File file2 = new File(string6);
            try {
                if (!file2.exists()) {
                    FileUtil.copyFile((File)file, (File)file2);
                }
            }
            catch (Exception exception) {
                System.out.println("checkForFullImagePath copy ERROR: Source File = " + string4 + " TO Dest File = " + string6);
                exception.printStackTrace();
            }
            return string5;
        }
        return string;
    }

    private final void copySpaceImageFolder(String string, String string2) {
        Object[] objectArray = new Object[]{string};
        String string3 = TextUtil.replace((String)string, (String)"\\", (String)"/");
        String string4 = Sys.getBajaHome().getPath() + "\\stations\\" + string2 + "\\Graphics\\Images";
        System.out.println("copySpaceImageFolder, Source Folder = " + string3 + " TO Dest Folder = " + string4);
        File file = new File(string3);
        File file2 = new File(string4);
        try {
            FileUtil.copyDir((File)file, (File)file2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getSpacePathOnly(String string, String string2) {
        String string3 = SlotPath.unescape((String)string2);
        int n = string3.indexOf(string);
        if (n > -1) {
            string3 = string3.substring(n);
            string3 = TextUtil.replace((String)string3, (String)string, (String)this.spaceRootName);
        }
        return SlotPath.unescape((String)string3);
    }

    public String getEquipmentPathOnly(String string, String string2) {
        String string3 = SlotPath.unescape((String)string2);
        int n = string3.indexOf(string);
        if (n > -1) {
            string3 = string3.substring(n);
            string3 = TextUtil.replace((String)string3, (String)string, (String)this.equipmentRootName);
        }
        return SlotPath.unescape((String)string3);
    }

    public String getDeviceNameOnly(String string) {
        String string2 = "";
        int n = string.indexOf("\\");
        if (n > 0) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public void addServedByNodes(BJciSpaceNode bJciSpaceNode, String string) {
        if (string.length() > 0) {
            String[] stringArray = TextUtil.split((String)string, (char)';');
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                int n2 = 0;
                try {
                    n2 = Integer.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 0;
                }
                this.tracemessage("   addServedByNodes for: " + bJciSpaceNode.getNodePath() + ", dev: " + n2);
                BJciAutoDeviceAdd bJciAutoDeviceAdd = this.getDeviceForDeviceID(n2);
                String string3 = bJciAutoDeviceAdd.getDeviceName();
                BJciSpaceServedBy bJciSpaceServedBy = new BJciSpaceServedBy();
                bJciSpaceServedBy.setEquipmentNodeOrd(bJciAutoDeviceAdd.getDeviceOrd());
                bJciSpaceServedBy.setEquipmentDescription(SlotPath.unescape((String)string3));
                bJciSpaceServedBy.setEquipmentType(bJciAutoDeviceAdd.getEquipmentType());
                String string4 = SlotPath.escape((String)("servedBy" + string3));
                if (bJciSpaceNode.get(string4) == null) {
                    bJciSpaceNode.add(string4, (BValue)bJciSpaceServedBy);
                }
                ++n;
            }
        }
    }

    public void addSpaceNode(Object[] objectArray, BJciAutoSpacesAdd bJciAutoSpacesAdd, BJciSpaceNode bJciSpaceNode) {
        BJciSpaceNode bJciSpaceNode2 = null;
        BJciSpaceNode bJciSpaceNode3 = null;
        String string = this.getSpaceImageDir();
        String string2 = Sys.getStation().getStationName();
        int n = 1;
        while (n < objectArray.length) {
            BJciAutoSpacesAdd bJciAutoSpacesAdd2 = (BJciAutoSpacesAdd)((Object)objectArray[n]);
            boolean bl = bJciAutoSpacesAdd2.getSpaceAdded();
            if (!bl && bJciAutoSpacesAdd.getSpaceId() == bJciAutoSpacesAdd2.getParentId()) {
                String string3 = bJciAutoSpacesAdd2.getSpaceType();
                String string4 = SlotPath.escape((String)bJciAutoSpacesAdd2.getSpaceName());
                String string5 = bJciAutoSpacesAdd2.getSpaceName();
                int n2 = bJciAutoSpacesAdd2.getSpaceId();
                int n3 = bJciAutoSpacesAdd2.getParentId();
                String string6 = bJciAutoSpacesAdd2.getServedBy();
                String string7 = bJciAutoSpacesAdd2.getSpaceImageName();
                String string8 = "";
                this.tracemessage("addSpaceNode, ID: " + n2 + ", PID: " + n3 + ", Name: " + string4 + ", Type: " + string3 + ", servedBy: " + string6 + ", img: " + string7);
                bJciSpaceNode2 = new BJciSpaceNode(string4, string3);
                bJciSpaceNode2.setDescription(string5);
                if (string7.length() > 0) {
                    string7 = this.checkForFullImagePath(string7, string, string2);
                    string8 = "file:^Graphics/Images/" + string7;
                    bJciSpaceNode2.setSpaceImage(BImage.make((String)string8));
                }
                bJciSpaceNode.add(string4, (BValue)bJciSpaceNode2);
                bJciAutoSpacesAdd2.setSpaceAdded(true);
                Class clazz = class$com$jci$jciSpaces$BJciSpaceNode;
                if (clazz == null) {
                    clazz = BJciAutoImport.class("[Lcom.jci.jciSpaces.BJciSpaceNode;", false);
                }
                Object[] objectArray2 = bJciSpaceNode.getChildren(clazz);
                int n4 = 0;
                while (n4 < objectArray2.length) {
                    if (((BJciSpaceNode)objectArray2[n4]).getName().equalsIgnoreCase(string4)) {
                        bJciSpaceNode3 = (BJciSpaceNode)objectArray2[n4];
                        bJciSpaceNode3.setNodePath(this.getSpacePathOnly("spaceRoot", bJciSpaceNode3.getNavOrd().toString()));
                        bJciAutoSpacesAdd2.setSpaceOrd(bJciSpaceNode3.getSlotPathOrd());
                        this.addServedByNodes(bJciSpaceNode3, string6);
                        break;
                    }
                    ++n4;
                }
                this.addSpaceNode(objectArray, bJciAutoSpacesAdd2, bJciSpaceNode3);
            }
            ++n;
        }
    }

    public void addEquipment() {
        BJciApplianceApp bJciApplianceApp = null;
        BJciEquipmentRoot bJciEquipmentRoot = null;
        BJciEquipmentRoot bJciEquipmentRoot2 = null;
        String string = this.getSpaceImageDir();
        String string2 = Sys.getStation().getStationName();
        try {
            Object[] objectArray;
            BOrd bOrd = BOrd.make((String)"station:|slot:/fxApp");
            BComponent bComponent = bOrd.get((BObject)this).asComponent();
            bJciApplianceApp = (BJciApplianceApp)bComponent;
            BJciAutoEquipmentAdd bJciAutoEquipmentAdd = null;
            Class clazz = class$com$jci$jciAutoImport$BJciAutoEquipmentAdd;
            if (clazz == null) {
                clazz = class$com$jci$jciAutoImport$BJciAutoEquipmentAdd = BJciAutoImport.class("[Lcom.jci.jciAutoImport.BJciAutoEquipmentAdd;", false);
            }
            if ((objectArray = this.getChildren(clazz)).length > 0) {
                Object[] objectArray2;
                bJciAutoEquipmentAdd = (BJciAutoEquipmentAdd)((Object)objectArray[0]);
                String string3 = bJciAutoEquipmentAdd.getEquipmentType();
                String string4 = bJciAutoEquipmentAdd.getEquipmentName();
                int n = bJciAutoEquipmentAdd.getEquipmentId();
                int n2 = bJciAutoEquipmentAdd.getParentId();
                int n3 = bJciAutoEquipmentAdd.getSpaceId();
                int n4 = bJciAutoEquipmentAdd.getDeviceId();
                String string5 = bJciAutoEquipmentAdd.getDeviceRef();
                String string6 = bJciAutoEquipmentAdd.getEquipmentImageName();
                this.equipmentRootName = string4;
                this.tracemessage("addEquipment, ID: " + n + ", PID: " + n2 + ", Name: " + string4 + ", Type: " + string3 + ", spaceID: " + n3 + ", devID: " + n4);
                bJciEquipmentRoot = new BJciEquipmentRoot(string4);
                bJciEquipmentRoot.setEquipmentType(string3);
                bJciEquipmentRoot.setEquipmentOrd(this.getDeviceOrdForDeviceID(n4));
                bJciEquipmentRoot.setNodePath(this.equipmentRootName);
                bJciApplianceApp.add("equipmentRoot", (BValue)bJciEquipmentRoot);
                BNameMap bNameMap = BNameMap.DEFAULT;
                BValue bValue = bJciApplianceApp.get("displayNames");
                if (bValue == null) {
                    bNameMap = BNameMap.make((BNameMap)bNameMap, (String)"equipmentRoot", (String)string4);
                    int n5 = 260;
                    bJciApplianceApp.add("displayNames", (BValue)bNameMap, n5);
                } else {
                    bNameMap = (BNameMap)bValue;
                    bNameMap = BNameMap.make((BNameMap)bNameMap, (String)"equipmentRoot", (String)string4);
                    bJciApplianceApp.set("displayNames", (BValue)bNameMap);
                }
                bJciAutoEquipmentAdd.setEquipmentAdded(true);
                Class clazz2 = class$com$jci$jciSpaces$BJciEquipmentNode;
                if (clazz2 == null) {
                    clazz2 = class$com$jci$jciSpaces$BJciEquipmentNode = BJciAutoImport.class("[Lcom.jci.jciSpaces.BJciEquipmentNode;", false);
                }
                if ((objectArray2 = bJciApplianceApp.getChildren(clazz2)).length > 0) {
                    bJciEquipmentRoot2 = (BJciEquipmentRoot)objectArray2[0];
                    bJciAutoEquipmentAdd.setEquipmentOrd(bJciEquipmentRoot2.getSlotPathOrd());
                    String string7 = "";
                    if (string6.length() > 0) {
                        string6 = this.checkForFullImagePath(string6, string, string2);
                        string7 = "file:^Graphics/Images/" + string6;
                        bJciEquipmentRoot2.setEquipmentImage(BImage.make((String)string7));
                    }
                }
                this.addEquipmentNode(objectArray, bJciAutoEquipmentAdd, (BJciEquipmentNode)bJciEquipmentRoot2);
                bJciEquipmentRoot2.doBuildAllEquipmentGraphics();
            } else {
                this.tracemessage("addEquipment, NO EQUIPMENT NODES to Add ");
            }
        }
        catch (Exception exception) {
            this.tracemessage("addEquipment After Add EXCEPTION");
            exception.printStackTrace();
        }
    }

    public void addEquipmentNode(Object[] objectArray, BJciAutoEquipmentAdd bJciAutoEquipmentAdd, BJciEquipmentNode bJciEquipmentNode) {
        BJciEquipmentNode bJciEquipmentNode2 = null;
        BJciEquipmentNode bJciEquipmentNode3 = null;
        String string = this.getSpaceImageDir();
        String string2 = Sys.getStation().getStationName();
        int n = 1;
        while (n < objectArray.length) {
            BJciAutoEquipmentAdd bJciAutoEquipmentAdd2 = (BJciAutoEquipmentAdd)((Object)objectArray[n]);
            boolean bl = bJciAutoEquipmentAdd2.getEquipmentAdded();
            if (!bl && bJciAutoEquipmentAdd.getEquipmentId() == bJciAutoEquipmentAdd2.getParentId()) {
                String string3 = bJciAutoEquipmentAdd2.getEquipmentType();
                String string4 = SlotPath.escape((String)bJciAutoEquipmentAdd2.getEquipmentName());
                String string5 = bJciAutoEquipmentAdd2.getEquipmentName();
                int n2 = bJciAutoEquipmentAdd2.getEquipmentId();
                int n3 = bJciAutoEquipmentAdd2.getParentId();
                int n4 = bJciAutoEquipmentAdd2.getSpaceId();
                int n5 = bJciAutoEquipmentAdd2.getDeviceId();
                String string6 = bJciAutoEquipmentAdd2.getDeviceRef();
                String string7 = bJciAutoEquipmentAdd2.getEquipmentImageName();
                String string8 = "";
                String string9 = bJciAutoEquipmentAdd2.getEquipmentServedBy();
                this.tracemessage("addEquipment, ID: " + n2 + ", PID: " + n3 + ", Name: " + string4 + ", Type: " + string3 + ", spaceID: " + n4 + ", devID: " + n5);
                bJciEquipmentNode2 = new BJciEquipmentNode(string4, string3);
                bJciEquipmentNode2.setEquipmentType(string3);
                bJciEquipmentNode2.setDescription(string5);
                bJciEquipmentNode2.setEquipmentOrd(this.getDeviceOrdForDeviceID(n5));
                if (string7.length() > 0) {
                    string7 = this.checkForFullImagePath(string7, string, string2);
                    string8 = "file:^Graphics/Images/" + string7;
                    bJciEquipmentNode2.setEquipmentImage(BImage.make((String)string8));
                }
                bJciEquipmentNode.add(string4 + '?', (BValue)bJciEquipmentNode2);
                this.addEquipmentServedBy(bJciEquipmentNode, bJciEquipmentNode2, string9);
                bJciAutoEquipmentAdd2.setEquipmentAdded(true);
                Class clazz = class$com$jci$jciSpaces$BJciEquipmentNode;
                if (clazz == null) {
                    clazz = BJciAutoImport.class("[Lcom.jci.jciSpaces.BJciEquipmentNode;", false);
                }
                Object[] objectArray2 = bJciEquipmentNode.getChildren(clazz);
                int n6 = 0;
                while (n6 < objectArray2.length) {
                    if (((BJciEquipmentNode)objectArray2[n6]).getName().equalsIgnoreCase(string4)) {
                        bJciEquipmentNode3 = (BJciEquipmentNode)objectArray2[n6];
                        bJciEquipmentNode3.setNodePath(this.getEquipmentPathOnly("equipmentRoot", bJciEquipmentNode3.getNavOrd().toString()));
                        this.addEquipmentLocatedInSpace(bJciEquipmentNode3, n4);
                        break;
                    }
                    ++n6;
                }
                this.addEquipmentNode(objectArray, bJciAutoEquipmentAdd2, bJciEquipmentNode3);
            }
            ++n;
        }
    }

    public void addEquipmentServedBy(BJciEquipmentNode bJciEquipmentNode, BJciEquipmentNode bJciEquipmentNode2, String string) {
        String[] stringArray;
        System.out.println("   addEquipmentServedBy, Equip Node = " + bJciEquipmentNode2.getDescription() + ", Parent = " + bJciEquipmentNode.getDescription());
        if (bJciEquipmentNode.getEquipmentType().length() > 0 && bJciEquipmentNode2.getEquipmentType().equalsIgnoreCase("VavBox")) {
            stringArray = bJciEquipmentNode.getEquipmentOrd();
            System.out.println("   addEquipmentServedBy, Device Ord = " + stringArray);
            BJciEquipmentServedBy bJciEquipmentServedBy = new BJciEquipmentServedBy();
            bJciEquipmentServedBy.setEquipmentNodeOrd((BOrd)stringArray);
            bJciEquipmentServedBy.setEquipmentType(bJciEquipmentNode.getEquipmentType());
            bJciEquipmentServedBy.setEquipmentDescription(SlotPath.unescape((String)bJciEquipmentNode.getDescription()));
            bJciEquipmentNode2.add("servedBy" + bJciEquipmentNode.getName(), (BValue)bJciEquipmentServedBy);
        }
        if (string.length() > 0) {
            System.out.println("   addEquipmentServedBy, servedByList = " + string);
            stringArray = TextUtil.split((String)string, (char)';');
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                int n2 = 0;
                try {
                    n2 = Integer.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 0;
                }
                this.tracemessage("   addEquipmentServedBy for: " + bJciEquipmentNode2.getNodePath() + ", dev: " + n2);
                BJciAutoDeviceAdd bJciAutoDeviceAdd = this.getDeviceForDeviceID(n2);
                String string3 = bJciAutoDeviceAdd.getDeviceName();
                BJciEquipmentServedBy bJciEquipmentServedBy = new BJciEquipmentServedBy();
                bJciEquipmentServedBy.setEquipmentNodeOrd(bJciAutoDeviceAdd.getDeviceOrd());
                bJciEquipmentServedBy.setEquipmentDescription(SlotPath.unescape((String)string3));
                bJciEquipmentServedBy.setEquipmentType(bJciAutoDeviceAdd.getEquipmentType());
                String string4 = SlotPath.escape((String)("servedBy" + string3));
                bJciEquipmentNode2.add(string4, (BValue)bJciEquipmentServedBy);
                ++n;
            }
        }
    }

    public void addEquipmentLocatedInSpace(BJciEquipmentNode bJciEquipmentNode, int n) {
        if (n == 0) {
            return;
        }
        int n2 = n - 3;
        try {
            Object[] objectArray;
            BOrd bOrd = BOrd.make((String)"station:|slot:/fxApp/autoImport");
            BComponent bComponent = bOrd.get((BObject)this).asComponent();
            BJciAutoSpacesAdd bJciAutoSpacesAdd = null;
            Class clazz = class$com$jci$jciAutoImport$BJciAutoSpacesAdd;
            if (clazz == null) {
                clazz = class$com$jci$jciAutoImport$BJciAutoSpacesAdd = BJciAutoImport.class("[Lcom.jci.jciAutoImport.BJciAutoSpacesAdd;", false);
            }
            if ((objectArray = bComponent.getChildren(clazz)).length > 0 && n2 < objectArray.length) {
                bJciAutoSpacesAdd = (BJciAutoSpacesAdd)((Object)objectArray[n2]);
                BOrd bOrd2 = bJciAutoSpacesAdd.getSpaceOrd();
                BJciEquipmentLocatedInSpace bJciEquipmentLocatedInSpace = new BJciEquipmentLocatedInSpace((BComponent)this, bOrd2);
                bJciEquipmentNode.add("locatedIn" + SlotPath.escape((String)bJciAutoSpacesAdd.getSpaceName()), (BValue)bJciEquipmentLocatedInSpace);
                this.tracemessage("addEquipmentLocatedInSpace, spaceID: " + n + ", Index: " + n2 + ", ord: " + bOrd2.toString());
            } else {
                this.tracemessage("addEquipmentLocatedInSpace, NO Spaces Added ");
            }
        }
        catch (Exception exception) {
            this.tracemessage("addEquipmentLocatedInSpace After Add EXCEPTION");
            exception.printStackTrace();
        }
    }

    public BOrd getDeviceOrdForDeviceID(int n) {
        BOrd bOrd = BOrd.NULL;
        if (n == 0) {
            return bOrd;
        }
        int n2 = n - 3;
        try {
            Object[] objectArray;
            BOrd bOrd2 = BOrd.make((String)"station:|slot:/fxApp/autoImport");
            BComponent bComponent = bOrd2.get((BObject)this).asComponent();
            BJciAutoDeviceAdd bJciAutoDeviceAdd = null;
            Class clazz = class$com$jci$jciAutoImport$BJciAutoDeviceAdd;
            if (clazz == null) {
                clazz = class$com$jci$jciAutoImport$BJciAutoDeviceAdd = BJciAutoImport.class("[Lcom.jci.jciAutoImport.BJciAutoDeviceAdd;", false);
            }
            if ((objectArray = bComponent.getChildren(clazz)).length > 0 && n2 < objectArray.length) {
                bJciAutoDeviceAdd = (BJciAutoDeviceAdd)((Object)objectArray[n2]);
                bOrd = bJciAutoDeviceAdd.getDeviceOrd();
                this.tracemessage("getDeviceOrdForDeviceID, deviceID: " + n + ", Index: " + n2 + ", ord: " + bOrd.toString());
            } else {
                this.tracemessage("getDeviceOrdForDeviceID, NO Devices Added ");
            }
        }
        catch (Exception exception) {
            this.tracemessage("getDeviceOrdForDeviceID After Add EXCEPTION");
            exception.printStackTrace();
        }
        return bOrd;
    }

    public BJciAutoDeviceAdd getDeviceForDeviceID(int n) {
        BJciAutoDeviceAdd bJciAutoDeviceAdd = null;
        if (n == 0) {
            return bJciAutoDeviceAdd;
        }
        int n2 = n - 3;
        try {
            Object[] objectArray;
            BOrd bOrd = BOrd.make((String)"station:|slot:/fxApp/autoImport");
            BComponent bComponent = bOrd.get((BObject)this).asComponent();
            Class clazz = class$com$jci$jciAutoImport$BJciAutoDeviceAdd;
            if (clazz == null) {
                clazz = class$com$jci$jciAutoImport$BJciAutoDeviceAdd = BJciAutoImport.class("[Lcom.jci.jciAutoImport.BJciAutoDeviceAdd;", false);
            }
            if ((objectArray = bComponent.getChildren(clazz)).length > 0 && n2 < objectArray.length) {
                bJciAutoDeviceAdd = (BJciAutoDeviceAdd)((Object)objectArray[n2]);
                this.tracemessage("getDeviceForDeviceID, deviceID: " + n + ", Index: " + n2 + ", ord: " + bJciAutoDeviceAdd.getDeviceOrd().toString());
            } else {
                this.tracemessage("getDeviceForDeviceID, NO Devices Added ");
            }
        }
        catch (Exception exception) {
            this.tracemessage("getDeviceForDeviceID After Add EXCEPTION");
            exception.printStackTrace();
        }
        return bJciAutoDeviceAdd;
    }

    public BFacets makeBooleanFacets(String string) {
        BFacets bFacets = null;
        String[] stringArray = TextUtil.split((String)string, (char)':');
        String string2 = "false";
        String string3 = "true";
        if (stringArray.length >= 2) {
            string3 = SlotPath.escape((String)stringArray[0]);
            string2 = SlotPath.escape((String)stringArray[1]);
        }
        bFacets = BFacets.makeBoolean((String)string3, (String)string2);
        return bFacets;
    }

    public BFacets makeEnumFacets(String string) {
        BFacets bFacets = null;
        String[] stringArray = TextUtil.split((String)string, (char)':');
        int n = stringArray.length;
        int[] nArray = new int[n];
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < stringArray.length) {
            nArray[n2] = n2;
            stringArray2[n2] = SlotPath.escape((String)stringArray[n2]);
            ++n2;
        }
        BEnumRange bEnumRange = BEnumRange.make((int[])nArray, (String[])stringArray2);
        bFacets = BFacets.makeEnum((BEnumRange)bEnumRange);
        return bFacets;
    }

    public BFacets makeNumericFacets(String string) {
        BUnit bUnit = null;
        BFacets bFacets = BFacets.NULL;
        try {
            UnitDatabase.getDefault();
            if (string.equalsIgnoreCase("DegF")) {
                bUnit = UnitDatabase.getUnit((String)"fahrenheit");
                bFacets = BFacets.makeNumeric((BUnit)bUnit, (BInteger)BInteger.make((int)0), (BNumber)BDouble.make((double)0.0), (BNumber)BDouble.make((double)100.0));
            }
            if (string.equalsIgnoreCase("DegC")) {
                bUnit = UnitDatabase.getUnit((String)"celsius");
                bFacets = BFacets.makeNumeric((BUnit)bUnit, (BInteger)BInteger.make((int)0), (BNumber)BDouble.make((double)0.0), (BNumber)BDouble.make((double)100.0));
            }
            if (string.equalsIgnoreCase("Pct") || string.equalsIgnoreCase("PctRH")) {
                bUnit = UnitDatabase.getUnit((String)"percent");
                bFacets = BFacets.makeNumeric((BUnit)bUnit, (BInteger)BInteger.make((int)0), (BNumber)BDouble.make((double)0.0), (BNumber)BDouble.make((double)100.0));
            }
            if (string.equalsIgnoreCase("PSI")) {
                bUnit = UnitDatabase.getUnit((String)"psi");
                bFacets = BFacets.makeNumeric((BUnit)bUnit, (int)0);
            }
            if (string.equalsIgnoreCase("BTU") || string.equalsIgnoreCase("BTU/H")) {
                bUnit = UnitDatabase.getUnit((String)"btu");
                bFacets = BFacets.makeNumeric((BUnit)bUnit, (int)0);
            }
            if (string.equalsIgnoreCase("CFM")) {
                bUnit = UnitDatabase.getUnit((String)"second");
                bFacets = BFacets.makeNumeric((BUnit)bUnit, (int)0);
            }
            if (string.equalsIgnoreCase("PPM")) {
                bUnit = UnitDatabase.getUnit((String)"ppm");
                bFacets = BFacets.makeNumeric((BUnit)bUnit, (int)0);
            }
            if (string.equalsIgnoreCase("second")) {
                bUnit = UnitDatabase.getUnit((String)"second");
                bFacets = BFacets.makeNumeric((BUnit)bUnit, (int)0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bFacets;
    }

    public BOrd makeFileOrd(String string, String string2, String string3) {
        BOrd bOrd = BOrd.NULL;
        String string4 = string;
        if (string2 != "") {
            string4 = string2;
        }
        String string5 = "local:|file:/" + string4 + '/' + string3;
        string5 = TextUtil.replace((String)string5, (String)"\\", (String)"/");
        bOrd = BOrd.make((String)string5);
        return bOrd;
    }

    public String doFieldResourceFileChanged(BResourceFileInformation bResourceFileInformation) {
        String string = "";
        String string2 = bResourceFileInformation.getResourceFile().toString();
        if (string2.toLowerCase().indexOf(".apd") > -1) {
            string = this.loadLibraryFileNamefromApd(bResourceFileInformation);
        } else if (string2.toLowerCase().indexOf(".caf") > -1) {
            string = this.loadLibraryFileNamefromCaf(bResourceFileInformation);
        } else if (string2.toLowerCase().indexOf(".csv") > -1) {
            string = this.loadLibraryFileNamefromCsv(bResourceFileInformation);
        }
        return string;
    }

    private final String loadLibraryFileNamefromApd(BResourceFileInformation bResourceFileInformation) {
        XParser xParser = null;
        String string = bResourceFileInformation.getResourceFile().toString();
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        try {
            System.out.println("loadLibraryFileNamefromApd ResourceFileFE, Baja Home = " + Sys.getBajaHome());
            BOrd bOrd = BOrd.make((String)string);
            System.out.println("loadLibraryFileNamefromApd BOrd from: " + string + ", is: " + bOrd);
            OrdTarget ordTarget = bOrd.resolve();
            System.out.println("loadLibraryFileNamefromApd Ord target is: " + ordTarget);
            BIFile bIFile = (BIFile)BOrd.make((String)string).resolve().get();
            BLocalFileStore bLocalFileStore = (BLocalFileStore)bIFile.getStore();
            String string4 = bLocalFileStore.getLocalFile().toString();
            System.out.println("loadLibraryFileNamefromApd, ifn is: " + string4);
            xParser = XParser.make((File)new File(string4));
            while (xParser.next() != -1) {
                if (xParser.elem().name().equals("UnitSystem")) {
                    xParser.next();
                    while (xParser.elem().name().equals("UnitSystem")) {
                        System.out.println("loadLibraryFileNamefromApd, UNITS, name = " + xParser.elem().name() + ", txt = " + xParser.text() + ", lvl = " + xParser.depth());
                        if (xParser.text() != null) {
                            string3 = xParser.text().toString();
                            string3.equals("SI");
                        }
                        xParser.next();
                    }
                }
                if (!xParser.elem().name().equals("Supervisor")) continue;
                xParser.next();
                while (xParser.elem().name().equals("SysLib")) {
                    System.out.println("loadLibraryFileNamefromApd, SysLib, name = " + xParser.elem().name() + "' txt = " + xParser.text() + "' lvl = " + xParser.depth());
                    if (xParser.text() != null) {
                        string2 = xParser.text().toString();
                        bl = true;
                        System.out.println("loadLibraryFileNamefromApd, libfilename = " + string2);
                    }
                    xParser.next();
                }
            }
            xParser.close();
            if (bl) {
                String string5 = Sys.getBajaHome().getPath();
                String string6 = "jciStandards\\sysLib";
                String string7 = "file:/" + string5 + '/' + string6 + '/' + string2;
                string7 = TextUtil.replace((String)string7, (String)"\\", (String)"/");
                System.out.println("loadLibraryFileNamefromApd, sysLibFilePath = " + string7);
                File file = new File(string5 + '/' + string6 + '/' + string2);
                if (file.isFile()) {
                    System.out.println("loadLibraryFileNamefromApd, lib file is " + file.getPath());
                    return string7;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
        return "";
    }

    private final String loadLibraryFileNamefromCaf(BResourceFileInformation bResourceFileInformation) {
        XParser xParser = null;
        boolean bl = false;
        String string = null;
        String string2 = "";
        String string3 = bResourceFileInformation.getResourceFile().toString();
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        try {
            Object object;
            String string4;
            System.out.println("loadLibraryFileNamefromCaf, ResourceFileFE, Baja Home = " + Sys.getBajaHome());
            BOrd bOrd = BOrd.make((String)string3);
            System.out.println("loadLibraryFileNamefromCaf, BOrd from: " + string3 + ", is " + bOrd);
            OrdTarget ordTarget = bOrd.resolve();
            System.out.println("loadLibraryFileNamefromCaf, Ord target is: " + ordTarget);
            BIFile bIFile = (BIFile)BOrd.make((String)string3).resolve().get();
            BLocalFileStore bLocalFileStore = (BLocalFileStore)bIFile.getStore();
            String string5 = bLocalFileStore.getLocalFile().toString();
            xParser = XParser.make((File)new File(string5));
            XElem xElem = xParser.parse();
            if (xElem != null) {
                String string6;
                int n3 = xElem.elems().length;
                this.allBacoids.clear();
                boolean bl3 = false;
                int n4 = 0;
                int n5 = 0;
                while (n5 < n3) {
                    string4 = xElem.elems()[n5];
                    if (string4.name().equals("object")) {
                        String string7;
                        Object object2;
                        int n6;
                        int n7;
                        string6 = string4.get("classid");
                        ++n4;
                        if (string6 != null && string6.equals(CONTROL_SEQUENCE_CLASS_ID)) {
                            bl3 = true;
                            n7 = string4.elems().length;
                            n6 = 0;
                            while (n6 < n7) {
                                object = string4.elems()[n6];
                                object2 = object.get(ID_STR);
                                if (object2 != null && ((String)object2).equals(UNIT_SET_PROPERTY)) {
                                    string7 = this.getPropertyData((XElem)object, 3, -1, true);
                                    this.getEnumPieces(string7, false).equals("1");
                                }
                                if (object2 != null && ((String)object2).equals(STANDARD_VERSION_PROPERTY)) {
                                    string7 = this.getPropertyData((XElem)object, 0, -1, true);
                                }
                                if (object2 != null && ((String)object2).equals(SYSTEM_CONFIGURATION_PROPERTY)) {
                                    string7 = this.getPropertyData((XElem)object, 1, -1, true);
                                    n2 = Integer.parseInt(string7.trim());
                                }
                                if (object2 != null && ((String)object2).equals(SYSTEM_TYPE_PROPERTY)) {
                                    string7 = this.getPropertyData((XElem)object, 1, -1, true);
                                    n = Integer.parseInt(string7.trim());
                                }
                                if (object2 != null && ((String)object2).equals(APPLICATION_MAPPED_PROPERTY)) {
                                    string7 = this.getPropertyData((XElem)object, 2, -1, true);
                                }
                                ++n6;
                            }
                        } else {
                            n7 = string4.elems().length;
                            n6 = 0;
                            while (n6 < n7) {
                                object2 = string4.elems()[n6];
                                string7 = object2.get(ID_STR);
                                if (string7 != null && string7.equals(OBJECTINSTANCENUM)) {
                                    String string8 = this.getPropertyData((XElem)object2, 5, -1, true);
                                    int n8 = Integer.parseInt(this.getBacoidPieces(string8, true));
                                    String string9 = this.getBacoidPieces(string8, false);
                                    this.allBacoids.put(string9, string9);
                                }
                                ++n6;
                            }
                        }
                    }
                    ++n5;
                }
                String string10 = BJciPctSystemTypes.make((int)n).getTag();
                string = "PCT-" + string10 + ".xml";
                if (n2 != 0) {
                    string6 = null;
                    switch (n) {
                        case 2005: {
                            string6 = BJciPctAhuConfigTypes.make((int)n2).getTag();
                            break;
                        }
                        case 2050: {
                            string6 = BJciPctCentralCoolingConfigTypes.make((int)n2).getTag();
                            break;
                        }
                        case 2095: {
                            string6 = BJciPctVavConfigTypes.make((int)n2).getTag();
                            break;
                        }
                        default: {
                            string6 = "";
                        }
                    }
                    string = "PCT-" + string10 + '-' + string6 + ".xml";
                } else if (n == 2050) {
                    string6 = BJciPctCentralCoolingConfigTypes.make((int)1).getTag();
                    string = "PCT-" + string10 + '-' + string6 + ".xml";
                }
                if (string10 != null) {
                    bl = true;
                    System.out.println("loadLibraryFileNamefromCaf, libfilename: " + string);
                }
            }
            xParser.close();
            if (bl) {
                String string11 = Sys.getBajaHome().getPath();
                string4 = "jciStandards\\sysLib";
                string2 = "file:/" + string11 + '/' + string4 + '/' + string;
                string2 = TextUtil.replace((String)string2, (String)"\\", (String)"/");
                System.out.println("loadLibraryFileNamefromCaf, sysLibFilePath: " + string2);
                object = new File(string11 + '/' + string4 + '/' + string);
                if (((File)object).isFile()) {
                    this.setGraphicFilesFromLibrary(bResourceFileInformation, ((File)object).getPath());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string2;
        }
        return string2;
    }

    public String loadLibraryFileNamefromCsv(BResourceFileInformation bResourceFileInformation) {
        boolean bl = false;
        String string = null;
        String string2 = "";
        String string3 = bResourceFileInformation.getResourceFile().toString();
        this.allDevTypes.clear();
        this.allDevTypes.put(new Integer(0), new Integer(0));
        try {
            Object object;
            BOrd bOrd = BOrd.make((String)string3);
            OrdTarget ordTarget = bOrd.resolve();
            BIFile bIFile = (BIFile)BOrd.make((String)string3).resolve().get();
            BLocalFileStore bLocalFileStore = (BLocalFileStore)bIFile.getStore();
            String string4 = bLocalFileStore.getLocalFile().toString();
            File file = new File(string4);
            int n = (int)file.length();
            int n2 = 0;
            FileReader fileReader = new FileReader(file);
            char[] cArray = new char[n];
            while (fileReader.ready()) {
                n2 += fileReader.read(cArray, n2, n - n2);
            }
            fileReader.close();
            StringReader stringReader = new StringReader(new String(cArray));
            LineNumberReader lineNumberReader = new LineNumberReader(stringReader);
            lineNumberReader.mark(cArray.length);
            lineNumberReader.readLine();
            String string5 = lineNumberReader.readLine();
            while (string5 != null) {
                object = BJciAutoImport.tocanizeString(string5, COMMA_STR, false);
                this.allDevTypes.put(new Integer(Integer.parseInt(object[1])), new Integer(Integer.parseInt(object[1])));
                string5 = lineNumberReader.readLine();
            }
            string = "StatGateway.xml";
            bl = true;
            if (bl) {
                object = Sys.getBajaHome().getPath();
                String string6 = "jciStandards\\sysLib";
                string2 = "file:/" + (String)object + '/' + string6 + '/' + string;
                string2 = TextUtil.replace((String)string2, (String)"\\", (String)"/");
                BOrd bOrd2 = BOrd.make((String)string2);
                File file2 = new File((String)object + '/' + string6 + '/' + string);
                if (file2.isFile()) {
                    this.setGraphicFilesFromLibrary(bResourceFileInformation, file2.getPath());
                    this.loadSlots();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string2;
        }
        return string2;
    }

    public static String[] tocanizeString(String string, String string2, boolean bl) {
        StringTokenizer stringTokenizer = string2 == null ? new StringTokenizer(string) : new StringTokenizer(string, string2, bl);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public String getPropertyData(XElem xElem, int n, int n2, boolean bl) {
        XElem xElem2;
        String string = "";
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        boolean bl5 = false;
        if (xElem != null && (xElem2 = bl ? xElem.elem(DATA_STR) : xElem) != null) {
            switch (n) {
                case 0: {
                    xElem2 = xElem2.elem(STRING_STR);
                    break;
                }
                case 1: {
                    xElem2 = xElem2.elem(UNSIGNEDSHORT_STR);
                    break;
                }
                case 2: {
                    xElem2 = xElem2.elem(BOOLEAN_STR);
                    break;
                }
                case 3: {
                    bl2 = true;
                    bl4 = false;
                    xElem2 = xElem2.elem(ENUM_STR);
                    break;
                }
                case 5: {
                    bl3 = true;
                    bl4 = false;
                    xElem2 = xElem2.elem(BACOID_STR);
                    break;
                }
                case 6: {
                    bl4 = false;
                    bl5 = true;
                    xElem2 = xElem2.elem(LISTOF_STR);
                    break;
                }
                case 8: {
                    bl4 = false;
                    bl5 = true;
                    xElem2 = xElem2.elem(ARRAY_STR);
                    break;
                }
                case 7: {
                    xElem2 = xElem2.elem(UNSIGNEDBYTE_STR);
                    break;
                }
            }
            if (xElem2 != null) {
                if (bl4) {
                    string = xElem2.text() != null ? xElem2.text().string() : "";
                } else if (bl2) {
                    string = xElem2.text() != null ? xElem2.get(SET_STR) + ':' + xElem2.text().string() : xElem2.get(SET_STR) + ":0";
                } else if (bl3) {
                    string = xElem2.text() != null ? xElem2.get(ID_STR) + ':' + xElem2.text().string() : xElem2.get(ID_STR) + ":0";
                } else if (bl5) {
                    string = this.parseListOf(xElem2, n2);
                }
            }
        }
        return string;
    }

    public String parseListOf(XElem xElem, int n) {
        String string = "";
        String string2 = COLON_STR;
        if (n == 5 || n == 3) {
            string2 = COMMA_STR;
        }
        XElem[] xElemArray = xElem.elems();
        int n2 = 0;
        while (n2 < xElemArray.length) {
            if (n == 0) {
                if (xElemArray[n2] != null && xElemArray[n2].text() != null) {
                    string = string + xElemArray[n2].text().string();
                }
            } else if (n == 5) {
                XElem xElem2 = xElemArray[n2];
                if (xElem2 != null && xElem2.text() != null) {
                    string = string + xElem2.get(ID_STR) + ':' + xElem2.text().string();
                }
            } else {
                string = string + this.getPropertyData(xElemArray[n2], n, -1, false);
            }
            if (n2 + 1 < xElemArray.length) {
                string = string + string2;
            }
            ++n2;
        }
        return string;
    }

    public String getBacoidPieces(String string, boolean bl) {
        int n;
        String string2 = "";
        if (string != null && (n = string.indexOf(COLON_STR)) > 0) {
            string2 = bl ? string.substring(0, n) : string.substring(n + 1);
        }
        return string2;
    }

    public String getEnumPieces(String string, boolean bl) {
        String string2 = "";
        int n = string.indexOf(COLON_STR);
        if (n > 0) {
            string2 = bl ? string.substring(0, n - 1) : string.substring(n + 1);
        }
        return string2;
    }

    protected void setGraphicFilesFromLibrary(BResourceFileInformation bResourceFileInformation, String string) {
        this.librarygraphicfiles.clear();
        XElem xElem = this.openSysLibFile(string);
        if (xElem != null) {
            XElem[] xElemArray = xElem.elems();
            int n = 0;
            while (n < xElemArray.length) {
                if (xElemArray[n].name().equals("Graphics")) {
                    XElem xElem2 = xElemArray[n];
                    XElem[] xElemArray2 = xElem2.elems();
                    int n2 = 0;
                    while (n2 < xElemArray2.length) {
                        String string2 = xElemArray2[n2].get("Type");
                        System.out.println("graphictype is " + string2);
                        if (string2.trim().length() > 0 || string2.equalsIgnoreCase("ipad")) {
                            String string3 = this.getGraphicFileNameForType(xElemArray2[n2], string2);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            this.xparSysLibFile.close();
            String string4 = (String)this.librarygraphicfiles.get("WB");
            if (string4 == null || string4.length() <= 0) {
                bResourceFileInformation.setWBGraphicFileName("OtherGraphic.px");
            } else {
                bResourceFileInformation.setWBGraphicFileName(string4);
            }
            string4 = (String)this.librarygraphicfiles.get("WBAsso2");
            if (string4 == null || string4.length() <= 0) {
                bResourceFileInformation.setWBAssociatedGraphicFileName2("");
            } else {
                bResourceFileInformation.setWBAssociatedGraphicFileName2(string4);
            }
            string4 = (String)this.librarygraphicfiles.get("WBAsso3");
            if (string4 == null || string4.length() <= 0) {
                bResourceFileInformation.setWBAssociatedGraphicFileName3("");
            } else {
                bResourceFileInformation.setWBAssociatedGraphicFileName3(string4);
            }
            string4 = (String)this.librarygraphicfiles.get("WBSubDevice");
            if (string4 == null || string4.length() <= 0) {
                bResourceFileInformation.setWBSubDeviceGraphicFileName("");
            } else {
                bResourceFileInformation.setWBSubDeviceGraphicFileName(string4);
            }
            string4 = (String)this.librarygraphicfiles.get("iPhone");
            if (string4 == null || string4.length() <= 0) {
                bResourceFileInformation.setHXGraphicFileName("OtherHx.px");
            } else {
                bResourceFileInformation.setHXGraphicFileName(string4);
            }
            string4 = (String)this.librarygraphicfiles.get("iPhoneAsso2");
            if (string4 == null || string4.length() <= 0) {
                bResourceFileInformation.setHXAssociatedGraphicFileName2("");
            } else {
                bResourceFileInformation.setHXAssociatedGraphicFileName2(string4);
            }
            string4 = (String)this.librarygraphicfiles.get("iPhoneAsso3");
            if (string4 == null || string4.length() <= 0) {
                bResourceFileInformation.setHXAssociatedGraphicFileName3("");
            } else {
                bResourceFileInformation.setHXAssociatedGraphicFileName3(string4);
            }
            string4 = (String)this.librarygraphicfiles.get("iPhoneSubDevice");
            if (string4 == null || string4.length() <= 0) {
                bResourceFileInformation.setHXSubDeviceGraphicFileName("");
            } else {
                bResourceFileInformation.setHXSubDeviceGraphicFileName(string4);
            }
            bResourceFileInformation.loadSlots();
        }
    }

    private final String getGraphicFileNameForType(XElem xElem, String string) {
        String string2 = null;
        XElem[] xElemArray = xElem.elems();
        int n = 0;
        while (n < xElemArray.length) {
            boolean bl = false;
            int n2 = xElemArray[n].attrSize();
            int n3 = 0;
            while (n3 < n2) {
                if (xElemArray[n].attrName(n3).indexOf("Condition") >= 0) {
                    String string3 = xElemArray[n].attrValue(n3);
                    if (string3 != null && string3.length() > 0) {
                        bl = this.testCondition(string3);
                        if (!bl) {
                            break;
                        }
                    } else {
                        bl = true;
                    }
                }
                ++n3;
            }
            if (bl) {
                if (xElemArray[n] != null && xElemArray[n].text() != null) {
                    string2 = xElemArray[n].text().toString();
                    this.librarygraphicfiles.put(string, string2 + ".px");
                    this.checkForAssociatedFiles(string, xElemArray[n]);
                    this.checkForSubDeviceFile(string, xElemArray[n]);
                    break;
                }
                string2 = "";
                break;
            }
            ++n;
        }
        return string2;
    }

    private final void checkForAssociatedFiles(String string, XElem xElem) {
        try {
            String string2 = this.getAttribute(xElem, "AssoGraphic1FileName", null);
            String string3 = this.getAttribute(xElem, "AssoGraphic2FileName", null);
            boolean bl = false;
            if (string2 != null && string2.length() > 0) {
                bl = true;
            }
            boolean bl2 = bl;
            boolean bl3 = false;
            if (string3 != null && string3.length() > 0) {
                bl3 = true;
            }
            boolean bl4 = bl3;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl2 && !bl4) {
                return;
            }
            if (bl2 && (bl5 = this.checkBothConditions(xElem, 1))) {
                this.librarygraphicfiles.put(string + "Asso2", string2 + ".px");
            }
            if (bl4 && (bl6 = this.checkBothConditions(xElem, 2))) {
                this.librarygraphicfiles.put(string + "Asso3", string3 + ".px");
            }
        }
        catch (Exception exception) {}
    }

    private final boolean checkBothConditions(XElem xElem, int n) {
        boolean bl = false;
        try {
            String string = xElem.get("AssoGraphic" + n + "Cond1");
            String string2 = xElem.get("AssoGraphic" + n + "Cond2");
            if (!(string != null && string.length() > 0 || string2 != null && string2.length() > 0)) {
                return bl;
            }
            if (string != null && string.length() > 0 && (bl = this.testCondition(string)) && string2 != null && string2.length() > 0) {
                bl = this.testCondition(string2);
            }
        }
        catch (Exception exception) {}
        return bl;
    }

    private final void checkForSubDeviceFile(String string, XElem xElem) {
        try {
            String string2 = this.getAttribute(xElem, "SubDeviceGraphic", null);
            boolean bl = false;
            if (string2 != null && string2.length() > 0) {
                bl = true;
            }
            boolean bl2 = bl;
            boolean bl3 = false;
            if (!bl2) {
                return;
            }
            if (bl2 && (bl3 = this.checkBothConditions(xElem))) {
                this.librarygraphicfiles.put(string + "SubDevice", string2 + ".px");
            }
        }
        catch (Exception exception) {}
    }

    private final boolean checkBothConditions(XElem xElem) {
        boolean bl = false;
        try {
            String string = xElem.get("SubDeviceCond1");
            String string2 = xElem.get("SubDeviceCond2");
            if (!(string != null && string.length() > 0 || string2 != null && string2.length() > 0)) {
                return bl;
            }
            if (string != null && string.length() > 0 && (bl = this.testCondition(string, true)) && string2 != null && string2.length() > 0) {
                bl = this.testCondition(string2, true);
            }
        }
        catch (Exception exception) {}
        return bl;
    }

    protected boolean matchCondition(String string) {
        boolean bl = false;
        boolean bl2 = false;
        String string2 = string.trim();
        if (string2.indexOf(NOT_SIGN_STR) == 0) {
            string2 = string2.substring(string2.indexOf(NOT_SIGN_STR) + 1);
            bl2 = true;
            string = string2;
        }
        if (string != null && string.length() > 0) {
            String string3 = (String)this.allBacoids.get(string);
            if (string3 == null && !bl2) {
                bl = false;
            } else if (string3 == null && bl2) {
                bl = true;
            } else if (string3 != null && !bl2) {
                bl = true;
            } else if (string3 != null && bl2) {
                bl = false;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    protected boolean matchCondition(String string, boolean bl) {
        Integer n;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = string.trim();
        if (string2.indexOf(NOT_SIGN_STR) == 0) {
            string2 = string2.substring(string2.indexOf(NOT_SIGN_STR) + 1);
            bl3 = true;
            string = string2;
        }
        if ((n = string != null && string.length() > 0 ? new Integer(string) : null) != null) {
            Integer n2 = (Integer)this.allDevTypes.get(n);
            if (n2 == null && !bl3) {
                bl2 = false;
            } else if (n2 == null && bl3) {
                bl2 = true;
            } else if (n2 != null && !bl3) {
                bl2 = true;
            } else if (n2 != null && bl3) {
                bl2 = false;
            }
        } else {
            bl2 = true;
        }
        return bl2;
    }

    protected boolean testCondition(String string) {
        boolean bl = false;
        String string2 = string.trim();
        String string3 = COMMA_STR;
        int n = string2.indexOf(string3);
        int n2 = 0;
        while (n > 0 && !bl) {
            bl = this.matchCondition(string2.substring(n2, n));
            string2 = string2.substring(n + 1).trim();
            n = string2.indexOf(string3);
        }
        if (!bl) {
            bl = this.matchCondition(string2);
        }
        return bl;
    }

    protected boolean testCondition(String string, boolean bl) {
        boolean bl2 = false;
        String string2 = string.trim();
        String string3 = COMMA_STR;
        int n = string2.indexOf(string3);
        int n2 = 0;
        while (n > 0 && !bl2) {
            bl2 = bl ? this.matchCondition(string2.substring(n2, n), bl) : this.matchCondition(string2.substring(n2, n));
            string2 = string2.substring(n + 1).trim();
            n = string2.indexOf(string3);
        }
        if (!bl2) {
            bl2 = bl ? this.matchCondition(string2, bl) : this.matchCondition(string2);
        }
        return bl2;
    }

    public XElem openSysLibFile(String string) {
        XElem xElem = null;
        if (string.length() != 0) {
            try {
                File file = new File(string);
                if (file.exists()) {
                    this.xparSysLibFile = XParser.make((File)file);
                    xElem = this.xparSysLibFile.parse();
                } else {
                    int n = string.indexOf("file:/");
                    String string2 = n == 0 ? string.substring(n + 6) : string;
                    file = new File(string2);
                    if (file.exists()) {
                        this.xparSysLibFile = XParser.make((File)file);
                        xElem = this.xparSysLibFile.parse();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return xElem;
    }

    private final String getAttribute(XElem xElem, String string, String string2) {
        String string3 = xElem.get(string, string2);
        if (string3 == null) {
            string3 = "";
        }
        String string4 = xElem.get(string, string2).trim();
        return string4;
    }

    public BDeviceNetwork getDeviceNetworkByName(String string) {
        try {
            this.tracemessage("getDeviceNetworkByName Getting Drivers");
            BDeviceNetwork bDeviceNetwork = null;
            Class clazz = class$com$jci$jciAutoImport$BJciAutoNetworkAdd;
            if (clazz == null) {
                clazz = class$com$jci$jciAutoImport$BJciAutoNetworkAdd = BJciAutoImport.class("[Lcom.jci.jciAutoImport.BJciAutoNetworkAdd;", false);
            }
            Object[] objectArray = this.getChildren(clazz);
            int n = 0;
            while (n < objectArray.length) {
                BJciAutoNetworkAdd bJciAutoNetworkAdd = (BJciAutoNetworkAdd)((Object)objectArray[n]);
                if (bJciAutoNetworkAdd.getNetworkName().equalsIgnoreCase(string)) {
                    BOrd bOrd = bJciAutoNetworkAdd.getNetworkOrd();
                    if (bOrd == null) break;
                    bDeviceNetwork = (BDeviceNetwork)bOrd.resolve((BObject)this).get();
                    this.tracemessage("getDeviceNetworkByName Got Driver: " + bDeviceNetwork.getName());
                    break;
                }
                ++n;
            }
            return bDeviceNetwork;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public BJciN2Network addN2Network(BJciAutoNetworkAdd bJciAutoNetworkAdd) {
        try {
            BDeviceNetwork bDeviceNetwork;
            BDriverContainer bDriverContainer = (BDriverContainer)Sys.getService((Type)BDriverContainer.TYPE);
            BJciN2Network bJciN2Network = new BJciN2Network();
            bJciN2Network.setEnabled(false);
            BSerialHelper bSerialHelper = new BSerialHelper();
            bSerialHelper.setBaudRate((BBaudRate)BSerialBaudRate.baud9600);
            bSerialHelper.setPortName(bJciAutoNetworkAdd.getNetworkPort());
            bJciN2Network.setSerialPortConfig(bSerialHelper);
            bJciN2Network.setRetryCount(2);
            try {
                bDriverContainer.add(bJciAutoNetworkAdd.getNetworkName(), (BValue)bJciN2Network);
                bDeviceNetwork = (BDeviceNetwork)bDriverContainer.get(bJciAutoNetworkAdd.getNetworkName());
                bJciAutoNetworkAdd.setNetworkOrd(bDeviceNetwork.getSlotPathOrd());
            }
            catch (Exception exception) {
                this.tracemessage("addN2Network, After Add, Driver EXCEPTION");
                exception.printStackTrace();
            }
            bDeviceNetwork = bDriverContainer.getChildComponents();
            int n = 0;
            while (n < ((BDeviceNetwork)bDeviceNetwork).length) {
                String string = bDeviceNetwork[n].getName();
                this.tracemessage("addN2Network After Add, Driver = " + string);
                if (string.equalsIgnoreCase(bJciAutoNetworkAdd.getNetworkName())) {
                    return (BJciN2Network)bDeviceNetwork[n];
                }
                ++n;
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            this.tracemessage("addN2Network, ServiceNotFoundException EXCEPTION");
            serviceNotFoundException.printStackTrace();
        }
        return null;
    }

    public BBacnetNetwork addBacnetNetwork(BJciAutoNetworkAdd bJciAutoNetworkAdd, String string) {
        try {
            this.tracemessage("addBacnetNetwork Getting Drivers");
            BBacnetNetwork bBacnetNetwork = null;
            boolean bl = false;
            BDriverContainer bDriverContainer = (BDriverContainer)Sys.getService((Type)BDriverContainer.TYPE);
            int n = 1001;
            int n2 = bJciAutoNetworkAdd.getLocalDeviceId();
            BLocalBacnetDevice bLocalBacnetDevice = null;
            BComponent[] bComponentArray = bDriverContainer.getChildComponents();
            int n3 = 0;
            while (n3 < bComponentArray.length) {
                this.tracemessage("addBacnetNetwork Driver = " + bComponentArray[n3].getName());
                if (bComponentArray[n3] instanceof BBacnetNetwork) {
                    bLocalBacnetDevice = ((BBacnetNetwork)bComponentArray[n3]).getLocalDevice();
                    n = bLocalBacnetDevice.getObjectId().getId();
                    n2 = bLocalBacnetDevice.getObjectId().getInstanceNumber();
                    this.tracemessage("addBacnetNetwork Found Bacnet Driver, ID = " + n + ", Inst = " + n2);
                    bBacnetNetwork = (BBacnetNetwork)bComponentArray[n3];
                    bJciAutoNetworkAdd.setNetworkOrd(bBacnetNetwork.getSlotPathOrd());
                    break;
                }
                ++n3;
            }
            if (bBacnetNetwork == null) {
                try {
                    bl = true;
                    bBacnetNetwork = new BBacnetNetwork();
                    bBacnetNetwork.setEnabled(false);
                    bDriverContainer.add("BacnetNetwork", (BValue)bBacnetNetwork);
                }
                catch (Exception exception) {
                    this.tracemessage("addBacnetNetwork After Add, Bacnet Driver EXCEPTION");
                    exception.printStackTrace();
                }
            }
            bComponentArray = bDriverContainer.getChildComponents();
            int n4 = 0;
            while (n4 < bComponentArray.length) {
                this.tracemessage("addBacnetNetwork After Add, Bacnet Driver = " + bComponentArray[n4].getName());
                if (bComponentArray[n4] instanceof BBacnetNetwork) {
                    BBacnetNetworkLayer bBacnetNetworkLayer;
                    BBacnetStack bBacnetStack;
                    BBacnetNetwork bBacnetNetwork2 = (BBacnetNetwork)bComponentArray[n4];
                    bJciAutoNetworkAdd.setNetworkOrd(bBacnetNetwork2.getSlotPathOrd());
                    if (bl) {
                        bLocalBacnetDevice = bBacnetNetwork2.getLocalDevice();
                        n = bLocalBacnetDevice.getObjectId().getId();
                        n2 = bLocalBacnetDevice.getObjectId().getInstanceNumber();
                        this.tracemessage("NEW Bacnet Driver, ID = " + n + ", Inst = " + n2);
                        if (n2 == -1) {
                            n2 = bJciAutoNetworkAdd.getLocalDeviceId();
                        }
                        bBacnetStack = BBacnetObjectIdentifier.make((int)8, (int)1234);
                        this.tracemessage("NEW ObjectId, ID = " + bBacnetStack.getId() + ", Inst = " + bBacnetStack.getInstanceNumber() + ", Type = " + bBacnetStack.getObjectType());
                        bBacnetNetwork2.getLocalDevice().setObjectId((BBacnetObjectIdentifier)bBacnetStack);
                    }
                    if (string.indexOf("MSTP") >= 0) {
                        bBacnetStack = (BBacnetStack)bBacnetNetwork2.getBacnetComm();
                        bBacnetNetworkLayer = bBacnetStack.getNetwork();
                        bBacnetNetworkLayer.getIpPort().setNetworkNumber(this.ipNetworkNbr);
                        BNetworkPort bNetworkPort = null;
                        String string2 = bJciAutoNetworkAdd.getNetworkBaud();
                        BBacnetMstpBaudRate bBacnetMstpBaudRate = BBacnetMstpBaudRate.baud_38400;
                        if (string2.equalsIgnoreCase("9600")) {
                            bBacnetMstpBaudRate = BBacnetMstpBaudRate.baud_9600;
                        }
                        if (string2.equalsIgnoreCase("19200")) {
                            bBacnetMstpBaudRate = BBacnetMstpBaudRate.baud_19200;
                        }
                        if (string2.equalsIgnoreCase("38400")) {
                            bBacnetMstpBaudRate = BBacnetMstpBaudRate.baud_38400;
                        }
                        if (string2.equalsIgnoreCase("76800")) {
                            bBacnetMstpBaudRate = BBacnetMstpBaudRate.baud_76800;
                        }
                        if (bNetworkPort == null) {
                            this.tracemessage("Bacnet Network MSTP Port NOT FOUND");
                            bNetworkPort = new BNetworkPort();
                            BBacnetMstpLinkLayer bBacnetMstpLinkLayer = new BBacnetMstpLinkLayer();
                            bBacnetMstpLinkLayer.setBaudRate(bBacnetMstpBaudRate);
                            bBacnetMstpLinkLayer.setPortName(bJciAutoNetworkAdd.getNetworkPort());
                            bNetworkPort.setLink((BBacnetLinkLayer)bBacnetMstpLinkLayer);
                            int n5 = bJciAutoNetworkAdd.getNetworkNumber();
                            if (n5 == 0) {
                                n5 = 1;
                            }
                            bNetworkPort.setNetworkNumber(n5);
                            bBacnetNetworkLayer.add(bJciAutoNetworkAdd.getNetworkName(), (BValue)bNetworkPort);
                        }
                    }
                    if (string.indexOf("BACNET IP") >= 0) {
                        bBacnetStack = (BBacnetStack)bBacnetNetwork2.getBacnetComm();
                        bBacnetNetworkLayer = bBacnetStack.getNetwork();
                        if (bJciAutoNetworkAdd.getNetworkNumber() > 1) {
                            this.ipNetworkNbr = bJciAutoNetworkAdd.getNetworkNumber();
                        }
                        bBacnetNetworkLayer.getIpPort().setNetworkNumber(this.ipNetworkNbr);
                    }
                    return bBacnetNetwork2;
                }
                ++n4;
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            this.tracemessage("addBacnetNetwork ServiceNotFoundException EXCEPTION");
            serviceNotFoundException.printStackTrace();
        }
        return null;
    }

    public BModbusAsyncNetwork addModbusAsyncNetwork(BJciAutoNetworkAdd bJciAutoNetworkAdd) {
        try {
            BComponent[] bComponentArray;
            this.tracemessage("addModbusAsyncNetwork Getting Drivers");
            BDriverContainer bDriverContainer = (BDriverContainer)Sys.getService((Type)BDriverContainer.TYPE);
            String string = bJciAutoNetworkAdd.getNetworkName();
            BModbusAsyncNetwork bModbusAsyncNetwork = new BModbusAsyncNetwork();
            bModbusAsyncNetwork.setEnabled(false);
            BSerialHelper bSerialHelper = new BSerialHelper();
            String string2 = bJciAutoNetworkAdd.getNetworkBaud();
            BSerialBaudRate bSerialBaudRate = BSerialBaudRate.baud9600;
            if (string2.equalsIgnoreCase("9600")) {
                bSerialBaudRate = BSerialBaudRate.baud9600;
            }
            if (string2.equalsIgnoreCase("19200")) {
                bSerialBaudRate = BSerialBaudRate.baud19200;
            }
            if (string2.equalsIgnoreCase("38400")) {
                bSerialBaudRate = BSerialBaudRate.baud38400;
            }
            if (string2.equalsIgnoreCase("76800")) {
                bSerialBaudRate = BSerialBaudRate.baud76800;
            }
            bSerialHelper.setBaudRate((BBaudRate)bSerialBaudRate);
            bSerialHelper.setPortName(bJciAutoNetworkAdd.getNetworkPort());
            bModbusAsyncNetwork.setSerialPortConfig(bSerialHelper);
            bDriverContainer.add(string, (BValue)bModbusAsyncNetwork);
            try {
                bComponentArray = (BComponent[])bDriverContainer.get(bJciAutoNetworkAdd.getNetworkName());
                bJciAutoNetworkAdd.setNetworkOrd(bComponentArray.getSlotPathOrd());
            }
            catch (Exception exception) {
                this.tracemessage("addModbusAsyncNetwork, After Add, Driver EXCEPTION");
                exception.printStackTrace();
            }
            bComponentArray = bDriverContainer.getChildComponents();
            int n = 0;
            while (n < bComponentArray.length) {
                String string3 = bComponentArray[n].getName();
                this.tracemessage("addModbusAsyncNetwork After Add, Driver = " + string3);
                if (string3.equalsIgnoreCase(bJciAutoNetworkAdd.getNetworkName())) {
                    return (BModbusAsyncNetwork)bComponentArray[n];
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.tracemessage("addModbusAsyncNetwork ServiceNotFoundException EXCEPTION");
            exception.printStackTrace();
        }
        return null;
    }

    public BModbusTcpNetwork addModbusTCPNetwork(BJciAutoNetworkAdd bJciAutoNetworkAdd) {
        try {
            BComponent[] bComponentArray;
            this.tracemessage("addModbusTCPNetwork Getting Drivers");
            BDriverContainer bDriverContainer = (BDriverContainer)Sys.getService((Type)BDriverContainer.TYPE);
            String string = bJciAutoNetworkAdd.getNetworkName();
            BModbusTcpNetwork bModbusTcpNetwork = new BModbusTcpNetwork();
            bModbusTcpNetwork.setEnabled(false);
            bDriverContainer.add(string, (BValue)bModbusTcpNetwork);
            try {
                bComponentArray = (BComponent[])bDriverContainer.get(bJciAutoNetworkAdd.getNetworkName());
                bJciAutoNetworkAdd.setNetworkOrd(bComponentArray.getSlotPathOrd());
            }
            catch (Exception exception) {
                this.tracemessage("addModbusTCPNetwork, After Add, Driver EXCEPTION");
                exception.printStackTrace();
            }
            bComponentArray = bDriverContainer.getChildComponents();
            int n = 0;
            while (n < bComponentArray.length) {
                String string2 = bComponentArray[n].getName();
                this.tracemessage("addModbusTCPNetwork After Add, Driver = " + string2);
                if (string2.equalsIgnoreCase(bJciAutoNetworkAdd.getNetworkName())) {
                    return (BModbusTcpNetwork)bComponentArray[n];
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.tracemessage("addModbusTCPNetwork ServiceNotFoundException EXCEPTION");
            exception.printStackTrace();
        }
        return null;
    }

    public void doRunAutoImport() {
        this.tracemessage("jciAutoImport: doRunAutoImport");
        if (!this.getEnabled()) {
            this.tracemessage("jciAutoImport Error Execute - DISABLED");
            return;
        }
        this.tracemessage("doRunAutoImport Execute");
        this.tracemessage("doRunAutoImport Import NETWORKS");
        this.doNetworkImport();
        this.doDeviceImport();
        this.addSchedules();
        this.addGroups();
        this.addSpaces();
        this.addEquipment();
        this.setEnabled(false);
        this.setStatus(BStatus.ok);
        this.setTrace(false);
        Sys.getStation().save();
        this.tracemessage("doRunAutoImport Saving Station");
    }

    public void doRunReadImportFile() {
        this.tracemessage("jciAutoImport: doRunReadImportFile");
        this.loadImportFile("", this);
    }

    public void doClearImportInfo() {
        this.tracemessage("jciAutoImport: doClearImportInfo");
        this.removeAll();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.ipNetworkNbr = 1001;
        this.haveMeterDevices = false;
        this.haveMeterMasters = false;
        this.spaceRootName = "";
        this.equipmentRootName = "";
    }

    public BJciAutoImport() {
        this.this();
        this.allBacoids = new HashMap();
        this.librarygraphicfiles = new HashMap();
        this.allDevTypes = new HashMap();
    }

    static {
        Class clazz = class$com$jci$jciAutoImport$BJciAutoImport;
        if (clazz == null) {
            clazz = class$com$jci$jciAutoImport$BJciAutoImport = BJciAutoImport.class("[Lcom.jci.jciAutoImport.BJciAutoImport;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$jci$jciAutoImport$BJciAutoImport;
        if (clazz2 == null) {
            clazz2 = class$com$jci$jciAutoImport$BJciAutoImport = BJciAutoImport.class("[Lcom.jci.jciAutoImport.BJciAutoImport;", false);
        }
        lex = Lexicon.make((Class)clazz2);
    }
}

