/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platMstp;

import com.tridium.platMstp.BBacnetMstpPlatformService;
import com.tridium.platMstp.MstpFrame;
import com.tridium.platMstp.MstpListener;
import java.io.File;
import javax.baja.nre.util.IntHashMap;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetMstpPlatformServiceNpsdk
extends BBacnetMstpPlatformService {
    public static final Type TYPE;
    private static boolean nativesLoaded;
    private IntHashMap trunkListeners;
    int numTrunks;
    static /* synthetic */ Class class$com$tridium$platMstp$BBacnetMstpPlatformServiceNpsdk;

    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        File file = new File(Sys.getBajaHome() + File.separator + "bin" + File.separator + "libmstp-npsdk.so");
        if (file.exists()) {
            log.trace("BacnetMstpPlatformNpsdk platform is valid");
            return true;
        }
        return false;
    }

    protected synchronized boolean loadLibraries() {
        if (nativesLoaded) {
            return true;
        }
        try {
            System.loadLibrary("mstp-npsdk");
            nativesLoaded = true;
            log.trace("mstp-npsdk loaded");
        }
        catch (Throwable throwable) {
            log.error("Unable load mstp-npsdk native", throwable);
        }
        return nativesLoaded;
    }

    public void serviceStarted() throws Exception {
        if (!this.initMstpd()) {
            throw new RuntimeException("cannot run mstp daemon processes");
        }
        log.trace("mstp initialization complete");
        super.serviceStarted();
    }

    public void serviceStopped() throws Exception {
        this.cleanup0();
        log.trace("cleanupMstp done");
        super.serviceStopped();
    }

    public boolean initMstpd() {
        if (!this.loadLibraries()) {
            return false;
        }
        return this.init0();
    }

    public int startDriver(String string, String string2, int n, int n2, int n3, int n4, MstpListener mstpListener) {
        log.trace("starting mstp driver: " + string2 + " at " + n + " baud, tsAddr=" + n2 + " maxMaster=" + n3 + " maxInfoFrames=" + n4);
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        int n5 = this.openDriver0(string2, n, n2, n3, n4);
        if (n5 == -1) {
            log.error("Could not open mstp: " + string2);
            throw new RuntimeException("Cannot open mstp");
        }
        MstpTrunkListener mstpTrunkListener = new MstpTrunkListener(n5, mstpListener);
        Thread thread = new Thread((Runnable)mstpTrunkListener, "mstp" + n5);
        thread.start();
        mstpTrunkListener.myThread = thread;
        this.trunkListeners.put(n5, (Object)mstpTrunkListener);
        return n5;
    }

    public void stopDriver(int n) {
        log.trace("stopping mstp driver");
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        MstpTrunkListener mstpTrunkListener = (MstpTrunkListener)this.trunkListeners.get(n);
        if (mstpTrunkListener == null) {
            throw new RuntimeException("Invalid handle " + n);
        }
        mstpTrunkListener.done = true;
        mstpTrunkListener.myThread.interrupt();
        this.closeDriver0(n);
        log.trace("mstp driver stopped");
    }

    public void sendFrame(int n, byte by, byte[] byArray, boolean bl) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        if (byArray.length > 501) {
            throw new IllegalArgumentException("Invalid frame length " + byArray.length);
        }
        this.sendFrame0(n, by, byArray, bl);
    }

    public void setBaudRate(int n, int n2) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        log.trace("setting baud rate to " + n2);
        this.setBaudRate0(n, n2);
    }

    public void setMaxMaster(int n, int n2) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        log.trace("setting max master to " + n2);
        this.setMaxMaster0(n, n2);
    }

    public void setMaxInfoFrames(int n, int n2) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        log.trace("setting max info frames to " + n2);
        this.setMaxInfoFrames0(n, n2);
    }

    public void setAddress(int n, int n2) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        log.trace("setting this station address to " + n2);
        this.setAddress0(n, n2);
    }

    public int getAddress(int n) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        int n2 = this.getAddress0(n);
        log.trace("getAddress0 returned " + n2);
        return n2;
    }

    private final native boolean init0();

    private final native void cleanup0();

    private final native int openDriver0(String var1, int var2, int var3, int var4, int var5);

    private final native void closeDriver0(int var1);

    private final native void rcvFrame0(int var1, MstpFrame var2);

    private final native void sendFrame0(int var1, byte var2, byte[] var3, boolean var4);

    private final native void setBaudRate0(int var1, int var2);

    private final native void setMaxMaster0(int var1, int var2);

    private final native void setMaxInfoFrames0(int var1, int var2);

    private final native void setAddress0(int var1, int var2);

    private final native int getAddress0(int var1);

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.trunkListeners = new IntHashMap();
        this.numTrunks = 6;
    }

    public BBacnetMstpPlatformServiceNpsdk() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$platMstp$BBacnetMstpPlatformServiceNpsdk;
        if (clazz == null) {
            clazz = class$com$tridium$platMstp$BBacnetMstpPlatformServiceNpsdk = BBacnetMstpPlatformServiceNpsdk.class("[Lcom.tridium.platMstp.BBacnetMstpPlatformServiceNpsdk;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        nativesLoaded = false;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MstpTrunkListener
    implements Runnable {
        int handle;
        MstpListener linkListener;
        Thread myThread;
        boolean done;

        public void run() {
            MstpFrame mstpFrame = new MstpFrame();
            log.trace("mstp trunk listener starting");
            while (!this.done) {
                try {
                    BBacnetMstpPlatformServiceNpsdk.this.rcvFrame0(this.handle, mstpFrame);
                    System.out.println("Frame received:\n" + TextUtil.bytesToHexString((byte[])mstpFrame.getData()));
                    if (this.linkListener == null) continue;
                    this.linkListener.receiveFrame(mstpFrame.getSrcAddr(), mstpFrame.getData(), mstpFrame.getDataExpectingReply());
                }
                catch (Exception exception) {
                    if (this.done) continue;
                    exception.printStackTrace();
                }
            }
            log.trace("mstp trunk listener done");
        }

        private final /* synthetic */ void this() {
            this.done = false;
        }

        public MstpTrunkListener(int n, MstpListener mstpListener) {
            this.this();
            this.handle = n;
            this.linkListener = mstpListener;
        }
    }
}

