/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.adr;

import com.tridium.adr.BAdrDevice;
import com.tridium.adr.BAdrDeviceFolder;
import com.tridium.adr.components.BAdrEventOpModeSchedule;
import com.tridium.adr.components.BAdrPollScheduler;
import com.tridium.adr.enums.BAdrEventStatusEnum;
import com.tridium.adr.program.BAdrDeviceExt;
import com.tridium.adr.program.BAdrEvent;
import com.tridium.adr.program.BAdrProgram;
import com.tridium.adr.program.BAdrProxyExt;
import com.tridium.adr.util.AdrPollingThread;
import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.Comm;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAdrNetwork
extends BBasicNetwork {
    public static final Property pollScheduler = BAdrNetwork.newProperty((int)0, (BValue)new BAdrPollScheduler(), null);
    public static final Property tuningPolicies = BAdrNetwork.newProperty((int)0, (BValue)new BTuningPolicyMap(), null);
    public static final Property workOnCacheEnabled = BAdrNetwork.newProperty((int)0, (boolean)false, null);
    public static final Property workOnCacheFrequency = BAdrNetwork.newProperty((int)4, (BValue)BRelTime.make((long)30000L), null);
    public static final Action resetMonitorThread = BAdrNetwork.newAction((int)4, (BValue)BBoolean.FALSE, null);
    public static final Type TYPE;
    private int mIndex;
    AdrPollingThread eventMonitoringThread;
    Log logAdrEventCache;
    static /* synthetic */ Class class$com$tridium$adr$BAdrNetwork;
    static /* synthetic */ Class class$com$tridium$adr$program$BAdrProgram;
    static /* synthetic */ Class class$com$tridium$adr$program$BAdrEvent;
    static /* synthetic */ Class class$com$tridium$adr$components$BAdrEventOpModeSchedule;
    static /* synthetic */ Class class$com$tridium$adr$BAdrDevice;
    static /* synthetic */ Class class$com$tridium$adr$BAdrDeviceFolder;

    public BAdrPollScheduler getPollScheduler() {
        return (BAdrPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BAdrPollScheduler bAdrPollScheduler) {
        this.set(pollScheduler, (BValue)bAdrPollScheduler, null);
    }

    public BTuningPolicyMap getTuningPolicies() {
        return (BTuningPolicyMap)this.get(tuningPolicies);
    }

    public void setTuningPolicies(BTuningPolicyMap bTuningPolicyMap) {
        this.set(tuningPolicies, (BValue)bTuningPolicyMap, null);
    }

    public boolean getWorkOnCacheEnabled() {
        return this.getBoolean(workOnCacheEnabled);
    }

    public void setWorkOnCacheEnabled(boolean bl) {
        this.setBoolean(workOnCacheEnabled, bl, null);
    }

    public BRelTime getWorkOnCacheFrequency() {
        return (BRelTime)this.get(workOnCacheFrequency);
    }

    public void setWorkOnCacheFrequency(BRelTime bRelTime) {
        this.set(workOnCacheFrequency, (BValue)bRelTime, null);
    }

    public void resetMonitorThread(BBoolean bBoolean) {
        this.invoke(resetMonitorThread, (BValue)bBoolean, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceType() {
        return BAdrDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BAdrDeviceFolder.TYPE;
    }

    public void started() throws Exception {
        this.doPing();
        if (this.isNetworkOk() && this.getWorkOnCacheEnabled()) {
            this.startEventMonitoringThread();
        }
    }

    private final boolean isNetworkOk() {
        boolean bl = false;
        if (!(this.isDown() || this.isFatalFault() || this.isDisabled())) {
            bl = true;
        }
        boolean bl2 = bl;
        return bl2;
    }

    public void doPing() {
        this.pingOk();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.stopEventMonitoringThread();
    }

    private final void startEventMonitoringThread() {
        if (this.eventMonitoringThread != null) {
            try {
                this.eventMonitoringThread.setThreadToBeRun(false);
                this.eventMonitoringThread.interrupt();
            }
            catch (Exception exception) {}
            this.eventMonitoringThread = null;
        }
        this.eventMonitoringThread = new AdrPollingThread(this);
        this.eventMonitoringThread.setThreadToBeRun(true);
        this.eventMonitoringThread.start();
    }

    private final void stopEventMonitoringThread() {
        if (this.eventMonitoringThread != null) {
            this.eventMonitoringThread.setThreadToBeRun(false);
            try {
                Thread.sleep(1000L);
                this.eventMonitoringThread = null;
            }
            catch (Exception exception) {}
        }
        this.eventMonitoringThread = null;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.invoke(resetMonitorThread, (BValue)BBoolean.TRUE);
            } else {
                this.invoke(resetMonitorThread, (BValue)BBoolean.FALSE);
            }
        }
        if (property == workOnCacheEnabled) {
            if (this.getWorkOnCacheEnabled() && this.getEnabled()) {
                this.invoke(resetMonitorThread, (BValue)BBoolean.TRUE);
            } else {
                this.invoke(resetMonitorThread, (BValue)BBoolean.FALSE);
            }
        }
    }

    protected Comm makeComm() {
        return null;
    }

    public final Feature getLicenseFeature() {
        Feature feature = Sys.getLicenseManager().getFeature("tridium", "adrsmart");
        return feature;
    }

    public void monitorEvents() {
        if (this.getEnabled() && this.getWorkOnCacheEnabled()) {
            BAdrDevice[] bAdrDeviceArray = new BAdrDevice[50];
            this.mIndex = 0;
            bAdrDeviceArray = this.getAllAdrDevices((BComponent)this, bAdrDeviceArray);
            int n = 0;
            int n2 = 0;
            while (n2 < bAdrDeviceArray.length) {
                if (bAdrDeviceArray[n2] == null || !bAdrDeviceArray[n2].isDeviceUnhealthy()) break;
                ++n;
                if (bAdrDeviceArray[n2].hasEvents() && bAdrDeviceArray[n2].getEnabled() && bAdrDeviceArray[n2].getEnableCache()) {
                    BAdrProgram[] bAdrProgramArray;
                    this.logAdrEventCache.trace(Thread.currentThread().getName() + ", monitoring events under -" + BAdrDevice.unescape(bAdrDeviceArray[n2].getName()));
                    BAdrDeviceExt bAdrDeviceExt = bAdrDeviceArray[n2].getPrograms();
                    Class clazz = class$com$tridium$adr$program$BAdrProgram;
                    if (clazz == null) {
                        clazz = BAdrNetwork.class("[Lcom.tridium.adr.program.BAdrProgram;", false);
                    }
                    if ((bAdrProgramArray = (BAdrProgram[])bAdrDeviceExt.getChildren(clazz)) != null && bAdrProgramArray.length > 0) {
                        this.logAdrEventCache.trace(BAdrDevice.unescape(bAdrDeviceArray[n2].getName()) + " ::no of programs - " + bAdrProgramArray.length);
                        int n3 = 0;
                        while (n3 < bAdrProgramArray.length) {
                            BAdrEvent[] bAdrEventArray;
                            BAdrProgram bAdrProgram = bAdrProgramArray[n3];
                            Class clazz2 = class$com$tridium$adr$program$BAdrEvent;
                            if (clazz2 == null) {
                                clazz2 = BAdrNetwork.class("[Lcom.tridium.adr.program.BAdrEvent;", false);
                            }
                            if ((bAdrEventArray = (BAdrEvent[])bAdrProgram.getChildren(clazz2)) != null && bAdrEventArray.length > 0) {
                                this.logAdrEventCache.trace(BAdrDevice.unescape(bAdrDeviceArray[n2].getName()) + " ::no of events under " + bAdrProgramArray[n3].getName() + " is:: " + bAdrEventArray.length);
                                int n4 = 0;
                                while (n4 < bAdrEventArray.length) {
                                    BAbsTime bAbsTime;
                                    BAdrEvent bAdrEvent = bAdrEventArray[n4];
                                    if (!this.getPollScheduler().getPollEnabled()) {
                                        bAdrEvent.setCurrentTime(0.0);
                                    }
                                    if ((bAbsTime = BAbsTime.now()).getMillis() < bAdrEvent.getEndTime().getMillis() && bAbsTime.getMillis() > bAdrEvent.getStartTime().getMillis()) {
                                        this.logAdrEventCache.trace("Event ::" + bAdrEvent.getEventIdentifier() + " ::current time is between event start and end time");
                                        BFolder bFolder = bAdrEvent.getOpModeSchedules();
                                        Class clazz3 = class$com$tridium$adr$components$BAdrEventOpModeSchedule;
                                        if (clazz3 == null) {
                                            clazz3 = BAdrNetwork.class("[Lcom.tridium.adr.components.BAdrEventOpModeSchedule;", false);
                                        }
                                        BAdrEventOpModeSchedule[] bAdrEventOpModeScheduleArray = (BAdrEventOpModeSchedule[])bFolder.getChildren(clazz3);
                                        int n5 = 0;
                                        while (n5 < bAdrEventOpModeScheduleArray.length) {
                                            long l = bAbsTime.getMillis();
                                            long l2 = (long)((double)bAdrEvent.getStartTime().getMillis() + bAdrEventOpModeScheduleArray[n5].getModeTimeOffset() * 1000.0);
                                            if (n5 != bAdrEventOpModeScheduleArray.length - 1) {
                                                long l3 = (long)((double)bAdrEvent.getStartTime().getMillis() + bAdrEventOpModeScheduleArray[n5 + 1].getModeTimeOffset() * 1000.0);
                                                if (l >= l2 && l < l3) {
                                                    bAdrEvent.setOpModeValue(bAdrEventOpModeScheduleArray[n5].getOpModeValue());
                                                    bAdrEvent.setEventStatus(BAdrEventStatusEnum.active);
                                                    if (bAdrEvent.getHighestPriorityEvent()) {
                                                        ((BAdrProxyExt)bAdrDeviceArray[n2].getActiveEvent().getOpModeValue().getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)bAdrEventOpModeScheduleArray[n5].getOpModeValue(), BStatus.ok));
                                                        this.logAdrEventCache.trace("event ::" + bAdrEvent.getEventIdentifier() + " is high priority event");
                                                        break;
                                                    }
                                                    this.logAdrEventCache.trace("event ::" + bAdrEvent.getEventIdentifier() + " is not a high priority event");
                                                    break;
                                                }
                                            } else if (l >= l2 && l <= bAdrEvent.getEndTime().getMillis()) {
                                                bAdrEvent.setEventStatus(BAdrEventStatusEnum.active);
                                                bAdrEvent.setOpModeValue(bAdrEventOpModeScheduleArray[n5].getOpModeValue());
                                                if (!bAdrEvent.getHighestPriorityEvent()) break;
                                                ((BAdrProxyExt)bAdrDeviceArray[n2].getActiveEvent().getOpModeValue().getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)bAdrEventOpModeScheduleArray[n5].getOpModeValue(), BStatus.ok));
                                                break;
                                            }
                                            ++n5;
                                        }
                                        if (bAdrEvent.getHighestPriorityEvent()) {
                                            this.logAdrEventCache.trace("event ::" + bAdrEvent.getEventIdentifier() + " is high priority event, settign active program");
                                            bAdrDeviceArray[n2].fillActiveEventInfo(bAdrEvent, true);
                                        } else {
                                            this.logAdrEventCache.trace("event ::" + bAdrEvent.getEventIdentifier() + " is NOT high priority event");
                                        }
                                    } else if (bAbsTime.getMillis() > bAdrEvent.getEndTime().getMillis()) {
                                        bAdrEvent.markedForDeletion = true;
                                        this.logAdrEventCache.trace("event ::" + bAdrEvent.getEventIdentifier() + " expired, marking for deletion");
                                        if (bAdrEvent.getHighestPriorityEvent()) {
                                            this.logAdrEventCache.trace("high Priority Event ::" + bAdrEvent.getEventIdentifier() + " expired, clearing active program info");
                                            bAdrDeviceArray[n2].clearActiveEventInfo(false);
                                        }
                                    }
                                    ++n4;
                                }
                            } else {
                                this.logAdrEventCache.trace("Program-" + bAdrProgramArray[n3].getProgramName() + ", marked for deletion");
                                bAdrProgramArray[n3].setMarkedForDeletion(true);
                            }
                            ++n3;
                        }
                    } else {
                        bAdrDeviceArray[n2].setHasEvents(false);
                    }
                    this.logAdrEventCache.trace(Thread.currentThread().getName() + ", monitored events under -" + BAdrDevice.unescape(bAdrDeviceArray[n2].getName()));
                }
                bAdrDeviceArray[n2].deleteObsoleteProgramsAndEvents();
                ++n2;
            }
        }
    }

    public void setThreadToRunMode(boolean bl) {
        this.eventMonitoringThread.setThreadToBeRun(bl);
    }

    public BAdrDevice[] getAdrDevices() {
        Class clazz = class$com$tridium$adr$BAdrDevice;
        if (clazz == null) {
            clazz = class$com$tridium$adr$BAdrDevice = BAdrNetwork.class("[Lcom.tridium.adr.BAdrDevice;", false);
        }
        return (BAdrDevice[])this.getChildren(clazz);
    }

    public BAdrDevice[] getAllAdrDevices(BComponent bComponent, BAdrDevice[] bAdrDeviceArray) {
        BAdrDeviceFolder[] bAdrDeviceFolderArray;
        Class clazz = class$com$tridium$adr$BAdrDevice;
        if (clazz == null) {
            clazz = class$com$tridium$adr$BAdrDevice = BAdrNetwork.class("[Lcom.tridium.adr.BAdrDevice;", false);
        }
        BAdrDevice[] bAdrDeviceArray2 = (BAdrDevice[])bComponent.getChildren(clazz);
        System.arraycopy(bAdrDeviceArray2, 0, bAdrDeviceArray, this.mIndex, bAdrDeviceArray2.length);
        this.mIndex += bAdrDeviceArray2.length;
        Class clazz2 = class$com$tridium$adr$BAdrDeviceFolder;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$adr$BAdrDeviceFolder = BAdrNetwork.class("[Lcom.tridium.adr.BAdrDeviceFolder;", false);
        }
        if ((bAdrDeviceFolderArray = (BAdrDeviceFolder[])bComponent.getChildren(clazz2)) != null && bAdrDeviceFolderArray.length > 0) {
            int n = 0;
            while (n < bAdrDeviceFolderArray.length) {
                bAdrDeviceArray = this.getAllAdrDevices((BComponent)bAdrDeviceFolderArray[n], bAdrDeviceArray);
                ++n;
            }
        }
        return bAdrDeviceArray;
    }

    public void doResetMonitorThread(BBoolean bBoolean) {
        this.stopEventMonitoringThread();
        if (bBoolean.getBoolean()) {
            this.startEventMonitoringThread();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.mIndex = 0;
        this.eventMonitoringThread = null;
        this.logAdrEventCache = Log.getLog((String)"AdrCache");
    }

    public BAdrNetwork() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$adr$BAdrNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$adr$BAdrNetwork = BAdrNetwork.class("[Lcom.tridium.adr.BAdrNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

