/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web;

import com.tridium.web.SnoopHtmlWriter;
import com.tridium.web.WebEnv;
import com.tridium.web.WebUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.baja.file.ExportOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.web.BWebProfileConfig;
import javax.baja.web.BWebService;
import javax.baja.web.BWebServlet;
import javax.baja.web.IWebEnv;
import javax.baja.web.UserAgent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class WebOp
extends ExportOp {
    BWebService service;
    IWebEnv webEnv;
    BWebProfileConfig profileConfig;
    HttpServletRequest request;
    HttpServletResponse response;
    UserAgent userAgent;
    String lang;
    BWebServlet servlet;

    public BWebService getService() {
        return this.service;
    }

    public IWebEnv getWebEnv() {
        if (this.webEnv == null) {
            this.webEnv = this.initWebEnv();
        }
        return this.webEnv;
    }

    public IWebEnv initWebEnv() {
        HttpSession httpSession = this.getRequest().getSession(true);
        this.webEnv = (IWebEnv)httpSession.getAttribute("webenv");
        if (this.webEnv == null) {
            this.webEnv = WebEnv.make(this);
            httpSession.setAttribute("webenv", this.webEnv);
        }
        return this.webEnv;
    }

    public BWebProfileConfig getProfileConfig() {
        if (this.profileConfig == null) {
            this.profileConfig = (BWebProfileConfig)((Object)this.getRequest().getSession(true).getAttribute("profileConfig"));
            if (this.profileConfig == null) {
                try {
                    this.profileConfig = this.getWebEnv().getWebProfileConfig(this.getUser());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (this.profileConfig == null) {
                this.profileConfig = this.getWebEnv().makeWebProfileConfig();
            }
        }
        return this.profileConfig;
    }

    public String getPathInfo() {
        if (this.servlet != null) {
            String string = this.servlet.getServletName();
            return this.request.getRequestURI().substring(string.length() + 1);
        }
        return this.request.getPathInfo();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setContentType(String string) {
        this.getResponse().setContentType(string);
    }

    public void setContentLength(int n) {
        this.getResponse().setContentLength(n);
    }

    public PrintWriter getWriter() throws IOException {
        return this.getResponse().getWriter();
    }

    public HtmlWriter getHtmlWriter() throws IOException {
        return new SnoopHtmlWriter(this, this.getWriter());
    }

    public UserAgent getUserAgent() {
        if (this.userAgent == null) {
            String string = this.request.getHeader("User-Agent");
            if (string == null) {
                return null;
            }
            try {
                this.userAgent = new UserAgent(string);
            }
            catch (Exception exception) {
                System.out.println("Invalid User-Agent: \"" + string + '\"');
                exception.printStackTrace();
            }
        }
        return this.userAgent;
    }

    public OutputStream getOutputStream() {
        try {
            return this.getResponse().getOutputStream();
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    public String toUri(BOrd bOrd) {
        return WebUtil.toUri((OrdTarget)this, this.getRequest(), bOrd);
    }

    public String getLanguage() {
        if (this.lang == null) {
            this.lang = WebUtil.getLanguage(this.getRequest(), this.getUser());
        }
        return this.lang;
    }

    public void fw(Object object) {
        if (object instanceof BWebServlet) {
            this.servlet = (BWebServlet)((Object)object);
        }
    }

    public void redirectToHome() throws Exception {
        BOrd bOrd = this.webEnv.getHomePage(this);
        this.getResponse().sendRedirect(WebUtil.getRedirect(this.getRequest(), WebUtil.toUri((OrdTarget)this, this.getRequest(), bOrd)));
    }

    public WebOp(OrdTarget ordTarget, BWebService bWebService, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        super(ordTarget);
        this.service = bWebService;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
    }
}

