/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web;

import com.tridium.httpd.ClfLogger;
import com.tridium.httpd.ElfLogger;
import com.tridium.httpd.Httpd;
import com.tridium.httpd.Logger;
import com.tridium.httpd.RequestQueue;
import com.tridium.httpd.ServiceThread;
import com.tridium.httpd.W3cLogger;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.sys.Nre;
import com.tridium.util.TimeFormat;
import com.tridium.web.BHttpTunnelFactory;
import com.tridium.web.SysServlet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.ServerSocket;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.baja.data.BIDataValue;
import javax.baja.file.BDataFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.file.types.audio.BAudioFile;
import javax.baja.file.types.image.BImageFile;
import javax.baja.file.types.text.BCssFile;
import javax.baja.file.types.text.BJavascriptFile;
import javax.baja.file.types.video.BVideoFile;
import javax.baja.io.net.IServerSocketFactory;
import javax.baja.io.net.ISocketFactory;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.registry.TypeInfo;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BHttpFoxCredentials;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BTypeSpec;
import javax.baja.web.BAuthenticationType;
import javax.baja.web.BClientEnvironments;
import javax.baja.web.BWebLogFileFormat;
import javax.baja.web.BWebLogFilePolicy;
import javax.baja.web.BWebProfileConfig;
import javax.baja.web.BWebServlet;
import javax.baja.web.IWebEnv;
import javax.baja.web.WebOp;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWebService
extends BAbstractService {
    public static final Property httpPort = BWebService.newProperty((int)0, (int)80, null);
    public static final Property httpEnabled = BWebService.newProperty((int)0, (boolean)true, null);
    public static final Property httpsPort = BWebService.newProperty((int)0, (int)443, null);
    public static final Property httpsEnabled = BWebService.newProperty((int)0, (boolean)false, null);
    public static final Property httpsOnly = BWebService.newProperty((int)0, (boolean)false, null);
    public static final Property httpsMinProtocol = BWebService.newProperty((int)0, (BValue)BSslTlsEnum.sslv3andtlsv1, null);
    public static final Property httpsCert = BWebService.newProperty((int)0, (String)"tridium", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:CertificateAliasFE")));
    public static final Property authenticationScheme = BWebService.newProperty((int)0, (BValue)BAuthenticationType.cookieDigest, null);
    public static final Property gzipEnabled = BWebService.newProperty((int)0, (boolean)true, null);
    public static final Property logFileEnabled = BWebService.newProperty((int)0, (boolean)false, null);
    public static final Property logFileFormat = BWebService.newProperty((int)0, (BValue)BWebLogFileFormat.commonLogFormat, null);
    public static final Property logFileDirectory = BWebService.newProperty((int)0, (BValue)BOrd.make((String)"file:^httpd"), null);
    public static final Property logFilePolicy = BWebService.newProperty((int)0, (BValue)BWebLogFilePolicy.daily, null);
    public static final Property logMaximumSize = BWebService.newProperty((int)0, (int)100, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"megabyte", (String)"MB", (BDimension)BDimension.DEFAULT, (double)1048576.0, (double)0.0)));
    public static final Property logFileIndex = BWebService.newProperty((int)4, (int)1, null);
    public static final Property backlog = BWebService.newProperty((int)0, (int)500, null);
    public static final Property maxThreads = BWebService.newProperty((int)0, (int)15, null);
    public static final Property minThreads = BWebService.newProperty((int)0, (int)3, null);
    public static final Property autoLoginEnabled = BWebService.newProperty((int)0, (boolean)false, null);
    public static final Property singleSignOnEnabled = BWebService.newProperty((int)0, (boolean)false, null);
    public static final Property loginTemplate = BWebService.newProperty((int)0, (BValue)BTypeSpec.NULL, (BFacets)BFacets.make((String)"allowNull", (BIDataValue)BBoolean.TRUE, (String)"targetType", (BIDataValue)BString.make((String)"web:LoginTemplate")));
    public static final Property tunnelingEnabled = BWebService.newProperty((int)0, (boolean)false, null);
    public static final Property proxyAuthenticationWhenTunneling = BWebService.newProperty((int)0, (boolean)false, null);
    public static final Property cookieDigestSessionTimeout = BWebService.newProperty((int)0, (int)5, (BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"minute")), (BFacets)BFacets.make((String)"min", (int)0)));
    public static final Property clientEnvironments = BWebService.newProperty((int)0, (BValue)new BClientEnvironments(), null);
    public static final Action reloadLog = BWebService.newAction((int)4, null);
    public static final Action delayedRestart = BWebService.newAction((int)4, null);
    public static final Type TYPE;
    private static Type[] serviceTypes;
    private static final BIcon icon;
    public static final Log log;
    public static final String SESSION_INFO_ADDR = "sessionInfoAddr";
    public static final String SESSION_INFO_USER = "sessionInfoUser";
    public static final String SESSION_INFO_AUTH = "sessionInfoAuth";
    public static final String SESSION_INFO_GUEST = "sessionInfoGuest";
    private static Class BFoxServiceClass;
    private static Method getFoxsEnabledMthd;
    private static Method setFoxsEnabledMthd;
    public static final List MEDIA_TYPES;
    public static final List GZIPPED_TYPES;
    private Httpd httpd;
    private SysServlet sysServlet;
    private HashMap byServlet;
    private HashMap byServletName;
    private RequestQueue requestQueue;
    private Clock.Ticket logReload;
    private Clock.Ticket restartTicket;
    static /* synthetic */ Class class$javax$baja$web$BWebService;

    public int getHttpPort() {
        return this.getInt(httpPort);
    }

    public void setHttpPort(int n) {
        this.setInt(httpPort, n, null);
    }

    public boolean getHttpEnabled() {
        return this.getBoolean(httpEnabled);
    }

    public void setHttpEnabled(boolean bl) {
        this.setBoolean(httpEnabled, bl, null);
    }

    public int getHttpsPort() {
        return this.getInt(httpsPort);
    }

    public void setHttpsPort(int n) {
        this.setInt(httpsPort, n, null);
    }

    public boolean getHttpsEnabled() {
        return this.getBoolean(httpsEnabled);
    }

    public void setHttpsEnabled(boolean bl) {
        this.setBoolean(httpsEnabled, bl, null);
    }

    public boolean getHttpsOnly() {
        return this.getBoolean(httpsOnly);
    }

    public void setHttpsOnly(boolean bl) {
        this.setBoolean(httpsOnly, bl, null);
    }

    public BSslTlsEnum getHttpsMinProtocol() {
        return (BSslTlsEnum)this.get(httpsMinProtocol);
    }

    public void setHttpsMinProtocol(BSslTlsEnum bSslTlsEnum) {
        this.set(httpsMinProtocol, (BValue)bSslTlsEnum, null);
    }

    public String getHttpsCert() {
        return this.getString(httpsCert);
    }

    public void setHttpsCert(String string) {
        this.setString(httpsCert, string, null);
    }

    public BAuthenticationType getAuthenticationScheme() {
        return (BAuthenticationType)this.get(authenticationScheme);
    }

    public void setAuthenticationScheme(BAuthenticationType bAuthenticationType) {
        this.set(authenticationScheme, (BValue)bAuthenticationType, null);
    }

    public boolean getGzipEnabled() {
        return this.getBoolean(gzipEnabled);
    }

    public void setGzipEnabled(boolean bl) {
        this.setBoolean(gzipEnabled, bl, null);
    }

    public boolean getLogFileEnabled() {
        return this.getBoolean(logFileEnabled);
    }

    public void setLogFileEnabled(boolean bl) {
        this.setBoolean(logFileEnabled, bl, null);
    }

    public BWebLogFileFormat getLogFileFormat() {
        return (BWebLogFileFormat)this.get(logFileFormat);
    }

    public void setLogFileFormat(BWebLogFileFormat bWebLogFileFormat) {
        this.set(logFileFormat, (BValue)bWebLogFileFormat, null);
    }

    public BOrd getLogFileDirectory() {
        return (BOrd)this.get(logFileDirectory);
    }

    public void setLogFileDirectory(BOrd bOrd) {
        this.set(logFileDirectory, (BValue)bOrd, null);
    }

    public BWebLogFilePolicy getLogFilePolicy() {
        return (BWebLogFilePolicy)this.get(logFilePolicy);
    }

    public void setLogFilePolicy(BWebLogFilePolicy bWebLogFilePolicy) {
        this.set(logFilePolicy, (BValue)bWebLogFilePolicy, null);
    }

    public int getLogMaximumSize() {
        return this.getInt(logMaximumSize);
    }

    public void setLogMaximumSize(int n) {
        this.setInt(logMaximumSize, n, null);
    }

    public int getLogFileIndex() {
        return this.getInt(logFileIndex);
    }

    public void setLogFileIndex(int n) {
        this.setInt(logFileIndex, n, null);
    }

    public int getBacklog() {
        return this.getInt(backlog);
    }

    public void setBacklog(int n) {
        this.setInt(backlog, n, null);
    }

    public int getMaxThreads() {
        return this.getInt(maxThreads);
    }

    public void setMaxThreads(int n) {
        this.setInt(maxThreads, n, null);
    }

    public int getMinThreads() {
        return this.getInt(minThreads);
    }

    public void setMinThreads(int n) {
        this.setInt(minThreads, n, null);
    }

    public boolean getAutoLoginEnabled() {
        return this.getBoolean(autoLoginEnabled);
    }

    public void setAutoLoginEnabled(boolean bl) {
        this.setBoolean(autoLoginEnabled, bl, null);
    }

    public boolean getSingleSignOnEnabled() {
        return this.getBoolean(singleSignOnEnabled);
    }

    public void setSingleSignOnEnabled(boolean bl) {
        this.setBoolean(singleSignOnEnabled, bl, null);
    }

    public BTypeSpec getLoginTemplate() {
        return (BTypeSpec)this.get(loginTemplate);
    }

    public void setLoginTemplate(BTypeSpec bTypeSpec) {
        this.set(loginTemplate, (BValue)bTypeSpec, null);
    }

    public boolean getTunnelingEnabled() {
        return this.getBoolean(tunnelingEnabled);
    }

    public void setTunnelingEnabled(boolean bl) {
        this.setBoolean(tunnelingEnabled, bl, null);
    }

    public boolean getProxyAuthenticationWhenTunneling() {
        return this.getBoolean(proxyAuthenticationWhenTunneling);
    }

    public void setProxyAuthenticationWhenTunneling(boolean bl) {
        this.setBoolean(proxyAuthenticationWhenTunneling, bl, null);
    }

    public int getCookieDigestSessionTimeout() {
        return this.getInt(cookieDigestSessionTimeout);
    }

    public void setCookieDigestSessionTimeout(int n) {
        this.setInt(cookieDigestSessionTimeout, n, null);
    }

    public BClientEnvironments getClientEnvironments() {
        return (BClientEnvironments)this.get(clientEnvironments);
    }

    public void setClientEnvironments(BClientEnvironments bClientEnvironments) {
        this.set(clientEnvironments, (BValue)bClientEnvironments, null);
    }

    public void reloadLog() {
        this.invoke(reloadLog, null, null);
    }

    public void delayedRestart() {
        this.invoke(delayedRestart, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "web");
    }

    public void serviceStarted() throws Exception {
        this.getComponentSpace().enableMixIn(BWebProfileConfig.TYPE);
        try {
            try {
                Nre.serviceManager.getService("platCrypto:CertManagerService");
                this.setFlags((Slot)httpsPort, this.getFlags((Slot)httpsPort) & 0xFFFFFFFA);
                this.setFlags((Slot)httpsEnabled, this.getFlags((Slot)httpsEnabled) & 0xFFFFFFFA);
                this.setFlags((Slot)httpsOnly, this.getFlags((Slot)httpsOnly) & 0xFFFFFFFA);
                this.setFlags((Slot)httpsMinProtocol, this.getFlags((Slot)httpsMinProtocol) & 0xFFFFFFFA);
                this.setFlags((Slot)httpsCert, this.getFlags((Slot)httpsCert) & 0xFFFFFFFA);
                if (SecurityInitializer.isFips()) {
                    if (this.getHttpsMinProtocol() != BSslTlsEnum.tlsv1) {
                        log.message("Changing https min protocol to tlsv1 to support fips mode");
                        this.setHttpsMinProtocol(BSslTlsEnum.tlsv1);
                    }
                    this.setFlags((Slot)httpsMinProtocol, this.getFlags((Slot)httpsMinProtocol) | 1);
                }
            }
            catch (Exception exception) {
                Nre.serviceManager.getService("crypto:CryptoService");
                this.setHttpsMinProtocol(BSslTlsEnum.tlsv1);
                this.setHttpsMinProtocol(BSslTlsEnum.sslv3);
                this.setFlags((Slot)httpsMinProtocol, this.getFlags((Slot)httpsMinProtocol) | 1 | 4);
                this.setFlags((Slot)httpsCert, this.getFlags((Slot)httpsCert) | 1 | 4);
                this.setFlags((Slot)httpsPort, this.getFlags((Slot)httpsPort) & 0xFFFFFFFA);
                this.setFlags((Slot)httpsOnly, this.getFlags((Slot)httpsOnly) & 0xFFFFFFFA);
                this.setFlags((Slot)httpsEnabled, this.getFlags((Slot)httpsEnabled) & 0xFFFFFFFA);
            }
        }
        catch (Exception exception) {
            if (this.getHttpsEnabled()) {
                log.warning("HTTPS is not supported on this device (missing platCrypto or crypto). Using HTTP instead.");
                this.setHttpEnabled(true);
            }
            this.setFlags((Slot)httpsPort, this.getFlags((Slot)httpsPort) | 1 | 4);
            this.setHttpsEnabled(false);
            this.setFlags((Slot)httpsEnabled, this.getFlags((Slot)httpsEnabled) | 1 | 4);
            this.setHttpsOnly(false);
            this.setFlags((Slot)httpsOnly, this.getFlags((Slot)httpsOnly) | 1 | 4);
            this.setFlags((Slot)httpsMinProtocol, this.getFlags((Slot)httpsMinProtocol) | 1 | 4);
            this.setFlags((Slot)httpsCert, this.getFlags((Slot)httpsCert) | 1 | 4);
        }
        BUserService.httpHandler = new WebHttpCredentialsHandler();
        if (Sys.isStationStarted()) {
            this.stationStarted();
        }
    }

    public void serviceStopped() throws Exception {
        this.httpd.installTunnelFactory(null);
        this.httpd.stop();
        this.httpd = null;
    }

    public void stationStarted() throws Exception {
        if (this.httpd != null && this.httpd.isServing()) {
            log.message("Web server already started.");
            return;
        }
        if (this.httpd == null) {
            this.httpd = new Httpd(new HttpdSettings(this, Sys.getBajaHome().getPath()));
            this.sysServlet = new SysServlet(this);
            this.httpd.registerServlet("/", this.sysServlet, null);
        }
        if (this.requestQueue == null) {
            this.requestQueue = new RequestQueue(this.httpd, this.getMinThreads(), this.getMaxThreads(), this.getBacklog());
        }
        if (this.isOperational() && (this.getHttpEnabled() || this.getHttpsEnabled())) {
            if (this.getTunnelingEnabled() && BHttpTunnelFactory.httpTunnelingLicensed()) {
                this.httpd.installTunnelFactory(new BHttpTunnelFactory(this.getProxyAuthenticationWhenTunneling()));
            }
            this.initLogFile(this.getLogFilename());
            this.httpd.run();
        } else {
            log.warning("HTTP and HTTPS are both disabled.");
        }
        this.updateStationSummaries();
    }

    private final void updateStationSummaries() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = -1;
        int n2 = -1;
        if (this.getHttpEnabled()) {
            n = this.getHttpPort();
        }
        if (this.getHttpsEnabled()) {
            n2 = this.getHttpsPort();
        }
        arrayList.add("httpport");
        arrayList2.add(String.valueOf(n));
        arrayList.add("httpsport");
        arrayList2.add(String.valueOf(n2));
        Nre.getPlatform().reportSummaryFields(arrayList.toArray(new String[0]), arrayList2.toArray(new String[0]));
    }

    public void stopped() throws Exception {
        this.getComponentSpace().disableMixIn(BWebProfileConfig.TYPE);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning() || this.httpd == null) {
            return;
        }
        if ((property == backlog || property == maxThreads || property == minThreads) && this.requestQueue != null) {
            this.requestQueue.setMaxQueueSize(this.getBacklog());
            this.requestQueue.setMaxThreads(this.getMaxThreads());
            this.requestQueue.setMinThreads(this.getMinThreads());
        }
        if (property == httpPort || property == httpsPort) {
            if (this.getEnabled()) {
                this.triggerDelayedRestart();
            }
        } else if (property == httpsCert || property == httpsMinProtocol || property == httpsCert) {
            if (this.getHttpsEnabled()) {
                this.triggerDelayedRestart();
            }
        } else if (property == logFileEnabled || property == logFileFormat || property == logFilePolicy || property == logMaximumSize || property == logFileDirectory || property == tunnelingEnabled || property == proxyAuthenticationWhenTunneling) {
            if (this.getEnabled() || this.getHttpsEnabled()) {
                this.triggerDelayedRestart();
            }
        } else if (property == httpEnabled || property == httpsEnabled || property == enabled) {
            this.triggerDelayedRestart();
        }
        if (property == httpsEnabled && this.isRunning() && this.getHttpsEnabled()) {
            try {
                Boolean bl;
                ICryptoManager iCryptoManager;
                try {
                    iCryptoManager = CertManagerFactory.getInstance();
                    if (iCryptoManager == null) {
                        return;
                    }
                }
                catch (Exception exception) {
                    return;
                }
                iCryptoManager = Sys.getService((Type)Sys.getType((String)"fox:FoxService"));
                if (iCryptoManager != null && !(bl = (Boolean)getFoxsEnabledMthd.invoke((Object)iCryptoManager, null)).booleanValue()) {
                    setFoxsEnabledMthd.invoke((Object)iCryptoManager, Boolean.TRUE);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private final synchronized void triggerDelayedRestart() {
        if (this.restartTicket == null) {
            this.restartTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)500L), (Action)delayedRestart, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doDelayedRestart() {
        BWebService bWebService = this;
        synchronized (bWebService) {
            this.restartTicket = null;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
            this.restart();
            return;
        }
    }

    public Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        if (n == 9900) {
            return this.httpd;
        }
        return super.fw(n, object, object2, object3, object4);
    }

    private final void initLogFile(File file) {
        if (this.getLogFileEnabled()) {
            try {
                Logger logger = null;
                switch (this.getLogFileFormat().getOrdinal()) {
                    case 0: {
                        logger = new ClfLogger(file);
                        break;
                    }
                    case 1: {
                        logger = new ElfLogger(file);
                        break;
                    }
                    case 2: {
                        logger = new W3cLogger(file);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                this.httpd.installLogger(logger);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                log.error("Cannot init log file", (Throwable)exception);
                return;
            }
            if (this.logReload == null) {
                this.logReload = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)5), (Action)reloadLog, null);
            }
        }
    }

    private final File getLogFilename() throws IOException {
        File file;
        BFileSystem bFileSystem = BFileSystem.INSTANCE;
        FilePath filePath = (FilePath)this.getLogFileDirectory().parse()[0];
        BDirectory bDirectory = bFileSystem.makeDir(filePath);
        File file2 = ((BLocalFileStore)bDirectory.getStore()).getLocalFile();
        BAbsTime bAbsTime = BAbsTime.make((long)System.currentTimeMillis(), (BTimeZone)BTimeZone.GMT);
        switch (this.getLogFilePolicy().getOrdinal()) {
            case 0: {
                String string = TimeFormat.format((BAbsTime)bAbsTime, (String)"YYMMDDHH");
                file = new File(file2, string + ".log");
                break;
            }
            case 1: {
                String string = TimeFormat.format((BAbsTime)bAbsTime, (String)"YYMMDD");
                file = new File(file2, string + ".log");
                break;
            }
            case 2: {
                BAbsTime bAbsTime2 = bAbsTime.subtract(BRelTime.makeHours((int)(bAbsTime.getWeekday().getOrdinal() * 24)));
                String string = TimeFormat.format((BAbsTime)bAbsTime2, (String)"YYMMDD");
                file = new File(file2, string + ".log");
                break;
            }
            case 3: {
                String string = TimeFormat.format((BAbsTime)bAbsTime, (String)"YYMM");
                file = new File(file2, string + ".log");
                break;
            }
            case 4: {
                DecimalFormat decimalFormat = new DecimalFormat("0000000");
                file = new File(file2, decimalFormat.format(this.getLogFileIndex()) + ".log");
                while (file.exists() && file.length() / 0x100000L >= (long)this.getLogMaximumSize()) {
                    this.setLogFileIndex(this.getLogFileIndex() + 1);
                    file = new File(file2, decimalFormat.format(this.getLogFileIndex()) + ".log");
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return file;
    }

    public void doReloadLog() {
        try {
            this.initLogFile(this.getLogFilename());
        }
        catch (Exception exception) {
            log.error("Cannot init log file", (Throwable)exception);
        }
    }

    private final void restart() {
        try {
            this.serviceStopped();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            log.error("Restart of web server failed on stop.", (Throwable)exception);
        }
        this.requestQueue = null;
        try {
            this.serviceStarted();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            log.error("Restart of web server failed on start.", (Throwable)exception);
        }
    }

    public IWebEnv getWebEnv(WebOp webOp) {
        return this.getClientEnvironments().getWebEnv(webOp);
    }

    public BWebServlet getServletByName(String string) {
        ServletEntry servletEntry = (ServletEntry)this.byServletName.get(string);
        if (servletEntry == null) {
            return null;
        }
        return servletEntry.servlet;
    }

    public SysServlet getSysServlet() {
        return this.sysServlet;
    }

    public BWebServlet[] getServlets() {
        return this.byServlet.keySet().toArray(new BWebServlet[this.byServlet.size()]);
    }

    void register(BWebServlet bWebServlet) {
        String string = bWebServlet.getServletName();
        if (!SlotPath.isValidName((String)string)) {
            log.error("Invalid servlet name: " + string);
            bWebServlet.setValidServletName(false);
            return;
        }
        ServletEntry servletEntry = (ServletEntry)this.byServletName.get(string);
        if (servletEntry != null) {
            log.error("Duplicate servlet name: " + string);
            bWebServlet.setValidServletName(false);
            return;
        }
        servletEntry = new ServletEntry(string, bWebServlet);
        this.byServletName.put(string, servletEntry);
        this.byServlet.put(bWebServlet, servletEntry);
        bWebServlet.setValidServletName(true);
    }

    void unregister(BWebServlet bWebServlet) {
        ServletEntry servletEntry = (ServletEntry)this.byServlet.get((Object)bWebServlet);
        if (servletEntry != null) {
            this.byServletName.remove(servletEntry.name);
            this.byServlet.remove((Object)bWebServlet);
        }
    }

    public void initFileResources(BIDirectory bIDirectory) {
        this.sysServlet.initFileResources(bIDirectory);
    }

    public void initFileResources(BIFile bIFile) {
        this.sysServlet.initFileResources(bIFile);
    }

    public BIcon getIcon() {
        return icon;
    }

    public HttpSession getHttpSession(String string) {
        return this.httpd.getHttpSession(string);
    }

    public boolean isGzippable(HttpServletRequest httpServletRequest, String string) {
        boolean bl = false;
        if (!this.getGzipEnabled()) {
            return false;
        }
        if (httpServletRequest.getProtocol().endsWith("1.1")) {
            Enumeration enumeration = httpServletRequest.getHeaders("accept-encoding");
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.equalsIgnoreCase("gzip") && !string2.equalsIgnoreCase("x-gzip")) continue;
                bl = true;
                break;
            }
            if (bl && GZIPPED_TYPES.contains(string)) {
                return true;
            }
        }
        return false;
    }

    public boolean isMediaType(String string) {
        return MEDIA_TYPES.contains(string);
    }

    public boolean isValidCookieRedirect(String string) {
        if (string == null) {
            return false;
        }
        if (string.startsWith("/wb/")) {
            return false;
        }
        String string2 = FileUtil.getExtension((String)string);
        if (string2 == null) {
            return true;
        }
        TypeInfo typeInfo = Sys.getRegistry().getFileTypeForExtension(string2);
        if (typeInfo == null || typeInfo.equals(BDataFile.TYPE.getTypeInfo())) {
            return true;
        }
        return !typeInfo.is(BImageFile.TYPE.getTypeInfo()) && !typeInfo.is(BAudioFile.TYPE.getTypeInfo()) && !typeInfo.is(BVideoFile.TYPE.getTypeInfo()) && !typeInfo.is(BCssFile.TYPE.getTypeInfo()) && !typeInfo.is(BJavascriptFile.TYPE.getTypeInfo());
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        Object[] objectArray;
        if (this.sysServlet != null) {
            this.sysServlet.spy(spyWriter);
        }
        spyWriter.startProps("Http Tunneling");
        spyWriter.prop((Object)"license.tunneling.http", (Object)("" + BHttpTunnelFactory.httpTunnelingLicensed()));
        spyWriter.endProps();
        spyWriter.startTable(true);
        spyWriter.trTitle((Object)"WebServlets", 3);
        spyWriter.w((Object)"<tr>").th((Object)"Servlet Name").th((Object)"Slot Path").th((Object)"Type").w((Object)"</tr>\n");
        BWebServlet[] bWebServletArray = this.getServlets();
        int n = 0;
        while (n < bWebServletArray.length) {
            objectArray = bWebServletArray[n];
            spyWriter.tr((Object)objectArray.getServletName(), (Object)objectArray.toPathString(), (Object)objectArray.getType());
            ++n;
        }
        spyWriter.endTable();
        RequestQueue requestQueue = this.httpd.getRequestQueue();
        spyWriter.startProps("WebService");
        spyWriter.prop((Object)"queue.size", requestQueue.getQueueSize());
        spyWriter.prop((Object)"queue.size.peak", requestQueue.getPeakQueueSize());
        spyWriter.prop((Object)"threads.busy", requestQueue.getBusyThreads());
        spyWriter.prop((Object)"threads.busy.peak", requestQueue.getPeakBusyThreads());
        spyWriter.prop((Object)"threads.total", requestQueue.getTotalThreads());
        spyWriter.prop((Object)"threads.total.peak", requestQueue.getPeakThreads());
        spyWriter.prop((Object)"threads.created", requestQueue.getThreadsCreated());
        spyWriter.prop((Object)"requests.total", requestQueue.getRequestsReceived());
        spyWriter.prop((Object)"connections.total", requestQueue.getTotalConnections());
        spyWriter.prop((Object)"connections.total.peak", requestQueue.getPeakConnections());
        spyWriter.endProps();
        if (log.isTraceOn() && this.isRunning()) {
            Object object;
            spyWriter.startTable(true);
            spyWriter.trTitle((Object)"Threads", 6);
            spyWriter.w((Object)"<tr>").th((Object)"").th((Object)"Name").th((Object)"Requests").th((Object)"Age").th((Object)"Last Activity").th((Object)"Busy").w((Object)"</tr>\n");
            objectArray = requestQueue.getThreads();
            int n2 = 0;
            while (n2 < objectArray.length) {
                object = (ServiceThread)objectArray[n2];
                spyWriter.w((Object)"<tr><td>").w(n2 + 1).w((Object)"</td><td>").w((Object)((Thread)object).getName()).w((Object)"</td><td>").w(((ServiceThread)object).getRequestCount()).w((Object)"</td><td>").w((Object)((ServiceThread)object).getAge()).w((Object)"</td><td>").w((Object)((ServiceThread)object).getLastActivity()).w((Object)"</td><td>").w(((ServiceThread)object).getBusy()).w((Object)"</td></tr>");
                ++n2;
            }
            spyWriter.endTable();
            spyWriter.startTable(true);
            spyWriter.trTitle((Object)"Connections", 7);
            spyWriter.w((Object)"<tr>").th((Object)"").th((Object)"Scheme").th((Object)"Client").th((Object)"Requests").th((Object)"Age").th((Object)"Last Activity").th((Object)"Timeout").w((Object)"</tr>\n");
            objectArray = requestQueue.getConnections();
            n2 = 0;
            while (n2 < objectArray.length) {
                object = (RequestQueue.Connection)objectArray[n2];
                spyWriter.w((Object)"<tr><td>").w(n2 + 1).w((Object)"</td><td>").w((Object)((RequestQueue.Connection)object).scheme).w((Object)"</td><td>").w((Object)((RequestQueue.Connection)object).socket.getRemoteSocketAddress()).w((Object)"</td><td>").w(((RequestQueue.Connection)object).getRequestCount()).w((Object)"</td><td>").w((Object)((RequestQueue.Connection)object).getAge()).w((Object)"</td><td>").w((Object)((RequestQueue.Connection)object).getLastActivity()).w((Object)"</td><td>").w((Object)((RequestQueue.Connection)object).getTimeout()).w((Object)"</td></tr>");
                ++n2;
            }
            spyWriter.endTable();
        }
        super.spy(spyWriter);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.byServlet = new HashMap();
        this.byServletName = new HashMap();
        this.restartTicket = null;
    }

    public BWebService() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$web$BWebService;
        if (clazz == null) {
            clazz = class$javax$baja$web$BWebService = BWebService.class("[Ljavax.baja.web.BWebService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        serviceTypes = new Type[]{TYPE};
        icon = BIcon.std((String)"web.png");
        log = Log.getLog((String)"web");
        BFoxServiceClass = null;
        getFoxsEnabledMthd = null;
        setFoxsEnabledMthd = null;
        try {
            BFoxServiceClass = Sys.getType((String)"fox:FoxService").getTypeClass();
            getFoxsEnabledMthd = BFoxServiceClass.getMethod("getFoxsEnabled", null);
            setFoxsEnabledMthd = BFoxServiceClass.getMethod("setFoxsEnabled", Boolean.TYPE);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            log.trace("fox not installed", (Throwable)exception);
        }
        MEDIA_TYPES = new ArrayList<String>(Arrays.asList("image/bmp", "image/png", "image/gif", "image/ief", "image/jpeg", "image/tiff", "image/svg+xml", "audio/basic", "audio/mp4", "audio/mpeg", "audio/ogg", "audio/vorbis", "audio/x-ms-wma", "audio/x-ms-wax", "audio/vnd.wave", "audio/webm", "video/mpeg", "video/mp4", "video/ogg", "video/quicktime", "video/webm", "video/x-matroska", "video/x-ms-wmv", "video/x-flv"));
        GZIPPED_TYPES = new ArrayList<String>(Arrays.asList("text/plain", "text/html", "text/xml", "text/css", "text/javascript", "application/xml", "application/xhtml+xml", "application/rss+xml", "application/javascript", "application/x-javascript", "application/json"));
    }

    public static class WebHttpCredentialsHandler
    extends BUserService.HttpCredentialsHandler {
        public BUser processCredentials(BHttpFoxCredentials bHttpFoxCredentials, String string) {
            BWebService bWebService = (BWebService)Sys.getService((Type)TYPE);
            BUserService bUserService = (BUserService)Sys.getService((Type)BUserService.TYPE);
            String string2 = bHttpFoxCredentials.getSessionId();
            HttpSession httpSession = bWebService.getHttpSession(string2);
            String string3 = bHttpFoxCredentials.getUsername();
            BUser bUser = bUserService.getGuest();
            if (bUserService.getUser(string3).equals((Object)bUser) && bUserService.canLogin(bUser)) {
                return bUser;
            }
            if (httpSession != null && ((Boolean)httpSession.getAttribute(BWebService.SESSION_INFO_AUTH)).booleanValue()) {
                String string4 = (String)httpSession.getAttribute(BWebService.SESSION_INFO_USER);
                String string5 = (String)httpSession.getAttribute(BWebService.SESSION_INFO_ADDR);
                if (string5 != null && string5.equals(string)) {
                    if (string3 != null && string3.equals(string4)) {
                        return bUserService.getUser(string3);
                    }
                } else {
                    throw new AuthenticationException("IP address doesn't match IP stored in web session");
                }
            }
            throw new AuthenticationException("Authentication failed.");
        }
    }

    static class HttpdSettings
    implements Httpd.Settings {
        private String docRoot;
        private BWebService service;

        public String getDocRoot() {
            return this.docRoot;
        }

        public ServerSocket getHttpServerSocket() throws IOException {
            return new ServerSocket(this.service.getHttpPort(), 10);
        }

        public ServerSocket getHttpsServerSocket() throws IOException {
            try {
                ICryptoManager iCryptoManager = CertManagerFactory.getInstance();
                IServerSocketFactory iServerSocketFactory = iCryptoManager.getServerSocketFactory(this.service.getHttpsMinProtocol(), false, this.service.getHttpsCert());
                return iServerSocketFactory.createServerSocket(this.service.getHttpsPort(), 10);
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                return this.getLegacyHttpsServerSocket();
            }
            catch (ModuleException moduleException) {
                return this.getLegacyHttpsServerSocket();
            }
            catch (TypeException typeException) {
                return this.getLegacyHttpsServerSocket();
            }
            catch (BindException bindException) {
                throw bindException;
            }
            catch (IOException iOException) {
                if (log.isTraceOn()) {
                    iOException.printStackTrace();
                }
                if (!this.service.getHttpEnabled() || this.service.getHttpsOnly()) {
                    log.warning("Unable to start https, enabling http connectivity!");
                    this.service.setHttpEnabled(true);
                    this.service.setHttpsOnly(false);
                }
                throw iOException;
            }
            catch (Exception exception) {
                if (log.isTraceOn()) {
                    exception.printStackTrace();
                }
                if (!this.service.getHttpEnabled() || this.service.getHttpsOnly()) {
                    log.warning("Unable to start https, enabling http connectivity!");
                    this.service.setHttpEnabled(true);
                    this.service.setHttpsOnly(false);
                }
                throw new IOException("Unable to create socket:" + exception.getLocalizedMessage());
            }
        }

        private final ServerSocket getLegacyHttpsServerSocket() throws IOException {
            try {
                BOrd bOrd = BOrd.make((String)"service:crypto:CryptoService|slot:ssl");
                OrdTarget ordTarget = bOrd.resolve((BObject)this.service);
                if (ordTarget == null) {
                    throw new IOException("Legacy crypto service not found.");
                }
                ISocketFactory iSocketFactory = (ISocketFactory)ordTarget.get();
                if (iSocketFactory == null) {
                    throw new IOException("Legacy crypto service not found.");
                }
                return iSocketFactory.createServerSocket(this.service.getHttpsPort(), 10);
            }
            catch (BindException bindException) {
                throw bindException;
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                throw new IOException("Valid crypto service not found.");
            }
        }

        public RequestQueue getRequestQueue() {
            return this.service.requestQueue;
        }

        public boolean isHttpEnabled() {
            return this.service.getHttpEnabled();
        }

        public int getHttpPort() {
            return this.service.getHttpPort();
        }

        public boolean isHttpsEnabled() {
            return this.service.getHttpsEnabled();
        }

        public int getHttpsPort() {
            return this.service.getHttpsPort();
        }

        HttpdSettings(BWebService bWebService, String string) {
            this.docRoot = string;
            this.service = bWebService;
        }
    }

    static class ServletEntry {
        String name;
        BWebServlet servlet;

        ServletEntry(String string, BWebServlet bWebServlet) {
            this.name = string;
            this.servlet = bWebServlet;
        }
    }
}

