/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web;

import javax.baja.log.Log;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatus;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BClientEnvironment;
import javax.baja.web.IWebEnv;
import javax.baja.web.UserAgent;
import javax.baja.web.WebOp;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BUserAgentClientEnvironment
extends BClientEnvironment {
    public static final Property userAgentPattern = BUserAgentClientEnvironment.newProperty((int)0, (String)"", null);
    public static final Type TYPE;
    private static Log envLog;
    private PatternMatcher matcher;
    private Pattern compiledPattern;
    static /* synthetic */ Class class$javax$baja$web$BUserAgentClientEnvironment;

    public String getUserAgentPattern() {
        return this.getString(userAgentPattern);
    }

    public void setUserAgentPattern(String string) {
        this.setString(userAgentPattern, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public abstract Type getWebProfileConfigType();

    public abstract IWebEnv makeWebEnv(WebOp var1);

    public void started() {
        super.started();
        this.initPattern();
        this.enableMixIn();
    }

    public void stopped() {
        this.disableMixIn();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)userAgentPattern)) {
            this.initPattern();
        } else {
            super.changed(property, context);
        }
    }

    public IWebEnv doMatchWebEnv(WebOp webOp) {
        UserAgent userAgent = webOp.getUserAgent();
        if (userAgent == null) {
            return null;
        }
        String string = userAgent.toString();
        if (this.matcher.contains(string, this.compiledPattern)) {
            if (envLog.isTraceOn()) {
                envLog.trace("match: " + string + " -> " + this.getUserAgentPattern());
            }
            return this.makeWebEnv(webOp);
        }
        return null;
    }

    public IWebEnv doGetWebEnv(WebOp webOp) {
        return this.makeWebEnv(webOp);
    }

    private final void initPattern() {
        this.matcher = new Perl5Matcher();
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        int n = 17;
        try {
            this.compiledPattern = perl5Compiler.compile(this.getUserAgentPattern(), n);
            this.updateStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false), "");
        }
        catch (MalformedPatternException malformedPatternException) {
            this.updateStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true), "Invalid expression: '" + this.getUserAgentPattern() + '\'');
        }
    }

    private final void enableMixIn() {
        if (!this.isMounted()) {
            return;
        }
        if (this.getStatus().isFault()) {
            return;
        }
        BComponentSpace bComponentSpace = this.getComponentSpace();
        bComponentSpace.enableMixIn(this.getWebProfileConfigType());
    }

    private final void disableMixIn() {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        bComponentSpace.disableMixIn(this.getWebProfileConfigType());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$web$BUserAgentClientEnvironment;
        if (clazz == null) {
            clazz = class$javax$baja$web$BUserAgentClientEnvironment = BUserAgentClientEnvironment.class("[Ljavax.baja.web.BUserAgentClientEnvironment;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        envLog = Log.getLog((String)"web.env");
    }
}

