/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.servlets;

import com.tridium.web.HttpHeaderUtil;
import com.tridium.web.SnoopHtmlWriter;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.file.BIFile;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BIDynamicFile;
import javax.baja.web.BServletView;
import javax.baja.web.WebOp;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BFileDownloadView
extends BServletView {
    public static final BFileDownloadView INSTANCE = new BFileDownloadView();
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$web$servlets$BFileDownloadView;

    public Type getType() {
        return TYPE;
    }

    public void doGet(WebOp webOp) throws Exception {
        HttpServletResponse httpServletResponse = webOp.getResponse();
        BIFile bIFile = (BIFile)webOp.get();
        if (bIFile instanceof BIDynamicFile) {
            this.writeDynamicFile(webOp, (BIDynamicFile)bIFile);
        } else if (bIFile.getFileName().endsWith(".bog")) {
            httpServletResponse.sendError(403);
        } else {
            this.downloadStaticFile(webOp);
        }
    }

    private final void downloadStaticFile(WebOp webOp) throws IOException {
        HttpServletResponse httpServletResponse = webOp.getResponse();
        BIFile bIFile = (BIFile)webOp.get();
        HttpHeaderUtil.setLastModified(httpServletResponse, bIFile);
        String string = bIFile.getMimeType();
        if (string != null) {
            httpServletResponse.setContentType(string);
        }
        if (this.isHtml(string) || this.isCss(string)) {
            HttpHeaderUtil.setCacheHeader(httpServletResponse, HttpHeaderUtil.MAX_AGE_ONE_DAY);
            this.sendSnoopableFile(webOp);
        } else {
            this.sendFile(webOp);
        }
    }

    private final void sendSnoopableFile(WebOp webOp) throws IOException {
        HttpServletRequest httpServletRequest = webOp.getRequest();
        HttpServletResponse httpServletResponse = webOp.getResponse();
        BIFile bIFile = (BIFile)webOp.get();
        if (!HttpHeaderUtil.isModifiedSince(httpServletRequest, bIFile)) {
            httpServletResponse.sendError(304);
        } else {
            if (webOp.getService().isGzippable(httpServletRequest, bIFile.getMimeType())) {
                httpServletResponse.setHeader("content-encoding", "gzip");
            }
            httpServletResponse.setHeader("transfer-encoding", "chunked");
            this.pipeThroughSnoop(webOp, bIFile);
        }
    }

    private final void sendFile(WebOp webOp) throws IOException {
        HttpServletRequest httpServletRequest = webOp.getRequest();
        HttpServletResponse httpServletResponse = webOp.getResponse();
        BIFile bIFile = (BIFile)webOp.get();
        String string = bIFile.getMimeType();
        if (HttpHeaderUtil.shouldAddExpires(bIFile)) {
            HttpHeaderUtil.setCacheHeader(httpServletResponse, HttpHeaderUtil.MAX_AGE_THREE_DAYS);
        } else if (webOp.getService().isMediaType(string) || "text/javascript".equals(string)) {
            HttpHeaderUtil.setCacheHeader(httpServletResponse, HttpHeaderUtil.MAX_AGE_ONE_DAY);
        }
        if (!HttpHeaderUtil.isModifiedSince(httpServletRequest, bIFile)) {
            httpServletResponse.sendError(304);
        } else {
            this.sendThroughSysServlet(webOp, bIFile);
        }
    }

    private final boolean isHtml(String string) {
        return "text/html".equals(string);
    }

    private final boolean isCss(String string) {
        return "text/css".equals(string);
    }

    private final void writeDynamicFile(WebOp webOp, BIDynamicFile bIDynamicFile) throws Exception {
        String string = bIDynamicFile.getDynamicMimeType();
        if (string == null) {
            string = "text/plain";
        }
        webOp.setContentType(string);
        bIDynamicFile.write(null, (OrdTarget)webOp, webOp.getWriter());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void pipeThroughSnoop(WebOp webOp, BIFile bIFile) throws IOException {
        HttpServletResponse httpServletResponse = webOp.getResponse();
        InputStream inputStream = null;
        try {
            inputStream = bIFile.getInputStream();
            SnoopHtmlWriter.pipe(webOp, inputStream, httpServletResponse.getWriter());
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw throwable;
        }
        {
            Object var6_7 = null;
        }
        try {}
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        if (inputStream == null) return;
        inputStream.close();
    }

    private final void sendThroughSysServlet(WebOp webOp, BIFile bIFile) {
        HttpServletRequest httpServletRequest = webOp.getRequest();
        HttpServletResponse httpServletResponse = webOp.getResponse();
        try {
            webOp.getService().getSysServlet().sendFile(httpServletRequest, httpServletResponse, bIFile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected BFileDownloadView() {
    }

    static {
        Class clazz = class$com$tridium$web$servlets$BFileDownloadView;
        if (clazz == null) {
            clazz = class$com$tridium$web$servlets$BFileDownloadView = BFileDownloadView.class("[Lcom.tridium.web.servlets.BFileDownloadView;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

