/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web;

import com.tridium.net.BHttpScheme;
import com.tridium.net.BHttpsScheme;
import com.tridium.net.HttpUtil;
import com.tridium.web.BHttpTunnel;
import java.io.OutputStream;
import java.net.URL;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.file.BFileScheme;
import javax.baja.log.Log;
import javax.baja.naming.BModuleScheme;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.user.BUser;
import javax.baja.util.BFormat;
import javax.baja.web.BIWebProfile;
import javax.baja.web.BWebService;
import javax.servlet.http.HttpServletRequest;

public class WebUtil {
    public static final Log log = Log.getLog((String)"web");
    public static final String TUNNEL_PATH = "/tunnel/";
    public static final String NIAGARA_TUNNEL_HEADER = "niagara-tunnel";

    public static String getLanguage(HttpServletRequest httpServletRequest, BUser bUser) {
        String string;
        if (bUser != null) {
            string = bUser.getLanguage();
            if (!(string = string.trim()).equals("")) {
                return string;
            }
        }
        if ((string = httpServletRequest.getHeader("Accept-Language")) != null) {
            string = string.trim();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (('a' > c || c > 'z') && ('A' > c || c > 'Z')) break;
                stringBuffer.append(c);
                ++n;
            }
            string = TextUtil.toLowerCase((String)stringBuffer.toString());
        }
        if (string == null || string.equals("")) {
            string = Sys.getLanguage();
        }
        return string;
    }

    public static String getRedirect(HttpServletRequest httpServletRequest, String string) {
        try {
            String string2;
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = TextUtil.toLowerCase((String)httpServletRequest.getScheme());
            stringBuffer.append(string3);
            stringBuffer.append("://");
            stringBuffer.append(httpServletRequest.getServerName());
            int n = httpServletRequest.getServerPort();
            if (!(string3.equals("http") && n == 80 || string3.equals("https") && n == 443)) {
                stringBuffer.append(':').append(n);
            }
            if (!string.startsWith("/")) {
                string2 = httpServletRequest.getRequestURI();
                int n2 = string2.lastIndexOf(47);
                stringBuffer.append(string2.substring(0, n2));
            } else {
                string2 = WebUtil.getAbsolutePathBase(httpServletRequest);
                if (!string2.equals("/") && !string.startsWith(string2)) {
                    if (string2.endsWith("/")) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    stringBuffer.append(string2);
                }
            }
            stringBuffer.append(string);
            string2 = stringBuffer.toString();
            return string2;
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String toUri(OrdTarget ordTarget, HttpServletRequest httpServletRequest, BOrd bOrd) {
        OrdQuery[] ordQueryArray = bOrd.parse();
        if (ordQueryArray.length > 0 && ordQueryArray[0].getBody().length() > 0) {
            if (ordQueryArray[0].getScheme().equals(BFileScheme.INSTANCE.getId())) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(WebUtil.getAbsolutePathBase(httpServletRequest));
                stringBuffer.append("file/");
                if (ordQueryArray[0].getBody().charAt(0) == '!') {
                    stringBuffer.append("!/");
                    stringBuffer.append(ordQueryArray[0].getBody().substring(1));
                } else {
                    stringBuffer.append(ordQueryArray[0].getBody().substring(1));
                }
                return stringBuffer.toString();
            }
            if (ordQueryArray[0].getScheme().equals(BModuleScheme.INSTANCE.getId())) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(WebUtil.getAbsolutePathBase(httpServletRequest));
                stringBuffer.append("module");
                stringBuffer.append(ordQueryArray[0].getBody().substring(1));
                return stringBuffer.toString();
            }
            if (ordQueryArray[0].getScheme().equals(BHttpScheme.INSTANCE.getId()) || ordQueryArray[0].getScheme().equals(BHttpsScheme.INSTANCE.getId())) {
                return bOrd.toString();
            }
        }
        String string = WebUtil.getAbsolutePathBase(httpServletRequest) + "ord?";
        return WebUtil.toUri(ordTarget, string, bOrd);
    }

    public static String toUri(OrdTarget ordTarget, String string, BOrd bOrd) {
        String[] stringArray;
        int n;
        String string2;
        Object object;
        String string3 = bOrd.toString();
        String string4 = HttpUtil.encodeUrl((String)bOrd.relativizeToSession().toString());
        boolean bl = true;
        boolean bl2 = false;
        OrdQuery[] ordQueryArray = bOrd.parse();
        if (string3.startsWith("ip:") && ordTarget != null) {
            object = ordTarget.getOrd().parse();
            if (((OrdQuery[])object).length > 1 && ordQueryArray.length > 1) {
                if (!object[0].toString().equals(ordQueryArray[0].toString())) {
                    bl = false;
                }
                if (!object[1].toString().equals(ordQueryArray[1].toString())) {
                    bl = false;
                }
            }
            bl2 = true;
        }
        object = "";
        boolean bl3 = false;
        if (ordQueryArray != null) {
            int n2 = ordQueryArray.length - 1;
            while (n2 >= 0) {
                if (ordQueryArray[n2] != null && (string2 = ordQueryArray[n2].toString()) != null && (string2.startsWith("fox:") || string2.startsWith("foxs:"))) {
                    String string5;
                    if (!bl3) {
                        bl3 = string2.startsWith("foxs:");
                    }
                    if ((string5 = ordQueryArray[n2].getBody()).length() <= 0 || (n = string5.indexOf(47)) < 0) break;
                    string5 = string5.substring(n);
                    stringArray = TextUtil.splitAndTrim((String)string5, (char)'/');
                    String string6 = null;
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        if (stringArray[n3] != null && !stringArray[n3].equals("")) {
                            int n4;
                            int n5;
                            String string7 = BHttpTunnel.parseHost(stringArray[n3]);
                            String string8 = (String)object + TUNNEL_PATH + string7 + ':';
                            int n6 = string.indexOf(string8);
                            if (n6 >= 0) {
                                n5 = n6 + string8.length();
                                n4 = string.indexOf("/", n5);
                                if (n4 < 0) {
                                    n4 = string.length();
                                }
                                string7 = string7 + ':' + string.substring(n5, n4);
                            } else {
                                if (string6 == null) {
                                    string6 = string;
                                    string6 = TextUtil.replace((String)string6, (String)"%5B", (String)"[");
                                    string6 = TextUtil.replace((String)string6, (String)"%5b", (String)"[");
                                    string6 = TextUtil.replace((String)string6, (String)"%5D", (String)"]");
                                    string6 = TextUtil.replace((String)string6, (String)"%5d", (String)"]");
                                }
                                if ((n6 = string6.indexOf(string8)) >= 0) {
                                    n5 = n6 + string8.length();
                                    n4 = string6.indexOf("/", n5);
                                    if (n4 < 0) {
                                        n4 = string6.length();
                                    }
                                    string7 = string7 + ':' + string6.substring(n5, n4);
                                }
                            }
                            object = (String)object + TUNNEL_PATH + string7;
                        }
                        ++n3;
                    }
                    break;
                }
                --n2;
            }
        }
        String string9 = WebUtil.parseTunnelPrefix(string);
        string2 = string.substring(string9.length());
        if (bl2) {
            string = (String)object + string2;
        } else {
            int n7 = object.length();
            if (n7 > 0 && (n = string9.indexOf((String)object)) >= 0 && (stringArray = string9.substring(n + n7)).indexOf(TUNNEL_PATH) < 0) {
                object = "";
            }
            string = string9 + (String)object + string2;
        }
        if (bl) {
            return string + string4;
        }
        OrdQuery[] ordQueryArray2 = bOrd.parse();
        StringBuffer stringBuffer = new StringBuffer();
        if (bl3) {
            stringBuffer.append("https://");
        } else {
            stringBuffer.append("http://");
        }
        stringArray = ordQueryArray2[0].getBody();
        if (stringArray.indexOf(58) != stringArray.lastIndexOf(58) && !stringArray.startsWith("[") && !stringArray.endsWith("]")) {
            stringBuffer.append("[").append((String)stringArray).append("]");
        } else {
            stringBuffer.append((String)stringArray);
        }
        stringBuffer.append(string);
        stringBuffer.append(string4);
        return stringBuffer.toString();
    }

    public static String toUri(OrdTarget ordTarget, String string, BOrd bOrd, URL uRL) {
        if (string.startsWith("/")) {
            string = WebUtil.parseTunnelPrefix(uRL) + string;
        }
        return WebUtil.toUri(ordTarget, string, bOrd);
    }

    public static String getLogo(BWebService bWebService) {
        BValue bValue = bWebService.get("logo");
        if (bValue == null) {
            return null;
        }
        return bValue.toString();
    }

    public static String getStationDisplayName(Context context) {
        BStation bStation = Sys.getStation();
        BValue bValue = bStation.get("displayName");
        if (bValue == null) {
            return bStation.getStationName();
        }
        if (bValue instanceof BString) {
            String string = ((BString)bValue).getString();
            if (string.length() == 0) {
                return null;
            }
            return string;
        }
        if (bValue instanceof BFormat) {
            BFormat bFormat = (BFormat)bValue;
            if (bFormat.getFormat().length() == 0) {
                return null;
            }
            try {
                String string = bFormat.format((Object)bStation, context);
                if (string.length() == 0) {
                    return null;
                }
                return string;
            }
            catch (Exception exception) {
                return "Error: " + exception.getClass().getName() + ": " + exception.getMessage();
            }
        }
        return "Error: displayName must be one of { BString, BFormat }";
    }

    public static String getAbsolutePathBase(HttpServletRequest httpServletRequest) {
        String string;
        String string2 = string = httpServletRequest != null ? httpServletRequest.getHeader(NIAGARA_TUNNEL_HEADER) : null;
        if (string != null && string.length() > 0) {
            return string + '/';
        }
        return "/";
    }

    public static String parseTunnelPrefix(URL uRL) {
        if (uRL != null) {
            return WebUtil.parseTunnelPrefix(uRL.getPath());
        }
        return "";
    }

    public static String parseTunnelPrefix(String string) {
        String string2 = "";
        if (string == null) {
            return string2;
        }
        String string3 = string;
        while (string3 != null && string3.startsWith(TUNNEL_PATH)) {
            string3 = string3.substring(TUNNEL_PATH.length());
            int n = string3.indexOf("/");
            String string4 = null;
            if (n >= 0) {
                string4 = string3.substring(0, n);
                string3 = string3.substring(n);
            } else {
                string4 = string3.substring(0, string3.length());
                string3 = null;
            }
            string2 = string2 + TUNNEL_PATH + string4;
        }
        return string2;
    }

    public static void closeOutputStream(OutputStream outputStream) {
        block3: {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Throwable throwable) {
                if (!log.isTraceOn()) break block3;
                log.trace("Cannot close OutputStream", throwable);
            }
        }
    }

    public static class ProfileFilter
    extends AgentFilter {
        BIWebProfile profile;
        BObject target;

        public boolean include(AgentInfo agentInfo) {
            if (!this.profile.hasView(this.target, agentInfo)) {
                return false;
            }
            if (agentInfo.getAppName() != null) {
                String[] stringArray = this.profile.getAppNames();
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].equals(agentInfo.getAppName())) {
                        return true;
                    }
                    ++n;
                }
                return false;
            }
            return true;
        }

        public ProfileFilter(BIWebProfile bIWebProfile, BObject bObject) {
            this.profile = bIWebProfile;
            this.target = bObject;
        }
    }
}

