/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web;

import com.tridium.httpd.CookieUtil;
import com.tridium.net.HttpUtil;
import com.tridium.user.BUserPasswordConfiguration;
import com.tridium.web.BHttpAuthAgent;
import com.tridium.web.BHttpUsernamePasswordAuthAgent;
import com.tridium.web.NWebOp;
import com.tridium.web.PxViewFilter;
import com.tridium.web.SysServlet;
import com.tridium.web.UserAndCredentials;
import com.tridium.web.WebEnv;
import com.tridium.web.WebProcessException;
import com.tridium.web.WebUtil;
import java.io.IOException;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.file.BExporter;
import javax.baja.file.ExportOp;
import javax.baja.log.Log;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BLocalScheme;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.naming.ViewQuery;
import javax.baja.security.BPermissions;
import javax.baja.spy.BSpy;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.web.BAuthenticationType;
import javax.baja.web.BIWebProfile;
import javax.baja.web.BServletView;
import javax.baja.web.BWebService;
import javax.baja.web.BWebServlet;
import javax.baja.web.IWebEnv;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WebProcess {
    static Log webLog = Log.getLog((String)"web");
    static Log uriLog = Log.getLog((String)"web.uri");
    static Log ordLog = Log.getLog((String)"web.ord");
    static Log authLog = Log.getLog((String)"web.auth");
    static Log targetLog = Log.getLog((String)"web.target");
    static Log viewListLog = Log.getLog((String)"web.viewList");
    static Log viewLog = Log.getLog((String)"web.view");
    private final SysServlet sys;
    private final BWebService webService;
    private final BUserService userService;
    private final HttpServletRequest req;
    private final HttpServletResponse resp;
    private String serverName;
    private String path;
    private String query;
    private String uri;
    private BOrd ord;
    private BWebServlet servlet;
    private BUser user;
    private boolean isGuest;
    private OrdTarget ordTarget;
    private BObject target;
    private NWebOp op;
    private IWebEnv env;
    private AgentList allViews;
    private AgentList hasViews;
    private AgentInfo viewInfo;
    private BObject view;
    static /* synthetic */ Class class$com$tridium$user$BUserPasswordConfiguration;

    /*
     * Unable to fully structure code
     */
    public void service() throws WebProcessException {
        try {
            block24: {
                var1_1 = null;
                this.toUri();
                this.resp.setDateHeader("Date", Clock.millis());
                this.resp.setDateHeader("Expires", 0L);
                this.resp.setHeader("cache-control", "private, must-revalidate");
                if (this.redirectToHttps()) {
                    return;
                }
                if (!this.sys.serviceSpecial(this.req, this.resp)) break block24;
                return;
                {
                    catch (Throwable var2_5) {
                        var1_1 = var2_5;
lbl15:
                        // 2 sources

                        try {
                            this.toOrd();
                        }
                        catch (Throwable var2_6) {
                            var1_1 = var2_6;
                        }
                        try {
                            this.authenticate();
                        }
                        catch (Throwable var2_8) {
                            var1_1 = var2_8;
                        }
                        try {
                            this.resolve();
                        }
                        catch (Throwable var2_9) {
                            var1_1 = var2_9;
                        }
                        if (this.challenge()) {
                            return;
                        }
                        if (this.sys.serviceSpecialWb(this.req, this.resp)) {
                            return;
                        }
                        if (var1_1 != null) {
                            throw var1_1;
                        }
                        this.toWebOp();
                        this.toWebEnv();
                        if (this.redirectToHome()) {
                            return;
                        }
                        if (this.serviceWebServlet()) {
                            return;
                        }
                        this.checkLicense();
                        this.toViewList();
                        this.toViewInfo();
                        this.checkViewPermission();
                        if (this.serviceWbView()) {
                            return;
                        }
                        this.toView();
                        if (this.serviceExporter()) {
                            return;
                        }
                        if (this.serviceServletView()) {
                            return;
                        }
                        throw new WebProcessException(404, "View is not web enabled");
                    }
                }
            }
            try {
                ** GOTO lbl15
            }
            catch (SyntaxException var1_3) {
                WebProcess.webLog.trace("Invalid ORD syntax: " + this.req.getQueryString());
                throw new WebProcessException(404, var1_3);
            }
        }
        catch (Throwable var1_4) {
            WebProcess.webLog.error("Internal Server Error", var1_4);
            throw new WebProcessException(500, var1_4);
        }
    }

    void toUri() {
        this.path = this.req.getRequestURI();
        this.query = this.req.getQueryString();
        this.uri = this.path;
        if (this.query != null && this.query.length() > 0) {
            this.uri = this.uri + '?' + this.query;
        }
        this.serverName = this.req.getServerName();
        if (uriLog.isTraceOn()) {
            uriLog.trace(this.req.getMethod() + ' ' + this.uri);
        }
    }

    public boolean redirectToHttps() throws Exception {
        if (this.req.getScheme().equals("https")) {
            return false;
        }
        if (!this.webService.getHttpsOnly() || !this.webService.getHttpsEnabled()) {
            return false;
        }
        int n = this.webService.getHttpsPort();
        String string = "https://" + this.serverName + ':' + n + this.uri;
        this.resp.sendRedirect(string);
        return true;
    }

    public void authenticate() throws Exception {
        UserAndCredentials userAndCredentials;
        BUserService bUserService = BUserService.getService();
        if (bUserService == null) {
            this.resp.sendError(503);
            return;
        }
        BHttpAuthAgent bHttpAuthAgent = (BHttpAuthAgent)bUserService.getAuthAgent(BHttpAuthAgent.TYPE);
        if (bHttpAuthAgent == null) {
            bHttpAuthAgent = BHttpUsernamePasswordAuthAgent.INSTANCE;
        }
        if ((userAndCredentials = bHttpAuthAgent.doWebProcessAuth(this.req, this.resp)) != null) {
            this.user = userAndCredentials.getUser();
            this.isGuest = this.user == this.userService.getGuestUser();
            if (!this.isGuest) {
                this.req.getSession().setAttribute("sessionInfoAddr", this.req.getRemoteAddr());
                this.req.getSession().setAttribute("sessionInfoUser", this.user.getUsername());
                this.req.getSession().setAttribute("sessionInfoAuth", new Boolean(true));
            }
        } else {
            this.user = this.userService.getGuestUser();
            this.isGuest = true;
        }
    }

    private final void toOrd() throws Exception {
        BOrd bOrd = this.toOrdImpl();
        if (bOrd == null) {
            throw new WebProcessException(404);
        }
        bOrd.normalize();
        OrdQuery[] ordQueryArray = bOrd.parse();
        int n = 0;
        while (n < ordQueryArray.length) {
            if (ordQueryArray[n].getScheme().equals("sql")) {
                throw new WebProcessException(500, "SQL ORD Scheme not allowed");
            }
            ++n;
        }
        this.ord = bOrd;
        if (ordLog.isTraceOn()) {
            ordLog.trace(this.ord.toString());
        }
    }

    private static final String decodeUrl(String string) throws WebProcessException {
        return HttpUtil.decodeUrl((String)string);
    }

    private final BOrd toOrdImpl() throws WebProcessException {
        if (this.uri.equals("/")) {
            return BLocalScheme.ORD;
        }
        if (this.path.equals("/ord")) {
            if (this.query == null) {
                this.query = "";
            }
            return BOrd.make((String)WebProcess.decodeUrl(this.query));
        }
        if (this.path.startsWith("/ord/")) {
            return BOrd.make((String)WebProcess.decodeUrl(this.path.substring("/ord/".length())));
        }
        if (this.path.startsWith("/file/")) {
            String string = this.path.substring("/file/".length());
            if (string.startsWith("stations")) {
                return BOrd.make((String)("file:!" + WebProcess.decodeUrl(this.path.substring("/file/".length()))));
            }
            if (string.startsWith("!")) {
                if (string.startsWith("!/")) {
                    return BOrd.make((String)("file:!" + WebProcess.decodeUrl(this.path.substring("/file/!/".length()))));
                }
                return BOrd.make((String)"file:!");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("file:^");
            stringBuffer.append(WebProcess.decodeUrl(this.path.substring("/file/".length())));
            return BOrd.make((String)stringBuffer.toString());
        }
        if (this.path.equals("/file")) {
            return BOrd.make((String)"file:^");
        }
        if (this.path.startsWith("/module/")) {
            return BOrd.make((String)("module://" + WebProcess.decodeUrl(this.path.substring("/module/".length()))));
        }
        int n = this.path.indexOf(47, 1);
        String string = n < 0 ? this.path.substring(1) : this.path.substring(1, n);
        BWebServlet bWebServlet = this.webService.getServletByName(string);
        if (bWebServlet != null) {
            return bWebServlet.getAbsoluteOrd();
        }
        return null;
    }

    private final void resolve() throws Exception {
        if (this.ord == null) {
            return;
        }
        try {
            BasicContext basicContext = new BasicContext(this.user, WebUtil.getLanguage(this.req, this.user));
            if (this.user != null) {
                basicContext = new BasicContext((Context)basicContext, BFacets.make((String)"username", (BIDataValue)BString.make((String)this.user.getUsername())));
            }
            this.ordTarget = this.ord.resolve((BObject)BLocalHost.INSTANCE, (Context)basicContext);
            this.target = this.ordTarget.get();
            if (this.target instanceof BWebServlet) {
                this.servlet = (BWebServlet)this.target;
                NWebOp nWebOp = new NWebOp(this.ordTarget, this.sys.service, this.req, this.resp);
                nWebOp.fw((Object)this.servlet);
                this.ordTarget = this.servlet.resolve(nWebOp);
                this.target = this.ordTarget.get();
            }
        }
        catch (UnresolvedException unresolvedException) {
            throw new WebProcessException(404);
        }
        if (targetLog.isTraceOn()) {
            targetLog.trace(this.target.toDebugString());
        }
    }

    public boolean challenge() throws Exception {
        Object object;
        if (!this.isGuest) {
            return this.handlePasswordReset();
        }
        if (this.userService.canLogin(this.user)) {
            if (this.ordTarget == null) {
                this.ordTarget = BLocalHost.INSTANCE.getAbsoluteOrd().resolve();
            }
            if ((object = this.ordTarget.getPermissionsForTarget()).hasOperatorRead()) {
                return false;
            }
        }
        if (this.webService.getAuthenticationScheme() == BAuthenticationType.basic) {
            if (authLog.isTraceOn()) {
                authLog.trace("  Challenge: basic");
            }
            object = Sys.getStation().getStationName();
            this.resp.setHeader("WWW-Authenticate", "Basic realm=\"" + (String)object + '\"');
            this.resp.sendError(401);
            return true;
        }
        if (authLog.isTraceOn()) {
            authLog.trace("  Challenge: cookie");
        }
        if (!this.path.equals("/") && this.req.getMethod().equals("GET") && this.webService.isValidCookieRedirect(this.uri)) {
            object = CookieUtil.getCookieName(this.req, "niagara_uri");
            Cookie cookie = new Cookie((String)object, this.uri);
            cookie.setPath("/");
            this.resp.addCookie(cookie);
        }
        this.resp.sendRedirect(WebUtil.getRedirect(this.req, "/login"));
        return true;
    }

    private final boolean handlePasswordReset() throws IOException {
        if (this.userService.canUsePasswordFeatures(this.user)) {
            BUserPasswordConfiguration[] bUserPasswordConfigurationArray;
            Class clazz = class$com$tridium$user$BUserPasswordConfiguration;
            if (clazz == null) {
                clazz = class$com$tridium$user$BUserPasswordConfiguration = WebProcess.class("[Lcom.tridium.user.BUserPasswordConfiguration;", false);
            }
            if ((bUserPasswordConfigurationArray = (BUserPasswordConfiguration[])this.user.getChildren(clazz)).length > 0 && bUserPasswordConfigurationArray[0].getForceResetAtNextLogin()) {
                String string = CookieUtil.getCookieName(this.req, "niagara_login_state");
                Cookie cookie = new Cookie(string, String.valueOf(3));
                cookie.setPath("/");
                this.resp.addCookie(cookie);
                this.resp.sendRedirect(WebUtil.getAbsolutePathBase(this.req) + "login");
                return true;
            }
        }
        return false;
    }

    private final boolean redirectToHome() throws Exception {
        if (!this.path.equals("/")) {
            return false;
        }
        BOrd bOrd = this.env.getHomePage(this.op);
        this.resp.sendRedirect(WebUtil.getRedirect(this.req, WebUtil.toUri(this.ordTarget, this.req, bOrd)));
        return true;
    }

    private final void toWebOp() throws Exception {
        this.op = new NWebOp(this.ordTarget, this.sys.service, this.req, this.resp);
        if (this.servlet != null) {
            this.op.fw((Object)this.servlet);
        }
    }

    private final boolean serviceWebServlet() throws Exception {
        if (this.servlet == null) {
            return false;
        }
        if (!this.op.getPermissionsForTarget().hasOperatorRead()) {
            throw new WebProcessException(403);
        }
        if (!this.servlet.getEnabled()) {
            throw new WebProcessException(410);
        }
        this.servlet.service(this.op);
        return true;
    }

    private final void toWebEnv() throws WebProcessException {
        this.env = this.op.initWebEnv();
    }

    private final void checkLicense() throws Exception {
        if (!this.isLicensed()) {
            viewLog.warning("Unlicensed: " + this.ord);
            throw new WebProcessException(403);
        }
    }

    private final boolean isLicensed() {
        BIWebProfile bIWebProfile;
        if (this.target instanceof BSpy) {
            return true;
        }
        if (!this.sys.licenseUi()) {
            return false;
        }
        return this.sys.licenseWb() || WebEnv.wbProfile == null || (bIWebProfile = this.env.getWebProfile(this.op)) == null || !bIWebProfile.getType().is(WebEnv.wbProfile);
    }

    private final void toViewList() throws Exception {
        this.allViews = this.env.getViews(this.op);
        if (this.allViews.size() == 0) {
            throw new WebProcessException(403, "No views available.");
        }
        AgentFilter agentFilter = AgentFilter.has((BPermissions)this.op.getPermissionsForTarget());
        WebUtil.ProfileFilter profileFilter = new WebUtil.ProfileFilter(this.env.getWebProfile(this.op), this.op.get());
        this.op.views = this.hasViews = this.allViews.filter(AgentFilter.and((AgentFilter)AgentFilter.and((AgentFilter)agentFilter, (AgentFilter)new PxViewFilter((OrdTarget)this.op)), (AgentFilter)profileFilter));
        if (this.allViews.size() > 0 && this.hasViews.size() == 0) {
            if (authLog.isTraceOn()) {
                authLog.trace("  Forbidden allViews.size=" + this.allViews.size());
            }
            throw new WebProcessException(403);
        }
        if (viewListLog.isTraceOn()) {
            viewListLog.trace(this.hasViews.toString());
        }
    }

    private final void toViewInfo() {
        ViewQuery viewQuery = this.ordTarget.getViewQuery();
        if (viewQuery != null && viewQuery.getViewId() != null) {
            this.viewInfo = this.env.getView(this.allViews, viewQuery.getViewId());
        }
        if (this.viewInfo == null) {
            this.viewInfo = this.env.getDefaultView(this.op, this.hasViews);
        }
        this.viewInfo = this.env.translate(this.viewInfo);
        if (viewLog.isTraceOn()) {
            viewLog.trace(this.viewInfo.toString());
        }
    }

    private final void checkViewPermission() throws Exception {
        BPermissions bPermissions;
        BPermissions bPermissions2 = this.op.getPermissionsForTarget();
        if (!bPermissions2.has(bPermissions = this.viewInfo.getRequiredPermissions())) {
            if (authLog.isTraceOn()) {
                authLog.trace("  Forbidden '" + bPermissions2 + "' < '" + bPermissions + '\'');
            }
            throw new WebProcessException(403);
        }
    }

    private final boolean serviceWbView() throws Exception {
        if (this.viewInfo.getAgentType().is(WebEnv.pxView)) {
            this.sys.wbServlet.serviceView(this.viewInfo, this.op);
            return true;
        }
        if (WebEnv.wbView != null && this.viewInfo.getAgentType().is(WebEnv.wbView)) {
            this.sys.wbServlet.serviceView(this.viewInfo, this.op);
            return true;
        }
        return false;
    }

    private final void toView() throws Exception {
        this.view = this.viewInfo.getInstance();
    }

    private final boolean serviceExporter() throws Exception {
        if (this.view instanceof BExporter) {
            BExporter bExporter = (BExporter)this.view;
            this.resp.setContentType(bExporter.getFileMimeType());
            bExporter.export((ExportOp)this.op);
            return true;
        }
        return false;
    }

    private final boolean serviceServletView() throws Exception {
        if (this.view instanceof BServletView) {
            ((BServletView)this.view).service(this.op);
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.ord = null;
        this.ordTarget = null;
    }

    public WebProcess(SysServlet sysServlet, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.this();
        this.sys = sysServlet;
        this.req = httpServletRequest;
        this.resp = httpServletResponse;
        this.webService = sysServlet.service;
        this.userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
    }
}

