/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web;

import com.tridium.sys.Nre;
import com.tridium.sys.module.NModule;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.sys.registry.NRegistry;
import com.tridium.web.BHttpAuthAgent;
import com.tridium.web.BHttpUsernamePasswordAuthAgent;
import com.tridium.web.HttpHeaderUtil;
import com.tridium.web.SysServlet;
import com.tridium.web.UserAndCredentials;
import com.tridium.web.WebUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.baja.agent.AgentInfo;
import javax.baja.file.BIFile;
import javax.baja.file.FileUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.registry.LexiconInfo;
import javax.baja.registry.ModuleInfo;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.IKeyStore;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BSimple;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.TimeZoneDatabase;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BFormat;
import javax.baja.web.BWebProfileConfig;
import javax.baja.web.BWebService;
import javax.baja.web.UserAgent;
import javax.baja.web.WebOp;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WbServlet {
    static Log log = Log.getLog((String)"web.wb");
    static final String jarMimeType = "application/java-archive";
    static final String niagaraZipMimeType = "application/x-niagara-zip";
    SysServlet sys;
    static /* synthetic */ Class class$java$security$cert$X509Certificate;

    public void service(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!this.sys.licenseWb()) {
            httpServletResponse.sendError(403);
            return;
        }
        if ((string = string.toLowerCase()).startsWith("/wbapplet") && string.endsWith(".jar")) {
            this.downloadAppletJar(httpServletRequest, httpServletResponse);
            return;
        }
        HttpHeaderUtil.neverCache(httpServletResponse);
        if (string.equals("/wb/keepalive")) {
            this.writeOneSpace(httpServletResponse);
        } else if (string.equals("/wb/module")) {
            this.downloadModule(httpServletRequest, httpServletResponse);
        } else if (string.equals("/wb/modulelist")) {
            this.downloadModuleList(httpServletRequest, httpServletResponse);
        } else if (string.startsWith("/wb/lexiconmodulelist")) {
            this.downloadLexiconModuleList(httpServletRequest, httpServletResponse);
        } else if (string.equals("/wb/extlist")) {
            this.downloadExtList(httpServletRequest, httpServletResponse);
        } else if (string.equals("/wb/tzversion")) {
            this.downloadTimeZonesVersion(httpServletRequest, httpServletResponse);
        } else if (string.equals("/wb/tz")) {
            this.downloadTimeZonesDb(httpServletRequest, httpServletResponse);
        } else if (string.startsWith("/wb/readzip/")) {
            this.downloadZip(httpServletRequest, httpServletResponse);
        } else if (string.startsWith("/wb/logon")) {
            this.logon(httpServletRequest, httpServletResponse);
        } else if (string.equals("/wb/facetkeys")) {
            this.downloadFacetKeys(httpServletRequest, httpServletResponse);
        } else if (string.startsWith("/wb/ext/")) {
            this.downloadExtJar(httpServletRequest, httpServletResponse);
        } else {
            log.error("Unknown wb req: " + string);
            httpServletResponse.sendError(404);
        }
    }

    private final void writeOneSpace(HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentLength(1);
        httpServletResponse.getWriter().write(32);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void downloadAppletJar(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        try {
            BIFile bIFile = (BIFile)BOrd.make((String)"module://web/wbapplet/wbapplet.jar").get();
            httpServletResponse.setContentType(jarMimeType);
            httpServletResponse.setContentLength((int)bIFile.getSize());
            InputStream inputStream = bIFile.getInputStream();
            ServletOutputStream servletOutputStream = null;
            try {
                servletOutputStream = httpServletResponse.getOutputStream();
                FileUtil.pipe((InputStream)inputStream, (long)bIFile.getSize(), (OutputStream)servletOutputStream);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                WebUtil.closeOutputStream(servletOutputStream);
                inputStream.close();
                throw throwable;
            }
            {
                Object var7_9 = null;
                WebUtil.closeOutputStream(servletOutputStream);
                inputStream.close();
                return;
            }
        }
        catch (UnresolvedException unresolvedException) {
            httpServletResponse.sendError(404, "wbapplet not found, check module content filter");
            BWebService.log.warning("wbapplet not found, check module content filter");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void downloadModule(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("name");
        if (string == null) {
            throw new SyntaxException("missing name param");
        }
        if (!new File(string.replace('\u0000', 'x')).getName().equals(string)) {
            throw new SyntaxException("invalid name param");
        }
        File file = new File(Sys.getBajaHome(), "modules" + File.separator + string + ".jar");
        if (this.preDownload(httpServletRequest, httpServletResponse, file)) {
            return;
        }
        log.trace("downloadModule: " + file);
        httpServletResponse.setContentType(jarMimeType);
        ZipFile zipFile = new ZipFile(file);
        int n = 0;
        int n2 = 0;
        ZipOutputStream zipOutputStream = new ZipOutputStream(httpServletResponse.getOutputStream());
        try {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (true) {
                block7: {
                    if (enumeration.hasMoreElements()) break block7;
                    zipOutputStream.flush();
                    break;
                }
                ZipEntry zipEntry = enumeration.nextElement();
                String string2 = zipEntry.getName();
                ++n;
                if (string2.startsWith("doc")) continue;
                ++n2;
                zipOutputStream.putNextEntry(new ZipEntry(string2));
                long l = zipEntry.getSize();
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                FileUtil.pipe((InputStream)inputStream, (long)l, (OutputStream)zipOutputStream);
                inputStream.close();
                zipOutputStream.closeEntry();
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            WebUtil.closeOutputStream(zipOutputStream);
            zipFile.close();
            throw throwable;
        }
        {
            Object var10_16 = null;
        }
        WebUtil.closeOutputStream(zipOutputStream);
        zipFile.close();
        log.trace("  sent " + n2 + " of " + n);
    }

    void downloadModuleList(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        httpServletResponse.setContentType("text/plain");
        PrintWriter printWriter = httpServletResponse.getWriter();
        ModuleInfo[] moduleInfoArray = Sys.getRegistry().getModules();
        int n = 0;
        while (n < moduleInfoArray.length) {
            NModuleInfo nModuleInfo = (NModuleInfo)moduleInfoArray[n];
            printWriter.println(nModuleInfo.getModuleName() + '=' + nModuleInfo.getVendorVersion() + ';' + nModuleInfo.getBuildTime());
            ++n;
        }
    }

    void downloadLexiconModuleList(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getParameter("locale");
        if (string == null) {
            throw new IOException("missing locale param");
        }
        NRegistry nRegistry = (NRegistry)Sys.getRegistry();
        LexiconInfo[] lexiconInfoArray = nRegistry.getLexicons();
        httpServletResponse.setContentType("text/plain");
        PrintWriter printWriter = httpServletResponse.getWriter();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < lexiconInfoArray.length) {
            String string2;
            LexiconInfo lexiconInfo = lexiconInfoArray[n];
            if (lexiconInfo.getLanguage().equals(string) && !arrayList.contains(string2 = lexiconInfo.getContainerModuleName())) {
                arrayList.add(string2);
                NModuleInfo nModuleInfo = (NModuleInfo)nRegistry.getModule(string2);
                printWriter.println(nModuleInfo.getModuleName() + '=' + nModuleInfo.getVendorVersion() + ';' + nModuleInfo.getBuildTime());
            }
            ++n;
        }
    }

    void downloadExtList(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        File[] fileArray;
        Object object;
        httpServletResponse.setContentType("text/plain");
        PrintWriter printWriter = httpServletResponse.getWriter();
        File file = new File(Sys.getBajaHome(), "bin/nre.jar");
        NModule nModule = Nre.moduleManager.makeModule(file);
        printWriter.println("nre-" + nModule.getVendorVersion() + ".jar=bin;" + file.lastModified());
        File file2 = new File(Sys.getBajaHome(), "bin/cryptoCore.jar");
        if (file2.exists()) {
            object = Nre.moduleManager.makeModule(file2);
            printWriter.println("cryptoCore-" + object.getVendorVersion() + ".jar=bin;" + file2.lastModified());
        }
        if ((fileArray = ((File)(object = new File(Sys.getBajaHome(), "bin/ext/"))).listFiles()) != null) {
            int n = 0;
            while (n < fileArray.length) {
                printWriter.println(fileArray[n].getName() + "=bin/ext;" + fileArray[n].lastModified());
                ++n;
            }
        }
    }

    void downloadExtJar(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getRequestURI();
        String string2 = string.substring(string.lastIndexOf("/") + 1);
        File file = null;
        file = string2.startsWith("nre") && string2.endsWith(".jar") ? new File(Sys.getBajaHome(), "bin/nre.jar") : (string2.startsWith("cryptoCore") && string2.endsWith(".jar") ? new File(Sys.getBajaHome(), "bin/cryptoCore.jar") : new File(Sys.getBajaHome(), "bin/ext/" + string2));
        if (file != null && file.exists()) {
            try {
                this.download(httpServletRequest, httpServletResponse, file, jarMimeType, false);
            }
            catch (SocketException socketException) {}
        } else {
            httpServletResponse.sendError(404);
        }
    }

    void downloadTimeZonesVersion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        httpServletResponse.setContentType("text/plain");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println(TimeZoneDatabase.getManifest().getVersion().toString());
    }

    void downloadTimeZonesDb(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        File file = new File(Sys.getBajaHome(), "lib" + File.separator + "timezones.jar");
        if (this.preDownload(httpServletRequest, httpServletResponse, file)) {
            return;
        }
        try {
            this.download(httpServletRequest, httpServletResponse, file, "application/zip", false);
        }
        catch (SocketException socketException) {}
    }

    void downloadZip(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getRequestURI();
        String string2 = string.substring("/wb/readzip".length() + 1);
        if (string2.indexOf("..") < 0 && (string2.startsWith("lexicon/") || string2.startsWith("registry/") || string2.startsWith("lib/"))) {
            string2 = string2.replace('/', File.separatorChar);
            File file = new File(Sys.getBajaHome(), string2);
            try {
                this.download(httpServletRequest, httpServletResponse, file, niagaraZipMimeType, false);
            }
            catch (SocketException socketException) {}
            return;
        }
        httpServletResponse.sendError(404);
    }

    void downloadFacetKeys(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        File file = new File(Sys.getBajaHome(), "workbench" + File.separator + "facetKeys.properties");
        if (this.preDownload(httpServletRequest, httpServletResponse, file)) {
            return;
        }
        try {
            this.download(httpServletRequest, httpServletResponse, file, "text/plain", false);
        }
        catch (SocketException socketException) {}
    }

    void logon(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        BWebService bWebService = (BWebService)Sys.getService((Type)BWebService.TYPE);
        BUserService bUserService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BUser bUser = null;
        BUserService bUserService2 = BUserService.getService();
        if (bUserService2 == null) {
            httpServletResponse.sendError(503);
            return;
        }
        BHttpAuthAgent bHttpAuthAgent = (BHttpAuthAgent)bUserService2.getAuthAgent(BHttpAuthAgent.TYPE);
        if (bHttpAuthAgent == null) {
            bHttpAuthAgent = BHttpUsernamePasswordAuthAgent.INSTANCE;
        }
        UserAndCredentials userAndCredentials = bHttpAuthAgent.doWebProcessAuth(httpServletRequest, httpServletResponse);
        bUser = userAndCredentials.getUser();
        boolean bl = bWebService.getSingleSignOnEnabled();
        if (!bl) {
            this.removeAuthCookies(httpServletRequest, httpServletResponse);
        }
        BWebProfileConfig bWebProfileConfig = (BWebProfileConfig)bUser.getMixIn(BWebProfileConfig.TYPE);
        BComponent bComponent = Sys.getService((Type)Sys.getType((String)"fox:FoxService"));
        httpServletResponse.setContentType("text/plain");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.print("username=" + bUser.getUsername() + '\n');
        BInteger bInteger = (BInteger)bComponent.get("port");
        if (httpServletRequest.getScheme().equalsIgnoreCase("https") && !System.getProperty("java.vm.name").equals("J9")) {
            printWriter.print("useFoxs=true\n");
            object = (BBoolean)bComponent.get("foxsEnabled");
            if (object.isActive()) {
                bInteger = (BInteger)bComponent.get("foxsPort");
                BString bString = (BString)bComponent.get("foxsCert");
                IKeyStore iKeyStore = CertManagerFactory.getInstance().getKeyStore();
                X509Certificate x509Certificate = iKeyStore.getCertificate(bString.getString());
                try {
                    Class clazz = Sys.loadClass((String)"platCrypto", (String)"com.tridium.crypto.core.cert.NX509Certificate");
                    Class[] classArray = new Class[1];
                    Class clazz2 = class$java$security$cert$X509Certificate;
                    if (clazz2 == null) {
                        clazz2 = class$java$security$cert$X509Certificate = WbServlet.class("[Ljava.security.cert.X509Certificate;", false);
                    }
                    classArray[0] = clazz2;
                    Method method = clazz.getMethod("extractSHA1Fingerprint", classArray);
                    String string = (String)method.invoke(null, x509Certificate);
                    printWriter.print("sha1FingerPrint=" + string + '\n');
                }
                catch (Exception exception) {}
            } else {
                bInteger = BInteger.make((int)-1);
            }
        }
        printWriter.print("foxPort=" + bInteger + '\n');
        printWriter.print("admin=" + this.sys.licenseWbAdmin() + '\n');
        printWriter.print("userFacets=" + bUser.getFacets().encodeToString() + '\n');
        printWriter.print("autoLogoffEnabled=" + bWebProfileConfig.getAutoLogoffEnabled() + '\n');
        printWriter.print("autoLogoffPeriod=" + bWebProfileConfig.getAutoLogoffPeriod().encodeToString() + '\n');
        object = httpServletRequest.getRequestedSessionId();
        if (object == null) {
            httpServletRequest.getSession();
            object = httpServletRequest.getRequestedSessionId();
        }
        if (object != null) {
            printWriter.print("httpSession=" + (String)object + '\n');
        }
    }

    boolean preDownload(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, File file) throws IOException {
        if (!file.exists()) {
            httpServletResponse.sendError(404);
            return true;
        }
        long l = file.lastModified() / 1000L * 1000L;
        long l2 = httpServletRequest.getDateHeader("If-Modified-Since");
        if (l2 != (long)-1 && l <= l2) {
            log.trace("download not-modified: " + file);
            httpServletResponse.sendError(304);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void download(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, File file, String string, boolean bl) throws IOException {
        if (this.preDownload(httpServletRequest, httpServletResponse, file)) {
            return;
        }
        int n = (int)file.length();
        httpServletResponse.setContentType(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        OutputStream outputStream = null;
        try {
            if (bl) {
                httpServletResponse.setHeader("content-encoding", "gzip");
                outputStream = httpServletResponse.getOutputStream();
            } else if (niagaraZipMimeType.equals(string)) {
                outputStream = new GZIPOutputStream(httpServletResponse.getOutputStream());
            } else {
                httpServletResponse.setContentLength(n);
                outputStream = httpServletResponse.getOutputStream();
            }
            HttpHeaderUtil.setLastModified(httpServletResponse, file);
            FileUtil.pipe((InputStream)bufferedInputStream, (long)n, (OutputStream)outputStream);
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            WebUtil.closeOutputStream(outputStream);
            ((InputStream)bufferedInputStream).close();
            throw throwable;
        }
        {
            Object var10_11 = null;
        }
        WebUtil.closeOutputStream(outputStream);
        ((InputStream)bufferedInputStream).close();
    }

    private final void removeAuthCookies(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray != null) {
            int n = 0;
            while (n < cookieArray.length) {
                String string = cookieArray[n].getName();
                if (string.equals("niagara_auth")) {
                    Cookie cookie = new Cookie(string, "");
                    cookie.setMaxAge(0);
                    cookie.setPath("/");
                    httpServletResponse.addCookie(cookie);
                }
                ++n;
            }
        }
    }

    public void serviceView(AgentInfo agentInfo, WebOp webOp) throws Exception {
        webOp.setContentType("text/html");
        AppletWriter appletWriter = new AppletWriter(webOp.getWriter(), webOp.getUserAgent(), webOp.getRequest());
        appletWriter.w("<html>");
        appletWriter.w("<head>");
        String string = null;
        String string2 = this.getStationDisplayName(webOp);
        String string3 = this.getViewDisplayName(agentInfo, webOp);
        string = string2 == null ? string3 : string2 + " - " + string3;
        if (string != null) {
            appletWriter.w("<title>");
            appletWriter.safe(string);
            appletWriter.w("</title>");
        }
        appletWriter.w("</head>");
        appletWriter.w("<body style='margin: 0; padding: 0;' bgcolor='#ffffff'>");
        appletWriter.applet(webOp.getOrd().toString(), webOp.getLanguage(), webOp.getProfileConfig().getTypeSpec().toString(), webOp.getUser().getUsername(), this.sys.service, webOp.getProfileConfig());
        appletWriter.w("</body></html>");
    }

    public String getStationDisplayName(WebOp webOp) {
        BStation bStation = Sys.getStation();
        Property property = bStation.getProperty("displayName");
        if (property == null) {
            return bStation.getStationName();
        }
        String string = null;
        if (property.getType() == BFormat.TYPE) {
            BFormat bFormat = (BFormat)bStation.get(property);
            string = bFormat.format((Object)bStation, (Context)webOp);
        } else if (property.getType() == BString.TYPE) {
            string = bStation.getString(property);
        }
        if (string.length() == 0) {
            return bStation.getStationName();
        }
        return string;
    }

    public String getViewDisplayName(AgentInfo agentInfo, WebOp webOp) {
        return agentInfo.getDisplayName((Context)webOp);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    WbServlet(SysServlet sysServlet) {
        this.sys = sysServlet;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class AppletWriter
    extends HtmlWriter {
        HttpServletRequest req;
        private boolean firstParam;

        public void applet(String string, String string2, String string3, String string4, BWebService bWebService) throws Exception {
            this.applet(string, string2, string3, string4, bWebService, null);
        }

        public void applet(String string, String string2, String string3, String string4, BWebService bWebService, BWebProfileConfig bWebProfileConfig) throws Exception {
            this.applet("100%", "100%", string, string2, string3, string4, bWebService, bWebProfileConfig);
        }

        public void applet(String string, String string2, String string3, String string4, String string5, String string6, BWebService bWebService) throws Exception {
            this.applet(string, string2, string3, string4, string5, string6, bWebService, null);
        }

        public void applet(String string, String string2, String string3, String string4, String string5, String string6, BWebService bWebService, BWebProfileConfig bWebProfileConfig) throws Exception {
            this.applet(string, string2, string3, string4, string5, string6, bWebService, bWebProfileConfig, null);
        }

        public void applet(String string, String string2, String string3, String string4, String string5, String string6, BWebService bWebService, BWebProfileConfig bWebProfileConfig, String[] stringArray) throws Exception {
            String string7 = WebUtil.getLogo(bWebService);
            String string8 = WebUtil.getAbsolutePathBase(this.req);
            this.appletStart(string, string2);
            this.appletParam("boxbgcolor", "#ffffff");
            this.appletParam("boxmessage", "Loading Niagara...");
            this.appletParam("image", "");
            this.appletParam("ord", string3);
            this.appletParam("locale", string4);
            this.appletParam("profile", string5);
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    this.appletParam(stringArray[n]);
                    ++n;
                }
            }
            if (string7 != null) {
                this.appletParam("logo", string8 + "ord?" + string7);
            }
            if (bWebProfileConfig != null) {
                Property[] propertyArray = bWebProfileConfig.getDynamicPropertiesArray();
                int n = 0;
                while (n < propertyArray.length) {
                    BValue bValue = bWebProfileConfig.get(propertyArray[n]);
                    if (bValue instanceof BSimple) {
                        this.appletParam(propertyArray[n].getName(), bValue.asSimple().encodeToString());
                    }
                    ++n;
                }
            }
            this.appletParam("user", string6);
            this.appletEnd();
        }

        public void appletStart() {
            this.appletStart("100%", "100%");
        }

        public void appletStart(String string, String string2) {
            String string3 = WebUtil.getAbsolutePathBase(this.req);
            boolean bl = false;
            String string4 = this.req.getHeader("User-Agent");
            if (string4 != null && (string4 = string4.toLowerCase()).indexOf("trident") >= 0) {
                bl = true;
            }
            this.w("<div id='applet'>\n");
            this.w("  <script type='text/javascript' src='" + string3 + "ord?module://web/com/tridium/web/rc/deployJava.js'></script>\n");
            if (bl) {
                this.w("  <script type='text/javascript' src='" + string3 + "ord?module://web/com/tridium/web/rc/deployJavaTrident.js'></script>\n");
            }
            this.w("   <script type='text/javascript'>\n");
            this.w("   var attributes = {codebase:'" + string3 + "',\n");
            this.w("      code:'WbApplet.class',\n");
            this.w("      archive:'wbapplet-" + Sys.getRegistry().getModule("web").getVendorVersion() + ".jar',\n");
            this.w("      width:'" + string + "',\n");
            this.w("      height:'" + string2 + "'};\n");
            this.w("   var parameters = {");
            this.firstParam = true;
        }

        public void appletParam(String string, String string2) {
            if (!this.firstParam) {
                this.w(",\n");
            }
            this.w("      ").safe(string).w((Object)":'").safe(string2).w((Object)"'");
            this.firstParam = false;
        }

        public void appletParam(String string) {
            if (!this.firstParam) {
                this.w(",\n");
            }
            this.w("      " + string);
            this.firstParam = false;
        }

        public void appletEnd() {
            this.w("};\n");
            this.w("  var version = '1.6';\n");
            this.w("  deployJava.runApplet(attributes, parameters, version);\n");
            this.w("  </script>\n");
            this.w("</div>");
        }

        private final /* synthetic */ void this() {
            this.firstParam = true;
        }

        public AppletWriter(PrintWriter printWriter, UserAgent userAgent) {
            this(printWriter, userAgent, null);
        }

        public AppletWriter(PrintWriter printWriter, UserAgent userAgent, HttpServletRequest httpServletRequest) {
            super((Writer)printWriter);
            this.this();
            this.req = httpServletRequest;
        }
    }
}

