/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web;

import com.tridium.httpd.CookieUtil;
import com.tridium.nre.auth.ScramSha256Server;
import com.tridium.web.BDefaultLoginTemplate;
import com.tridium.web.BHttpUsernamePasswordAuthAgent;
import com.tridium.web.UserAndCredentials;
import com.tridium.web.WebUtil;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import javax.baja.io.HtmlWriter;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BPbkdf2HmacSha256PasswordEncoder;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BString;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BAuthAgent;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.web.BAuthenticationType;
import javax.baja.web.BLoginTemplate;
import javax.baja.web.BWebService;
import javax.baja.web.IStateLoginTemplate;
import javax.baja.web.LoginState;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BHttpAuthAgent
extends BAuthAgent {
    private static final String DIGEST_TYPE = System.getProperty("niagara.web.messageDigest", "SHA-1");
    protected static final String CNAME_NIAGARA_LOGIN_STATE = "niagara_login_state";
    protected static final String CNAME_NIAGARA_LOGIN_STATE_DATA = "niagara_login_state_data";
    protected static final String CNAME_NIAGARA_SESSION = "niagara_session";
    protected static final String CNAME_NIAGARA_AUTH = "niagara_auth";
    protected static final String CNAME_NIAGARA_AUTH_AUTO = "niagara_auth_auto";
    protected static final String LOGIN_STATE_DATA_DUP_PASSWORD = "duplicatePassword";
    public static final int LOGIN_STATE_OK = 0;
    public static final int LOGIN_STATE_RETRY = 1;
    public static final int LOGIN_STATE_UNKNOWN_ERROR = 2;
    public static final int LOGIN_STATE_PASSWORD_RESET = 3;
    public static final int LOGIN_STATE_KERB_FAILED = 4;
    public static final int LOGIN_STATE_ILLEGAL_NETWORK_USER = 5;
    public static final int LOGIN_STATE_HTTP_FOX_SSL_MISMATCH = 6;
    public static final Type TYPE;
    protected static BLoginTemplate defaultTemplate;
    protected static long AUTH_TIMESTAMP_TOLERANCE;
    protected static Log authLog;
    private static BHttpAuthAgent authAgent;
    private BWebService webService;
    private BUserService userService;
    static /* synthetic */ Class class$com$tridium$web$BHttpAuthAgent;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$tridium$web$BHttpAuthAgent$AuthContext;

    public void doLoginGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        BLoginTemplate bLoginTemplate = null;
        BTypeSpec bTypeSpec = (BTypeSpec)this.getWebService().get("loginTemplate");
        if (bTypeSpec == null || bTypeSpec.isNull()) {
            bLoginTemplate = defaultTemplate;
        } else {
            try {
                bLoginTemplate = (BLoginTemplate)bTypeSpec.getInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bLoginTemplate = defaultTemplate;
            }
        }
        LoginState loginState = LoginState.make(0);
        Cookie[] cookieArray = httpServletRequest.getCookies();
        String string = CookieUtil.getCookieName(httpServletRequest, CNAME_NIAGARA_LOGIN_STATE);
        String string2 = this.getLoginStateData(httpServletRequest, httpServletResponse);
        if (cookieArray != null) {
            int n = 0;
            while (n < cookieArray.length) {
                if (cookieArray[n].getName().equals(string)) {
                    if (cookieArray[n].getValue().equals(String.valueOf(1))) {
                        loginState = LoginState.make(1, string2);
                    } else if (cookieArray[n].getValue().equals(String.valueOf(3))) {
                        loginState = LoginState.make(3, string2);
                    } else if (cookieArray[n].getValue().equals(String.valueOf(4))) {
                        loginState = LoginState.make(4, string2);
                    } else if (cookieArray[n].getValue().equals(String.valueOf(5))) {
                        loginState = LoginState.make(5, string2);
                    } else if (cookieArray[n].getValue().equals(String.valueOf(6))) {
                        loginState = LoginState.make(6, string2);
                    }
                    this.removeCookie(httpServletResponse, string);
                }
                ++n;
            }
        }
        httpServletResponse.setContentType("text/html");
        if (bLoginTemplate instanceof IStateLoginTemplate) {
            ((IStateLoginTemplate)((Object)bLoginTemplate)).write(this.getWebService(), httpServletRequest, httpServletResponse, loginState);
        } else if (loginState.getState() == 0) {
            bLoginTemplate.write(this.getWebService(), httpServletRequest, httpServletResponse, false);
        } else if (loginState.getState() == 1) {
            bLoginTemplate.write(this.getWebService(), httpServletRequest, httpServletResponse, true);
        } else {
            bLoginTemplate = defaultTemplate;
            ((IStateLoginTemplate)((Object)bLoginTemplate)).write(this.getWebService(), httpServletRequest, httpServletResponse, loginState);
        }
    }

    public void writeHeader(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HtmlWriter htmlWriter = new HtmlWriter((Writer)httpServletResponse.getWriter());
        Lexicon lexicon = Lexicon.make((String)"web", (String)WebUtil.getLanguage(httpServletRequest, null));
        htmlWriter.println(" <title>" + lexicon.getText("login") + "</title>");
        String string = WebUtil.getAbsolutePathBase(httpServletRequest);
        htmlWriter.println(" <meta http-equiv='Content-type' content='text/html;charset=UTF-8' />");
        htmlWriter.println(" <link rel='stylesheet' type='text/css' href='" + string + "login/login.css'/>");
        htmlWriter.println(" <script type='text/javascript' src='" + string + "login/sha1.js'></script>");
        htmlWriter.println(" <script type='text/javascript' src='" + string + "login/login.js'></script>");
    }

    public String getLoginMessageContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, LoginState loginState) {
        if (loginState.getState() == 0) {
            return null;
        }
        Lexicon lexicon = Lexicon.make((String)"web", (String)WebUtil.getLanguage(httpServletRequest, null));
        StringBuffer stringBuffer = new StringBuffer();
        if (loginState.getState() == 2) {
            stringBuffer.append(" <b>" + lexicon.getText("login.failed") + "</b><br/>");
            stringBuffer.append(" " + lexicon.getText("login.failed.unknown.details"));
        } else if (loginState.getState() == 3) {
            stringBuffer.append(" <b>" + lexicon.getText("login.password.reset") + "</b><br/>");
            stringBuffer.append(" " + lexicon.getText("login.password.reset.details"));
            String string = (String)loginState.getData();
            if (string != null && string.equals(LOGIN_STATE_DATA_DUP_PASSWORD)) {
                stringBuffer.append("<br>" + Lexicon.make((String)"baja").get("user.strongPassword.alreadyUsed"));
            }
        } else if (loginState.getState() == 5) {
            stringBuffer.append(" <b>" + lexicon.getText("login.failed") + "</b><br/>");
            stringBuffer.append(" " + lexicon.getText("login.illegal.network.user.passwordReset"));
        } else if (loginState.getState() == 6) {
            stringBuffer.append(" <b>" + lexicon.getText("login.failed") + "</b><br/>");
            stringBuffer.append(" " + lexicon.getText("login.failed.httpFox.mismatch.details"));
        } else {
            stringBuffer.append(" <b>" + lexicon.getText("login.failed") + "</b><br/>");
            stringBuffer.append(" " + lexicon.getText("login.failed.details"));
        }
        return stringBuffer.toString();
    }

    private final String getLoginStateData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        String string = CookieUtil.getCookieName(httpServletRequest, CNAME_NIAGARA_LOGIN_STATE_DATA);
        if (cookieArray != null) {
            int n = 0;
            while (n < cookieArray.length) {
                if (cookieArray[n].getName().equals(string)) {
                    return cookieArray[n].getValue();
                }
                this.removeCookie(httpServletResponse, string);
                ++n;
            }
        }
        return null;
    }

    public abstract void writeLoginForm(HttpServletRequest var1, HttpServletResponse var2, LoginState var3) throws Exception;

    public BOrd resourceToOrd(String string) {
        return BOrd.make((String)("module://web/com/tridium/web/rc/" + string));
    }

    public void doLogoutGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        try {
            Auditor auditor = Sys.getAuditor();
            if (auditor != null) {
                String string = httpServletRequest.getRemoteHost();
                if (string == null) {
                    string = httpServletRequest.getRemoteAddr();
                }
                String string2 = httpServletRequest.getRemoteUser();
                auditor.audit(new AuditEvent("Logout", this.getWebService().toPathString(), string != null ? string : "", "", "", string2 != null ? string2 : ""));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.invalidateSession(httpServletRequest, httpServletResponse);
        httpServletResponse.sendRedirect(WebUtil.getRedirect(httpServletRequest, "/"));
    }

    protected void invalidateSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string;
        Cookie[] cookieArray;
        Cookie[] cookieArray2 = null;
        Property property = this.getWebService().getProperty("cookieDomain");
        if (property != null && (cookieArray = this.getWebService().getString(property).trim()).length() > 0 && TextUtil.toLowerCase((String)httpServletRequest.getServerName()).indexOf(TextUtil.toLowerCase((String)cookieArray)) >= 0) {
            cookieArray2 = cookieArray;
        }
        try {
            cookieArray = Sys.loadClass((String)"fox", (String)"com.tridium.fox.sys.BFoxService");
            Class[] classArray = new Class[1];
            Class clazz = class$java$lang$String;
            if (clazz == null) {
                clazz = class$java$lang$String = BHttpAuthAgent.class("[Ljava.lang.String;", false);
            }
            classArray[0] = clazz;
            Method method = cookieArray.getMethod("httpSessionClosed", classArray);
            string = httpServletRequest.getRequestedSessionId();
            method.invoke(null, string);
            httpServletRequest.getSession().invalidate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        cookieArray = httpServletRequest.getCookies();
        int n = 0;
        while (cookieArray != null && n < cookieArray.length) {
            string = cookieArray[n].getName();
            if (string.startsWith(CNAME_NIAGARA_AUTH) || string.startsWith(CNAME_NIAGARA_SESSION)) {
                Cookie cookie = new Cookie(string, "");
                cookie.setValue(null);
                cookie.setMaxAge(0);
                cookie.setPath("/");
                if (cookieArray2 != null) {
                    cookie.setDomain((String)cookieArray2);
                }
                httpServletResponse.addCookie(cookie);
            }
            ++n;
        }
    }

    public abstract void doLoginPost(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    public abstract UserAndCredentials doWebProcessAuth(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    protected abstract AuthContext getFromHeader(String var1) throws Exception;

    protected abstract void updateCookie(AuthContext var1, HttpServletRequest var2, HttpServletResponse var3);

    protected void removeCookie(HttpServletResponse httpServletResponse, String string) {
        Cookie cookie = new Cookie(string, "false");
        cookie.setMaxAge(0);
        cookie.setPath("/");
        httpServletResponse.addCookie(cookie);
    }

    protected String getAuditKey(AuthContext authContext) {
        if (authContext.credentials != null && authContext.credentials instanceof BUsernameAndPassword) {
            BUsernameAndPassword bUsernameAndPassword = (BUsernameAndPassword)authContext.credentials;
            return bUsernameAndPassword.getUsername();
        }
        if (authContext.getUsername() != null) {
            return authContext.getUsername();
        }
        return "unknown";
    }

    protected abstract AuthContext getFromCookie(Cookie var1, boolean var2) throws Exception;

    protected String makeNonce(HttpServletRequest httpServletRequest) {
        long l = Clock.millis();
        return TextUtil.padZeros((String)Long.toHexString(l), (int)16) + this.getNonceDigest(l, httpServletRequest);
    }

    public boolean isNonceValid(String string, HttpServletRequest httpServletRequest) {
        try {
            long l;
            long l2 = Long.parseLong(string.substring(0, 16), 16);
            if (this.getWebService().getCookieDigestSessionTimeout() >= 0 && (l = Clock.millis()) - l2 > (long)this.getWebService().getCookieDigestSessionTimeout() * 60000L) {
                return false;
            }
            return this.getNonceDigest(l2, httpServletRequest).equals(string.substring(16));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    protected String getNonceDigest(long l, HttpServletRequest httpServletRequest) {
        String string;
        BString bString = (BString)this.getWebService().get("cookieDomain");
        if (bString == null) {
            HttpSession httpSession = httpServletRequest.getSession(true);
            string = httpSession.getId();
            httpSession.setMaxInactiveInterval(this.getWebService().getCookieDigestSessionTimeout() * 60);
        } else {
            string = bString.toString();
        }
        return TextUtil.bytesToHexString((byte[])this.digest(Long.toHexString(l) + string + "30e7e918c8474db68536e6653e4978df"));
    }

    public boolean isDigest() {
        boolean bl = false;
        if (this.getWebService().getAuthenticationScheme() == BAuthenticationType.cookieDigest) {
            bl = true;
        }
        return bl;
    }

    public AuthContext[] getAuthContexts(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        int[] nArray = null;
        if (this.getWebService().getAuthenticationScheme() == BAuthenticationType.basic) {
            int[] nArray2 = new int[2];
            nArray2[0] = 1;
            nArray = nArray2;
        } else if (this.getWebService().getAuthenticationScheme() == BAuthenticationType.cookieDigest) {
            nArray = new int[]{2, 1};
        } else {
            int[] nArray3 = new int[2];
            nArray3[1] = 1;
            nArray = nArray3;
        }
        int n = 0;
        while (n < nArray.length) {
            AuthContext[] authContextArray = this.getContextFromCookieName(httpServletRequest, httpServletResponse, CNAME_NIAGARA_SESSION);
            if (authContextArray != null) {
                int n2 = 0;
                while (n2 < authContextArray.length) {
                    if (authContextArray[n2].getScheme() == null) {
                        switch (nArray[n]) {
                            case 1: {
                                authContextArray[n2].setScheme("Basic");
                                break;
                            }
                            case 0: {
                                authContextArray[n2].setScheme("Cookie");
                                break;
                            }
                            case 2: {
                                authContextArray[n2].setScheme("CookieDigest");
                                break;
                            }
                        }
                    }
                    ++n2;
                }
                return authContextArray;
            }
            if (nArray[n] == 1) {
                String string = httpServletRequest.getHeader("Authorization");
                if (string != null) {
                    AuthContext authContext = this.getFromHeader(string);
                    return new AuthContext[]{authContext};
                }
            } else if (nArray[n] == 0) {
                if (this.getWebService().getAutoLoginEnabled() && (authContextArray = this.getContextFromCookieName(httpServletRequest, httpServletResponse, CNAME_NIAGARA_AUTH_AUTO)) != null) {
                    return authContextArray;
                }
                authContextArray = this.getContextFromCookieName(httpServletRequest, httpServletResponse, CNAME_NIAGARA_AUTH);
                if (authContextArray != null) {
                    return authContextArray;
                }
            }
            ++n;
        }
        return null;
    }

    private final AuthContext[] getContextFromCookieName(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        AuthContext authContext;
        Cookie[] cookieArray = httpServletRequest.getCookies();
        String string2 = CookieUtil.getCookieName(httpServletRequest, string);
        Class clazz = class$com$tridium$web$BHttpAuthAgent$AuthContext;
        if (clazz == null) {
            clazz = class$com$tridium$web$BHttpAuthAgent$AuthContext = BHttpAuthAgent.class("[Lcom.tridium.web.BHttpAuthAgent$AuthContext;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (cookieArray != null && n < cookieArray.length) {
            if (cookieArray[n].getName().equals(string2) && (authContext = this.getFromCookie(cookieArray[n], false)) != null) {
                array.add((Object)authContext);
            }
            ++n;
        }
        if (array.size() > 0) {
            return (AuthContext[])array.trim();
        }
        if (!string2.equals(string)) {
            n = 0;
            while (cookieArray != null && n < cookieArray.length) {
                if (cookieArray[n].getName().equals(string) && (authContext = this.getFromCookie(cookieArray[n], false)) != null) {
                    array.add((Object)authContext);
                }
                ++n;
            }
            if (array.size() > 0) {
                return (AuthContext[])array.trim();
            }
        }
        return null;
    }

    protected BWebService getWebService() {
        if (this.webService == null) {
            this.webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
        }
        return this.webService;
    }

    protected BUserService getUserService() {
        if (this.userService == null) {
            this.userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        }
        return this.userService;
    }

    public byte[] digest(String string) {
        return this.digest(string.getBytes());
    }

    public byte[] digest(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(DIGEST_TYPE);
            messageDigest.update(byArray);
            return messageDigest.digest();
        }
        catch (Exception exception) {
            throw new BajaRuntimeException("Error creating digest", (Throwable)exception);
        }
    }

    public static final BHttpAuthAgent getAuthAgent() {
        if (authAgent == null) {
            BUserService bUserService = BUserService.getService();
            if (bUserService == null) {
                authAgent = BHttpUsernamePasswordAuthAgent.INSTANCE;
            } else {
                authAgent = (BHttpAuthAgent)bUserService.getAuthAgent(TYPE);
                if (authAgent == null) {
                    authAgent = BHttpUsernamePasswordAuthAgent.INSTANCE;
                }
            }
        }
        return authAgent;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.webService = null;
        this.userService = null;
    }

    public BHttpAuthAgent() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$web$BHttpAuthAgent;
        if (clazz == null) {
            clazz = class$com$tridium$web$BHttpAuthAgent = BHttpAuthAgent.class("[Lcom.tridium.web.BHttpAuthAgent;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        defaultTemplate = new BDefaultLoginTemplate();
        AUTH_TIMESTAMP_TOLERANCE = 20000L;
        authLog = Log.getLog((String)"web.auth");
        authAgent = null;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected abstract class AuthContext {
        protected boolean audit;
        protected String scheme;
        protected BICredentials credentials;
        protected String username;
        protected Cookie cookieSource;
        protected boolean extendExpiration;
        protected String remoteHost;
        protected HttpSession session;

        public void setAudit(boolean bl) {
            this.audit = bl;
        }

        public boolean getAudit() {
            return this.audit;
        }

        public void setScheme(String string) {
            this.scheme = string;
        }

        public String getScheme() {
            return this.scheme;
        }

        public void setCookieSource(Cookie cookie) {
            this.cookieSource = cookie;
        }

        public Cookie getCookieSource() {
            return this.cookieSource;
        }

        public void setExtendExpiration(boolean bl) {
            this.extendExpiration = bl;
        }

        public boolean getExtendExpiration() {
            return this.extendExpiration;
        }

        public void setRemoteHost(String string) {
            this.remoteHost = string;
        }

        public String getRemoteHost() {
            return this.remoteHost;
        }

        public String toString() {
            return this.scheme;
        }

        public void setSession(HttpSession httpSession) {
            this.session = httpSession;
        }

        public HttpSession getSession() {
            return this.session;
        }

        public String getUsername() {
            return this.username;
        }

        private final /* synthetic */ void this() {
            this.audit = false;
            this.scheme = null;
            this.credentials = null;
            this.username = null;
            this.cookieSource = null;
            this.extendExpiration = false;
            this.remoteHost = null;
            this.session = null;
        }

        protected AuthContext() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class HttpUserKeyFactory
    implements ScramSha256Server.IUserKeyFactory {
        public String getUserKey(String string) {
            BUserService bUserService = (BUserService)Sys.getService((Type)BUserService.TYPE);
            BUser bUser = bUserService.getUser(string);
            if (bUser == null || !bUserService.canLogin(bUser)) {
                BPbkdf2HmacSha256PasswordEncoder bPbkdf2HmacSha256PasswordEncoder = BPbkdf2HmacSha256PasswordEncoder.makeFake((String)string);
                return bPbkdf2HmacSha256PasswordEncoder.getValue();
            }
            BPbkdf2HmacSha256PasswordEncoder.makeFake((String)string);
            BPassword bPassword = bUser.getPassword();
            BPbkdf2HmacSha256PasswordEncoder bPbkdf2HmacSha256PasswordEncoder = (BPbkdf2HmacSha256PasswordEncoder)bPassword.getPasswordEncoder();
            return bPbkdf2HmacSha256PasswordEncoder.getValue();
        }
    }
}

