/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpd;

import com.tridium.httpd.Logger;
import com.tridium.util.TimeFormat;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.timezone.BTimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class W3cLogger
implements Logger {
    private File logFile;
    private PrintWriter out;

    public void init() throws IOException {
        this.out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(this.logFile.toString(), this.logFile.exists())));
        if (this.logFile.length() == 0L) {
            this.out.println("#Software: Niagara Web Service " + Sys.loadModule((String)"web").getVendorVersion());
            this.out.println("#Version: 1.0");
            this.out.println("#Date: " + TimeFormat.format((BAbsTime)BAbsTime.make((long)System.currentTimeMillis(), (BTimeZone)BTimeZone.GMT), (String)"YYYY-MM-DD HH:MM:ss"));
            this.out.println("#Fields: date time cs-method cs-uri cs-username c-ip cs-version cs(User-Agent) cs(Referer) sc-status sc-bytes");
            this.out.flush();
        }
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (Exception exception) {}
    }

    public void log(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, int n2, String string) {
        if (this.out == null) {
            return;
        }
        String string2 = httpServletRequest.getRemoteAddr();
        int n3 = httpServletRequest.getRemotePort();
        String string3 = null;
        try {
            string3 = httpServletRequest.getRemoteUser();
        }
        catch (Exception exception) {}
        if (string3 == null) {
            string3 = string;
        }
        String string4 = httpServletRequest.getHeader("User-Agent");
        String string5 = httpServletRequest.getHeader("Referer");
        String string6 = httpServletRequest.getQueryString();
        BFacets bFacets = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"timeFormat", (BIDataValue)BString.make((String)"YYYY-MM-DD HH:mm:ss"));
        String string7 = BAbsTime.make((long)System.currentTimeMillis(), (BTimeZone)BTimeZone.GMT).toString((Context)bFacets);
        char c = ' ';
        char c2 = '-';
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string7);
        stringBuffer.append(c);
        stringBuffer.append(httpServletRequest.getMethod());
        stringBuffer.append(c);
        stringBuffer.append(httpServletRequest.getRequestURI());
        if (string6 != null) {
            stringBuffer.append("?").append(string6);
        }
        stringBuffer.append(c);
        if (string3 != null) {
            stringBuffer.append(string3);
        } else {
            stringBuffer.append(c2);
        }
        stringBuffer.append(c);
        stringBuffer.append(string2);
        if (n3 != 80) {
            stringBuffer.append(":");
            stringBuffer.append(n3);
        }
        stringBuffer.append(c);
        stringBuffer.append(httpServletRequest.getProtocol());
        stringBuffer.append(c);
        if (string4 != null) {
            stringBuffer.append(string4.replace(' ', '+'));
        } else {
            stringBuffer.append(c2);
        }
        stringBuffer.append(c);
        if (string5 != null) {
            stringBuffer.append(string5);
        } else {
            stringBuffer.append(c2);
        }
        stringBuffer.append(c);
        stringBuffer.append(n);
        stringBuffer.append(c);
        stringBuffer.append(n2);
        stringBuffer.append("\r\n");
        this.out.print(stringBuffer.toString());
        this.out.flush();
    }

    public File getFile() {
        return this.logFile;
    }

    public W3cLogger(File file) {
        this.logFile = file;
    }

    public W3cLogger(String string) {
        this(new File(string));
    }
}

