/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpd;

import com.tridium.httpd.HttpResponse;
import com.tridium.net.ChunkedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NServletOutputStream
extends ServletOutputStream {
    private byte[] buf;
    private boolean committed;
    private int count;
    private int max;
    private OutputStream out;
    private HttpResponse res;
    private int total;

    public int getBytesWritten() {
        return this.total;
    }

    public void write(int n) throws IOException {
        if (this.max == this.total) {
            IOException iOException = new IOException("Attempt to write past contentLength=" + this.max);
            iOException.printStackTrace();
            throw iOException;
        }
        ++this.total;
        if (this.count >= this.buf.length) {
            this.writeBuffer();
        }
        this.buf[this.count++] = (byte)n;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.max != -1 && this.total + n2 > this.max) {
            IOException iOException = new IOException("Attempt to write past contentLength=" + this.max);
            iOException.printStackTrace();
            throw iOException;
        }
        this.total += n2;
        if (n2 >= this.buf.length) {
            this.writeBuffer();
            this.out.write(byArray, n, n2);
            return;
        }
        if (n2 > this.buf.length - this.count) {
            this.writeBuffer();
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void flush() throws IOException {
        this.writeBuffer();
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public int getBufferSize() {
        return this.buf.length;
    }

    public void setBufferSize(int n) {
        if (this.committed) {
            throw new IllegalStateException("Response already committed.");
        }
        this.buf = new byte[n];
    }

    public void resetBuffer() {
        if (this.committed) {
            throw new IllegalStateException("Response already committed.");
        }
        this.count = 0;
        this.total = 0;
    }

    private final void writeBuffer() throws IOException {
        if (!this.committed) {
            this.committed = true;
            this.res.write(this.out);
        }
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
        this.out.flush();
    }

    private final /* synthetic */ void this() {
        this.committed = false;
        this.count = 0;
        this.total = 0;
    }

    public NServletOutputStream(HttpResponse httpResponse, OutputStream outputStream, ChunkedOutputStream chunkedOutputStream) {
        this.this();
        this.res = httpResponse;
        this.out = chunkedOutputStream;
        this.max = -1;
        this.committed = true;
        this.buf = new byte[chunkedOutputStream.getChunkSize()];
        try {
            httpResponse.write(outputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public NServletOutputStream(HttpResponse httpResponse, OutputStream outputStream, GZIPOutputStream gZIPOutputStream, int n) {
        this.this();
        this.res = httpResponse;
        this.out = gZIPOutputStream;
        this.max = -1;
        this.committed = true;
        this.buf = new byte[n];
        try {
            httpResponse.write(outputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public NServletOutputStream(HttpResponse httpResponse, OutputStream outputStream, int n, int n2) {
        this.this();
        this.res = httpResponse;
        this.out = outputStream;
        this.max = n;
        this.buf = new byte[n2];
    }
}

