/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpd;

import com.tridium.httpd.HttpRequest;
import com.tridium.httpd.HttpResponseHeader;
import com.tridium.httpd.Httpd;
import com.tridium.httpd.HttpdUtils;
import com.tridium.httpd.NServletOutputStream;
import com.tridium.net.ChunkedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.zip.GZIPOutputStream;
import javax.baja.log.Log;
import javax.baja.net.Http;
import javax.baja.nre.util.TextUtil;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HttpResponse
implements HttpServletResponse {
    private Httpd httpd;
    private OutputStream out;
    private NServletOutputStream servletOut;
    private ChunkedOutputStream chunkOut;
    private GZIPOutputStream gzipOut;
    private PrintWriter writer;
    private int statusCode;
    private String statusMsg;
    private HttpResponseHeader header;
    private boolean written;
    private boolean lengthSet;
    private boolean shouldClose;
    private int bufSize;
    public HttpRequest request;
    private boolean charSet;
    private Locale locale;

    int commit() throws IOException {
        try {
            if (this.writer != null) {
                this.writer.flush();
            }
            if (this.servletOut != null) {
                if (this.chunkOut == null && !this.servletOut.isCommitted() && this.header.get("content-length") == null) {
                    this.setContentLength(this.servletOut.getBytesWritten());
                }
                this.servletOut.flush();
            }
            if (this.gzipOut != null) {
                this.gzipOut.finish();
                this.gzipOut.close();
            } else if (this.chunkOut != null) {
                this.chunkOut.close();
            }
            this.out.flush();
        }
        catch (Exception exception) {
            this.shouldClose = true;
        }
        if (this.servletOut != null) {
            return this.servletOut.getBytesWritten();
        }
        return 0;
    }

    public void reset() {
        if (this.written) {
            this.written = false;
            if (this.servletOut != null) {
                try {
                    this.servletOut.flush();
                }
                catch (Exception exception) {}
                this.servletOut = null;
            }
            this.header = new HttpResponseHeader();
            this.lengthSet = false;
        }
    }

    boolean shouldClose() {
        if (this.shouldClose) {
            return true;
        }
        if (this.getStatus() == 100) {
            return false;
        }
        if (this.header.contains("upgrade", "websocket")) {
            return false;
        }
        boolean bl = false;
        if (!this.lengthSet && !this.header.contains("transfer-encoding", "chunked") || this.header.contains("Connection", "close")) {
            bl = true;
        }
        return bl;
    }

    public String getCharacterEncoding() {
        String string = this.header.get("content-type");
        if (string == null) {
            return "UTF-8";
        }
        int n = string.indexOf(";");
        if (n == -1) {
            return "UTF-8";
        }
        if ((n = string.indexOf("charset=", n)) == -1) {
            return "UTF-8";
        }
        String string2 = string.substring(n + 8);
        string2 = string2.replace('\"', ' ');
        return string2.trim();
    }

    public void setCharacterEncoding(String string) {
        if (this.written) {
            throw new IllegalStateException("Already written.");
        }
        this.charSet = true;
        this.header.set("content-type", this.getContentTypeOnly() + "; charset=" + string);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        String string;
        if (this.written) {
            throw new IllegalStateException("Already written.");
        }
        this.locale = locale;
        String string2 = locale.getLanguage();
        if (string2 != null && string2.length() > 0 && (string = locale.getCountry()) != null && string.length() > 0) {
            string2 = string2 + '-' + string;
        }
        this.header.set("content-language", string2);
        if (!this.charSet) {
            this.setCharacterEncoding(string2);
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.servletOut == null) {
            boolean bl;
            String string = this.header.get("transfer-encoding");
            boolean bl2 = false;
            if (string != null && string.equals("chunked")) {
                bl2 = true;
            }
            boolean bl3 = bl2;
            String string2 = this.header.get("content-encoding");
            boolean bl4 = false;
            if (string2 != null && string2.equals("gzip")) {
                bl4 = true;
            }
            if ((bl = bl4) && !bl3) {
                bl3 = true;
                this.header.set("transfer-encoding", "chunked");
            }
            if (bl3) {
                this.chunkOut = new ChunkedOutputStream(this.out, 2048);
                if (bl) {
                    this.gzipOut = new GZIPOutputStream((OutputStream)this.chunkOut);
                    this.servletOut = new NServletOutputStream(this, this.out, this.gzipOut, this.chunkOut.getChunkSize());
                } else {
                    this.servletOut = new NServletOutputStream(this, this.out, this.chunkOut);
                }
            } else {
                int n = this.header.getInt("content-length", -1);
                this.servletOut = new NServletOutputStream(this, this.out, n, this.bufSize);
            }
        }
        return this.servletOut;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            String string = this.getCharacterEncoding();
            if (string != null) {
                if (string.equalsIgnoreCase("UTF-8")) {
                    string = "UTF8";
                } else if (string.equalsIgnoreCase("US-ASCII")) {
                    string = "ASCII";
                } else if (string.equalsIgnoreCase("ISO-8859-1")) {
                    string = "ISO8859_1";
                } else if (string.equalsIgnoreCase("UTF-16BE")) {
                    string = "UnicodeBigUnmarked";
                } else if (string.equalsIgnoreCase("UTF-16LE")) {
                    string = "UnicodeLittleUnmarked";
                }
            }
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), string));
        }
        return this.writer;
    }

    public void setContentLength(int n) {
        if (this.written) {
            throw new IllegalStateException("Already written.");
        }
        if (n >= 0) {
            this.lengthSet = true;
        }
        this.header.setInt("content-length", n);
    }

    public String getContentType() {
        return this.header.get("content-type");
    }

    public String getContentTypeOnly() {
        String string = this.header.get("content-type");
        int n = string.indexOf(";");
        if (n > 0) {
            return string.substring(0, n).trim();
        }
        return string;
    }

    public void setContentType(String string) {
        if (this.written) {
            throw new IllegalStateException("Already written.");
        }
        if (TextUtil.toLowerCase((String)string).indexOf("charset=") > 0) {
            this.header.set("content-type", string);
            this.charSet = true;
        } else {
            this.header.set("content-type", string + "; charset=" + this.getCharacterEncoding());
        }
    }

    public int getBufferSize() {
        if (this.servletOut == null) {
            return this.bufSize;
        }
        return this.servletOut.getBufferSize();
    }

    public void setBufferSize(int n) {
        if (this.servletOut != null) {
            this.servletOut.setBufferSize(n);
        }
        this.bufSize = n;
    }

    public void flushBuffer() throws IOException {
        if (this.servletOut != null) {
            this.servletOut.flush();
        }
    }

    public void resetBuffer() {
        if (this.servletOut != null) {
            this.servletOut.resetBuffer();
        }
    }

    public boolean isCommitted() {
        if (this.servletOut == null) {
            return false;
        }
        return this.servletOut.isCommitted();
    }

    public void addCookie(Cookie cookie) {
        if (this.written) {
            throw new IllegalStateException("Already written.");
        }
        if (this.request.getScheme().equalsIgnoreCase("https")) {
            cookie.setSecure(true);
        }
        this.header.addCookie(cookie);
    }

    public boolean containsHeader(String string) {
        boolean bl = false;
        if (this.header.get(string) != null) {
            bl = true;
        }
        return bl;
    }

    public String encodeRedirectURL(String string) {
        return string;
    }

    public String encodeRedirectUrl(String string) {
        return this.encodeRedirectURL(string);
    }

    public String encodeURL(String string) {
        return string;
    }

    private final String ensureAbsolute(String string) {
        int n = string.indexOf(58);
        if (n > 0 && n == string.indexOf(47) - 1) {
            return string;
        }
        String string2 = this.request.getScheme();
        int n2 = this.request.getServerPort();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append("://");
        stringBuffer.append(this.request.getServerName());
        if (string2.equals("http") && n2 != 80 || string2.equals("https") && n2 != 443) {
            stringBuffer.append(':').append(n2);
        }
        return stringBuffer.append(string).toString();
    }

    public String encodeUrl(String string) {
        return this.encodeURL(string);
    }

    public void sendError(int n) throws IOException {
        this.sendError(n, null);
    }

    public void sendError(int n, String string) throws IOException {
        OutputStream outputStream;
        if (this.written) {
            throw new IllegalStateException();
        }
        boolean bl = false;
        if (n / 100 == 1 || n == 204 || n == 304) {
            this.setContentLength(0);
            bl = true;
        }
        this.setStatus(n);
        if (string == null) {
            string = "The above error occurred while processing your request.";
        }
        byte[] byArray = null;
        if (!bl) {
            outputStream = new ByteArrayOutputStream(256);
            PrintWriter printWriter = new PrintWriter(outputStream);
            HttpdUtils.writeHttpErrorPage(printWriter, n, string);
            printWriter.flush();
            this.setContentType("text/html");
            byArray = ((ByteArrayOutputStream)outputStream).toByteArray();
            printWriter.close();
            this.setContentLength(byArray.length);
        }
        this.write(this.out);
        if (!bl) {
            outputStream = this.getOutputStream();
            outputStream.write(byArray);
            outputStream.flush();
        }
    }

    public void sendRedirect(String string) throws IOException {
        this.setHeader("Location", this.ensureAbsolute(string));
        this.sendError(302);
    }

    public void setHeader(String string, String string2) {
        if (this.written) {
            throw new IllegalStateException("Already written.");
        }
        this.header.set(string, string2);
    }

    public void setIntHeader(String string, int n) {
        if (this.written) {
            throw new IllegalStateException("Already written.");
        }
        this.header.setInt(string, n);
    }

    public void setDateHeader(String string, long l) {
        if (this.written) {
            throw new IllegalStateException("Already written.");
        }
        this.header.setDate(string, l);
    }

    public int getStatus() {
        return this.statusCode;
    }

    public void setStatus(int n) {
        if (this.written) {
            throw new IllegalStateException("Already written.");
        }
        this.setStatus(n, null);
    }

    public void setStatus(int n, String string) {
        if (this.written) {
            throw new IllegalStateException("Already written.");
        }
        this.statusCode = n;
        this.statusMsg = string != null ? string : Http.getReasonPhrase((int)n);
    }

    public void addIntHeader(String string, int n) {
        this.header.setInt(string, n);
    }

    public void addHeader(String string, String string2) {
        this.header.set(string, string2);
    }

    public void addDateHeader(String string, long l) {
        this.header.setDate(string, l);
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.written) {
            return;
        }
        if (this.statusMsg == null) {
            this.statusMsg = Http.getReasonPhrase((int)this.statusCode);
        }
        PrintWriter printWriter = new PrintWriter(outputStream, false);
        Log log = Httpd.requestLog;
        StringBuffer stringBuffer = null;
        boolean bl = log.isLoggable(0);
        if (bl) {
            stringBuffer = new StringBuffer(256);
        }
        printWriter.print("HTTP/1.1");
        printWriter.print(' ');
        printWriter.print(this.statusCode);
        printWriter.print(' ');
        printWriter.print(this.statusMsg);
        printWriter.print("\r\n");
        if (bl) {
            stringBuffer.append("HTTP/1.1");
            stringBuffer.append(' ');
            stringBuffer.append(this.statusCode);
            stringBuffer.append(' ');
            stringBuffer.append(this.statusMsg);
            stringBuffer.append("\r\n");
        }
        if (this.shouldClose()) {
            this.header.set("Connection", "close");
        }
        this.header.write(printWriter, stringBuffer);
        HttpResponseHeader httpResponseHeader = this.httpd.getStdResponse();
        httpResponseHeader.write(printWriter, stringBuffer);
        printWriter.print("\r\n");
        if (bl) {
            stringBuffer.append("\r\n");
            Httpd.requestLog.trace(Thread.currentThread().getName() + ": RESP\n  " + stringBuffer.toString());
        }
        this.written = true;
        printWriter.flush();
    }

    private final /* synthetic */ void this() {
        this.written = false;
        this.lengthSet = false;
        this.shouldClose = false;
        this.bufSize = 16384;
        this.charSet = false;
    }

    public HttpResponse(Httpd httpd, OutputStream outputStream) {
        this.this();
        this.httpd = httpd;
        this.out = outputStream;
        this.header = new HttpResponseHeader();
        this.setContentType(httpd.getDefaultContentType());
        this.statusCode = 200;
    }
}

