/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpd;

import com.tridium.httpd.CookieUtil;
import com.tridium.httpd.HttpResponse;
import com.tridium.httpd.Httpd;
import com.tridium.httpd.NHttpSessionContext;
import com.tridium.httpd.NServletInputStream;
import com.tridium.httpd.RequestInfo;
import com.tridium.httpd.RequestLine;
import com.tridium.httpd.ServiceThread;
import com.tridium.net.HttpDateFormat;
import com.tridium.net.HttpRequestHeader;
import com.tridium.net.HttpUtil;
import com.tridium.nre.util.IPAddressUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.baja.nre.util.Base64;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HttpRequest
implements HttpServletRequest {
    private HttpRequestHeader header;
    private String aliasPath;
    private ServletContext servletContext;
    private RequestInfo reqInfo;
    private InputStream in;
    private OutputStream out;
    private BufferedReader reader;
    private RequestLine requestLine;
    private int contentLength;
    private byte[] formContent;
    private Hashtable paramTable;
    private Hashtable attributes;
    private boolean wroteContinue;
    private String charset;
    Httpd httpd;
    public HttpResponse response;
    HttpSession session;
    private NServletInputStream nServetInputStream;
    private Cookie[] cookies;

    void read(InputStream inputStream) throws IOException {
        String string;
        this.header = new HttpRequestHeader();
        this.header.read(inputStream);
        if (this.requestLine.getMethod().equals("POST") && (string = this.getContentType()) != null && string.startsWith("application/x-www-form-urlencoded")) {
            int n = this.getContentLength();
            if (n <= 0) {
                return;
            }
            this.formContent = new byte[n];
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readFully(this.formContent);
            this.paramTable = HttpUtils.parsePostData(n, new NServletInputStream((InputStream)new ByteArrayInputStream(this.formContent), n));
        }
    }

    void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(this.requestLine.toString());
        stringBuffer.append('\n');
        stringBuffer.append(this.header.toString());
        return stringBuffer.toString();
    }

    public Object getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(string);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public void removeAttribute(String string) {
        if (this.attributes != null) {
            this.attributes.remove(string);
        }
    }

    public void setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(string, object);
    }

    public String getCharacterEncoding() {
        if (this.charset != null) {
            return this.charset;
        }
        try {
            String string = this.header.get("content-type");
            if (string == null) {
                this.charset = "UTF-8";
                return "UTF-8";
            }
            int n = string.indexOf(";");
            if (n == -1) {
                this.charset = "UTF-8";
                return "UTF-8";
            }
            if ((n = string.indexOf("charset=", n)) == -1) {
                this.charset = "UTF-8";
                return "UTF-8";
            }
            String string2 = string.substring(n + 8);
            string2 = string2.replace('\"', ' ').trim();
            this.setCharacterEncoding(string2);
            return this.charset;
        }
        catch (Exception exception) {
            this.charset = "UTF-8";
            return "UTF-8";
        }
    }

    public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
        byte[] byArray = new byte[]{97};
        new String(byArray, string);
        this.charset = string;
    }

    public int getContentLength() {
        if (this.contentLength == -1) {
            this.contentLength = this.header.getInt("content-length", -1);
        }
        return this.contentLength;
    }

    public String getContentType() {
        return this.header.get("content-type");
    }

    public ServletInputStream getInputStream() {
        Object object;
        String string = this.getHeader("Expect");
        boolean bl = false;
        if ((this.requestLine.getMethod().equals("POST") || this.requestLine.getMethod().equals("PUT")) && this.requestLine.getMajorVersion() == 1 && this.requestLine.getMinorVersion() == 1 && !this.wroteContinue) {
            bl = true;
        }
        if (this.requestLine.getMajorVersion() >= 1 && this.requestLine.getMinorVersion() >= 1 && string != null && string.equalsIgnoreCase("100-continue") && !this.wroteContinue) {
            bl = true;
        }
        if (bl) {
            ((ServiceThread)Thread.currentThread()).trace("sending CONTINUE (100)");
            object = new PrintWriter(this.out);
            ((PrintWriter)object).print("HTTP/1.1 100 Continue");
            ((PrintWriter)object).print("\r\n");
            ((PrintWriter)object).print("\r\n");
            ((PrintWriter)object).flush();
            this.wroteContinue = true;
        }
        if (this.nServetInputStream != null) {
            return this.nServetInputStream;
        }
        if (this.formContent != null) {
            this.nServetInputStream = new NServletInputStream((InputStream)new ByteArrayInputStream(this.formContent), this.formContent.length);
            return this.nServetInputStream;
        }
        object = this.header.get("transfer-encoding");
        this.nServetInputStream = this.header.contains("transfer-encoding", "chunked") ? new NServletInputStream(this.in, true) : new NServletInputStream(this.in, this.getContentLength());
        return this.nServetInputStream;
    }

    private final Hashtable getParamTable() {
        String string;
        if (this.paramTable == null && (string = this.requestLine.getQuery()) != null) {
            this.paramTable = HttpUtils.parseQueryString(string);
        }
        return this.paramTable;
    }

    public Map getParameterMap() {
        return this.getParamTable();
    }

    public String getParameter(String string) {
        Hashtable hashtable = this.getParamTable();
        if (hashtable == null) {
            return null;
        }
        Object v = hashtable.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            return (String)v;
        }
        return ((String[])v)[0];
    }

    public Enumeration getParameterNames() {
        Hashtable hashtable = this.getParamTable();
        if (hashtable == null) {
            return new Vector(0).elements();
        }
        return hashtable.keys();
    }

    public String[] getParameterValues(String string) {
        Hashtable hashtable = this.getParamTable();
        if (hashtable == null) {
            return null;
        }
        return (String[])hashtable.get(string);
    }

    public String getProtocol() {
        return this.requestLine.getVersion();
    }

    public BufferedReader getReader() {
        if (this.reader == null) {
            try {
                this.reader = new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.getCharacterEncoding()));
            }
            catch (Exception exception) {}
            this.reader = new BufferedReader(new InputStreamReader(this.getInputStream()));
        }
        return this.reader;
    }

    public String getRealPath(String string) {
        return this.servletContext.getRealPath(string);
    }

    public String getLocalName() {
        return this.reqInfo.socket.getLocalAddress().getHostName();
    }

    public String getLocalAddr() {
        return this.reqInfo.socket.getLocalAddress().toString();
    }

    public int getLocalPort() {
        return this.reqInfo.socket.getLocalPort();
    }

    public String getRemoteAddr() {
        return this.reqInfo.remoteAddress;
    }

    public String getRemoteHost() {
        return this.reqInfo.remoteHostName;
    }

    public int getRemotePort() {
        return this.reqInfo.port;
    }

    public String getScheme() {
        return this.reqInfo.scheme;
    }

    public String getServerName() {
        String string = this.getHeader("host");
        if (string != null) {
            return HttpUtil.parseHost((String)string);
        }
        return this.reqInfo.serverName;
    }

    public int getServerPort() {
        String string = this.getHeader("host");
        if (string != null) {
            int n = 80;
            if (this.getScheme().equalsIgnoreCase("https")) {
                n = 443;
            }
            return HttpUtil.parsePort((String)string, (int)n);
        }
        return this.reqInfo.port;
    }

    public boolean isSecure() {
        return this.getScheme().equalsIgnoreCase("https");
    }

    public boolean isUserInRole(String string) {
        return false;
    }

    public Principal getUserPrincipal() {
        String string = this.getRemoteUser();
        if (string == null) {
            return null;
        }
        return new PrincipalWrapper(string);
    }

    public Locale getLocale() {
        Enumeration enumeration = this.getHeaders("accept-language");
        Locale locale = null;
        double d = 0.0;
        while (enumeration.hasMoreElements()) {
            Locale locale2;
            String string = enumeration.nextElement().toString();
            double d2 = this.quality(string);
            if (!(d2 > d) || (locale2 = this.locale(string)) == null) continue;
            d = d2;
            locale = locale2;
        }
        return locale;
    }

    public Enumeration getLocales() {
        Enumeration enumeration = this.getHeaders("accept-language");
        Hashtable<Locale, String> hashtable = new Hashtable<Locale, String>();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            Locale locale = this.locale(string);
            if (locale == null) continue;
            hashtable.put(locale, "");
        }
        return hashtable.keys();
    }

    private final double quality(String string) {
        int n = string.indexOf(";q=");
        if (n < 0) {
            return 1.0;
        }
        try {
            return Double.parseDouble(string.substring(n + 3));
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    private final Locale locale(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = string.indexOf(45);
        if (n < 0) {
            string2 = string;
            string3 = "";
            string4 = "";
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
            int n2 = string3.indexOf(45);
            if (n2 > 0) {
                String string5 = string3.substring(0, n2);
                string4 = string3.substring(n2 + 1);
                string3 = string5;
            } else {
                string4 = "";
            }
        }
        return new Locale(string2, string3, string4);
    }

    public String getAuthType() {
        String string = this.getHeader("authorization");
        if (string != null && string.startsWith("Basic ")) {
            return "BASIC";
        }
        if (this.getRemoteUser() != null) {
            return "COOKIE";
        }
        return null;
    }

    public String getContextPath() {
        return "";
    }

    public Cookie[] getCookies() {
        if (this.cookies == null) {
            this.cookies = CookieUtil.parseCookies(this.header);
        }
        return this.cookies;
    }

    public long getDateHeader(String string) {
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return -1;
        }
        return HttpDateFormat.parse((String)string2);
    }

    public String getHeader(String string) {
        return this.header.get(string);
    }

    public Enumeration getHeaders(String string) {
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return new Vector(0).elements();
        }
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (c == ',') {
                String string3 = stringBuffer.toString().trim();
                if (string3.length() > 0) {
                    vector.addElement(string3);
                }
                stringBuffer.setLength(0);
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        if (stringBuffer.length() > 0) {
            vector.addElement(stringBuffer.toString().trim());
        }
        return vector.elements();
    }

    public Enumeration getHeaderNames() {
        return this.header.getFieldNames();
    }

    public int getIntHeader(String string) {
        return this.header.getInt(string, -1);
    }

    public String getMethod() {
        return this.requestLine.getMethod();
    }

    public String getPathInfo() {
        if (this.aliasPath == null) {
            return this.requestLine.getUri();
        }
        if (this.aliasPath.length() == this.requestLine.getUri().length()) {
            return null;
        }
        return this.requestLine.getUri().substring(this.aliasPath.length());
    }

    public String getPathTranslated() {
        return this.getRealPath(this.getPathInfo());
    }

    public String getQueryString() {
        return this.requestLine.getQuery();
    }

    public String getRemoteUser() {
        String string = this.getHeader("authorization");
        if (string != null && string.startsWith("Basic ")) {
            String string2 = string.substring("Basic ".length());
            string2 = new String(Base64.decode((String)string2));
            int n = string2.indexOf(58);
            return new String(string2.substring(0, n));
        }
        String string3 = (String)this.getSession().getAttribute("sessionInfoUser");
        if (string3 != null) {
            return string3;
        }
        Cookie[] cookieArray = this.getCookies();
        String string4 = CookieUtil.getCookieName(this, "niagara_auth");
        int n = 0;
        while (cookieArray != null && n < cookieArray.length) {
            if (cookieArray[n].getName().equals(string4)) {
                String string5 = cookieArray[n].getValue();
                string5 = Base64.decodeToString((String)string5);
                int n2 = string5.indexOf(58);
                return new String(string5.substring(0, n2));
            }
            ++n;
        }
        if (!string4.equals("niagara_auth")) {
            n = 0;
            while (cookieArray != null && n < cookieArray.length) {
                if (cookieArray[n].getName().equals("niagara_auth")) {
                    String string6 = cookieArray[n].getValue();
                    string6 = Base64.decodeToString((String)string6);
                    int n3 = string6.indexOf(58);
                    return new String(string6.substring(0, n3));
                }
                ++n;
            }
        }
        return null;
    }

    public String getRequestedSessionId() {
        HttpSession httpSession = this.getSession(false);
        if (httpSession != null) {
            return httpSession.getId();
        }
        Cookie[] cookieArray = this.getCookies();
        if (cookieArray == null) {
            return null;
        }
        String string = CookieUtil.getCookieName(this, "niagara_session");
        int n = cookieArray.length;
        while (--n >= 0) {
            if (!cookieArray[n].getName().equals(string)) continue;
            return cookieArray[n].getValue();
        }
        return null;
    }

    public String getRequestURI() {
        return this.requestLine.getUri();
    }

    public StringBuffer getRequestURL() {
        return HttpUtils.getRequestURL(this);
    }

    public String getServletPath() {
        return this.aliasPath;
    }

    public void setAliasPath(String string) {
        this.aliasPath = string;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean bl) {
        String string;
        if (this.session != null) {
            return this.session;
        }
        NHttpSessionContext nHttpSessionContext = this.httpd.sessionContext;
        Cookie[] cookieArray = this.getCookies();
        if (cookieArray != null) {
            string = CookieUtil.getCookieName(this, "niagara_session");
            int n = cookieArray.length;
            while (--n >= 0) {
                if (!cookieArray[n].getName().equals(string)) continue;
                this.session = nHttpSessionContext.getSession(cookieArray[n].getValue());
                if (this.session == null) break;
                if (IPAddressUtil.isIpv6Address((String)this.getRemoteAddr()) || IPAddressUtil.isIpv4MappedAddress((String)this.getRemoteAddr())) {
                    if (this.session.getAttribute("ipv6RemoteAddr") == null) {
                        this.session.setAttribute("ipv6RemoteAddr", this.getRemoteAddr());
                        break;
                    }
                    if (this.getRemoteAddr().equals(this.session.getAttribute("ipv6RemoteAddr"))) break;
                    this.session = null;
                    break;
                }
                if (this.session.getAttribute("ipv4RemoteAddr") == null) {
                    this.session.setAttribute("ipv4RemoteAddr", this.getRemoteAddr());
                    break;
                }
                if (this.getRemoteAddr().equals(this.session.getAttribute("ipv4RemoteAddr"))) break;
                this.session = null;
                break;
            }
        }
        if (this.session == null && bl) {
            this.session = nHttpSessionContext.create("s");
            if (IPAddressUtil.isIpv6Address((String)this.getRemoteAddr()) || IPAddressUtil.isIpv4MappedAddress((String)this.getRemoteAddr())) {
                this.session.setAttribute("ipv6RemoteAddr", this.getRemoteAddr());
            } else {
                this.session.setAttribute("ipv4RemoteAddr", this.getRemoteAddr());
            }
            string = CookieUtil.getCookieName(this, "niagara_session");
            Cookie cookie = new Cookie(string, this.session.getId());
            cookie.setPath("/");
            this.response.addCookie(cookie);
        }
        return this.session;
    }

    public void resetSession() {
        if (this.session != null) {
            this.session.invalidate();
            this.session = null;
        }
        this.session = this.getSession(true);
    }

    public boolean isRequestedSessionIdValid() {
        boolean bl = false;
        if (this.getSession(false) != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public void closeRequest() {
        if (this.nServetInputStream != null) {
            this.nServetInputStream.readFully();
        }
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        throw new UnsupportedOperationException();
    }

    private final /* synthetic */ void this() {
        this.contentLength = -1;
        this.wroteContinue = false;
    }

    public HttpRequest(Httpd httpd, RequestInfo requestInfo, RequestLine requestLine, InputStream inputStream, OutputStream outputStream) throws IOException {
        this.this();
        this.httpd = httpd;
        this.reqInfo = requestInfo;
        this.requestLine = requestLine;
        this.in = inputStream;
        this.out = outputStream;
        this.read(inputStream);
        this.getSession(false);
        if (requestLine.getMethod().equals("POST") || requestLine.getMethod().equals("PUT")) {
            this.nServetInputStream = (NServletInputStream)this.getInputStream();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PrincipalWrapper
    implements Principal {
        String principalName;

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            return object.toString().equals(this.principalName);
        }

        public String getName() {
            return this.principalName;
        }

        public int hashCode() {
            return this.principalName.hashCode();
        }

        public String toString() {
            return this.principalName;
        }

        PrincipalWrapper(String string) {
            this.principalName = string;
        }
    }
}

