/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpd;

import com.tridium.httpd.HttpdUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileServlet
extends HttpServlet {
    public static final String padding = "                              ";
    private String docRoot;
    private DateFormat df;
    private StringBuffer scratch;

    protected String getRealPath(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getPathInfo();
        string = string == null ? "/" : "/" + string;
        if (this.docRoot == null) {
            return httpServletRequest.getRealPath(string);
        }
        return HttpdUtils.getRealPath(this.docRoot, string);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.sendFile(httpServletRequest, httpServletResponse, true);
    }

    public void doHead(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.sendFile(httpServletRequest, httpServletResponse, false);
    }

    public void sendFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws IOException {
        String string = this.getRealPath(httpServletRequest);
        File file = new File(string);
        if (!file.exists()) {
            httpServletResponse.sendError(404);
            return;
        }
        if (file.isDirectory()) {
            try {
                this.sendDirectory(file, httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        long l = httpServletRequest.getDateHeader("If-Modified-Since");
        long l2 = file.lastModified() / 1000L * 1000L;
        if (l != (long)-1 && l2 <= l) {
            httpServletResponse.sendError(304);
            return;
        }
        httpServletResponse.setStatus(200);
        String string2 = this.getServletConfig().getServletContext().getMimeType(string);
        httpServletResponse.setContentType(string2);
        int n = (int)file.length();
        httpServletResponse.setContentLength(n);
        httpServletResponse.setDateHeader("Last-Modified", l2);
        if (bl) {
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            }
            catch (Exception exception) {
                httpServletResponse.sendError(404);
                return;
            }
            BufferedOutputStream bufferedOutputStream = null;
            try {
                bufferedOutputStream = new BufferedOutputStream(httpServletResponse.getOutputStream());
                if (n != -1) {
                    this.sendKnownSize(n, bufferedInputStream, bufferedOutputStream);
                } else {
                    this.sendUnknownSize(bufferedInputStream, bufferedOutputStream);
                }
                bufferedOutputStream.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                httpServletResponse.sendError(500);
            }
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (Exception exception) {}
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        super.doPost(httpServletRequest, httpServletResponse);
    }

    public void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        super.doDelete(httpServletRequest, httpServletResponse);
    }

    private final void sendKnownSize(int n, InputStream inputStream, OutputStream outputStream) throws IOException {
        if (n == -1) {
            this.sendUnknownSize(inputStream, outputStream);
            return;
        }
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = new byte[Math.min(n, 16384)];
        do {
            if ((n3 = inputStream.read(byArray)) == -1) continue;
            outputStream.write(byArray, 0, n3);
            n2 += n3;
        } while (n2 < n && n3 != -1);
    }

    private final void sendUnknownSize(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = 0;
        byte[] byArray = new byte[2048];
        do {
            if ((n = inputStream.read(byArray)) == -1) continue;
            outputStream.write(byArray, 0, n);
        } while (n != -1);
    }

    public void sendDirectory(File file, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = httpServletRequest.getRequestURI();
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.print("<html>\n");
        printWriter.println("<h1>Index of " + string + "</h1>");
        if (string.length() != 0 && !string.equals("/") && !string.equalsIgnoreCase(httpServletRequest.getServletPath())) {
            printWriter.print("<b>");
            this.writeLink(printWriter, "Parent Directory", this.getParent(string));
            printWriter.println("</b>");
        }
        this.beginFileList(printWriter);
        boolean bl = false;
        if (string.charAt(string.length() - 1) == '/') {
            bl = true;
        }
        boolean bl2 = bl ^ true;
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = null;
            string2 = bl2 ? string + '/' + stringArray[n] : string + stringArray[n];
            File file2 = new File(file, stringArray[n]);
            this.writeFileLink(printWriter, file2, string2);
            ++n;
        }
        this.endFileList(printWriter);
        printWriter.print("</html>");
        printWriter.flush();
    }

    public void writeLink(PrintWriter printWriter, String string, String string2) {
        printWriter.print("<a href=\"" + string2 + "\">" + string + "</a>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLinkLine(String string, String string2) {
        StringBuffer stringBuffer = this.scratch;
        synchronized (stringBuffer) {
            this.scratch.setLength(0);
            this.scratch.append("<a href=\"").append(string2).append("\">");
            this.scratch.append(string).append("</a>");
            return this.scratch.toString();
        }
    }

    public String pad(String string, int n) {
        int n2 = n - string.length();
        if (n2 > 0) {
            return string + padding.substring(0, Math.min(n2, 30));
        }
        return string;
    }

    public void beginFileList(PrintWriter printWriter) {
        printWriter.print("<pre>");
        printWriter.print(this.pad("Name", 25));
        printWriter.print(this.pad("Last Modified", 28));
        printWriter.print("Size");
        printWriter.println("</pre><hr>");
        printWriter.println("<pre>");
    }

    public void endFileList(PrintWriter printWriter) {
        printWriter.println("</pre>");
    }

    public void writeFileLink(PrintWriter printWriter, File file, String string) {
        int n;
        if (file.isDirectory()) {
            printWriter.print("<b>");
        }
        String string2 = file.getName();
        this.writeLink(printWriter, string2, string);
        if (file.isDirectory()) {
            printWriter.print("</b>");
        }
        if ((n = 25 - string2.length()) > 0) {
            printWriter.print(this.pad(" ", n));
        }
        String string3 = this.getTime(file.lastModified());
        printWriter.print(string3);
        n = 28 - string3.length();
        if (n > 0) {
            printWriter.print(this.pad(" ", n));
        }
        if (!file.isDirectory()) {
            printWriter.print(this.getSize(file.length()));
        }
        printWriter.println();
    }

    public String getTime(long l) {
        if (this.df == null) {
            this.df = new SimpleDateFormat("dd MMM yyyy, HH:mm:ss");
        }
        return this.df.format(new Date(l));
    }

    protected String getSize(long l) {
        long l2 = l / 1000L;
        long l3 = l - l2;
        if (l3 > 0L) {
            String string = Long.toString(l3);
            return "" + l2 + '.' + string.charAt(0) + 'K';
        }
        return "" + l2 + 'K';
    }

    public String getParent(String string) {
        int n = string.lastIndexOf("/", string.length() - 2);
        String string2 = string.substring(0, n);
        return string2;
    }

    protected String getExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return null;
    }

    private final /* synthetic */ void this() {
        this.scratch = new StringBuffer(30);
    }

    public FileServlet() {
        this(null);
    }

    public FileServlet(String string) {
        this.this();
        this.docRoot = string;
    }
}

