/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpd;

import com.tridium.net.HttpRequestHeader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.baja.naming.SlotPath;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class CookieUtil {
    private static DateFormat dateFormat = new SimpleDateFormat("EEEEE, dd-MMM-yyyy HH:mm:ss");
    public static final String NIAGARA_TUNNEL_HEADER = "niagara-tunnel";

    public static void write(Cookie cookie, PrintWriter printWriter) throws IOException {
        int n = cookie.getVersion();
        if (n == 0) {
            CookieUtil.writeVersion0(cookie, printWriter);
        } else {
            CookieUtil.writeVersion1(cookie, printWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void writeVersion0(Cookie cookie, PrintWriter printWriter) {
        String string;
        String string2;
        printWriter.print(cookie.getName());
        printWriter.print('=');
        printWriter.print(cookie.getValue());
        int n = cookie.getMaxAge();
        if (n >= 0) {
            printWriter.print(';');
            long l = 0L;
            if (n > 0) {
                long l2 = System.currentTimeMillis();
                l = l2 + 1000L * (long)n;
            }
            printWriter.print(" expires=");
            String string3 = null;
            DateFormat dateFormat = CookieUtil.dateFormat;
            synchronized (dateFormat) {
                string3 = CookieUtil.dateFormat.format(new Date(l));
                // MONITOREXIT @DISABLED, blocks:[0, 1, 8] lbl17 : MonitorExitStatement: MONITOREXIT : var6_7
                printWriter.print(string3);
                printWriter.print(" GMT");
            }
        }
        if ((string2 = cookie.getPath()) != null) {
            printWriter.print(';');
            printWriter.print(" path=");
            printWriter.print(string2);
        }
        if ((string = cookie.getDomain()) != null) {
            printWriter.print(';');
            printWriter.print(" domain=");
            printWriter.print(string);
        }
        if (cookie.getSecure()) {
            printWriter.print(';');
            printWriter.print(" secure");
        }
        if (cookie.getHttpOnly()) {
            printWriter.print(';');
            printWriter.print(" HttpOnly");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void writeVersion1(Cookie cookie, PrintWriter printWriter) {
        String string;
        int n;
        String string2;
        printWriter.print(cookie.getName());
        printWriter.print('=');
        printWriter.print(cookie.getValue());
        String string3 = cookie.getComment();
        if (string3 != null) {
            printWriter.print(';');
            printWriter.print("comment=");
            printWriter.print(string3);
        }
        if ((string2 = cookie.getDomain()) != null) {
            printWriter.print(';');
            printWriter.print("domain=");
            printWriter.print(string2);
        }
        if ((n = cookie.getMaxAge()) >= 0) {
            printWriter.print(';');
            printWriter.print("max-Age=");
            printWriter.print(n);
            printWriter.print(';');
            long l = System.currentTimeMillis();
            long l2 = l + (long)n;
            printWriter.print("expires=");
            String string4 = null;
            DateFormat dateFormat = CookieUtil.dateFormat;
            synchronized (dateFormat) {
                string4 = CookieUtil.dateFormat.format(new Date(l2));
                // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl26 : MonitorExitStatement: MONITOREXIT : var10_9
                printWriter.print(string4);
                printWriter.print(" GMT");
            }
        }
        if ((string = cookie.getPath()) != null) {
            printWriter.print(';');
            printWriter.print("path=");
            printWriter.print(string);
        }
        if (cookie.getSecure()) {
            printWriter.print(';');
            printWriter.print("secure");
        }
        printWriter.print(";version=1");
    }

    public static Cookie[] parseCookies(HttpRequestHeader httpRequestHeader) {
        String[] stringArray = httpRequestHeader.getCookies();
        if (stringArray == null) {
            return null;
        }
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>(stringArray.length);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n2], ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                int n3 = string.indexOf(61);
                if (n3 == -1) continue;
                String string2 = string.substring(0, n3).trim();
                String string3 = string.substring(n3 + 1);
                arrayList.add(new Cookie(string2, string3));
            }
            ++n2;
        }
        return arrayList.toArray(new Cookie[arrayList.size()]);
    }

    public static String getCookieName(HttpServletRequest httpServletRequest, String string) {
        String string2;
        String string3 = string2 = httpServletRequest != null ? httpServletRequest.getHeader(NIAGARA_TUNNEL_HEADER) : null;
        if (string2 != null && string2.length() > 0 && !string2.equals("/")) {
            return string + SlotPath.escape((String)string2);
        }
        return string;
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

