/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.util;

import com.tridium.lonIp.datatypes.BChannelMember;
import com.tridium.lonIp.datatypes.BIpChannel;
import com.tridium.lonIp.datatypes.BIpLonNetworkConfig;
import com.tridium.lonIp.datatypes.BMemberTable;
import com.tridium.lonIp.enums.BIpLonRouterTypeEnum;
import com.tridium.lonIp.link.LonIpAddress;
import com.tridium.lonIp.link.LonIpLinkLayer;
import com.tridium.lonIp.messages.LonIp;
import com.tridium.lonIp.messages.LonIpMessage;
import com.tridium.lonworks.datatypes.BLonRouteTable;
import com.tridium.lonworks.loncomm.NAppBuffer;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Context;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LonIpAddressManager
implements LonIp {
    private static final int WAIT = 0;
    private static final int USED_HASH = 1;
    private static final int USED_BCAST = 2;
    private static final int RCV_RESP = 3;
    int state;
    int tag;
    LonAddress sndAdr;
    LonIpMessage ipMsgHold;
    LonIpAddress bcast;
    LonIpAddress repeats;
    Hashtable adrHash;
    boolean staleSend;
    private BLonNetwork lonworks;
    private BIpChannel ipChan;
    private BIpLonNetworkConfig netCfg;
    private BMemberTable memTab;

    public synchronized void receivedResponseMessage(LonIpMessage lonIpMessage, int n) {
        if (this.state == 2 && this.tag == n) {
            BChannelMember bChannelMember = this.memTab.findEntry(lonIpMessage.getSrcAddress(), lonIpMessage.getSrcPort());
            LonIpAddress lonIpAddress = new LonIpAddress(bChannelMember, this.netCfg);
            lonIpAddress.copyToNext(this.repeats);
            this.adrHash.put(this.sndAdr, lonIpAddress);
        }
        if (this.tag == n && this.ipMsgHold != null) {
            this.ipMsgHold.responseReceived();
            this.ipMsgHold = null;
        }
        this.state = 3;
    }

    public synchronized void getSendList(LonIpMessage lonIpMessage, NAppBuffer nAppBuffer) {
        LonIpAddress lonIpAddress;
        if (this.staleSend) {
            this.updateSendLists();
        }
        if (this.state == 1) {
            this.adrHash.remove(this.sndAdr);
        }
        LonAddress lonAddress = nAppBuffer.getDestAddress();
        switch (lonAddress.getAddressType()) {
            case 0: 
            case 3: 
            case 126: {
                this.state = 0;
                lonIpMessage.sendList = this.bcast;
                return;
            }
        }
        this.tag = nAppBuffer.getTag();
        int n = 0;
        if (!nAppBuffer.isResp()) {
            lonIpAddress = null;
            switch (nAppBuffer.getServiceType().getOrdinal()) {
                case 0: {
                    n = 1;
                    lonIpAddress = nAppBuffer.getTransmitTimer();
                    break;
                }
                case 3: {
                    n = 1;
                    lonIpAddress = nAppBuffer.getTransmitTimer();
                    break;
                }
                case 1: {
                    lonIpAddress = nAppBuffer.getRepeatTimer();
                    break;
                }
            }
            if (lonIpAddress != null) {
                lonIpMessage.retries = nAppBuffer.getRetryCount();
                lonIpMessage.repeatTime = lonIpAddress.getTime();
            }
        }
        lonIpAddress = (LonIpAddress)this.adrHash.get(lonAddress);
        this.sndAdr = lonAddress;
        if (lonIpAddress != null) {
            this.state = n;
            lonIpMessage.sendList = lonIpAddress;
        } else {
            this.state = 2;
            lonIpMessage.sendList = this.bcast;
        }
        if (n != 0) {
            this.ipMsgHold = lonIpMessage;
        }
    }

    public void memberChanged(Context context) {
        this.staleSend = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void updateSendLists() {
        Object object;
        BChannelMember[] bChannelMemberArray = this.memTab.getChannelMembers();
        int n = 1;
        int n2 = 0;
        Object object2 = null;
        LonIpAddress lonIpAddress = null;
        Hashtable<Object, LonIpAddress> hashtable = new Hashtable<Object, LonIpAddress>(64);
        int n3 = 0;
        while (n3 < bChannelMemberArray.length) {
            object = bChannelMemberArray[n3].getRouterType();
            if (object == BIpLonRouterTypeEnum.Bridge || object == BIpLonRouterTypeEnum.Repeater) {
                LonIpAddress lonIpAddress2 = new LonIpAddress(bChannelMemberArray[n3], this.netCfg);
                lonIpAddress2.next = lonIpAddress;
                lonIpAddress = lonIpAddress2;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < bChannelMemberArray.length) {
            if (!this.netCfg.isLocal(bChannelMemberArray[n3])) {
                n = this.findMax(bChannelMemberArray[n3].getSubnetMask(), n);
                n2 = this.findMax(bChannelMemberArray[n3].getGroupMask(), n2);
                object = new LonIpAddress(bChannelMemberArray[n3], this.netCfg);
                ((LonIpAddress)object).next = object2;
                object2 = object;
                hashtable.put(bChannelMemberArray[n3].getSubnetNode(), ((LonIpAddress)object).copy(lonIpAddress));
                hashtable.put(bChannelMemberArray[n3].getNeuronId(), ((LonIpAddress)object).copy(lonIpAddress));
            }
            ++n3;
        }
        LonIpAddressManager lonIpAddressManager = this;
        synchronized (lonIpAddressManager) {
            this.bcast = object2;
            this.staleSend = false;
            this.adrHash = hashtable;
            this.repeats = lonIpAddress;
            return;
        }
    }

    private final int findMax(BLonRouteTable bLonRouteTable, int n) {
        int n2 = n;
        while (n2 < 255) {
            if (!bLonRouteTable.getFlag(n2)) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps();
        spyWriter.trTitle((Object)"sendlist", 1);
        spyWriter.prop((Object)"bcast", (Object)this.ipToString(this.bcast));
        spyWriter.prop((Object)"repeats", (Object)this.ipToString(this.repeats));
        spyWriter.endProps();
        spyWriter.startProps();
        spyWriter.trTitle((Object)"adrHash", 1);
        if (this.adrHash == null) {
            this.updateSendLists();
        }
        Enumeration enumeration = this.adrHash.keys();
        while (enumeration.hasMoreElements()) {
            LonAddress lonAddress = (LonAddress)enumeration.nextElement();
            LonIpAddress lonIpAddress = (LonIpAddress)this.adrHash.get(lonAddress);
            spyWriter.prop((Object)lonAddress, (Object)this.ipToString(lonIpAddress));
        }
        spyWriter.endProps();
    }

    private final String ipToString(LonIpAddress lonIpAddress) {
        StringBuffer stringBuffer = new StringBuffer();
        while (lonIpAddress != null) {
            stringBuffer.append(lonIpAddress).append(", ");
            lonIpAddress = lonIpAddress.next;
        }
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.state = 0;
        this.ipMsgHold = null;
        this.staleSend = true;
    }

    public LonIpAddressManager(BLonNetwork bLonNetwork, LonIpLinkLayer lonIpLinkLayer) {
        this.this();
        this.lonworks = bLonNetwork;
        this.ipChan = (BIpChannel)bLonNetwork.get("ipChannel");
        this.netCfg = this.ipChan.getNetworkConfig();
        this.memTab = this.ipChan.getMemberTable();
        ((BIpChannel)bLonNetwork.get("ipChannel")).registerAddressManager(this);
    }
}

