/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.messages;

import com.tridium.lonIp.datatypes.BDateTime;
import com.tridium.lonIp.datatypes.BIpAddress;
import com.tridium.lonIp.messages.LonIpMessage;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RequestMessage
extends LonIpMessage {
    public BDateTime dateTime;
    public int reason;
    public int requestAll;
    public boolean clear;
    public int requestId;
    public int segmentId;
    public BDateTime since;
    public BIpAddress ipAddress;
    public int ipUcPort;

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        this.dateTime = BDateTime.fromInputStream(lonInputStream);
        int n = lonInputStream.readUnsigned8();
        this.reason = n & 3;
        this.requestAll = n & 4;
        boolean bl = false;
        if ((n & 8) > 0) {
            bl = true;
        }
        this.clear = bl;
        this.requestId = lonInputStream.readUnsigned16();
        this.segmentId = lonInputStream.readUnsigned8();
        this.since = BDateTime.fromInputStream(lonInputStream);
        this.ipAddress = BIpAddress.fromInputStream(lonInputStream);
        if (lonInputStream.available() >= 4) {
            lonInputStream.readUnsigned16();
            this.ipUcPort = lonInputStream.readUnsigned16();
        }
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        this.dateTime.toOutputStream(lonOutputStream);
        lonOutputStream.writeUnsigned8(this.reason | this.requestAll | (this.clear ? 8 : 0));
        lonOutputStream.writeUnsigned16(this.requestId);
        lonOutputStream.writeUnsigned8(this.segmentId);
        this.since.toOutputStream(lonOutputStream);
        this.ipAddress.toOutputStream(lonOutputStream);
        if (this.ipUcPort > 0) {
            lonOutputStream.writeUnsigned16(0);
            lonOutputStream.writeUnsigned16(this.ipUcPort);
        }
    }

    private final /* synthetic */ void this() {
        this.ipAddress = BIpAddress.DEFAULT;
        this.ipUcPort = 0;
    }

    public RequestMessage() {
        this.this();
    }

    public RequestMessage(int n) {
        this(n, BDateTime.DEFAULT);
    }

    public RequestMessage(int n, BDateTime bDateTime) {
        this.this();
        this.packetType = n;
        this.dateTime = BDateTime.make();
        this.requestId = 1;
        this.reason = 0;
        this.requestAll = 4;
        this.since = bDateTime;
    }
}

