/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.messages;

import com.tridium.lonIp.datatypes.BIpAddress;
import com.tridium.lonIp.datatypes.BIpLonNetworkConfig;
import com.tridium.lonIp.datatypes.BTimeStamp;
import com.tridium.lonIp.link.LonIpAddress;
import com.tridium.lonIp.messages.Acknowledge;
import com.tridium.lonIp.messages.ChannelMembership;
import com.tridium.lonIp.messages.ChannelRouting;
import com.tridium.lonIp.messages.DataMessage;
import com.tridium.lonIp.messages.DeviceRegistration;
import com.tridium.lonIp.messages.LonIp;
import com.tridium.lonIp.messages.RequestMessage;
import com.tridium.lonIp.messages.SendList;
import com.tridium.lonIp.messages.StatisticsResp;
import com.tridium.lonIp.messages.Unknown;
import com.tridium.lonworks.loncomm.LinkedQueue;
import com.tridium.lonworks.util.LonByteArrayUtil;
import java.net.InetAddress;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class LonIpMessage
implements LinkedQueue.Linkable,
LonIp {
    private static final byte[] DEFAULT_SESSION_ID = new byte[4];
    public int retries;
    public int repeatTime;
    public int packetLength;
    public int version;
    public int packetType;
    public int extendedHdrSize;
    public int protocolFlags;
    public int vendorCode;
    public byte[] sessionId;
    public int sequenceNumber;
    public BTimeStamp timeStamp;
    public boolean hasExtendedNat;
    public BIpAddress ipAdr;
    public BIpAddress natAdr;
    public int ipPort;
    public LonIpAddress sendList;
    private InetAddress srcAddress;
    private int srcPort;
    public LinkedQueue.Linkable next;

    public static LonIpMessage make(byte[] byArray) throws LonException {
        LonIpMessage lonIpMessage = null;
        switch (byArray[3]) {
            case 1: {
                lonIpMessage = new DataMessage();
                break;
            }
            case 3: 
            case 113: {
                lonIpMessage = new DeviceRegistration();
                break;
            }
            case 96: 
            case 99: 
            case 100: 
            case 102: 
            case 104: {
                lonIpMessage = new RequestMessage();
                break;
            }
            case 4: {
                lonIpMessage = new ChannelMembership();
                break;
            }
            case 6: {
                lonIpMessage = new SendList();
                break;
            }
            case 8: {
                lonIpMessage = new ChannelRouting();
                break;
            }
            case 7: {
                lonIpMessage = new Acknowledge();
                break;
            }
            case 112: {
                lonIpMessage = new StatisticsResp();
                break;
            }
            default: {
                lonIpMessage = new Unknown();
            }
        }
        if (lonIpMessage != null) {
            lonIpMessage.fromNetworkBytes(byArray);
        }
        return lonIpMessage;
    }

    public boolean isDataMessage() {
        return false;
    }

    public byte[] toNetworkBytes() {
        LonOutputStream lonOutputStream = new LonOutputStream();
        lonOutputStream.writeUnsigned16(0);
        lonOutputStream.writeUnsigned8(this.version);
        lonOutputStream.writeUnsigned8(this.packetType);
        lonOutputStream.writeUnsigned8(this.hasExtendedNat ? 3 : 0);
        lonOutputStream.writeUnsigned8(this.protocolFlags);
        lonOutputStream.writeUnsigned16(this.vendorCode);
        lonOutputStream.writeByteArray(this.sessionId, 4);
        lonOutputStream.writeSigned32(this.sequenceNumber);
        this.timeStamp.toOutputStream(lonOutputStream);
        if (this.hasExtendedNat) {
            this.ipAdr.toOutputStream(lonOutputStream);
            this.natAdr.toOutputStream(lonOutputStream);
            lonOutputStream.writeUnsigned16(this.ipPort);
            lonOutputStream.writeUnsigned16(0);
        }
        this.toOutputStream(lonOutputStream);
        byte[] byArray = lonOutputStream.toByteArray();
        int n = byArray.length;
        byArray[0] = (byte)(n >> 8 & 0xFF);
        byArray[1] = (byte)(n & 0xFF);
        return byArray;
    }

    public final void fromNetworkBytes(byte[] byArray) throws LonException {
        LonInputStream lonInputStream = new LonInputStream(byArray);
        this.packetLength = lonInputStream.readUnsigned16();
        this.version = lonInputStream.readUnsigned8();
        this.packetType = lonInputStream.readUnsigned8();
        this.extendedHdrSize = lonInputStream.readUnsigned8();
        this.protocolFlags = lonInputStream.readUnsigned8();
        this.vendorCode = lonInputStream.readUnsigned16();
        this.sessionId = lonInputStream.readByteArray(4);
        this.sequenceNumber = lonInputStream.readSigned32();
        this.timeStamp = BTimeStamp.fromInputStream(lonInputStream);
        if (this.extendedHdrSize == 3) {
            this.hasExtendedNat = true;
            this.ipAdr = BIpAddress.fromInputStream(lonInputStream);
            this.natAdr = BIpAddress.fromInputStream(lonInputStream);
            this.ipPort = lonInputStream.readUnsigned16();
            lonInputStream.readUnsigned16();
        } else if (this.extendedHdrSize > 0) {
            int n = 0;
            while (n < this.extendedHdrSize) {
                System.out.println("**** extended header " + LonByteArrayUtil.toString((byte[])lonInputStream.readByteArray(4)));
                ++n;
            }
        }
        this.fromInputStream(lonInputStream);
    }

    public abstract void fromInputStream(LonInputStream var1) throws LonException;

    public abstract void toOutputStream(LonOutputStream var1);

    public void addExtendedNat(BIpLonNetworkConfig bIpLonNetworkConfig, boolean bl) {
        this.hasExtendedNat = true;
        this.ipAdr = bIpLonNetworkConfig.getMyIpAddress();
        this.natAdr = bIpLonNetworkConfig.getNatIpAddress();
        this.ipPort = bl ? bIpLonNetworkConfig.getConfigServerPort() : bIpLonNetworkConfig.getRcvPort();
    }

    public synchronized boolean retry() {
        if (this.retries <= 0) {
            return false;
        }
        try {
            this.wait(this.repeatTime);
        }
        catch (Exception exception) {}
        --this.retries;
        boolean bl = false;
        if (this.retries >= 0) {
            bl = true;
        }
        return bl;
    }

    public synchronized void responseReceived() {
        this.retries = 0;
        this.notify();
    }

    public InetAddress getSrcAddress() {
        return this.srcAddress;
    }

    public void setSrcAddress(InetAddress inetAddress) {
        this.srcAddress = inetAddress;
    }

    public int getSrcPort() {
        return this.srcPort;
    }

    public void setSrcPort(int n) {
        this.srcPort = n;
    }

    public LinkedQueue.Linkable getNext() {
        return this.next;
    }

    public void setNext(LinkedQueue.Linkable linkable) {
        this.next = linkable;
    }

    private final /* synthetic */ void this() {
        this.retries = 0;
        this.repeatTime = 0;
        this.version = 1;
        this.extendedHdrSize = 0;
        this.protocolFlags = 0;
        this.vendorCode = 0;
        this.sessionId = DEFAULT_SESSION_ID;
        this.timeStamp = BTimeStamp.DEFAULT;
        this.hasExtendedNat = false;
        this.ipAdr = null;
        this.natAdr = null;
        this.sendList = null;
        this.srcAddress = null;
        this.next = null;
    }

    public LonIpMessage() {
        this.this();
    }
}

