/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.messages;

import com.tridium.lonIp.messages.LonIpMessage;
import com.tridium.lonworks.enums.BLonCompletionCode;
import com.tridium.lonworks.loncomm.NAppBuffer;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BAddressEntry;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BDomainId;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.lonworks.enums.BLonServiceType;
import javax.baja.lonworks.io.AppBuffer;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DataMessage
extends LonIpMessage {
    private static final int VERSION = 0;
    private static final int TPDU = 0;
    private static final int SPDU = 1;
    private static final int AuthPDU = 2;
    private static final int APDU = 3;
    private static final int TPDU_ACKD = 0;
    private static final int TPDU_UN_ACKD_RPT = 1;
    private static final int TPDU_ACK = 2;
    private static final int TPDU_REMINDER = 4;
    private static final int TPDU_REM_MSG = 5;
    private static final int SPDU_REQUEST = 0;
    private static final int SPDU_RESPONSE = 2;
    private static final int SPDU_REMINDER = 4;
    private static final int SPDU_REM_MSG = 5;
    private static final int BROADCAST = 0;
    private static final int GROUP = 1;
    private static final int SUBNET_NODE = 2;
    private static final int GROUP_RESPONSE = 2;
    private static final int NEURON_ID = 3;
    int adrFmt;
    int destSubnetGroup;
    int destNode;
    BNeuronId destNid;
    LonAddress destAddr;
    NAppBuffer appBuf;
    BLonNetwork lon;

    public AppBuffer getAppBuffer() {
        return this.appBuf;
    }

    public boolean isDataMessage() {
        return true;
    }

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        int n;
        this.appBuf = NAppBuffer.makeAppBuffer();
        this.appBuf.setCommand(16);
        lonInputStream.setBitFieldMark();
        this.appBuf.setPriority(lonInputStream.readBooleanBit(0, 7, 1));
        if (lonInputStream.readBit(1, 6, 2) != 0) {
            throw new RuntimeException("Invalid version in DataMessage");
        }
        int n2 = lonInputStream.readBit(1, 4, 2);
        this.adrFmt = lonInputStream.readBit(1, 2, 2);
        int n3 = lonInputStream.readBit(1, 0, 2);
        int n4 = lonInputStream.readUnsigned8();
        boolean bl = lonInputStream.readBooleanBit(3, 7, 1);
        BSubnetNode bSubnetNode = BSubnetNode.make((int)n4, (int)lonInputStream.readBit(3, 0, 7));
        this.appBuf.setSourceAddress(bSubnetNode);
        this.destSubnetGroup = lonInputStream.readUnsigned8();
        switch (this.adrFmt) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.destNode = lonInputStream.readBit(5, 0, 7);
                if (bl) break;
                lonInputStream.readByteArray(2);
                break;
            }
            case 3: {
                this.destNid = BNeuronId.make((byte[])lonInputStream.readByteArray(6));
                break;
            }
        }
        BDomainId bDomainId = BDomainId.make((int)n3, (byte[])lonInputStream.readByteArray(n3));
        lonInputStream.setBitFieldMark();
        block6 : switch (n2) {
            case 0: {
                n = lonInputStream.readBit(0, 4, 3);
                this.appBuf.setTag(lonInputStream.readBit(0, 0, 4));
                this.appBuf.setExplicitAddress(true);
                switch (n) {
                    case 0: {
                        this.appBuf.setServiceType(BLonServiceType.acked, true);
                        break block6;
                    }
                    case 1: {
                        this.appBuf.setServiceType(BLonServiceType.unackedRpt, true);
                        break block6;
                    }
                    case 2: {
                        this.appBuf.setQueue(6);
                        this.appBuf.setComplCode(BLonCompletionCode.succeeds);
                        break block6;
                    }
                    case 4: 
                    case 5: {
                        throw new RuntimeException("TPDU not implemented");
                    }
                }
                break;
            }
            case 1: {
                int n5 = lonInputStream.readBit(0, 4, 3);
                this.appBuf.setTag(lonInputStream.readBit(0, 0, 4));
                this.appBuf.setExplicitAddress(true);
                switch (n5) {
                    case 0: {
                        this.appBuf.setServiceType(BLonServiceType.request, true);
                        break block6;
                    }
                    case 2: {
                        this.appBuf.setQueue(6);
                        this.appBuf.setResp(true);
                        this.appBuf.setComplCode(BLonCompletionCode.succeeds);
                        break block6;
                    }
                    case 4: 
                    case 5: {
                        throw new RuntimeException("SPDU_REMINDER not implemented");
                    }
                }
                break;
            }
            case 2: {
                System.out.println("Authenticated pdu - not implemented.");
                break;
            }
            case 3: {
                this.appBuf.setServiceType(BLonServiceType.unacked, true);
                break;
            }
        }
        n = this.packetLength - lonInputStream.position() - 2;
        this.appBuf.readMessage(lonInputStream, n);
    }

    public boolean isMyMessage(BLonDevice bLonDevice) {
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        BSubnetNode bSubnetNode = bDeviceData.getSubnetNodeId();
        switch (this.adrFmt) {
            case 0: {
                boolean bl = false;
                if (this.destSubnetGroup == 0 || bSubnetNode.getSubnetId() == this.destSubnetGroup) {
                    bl = true;
                }
                return bl;
            }
            case 1: {
                BAddressEntry[] bAddressEntryArray = bDeviceData.getAddressTable().getAddresses();
                int n = 0;
                while (n < bAddressEntryArray.length) {
                    if (bAddressEntryArray[n].isGroupAddress() && bAddressEntryArray[n].getGroupOrSubnet() == this.destSubnetGroup) {
                        return true;
                    }
                    ++n;
                }
                return false;
            }
            case 2: {
                boolean bl = false;
                if (this.destSubnetGroup == bSubnetNode.getSubnetId() && this.destNode == bSubnetNode.getNodeId()) {
                    bl = true;
                }
                return bl;
            }
            case 3: {
                return this.destNid.equals((Object)bDeviceData.getNeuronId());
            }
        }
        return false;
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.setBitFieldMark();
        lonOutputStream.writeBooleanBit(this.appBuf.isPriority(), 0, 7, 1);
        lonOutputStream.writeBooleanBit(false, 0, 6, 1);
        lonOutputStream.writeBit(this.getDeltaBl(), 0, 0, 6);
        lonOutputStream.writeBit(0, 1, 6, 2);
        int n = 0;
        int n2 = 0;
        BLonServiceType bLonServiceType = this.appBuf.getServiceType();
        if (this.appBuf.isResp()) {
            n = 1;
            n2 = 2;
        } else if (bLonServiceType == BLonServiceType.acked) {
            n = 0;
            n2 = 0;
        } else if (bLonServiceType == BLonServiceType.unackedRpt) {
            n = 0;
            n2 = 1;
        } else if (bLonServiceType == BLonServiceType.request) {
            n = 1;
            n2 = 0;
        } else if (bLonServiceType == BLonServiceType.unacked) {
            n = 3;
        } else {
            throw new RuntimeException("Unknown format type");
        }
        lonOutputStream.writeBit(n, 1, 4, 2);
        int n3 = this.getAddressFormat();
        BDomainId bDomainId = this.lon.getLonNetmgmt().getDomainId();
        lonOutputStream.writeBit(n3 & 3, 1, 2, 2);
        lonOutputStream.writeBit(bDomainId.getLength(), 1, 0, 2);
        BSubnetNode bSubnetNode = this.lon.getLocalLonDevice().getSubnetNodeAddress();
        switch (n3) {
            case 0: {
                lonOutputStream.writeUnsigned8(bSubnetNode.getSubnetId());
                lonOutputStream.writeBit(1, 3, 7, 1);
                lonOutputStream.writeBit(bSubnetNode.getNodeId(), 3, 0, 7);
                lonOutputStream.writeUnsigned8(0);
                break;
            }
            case 2: {
                BSubnetNode bSubnetNode2 = (BSubnetNode)this.destAddr;
                lonOutputStream.writeUnsigned8(bSubnetNode.getSubnetId());
                lonOutputStream.writeBit(1, 3, 7, 1);
                lonOutputStream.writeBit(bSubnetNode.getNodeId(), 3, 0, 7);
                lonOutputStream.writeUnsigned8(bSubnetNode2.getSubnetId());
                lonOutputStream.writeBit(1, 5, 7, 1);
                lonOutputStream.writeBit(bSubnetNode2.getNodeId(), 5, 0, 7);
                break;
            }
            case 3: {
                BNeuronId bNeuronId = (BNeuronId)this.destAddr;
                lonOutputStream.writeUnsigned8(bSubnetNode.getSubnetId());
                lonOutputStream.writeBit(1, 3, 7, 1);
                lonOutputStream.writeBit(bSubnetNode.getNodeId(), 3, 0, 7);
                lonOutputStream.writeUnsigned8(0);
                lonOutputStream.writeByteArray(bNeuronId.getByteArray(), 6);
                break;
            }
        }
        if (bDomainId.getLength() > 0) {
            lonOutputStream.writeByteArray(bDomainId.getDomainId());
        }
        lonOutputStream.setBitFieldMark();
        switch (n) {
            case 0: 
            case 1: {
                lonOutputStream.writeBooleanBit(this.appBuf.isAuthenticate(), 0, 7, 1);
                lonOutputStream.writeBit(n2, 0, 4, 3);
                lonOutputStream.writeBit(this.appBuf.getTag(), 0, 0, 4);
                break;
            }
            case 3: {
                break;
            }
        }
        this.appBuf.writeMessage(lonOutputStream);
        lonOutputStream.writeUnsigned16(0);
    }

    public byte[] toNetworkBytes() {
        byte[] byArray = super.toNetworkBytes();
        int n = DataMessage.calculateChecksum(byArray, byArray.length - 2);
        byArray[byArray.length - 2] = (byte)(n >> 8 & 0xFF);
        byArray[byArray.length - 1] = (byte)(n & 0xFF);
        return byArray;
    }

    private final int getDeltaBl() {
        return 1;
    }

    private static final int calculateChecksum(byte[] byArray, int n) {
        int n2 = 4129;
        int n3 = -1;
        int n4 = 0;
        while (n4 < n) {
            int n5 = byArray[n4] & 0xFF;
            int n6 = 0;
            while (n6 < 8) {
                boolean bl = false;
                if ((n3 & 0x8000) > 0) {
                    bl = true;
                }
                boolean bl2 = bl;
                boolean bl3 = false;
                if ((n5 & 0x80) > 0) {
                    bl3 = true;
                }
                boolean bl4 = bl3;
                n3 = n3 << 1 & (char)-1;
                if (bl2 != bl4) {
                    n3 = (n3 ^ n2) & (char)-1;
                }
                n5 = n5 << 1 & 0xFF;
                ++n6;
            }
            ++n4;
        }
        return n3 ^= (char)-1;
    }

    private final int getAddressFormat() {
        this.destAddr = this.appBuf.getDestAddress();
        byte by = (byte)this.destAddr.getAddressType();
        switch (by) {
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 0;
            }
            case 127: {
                throw new RuntimeException("Attempt to communicate with local device. " + this.appBuf);
            }
        }
        throw new RuntimeException("Invalid address type in app buffer. " + this.appBuf);
    }

    private final /* synthetic */ void this() {
        this.appBuf = null;
        this.lon = null;
    }

    public DataMessage() {
        this.this();
    }

    public DataMessage(NAppBuffer nAppBuffer, BLonNetwork bLonNetwork) {
        this.this();
        this.packetType = 1;
        this.lon = bLonNetwork;
        this.appBuf = nAppBuffer;
    }
}

