/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.link;

import com.tridium.lonIp.ChannelMonitor;
import com.tridium.lonIp.ConfigServer;
import com.tridium.lonIp.NetMangementListener;
import com.tridium.lonIp.RouterListener;
import com.tridium.lonIp.Statistics;
import com.tridium.lonIp.datatypes.BDateTime;
import com.tridium.lonIp.datatypes.BIpAddress;
import com.tridium.lonIp.datatypes.BIpChannel;
import com.tridium.lonIp.datatypes.BIpLonNetworkConfig;
import com.tridium.lonIp.datatypes.BMemberTable;
import com.tridium.lonIp.link.LonIpAddress;
import com.tridium.lonIp.messages.DataMessage;
import com.tridium.lonIp.messages.LonIp;
import com.tridium.lonIp.messages.LonIpMessage;
import com.tridium.lonIp.util.LonIpAddressManager;
import com.tridium.lonIp.util.MemberAction;
import com.tridium.lonworks.enums.BLonCompletionCode;
import com.tridium.lonworks.loncomm.LinkedQueue;
import com.tridium.lonworks.loncomm.NAppBuffer;
import com.tridium.lonworks.loncomm.NLonComm;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.sys.NreLib;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import javax.baja.log.Log;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.datatypes.BAddressEntry;
import javax.baja.lonworks.datatypes.BLocal;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.lonworks.enums.BLonServiceType;
import javax.baja.lonworks.io.AppBuffer;
import javax.baja.lonworks.io.LonLinkLayer;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LonIpLinkLayer
implements LonLinkLayer,
LonIp {
    byte[] sessionId;
    int seqNum;
    private byte[] readOnly;
    private DatagramSocket udpPort;
    private AppBufferReceive appBuffRcv;
    private UdpReceiveDriver rcvDriver;
    private UdpTransmitDriver xmitDriver;
    private Thread appThread;
    private Thread rcvThread;
    private Thread xmitThread;
    private BLonNetwork lonworks;
    private NLonComm lonComm;
    private ChannelMonitor channelMon;
    private ConfigServer configSrv;
    private boolean done;
    private Log log;
    private NetMangementListener nmListner;
    private RouterListener rtrListner;
    public LonIpAddressManager adrMan;
    public Statistics stats;

    public void verifySettings() throws Exception {
    }

    private final void checkLicense() {
        try {
            Sys.getLicenseManager().getFeature("tridium", "lonIp").check();
        }
        catch (Throwable throwable) {
            this.lonworks.configFatal("Unlicensed");
            this.lonworks.getLog().error("LonIp not licensed.");
        }
    }

    public final void start() throws Exception {
        this.checkLicense();
        if (!this.lonworks.getEnabled() || this.lonworks.getStatus().isFault()) {
            return;
        }
        if (this.lonworks.get("ipChannel") == null) {
            this.lonworks.add("ipChannel", (BValue)new BIpChannel());
        }
        this.checkChannelInitialization();
        this.nmListner = new NetMangementListener(this, (LonComm)this.lonComm, this.lonworks);
        this.rtrListner = new RouterListener(this, (LonComm)this.lonComm, this.lonworks);
        InetAddress inetAddress = this.getNetConfig().getMyIpAddress().getInetAddress();
        if (this.getNetConfig().getMyIpAddress().equals((Object)BIpAddress.DEFAULT)) {
            inetAddress = NreLib.getLocalHost();
            this.getNetConfig().set(BIpLonNetworkConfig.myIpAddress, (BValue)BIpAddress.make(inetAddress), BMemberTable.internalChange);
        }
        this.udpPort = new DatagramSocket(this.getNetConfig().getRcvPort(), inetAddress);
        if (this.udpPort == null) {
            String string = "DatagramSocket is null!  Socket " + this.getNetConfig().getRcvPort() + " may be in use by another process.";
            this.log.error(string);
            throw new LonException(string);
        }
        this.done = false;
        this.appBuffRcv = new AppBufferReceive();
        this.appThread = new Thread((Runnable)this.appBuffRcv, this.lonComm.lonNetwork().getLogName() + ".AppBufferRcv");
        this.appThread.start();
        this.appThread.setPriority(5);
        this.rcvDriver = new UdpReceiveDriver();
        this.rcvThread = new Thread((Runnable)this.rcvDriver, this.lonComm.lonNetwork().getLogName() + ".LonIpRcvDriver");
        this.rcvThread.start();
        this.rcvThread.setPriority(5);
        this.xmitDriver = new UdpTransmitDriver();
        this.xmitThread = new Thread((Runnable)this.xmitDriver, this.lonComm.lonNetwork().getLogName() + ".LonIpXmitDriver");
        this.xmitThread.start();
        this.xmitThread.setPriority(5);
        this.channelMon.start();
        this.configSrv.start();
    }

    public void stop() {
        if (this.channelMon != null) {
            this.channelMon.stop();
        }
        if (this.configSrv != null) {
            this.configSrv.stop();
        }
        this.done = true;
        if (this.rcvThread != null) {
            this.rcvThread.interrupt();
        }
        if (this.xmitThread != null) {
            this.xmitThread.interrupt();
        }
        if (this.udpPort != null) {
            this.udpPort.close();
        }
    }

    public void sendLonMessage(AppBuffer appBuffer) {
        NAppBuffer nAppBuffer = (NAppBuffer)appBuffer;
        DataMessage dataMessage = new DataMessage(nAppBuffer, this.lonworks);
        dataMessage.sessionId = this.sessionId;
        this.adrMan.getSendList(dataMessage, nAppBuffer);
        this.xmitDriver.sendToDriver(dataMessage);
    }

    public void sendIpMessage(LonIpMessage lonIpMessage, LonIpAddress lonIpAddress) {
        lonIpMessage.sendList = lonIpAddress;
        this.xmitDriver.sendToDriver(lonIpMessage);
    }

    public void sendResponse(NAppBuffer nAppBuffer, LonMessage lonMessage) {
        NAppBuffer nAppBuffer2 = NAppBuffer.makeAppBuffer();
        nAppBuffer2.setTag(nAppBuffer.getTag());
        nAppBuffer2.setServiceType(BLonServiceType.request);
        nAppBuffer2.setPriority(nAppBuffer.isPriority());
        nAppBuffer2.setResp(true);
        nAppBuffer2.setDestAddress((LonAddress)nAppBuffer.getSourceAddress());
        nAppBuffer2.setMessage(lonMessage);
        nAppBuffer2.setNoTransaction(true);
        this.sendLonMessage((AppBuffer)nAppBuffer2);
    }

    private final void checkChannelInitialization() throws LonException {
        if (!this.getNetConfig().getIsConfigServer() && this.getNetConfig().getConfigServerIp() == BIpAddress.DEFAULT) {
            throw new LonException("No configuration server specified.");
        }
    }

    private final BIpLonNetworkConfig getNetConfig() {
        return this.channelMon.netCfg;
    }

    private final void routeIpMsg(LonIpMessage lonIpMessage) {
        if (lonIpMessage.vendorCode != 0 && (lonIpMessage.vendorCode != 1 || lonIpMessage.packetType != 104)) {
            if (this.log.isTraceOn()) {
                System.out.println("Vendor specific message type: " + Integer.toString(lonIpMessage.vendorCode, 16) + '.' + Integer.toString(lonIpMessage.packetType, 16));
            }
            return;
        }
        if (lonIpMessage.packetType == 1) {
            DataMessage dataMessage = (DataMessage)lonIpMessage;
            if (!dataMessage.isMyMessage((BLonDevice)this.lonworks.getLocalLonDevice())) {
                return;
            }
            NAppBuffer nAppBuffer = (NAppBuffer)dataMessage.getAppBuffer();
            if (!this.nmListner.receiveLonMessage(nAppBuffer) && !this.rtrListner.receiveLonMessage(nAppBuffer)) {
                if (nAppBuffer.isResponse()) {
                    this.adrMan.receivedResponseMessage(lonIpMessage, nAppBuffer.getTag());
                    this.lonComm.handleResponseMessage(nAppBuffer);
                } else {
                    this.appBuffRcv.receiveLonMessage(nAppBuffer);
                }
            }
        } else {
            this.channelMon.receiveMessage(lonIpMessage);
        }
    }

    private final void sendCompletion(DataMessage dataMessage) {
        NAppBuffer nAppBuffer = (NAppBuffer)dataMessage.getAppBuffer();
        BLonServiceType bLonServiceType = nAppBuffer.getServiceType();
        int n = nAppBuffer.getQueue();
        if ((n == 2 || n == 3) && (bLonServiceType == BLonServiceType.unackedRpt || bLonServiceType == BLonServiceType.unacked) || n == 4 || n == 5) {
            NAppBuffer nAppBuffer2 = this.makeCompletionBuf(nAppBuffer, BLonCompletionCode.succeeds);
            this.lonComm.handleResponseMessage(nAppBuffer2);
        }
    }

    private final NAppBuffer makeCompletionBuf(NAppBuffer nAppBuffer, BLonCompletionCode bLonCompletionCode) {
        byte[] byArray = nAppBuffer.toNetworkBytes();
        byte[] byArray2 = new byte[18];
        int n = byArray.length > 18 ? 18 : byArray.length;
        System.arraycopy(byArray, 0, byArray2, 0, n);
        NAppBuffer nAppBuffer2 = NAppBuffer.makeAppBuffer((byte[])byArray2);
        nAppBuffer2.setQueue(6);
        nAppBuffer2.setComplCode(bLonCompletionCode);
        return nAppBuffer2;
    }

    public void writeLinkDebug(String string, byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[').append(this.lonworks.getLogName()).append(']');
        stringBuffer.append(string).append(NmUtil.timeStamp());
        stringBuffer.append("|");
        if (n > byArray.length) {
            n = byArray.length;
        }
        int n2 = 20;
        if (n > 5) {
            n2 += byArray[4] * 4;
        }
        if (n > 0) {
            int n3 = 0;
            while (n3 < n) {
                if (n3 != 0 && n3 % 4 == 0) {
                    stringBuffer.append(' ');
                }
                if (n3 == n2) {
                    stringBuffer.append("\n                     ");
                }
                if ((byArray[n3] & 0xFF) < 16) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(Integer.toString(byArray[n3] & 0xFF, 16)).append(' ');
                ++n3;
            }
        }
        System.out.println(stringBuffer.toString());
    }

    public boolean isLinkDebug() {
        return this.lonComm.getLinkDebug();
    }

    private final boolean isLocal(NAppBuffer nAppBuffer) {
        return ((BSimple)nAppBuffer.getDestAddress()).getType().is(BLocal.TYPE);
    }

    private final void generateLocalResponse(NAppBuffer nAppBuffer) {
        byte[] byArray = nAppBuffer.toNetworkBytes();
        switch (nAppBuffer.getMessageCode()) {
            case 109: {
                int n = (byArray[18] << 8) + byArray[19];
                byte by = byArray[20];
                byte[] byArray2 = this.createResponseMsg(byArray, by + 1);
                System.arraycopy(this.readOnly, n, byArray2, 17, by);
                this.lonComm.handleResponseMessage(NAppBuffer.makeAppBuffer((byte[])byArray2));
                break;
            }
            case 102: {
                byte[] byArray3 = this.createResponseMsg(byArray, 1);
                this.lonComm.handleResponseMessage(NAppBuffer.makeAppBuffer((byte[])byArray3));
                break;
            }
            case 103: {
                byte by = byArray[17];
                byte[] byArray4 = this.createResponseMsg(byArray, 6);
                BAddressEntry bAddressEntry = this.lonworks.getLocalLonDevice().getDeviceData().getAddressTable().getAddressEntry((int)by);
                byte[] byArray5 = bAddressEntry.getRawAddress();
                System.arraycopy(byArray5, 0, byArray4, 17, 5);
                this.lonComm.handleResponseMessage(NAppBuffer.makeAppBuffer((byte[])byArray4));
                break;
            }
            default: {
                NAppBuffer nAppBuffer2 = this.makeCompletionBuf(nAppBuffer, BLonCompletionCode.fails);
                nAppBuffer2.exception = new LonException("No local neuron for lonIp local device.");
                this.lonComm.handleResponseMessage(nAppBuffer2);
            }
        }
    }

    private final byte[] createResponseMsg(byte[] byArray, int n) {
        byte[] byArray2 = new byte[16 + n];
        byArray2[0] = 22;
        byArray2[1] = (byte)(14 + n);
        byArray2[2] = byArray[2];
        byArray2[3] = (byte)(byArray[3] | 1);
        byArray2[4] = (byte)n;
        byArray2[16] = (byte)(byArray[16] & 0xFFFFFF3F | 0x20);
        return byArray2;
    }

    private final /* synthetic */ void this() {
        this.sessionId = BDateTime.make().getByteArray();
        this.seqNum = 0;
        byte[] byArray = new byte[40];
        byArray[1] = 16;
        byArray[2] = 83;
        byArray[3] = 56;
        byArray[4] = 55;
        byArray[7] = -94;
        byArray[8] = 64;
        byArray[9] = 20;
        byArray[10] = 64;
        byArray[11] = -1;
        byArray[12] = -1;
        byArray[13] = -112;
        byArray[15] = -114;
        byArray[16] = 1;
        byArray[17] = 3;
        byArray[18] = -128;
        byArray[20] = 3;
        byArray[21] = -4;
        byArray[22] = -16;
        byArray[23] = 7;
        byArray[26] = 68;
        byArray[27] = 88;
        byArray[28] = 88;
        byArray[29] = 1;
        byArray[30] = -1;
        byArray[31] = -1;
        byArray[33] = 103;
        byArray[35] = 4;
        this.readOnly = byArray;
        this.appThread = null;
        this.rcvThread = null;
        this.xmitThread = null;
    }

    public LonIpLinkLayer(LonComm lonComm, BLonNetwork bLonNetwork) {
        this.this();
        this.lonworks = bLonNetwork;
        this.lonComm = (NLonComm)lonComm;
        this.log = Log.getLog((String)bLonNetwork.getLogName());
        this.adrMan = new LonIpAddressManager(bLonNetwork, this);
        this.channelMon = new ChannelMonitor(bLonNetwork, this);
        this.configSrv = new ConfigServer(bLonNetwork, this);
        this.stats = new Statistics();
        MemberAction.init(bLonNetwork, this);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class AppBufferReceive
    implements Runnable {
        LinkedQueue appQueue;

        public void run() {
            while (!LonIpLinkLayer.this.done) {
                try {
                    NAppBuffer nAppBuffer = (NAppBuffer)this.appQueue.dequeue();
                    if (nAppBuffer == null) continue;
                    LonIpLinkLayer.this.lonComm.receiveLonMessage(nAppBuffer);
                }
                catch (ThreadDeath threadDeath) {
                    LonIpLinkLayer.this.done = true;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    LonIpLinkLayer.this.log.error("LonIpLinkLayer.AppBufferReceive error", throwable);
                }
            }
        }

        private final void receiveLonMessage(NAppBuffer nAppBuffer) {
            this.appQueue.enqueue((LinkedQueue.Linkable)nAppBuffer);
        }

        private final /* synthetic */ void this() {
            this.appQueue = new LinkedQueue();
        }

        private AppBufferReceive() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class UdpReceiveDriver
    implements Runnable {
        public void run() {
            block7: while (!LonIpLinkLayer.this.done) {
                byte[] byArray = new byte[1600];
                try {
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, 1600);
                    try {
                        LonIpLinkLayer.this.udpPort.receive(datagramPacket);
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        continue;
                    }
                    if (LonIpLinkLayer.this.isLinkDebug()) {
                        LonIpLinkLayer.this.writeLinkDebug("Rcvd:" + datagramPacket.getAddress() + ':' + datagramPacket.getPort() + "  ", byArray, datagramPacket.getLength());
                    }
                    int n = datagramPacket.getLength();
                    int n2 = 0;
                    byte[] byArray2 = byArray;
                    while (n2 < n) {
                        LonIpMessage lonIpMessage = LonIpMessage.make(byArray2);
                        lonIpMessage.setSrcAddress(datagramPacket.getAddress());
                        lonIpMessage.setSrcPort(datagramPacket.getPort());
                        LonIpLinkLayer.this.routeIpMsg(lonIpMessage);
                        if ((n2 += lonIpMessage.packetLength) < n) {
                            int n3 = ((byArray[n2] & 0xFF) << 8) + (byArray[n2 + 1] & 0xFF);
                            if (n3 + n2 > n) continue block7;
                            byArray2 = new byte[n3];
                            System.arraycopy(byArray, n2, byArray2, 0, n3);
                        }
                        LonIpLinkLayer.this.stats.receivedMsg(lonIpMessage, lonIpMessage.getSrcAddress(), byArray2.length);
                    }
                }
                catch (SocketException socketException) {
                    if (LonIpLinkLayer.this.done) continue;
                    LonIpLinkLayer.this.log.error("SocketException in LonIpLinkLayer!", (Throwable)socketException);
                }
                catch (IOException iOException) {
                    if (LonIpLinkLayer.this.done) continue;
                    LonIpLinkLayer.this.log.error("Error receiving LonIp packet!", (Throwable)iOException);
                }
                catch (ThreadDeath threadDeath) {
                    LonIpLinkLayer.this.done = true;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    LonIpLinkLayer.this.log.error("LonIpLinkLayer.UdpReceiveDriver error", throwable);
                }
            }
        }

        private UdpReceiveDriver() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class UdpTransmitDriver
    implements Runnable {
        LinkedQueue sendQueue;

        public void run() {
            DatagramPacket datagramPacket = new DatagramPacket(new byte[0], 0);
            while (!LonIpLinkLayer.this.done) {
                Object object;
                LonIpMessage lonIpMessage = (LonIpMessage)this.sendQueue.dequeue();
                if (lonIpMessage == null) continue;
                if (lonIpMessage.isDataMessage() && LonIpLinkLayer.this.isLocal((NAppBuffer)(object = (Object)((NAppBuffer)((DataMessage)lonIpMessage).getAppBuffer())))) {
                    LonIpLinkLayer.this.generateLocalResponse((NAppBuffer)object);
                    continue;
                }
                try {
                    object = lonIpMessage.toNetworkBytes();
                    do {
                        LonIpAddress lonIpAddress = lonIpMessage.sendList;
                        while (lonIpAddress != null) {
                            LonIpLinkLayer.this.stats.sentMsg(lonIpMessage, lonIpAddress.inetAdr, ((byte[])object).length);
                            int n = 1;
                            if (lonIpAddress.chanMem != null) {
                                n = lonIpAddress.chanMem.getSequenceAndIncrement();
                            }
                            int n2 = n;
                            object[12] = (byte)(n2 >> 24 & 0xFF);
                            object[13] = (byte)(n2 >> 16 & 0xFF);
                            object[14] = (byte)(n2 >> 8 & 0xFF);
                            object[15] = (byte)(n2 & 0xFF);
                            if (LonIpLinkLayer.this.isLinkDebug()) {
                                System.out.println();
                                LonIpLinkLayer.this.writeLinkDebug("Send " + lonIpAddress + ':', (byte[])object, ((byte[])object).length);
                            }
                            datagramPacket.setAddress(lonIpAddress.inetAdr);
                            datagramPacket.setPort(lonIpAddress.port);
                            datagramPacket.setData((byte[])object);
                            datagramPacket.setLength(((byte[])object).length);
                            try {
                                LonIpLinkLayer.this.udpPort.send(datagramPacket);
                            }
                            catch (BindException bindException) {
                                LonIpLinkLayer.this.log.warning("Can not send to " + lonIpAddress.inetAdr + ':' + lonIpAddress.port);
                            }
                            lonIpAddress = lonIpAddress.next;
                        }
                    } while (lonIpMessage.retry());
                    if (!lonIpMessage.isDataMessage()) continue;
                    LonIpLinkLayer.this.sendCompletion((DataMessage)lonIpMessage);
                }
                catch (ThreadDeath threadDeath) {
                    LonIpLinkLayer.this.done = true;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    LonIpLinkLayer.this.log.error("LonIpLinkLayer.UdpTransmitDriver error", throwable);
                }
            }
        }

        private final void sendToDriver(LonIpMessage lonIpMessage) {
            this.sendQueue.enqueue((LinkedQueue.Linkable)lonIpMessage);
        }

        private final /* synthetic */ void this() {
            this.sendQueue = new LinkedQueue();
        }

        private UdpTransmitDriver() {
            this.this();
        }
    }
}

