/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.datatypes;

import com.tridium.lonIp.datatypes.BChannelMember;
import com.tridium.lonIp.datatypes.BIpAddress;
import com.tridium.lonIp.datatypes.BIpChannel;
import com.tridium.lonIp.datatypes.BMemberTable;
import com.tridium.lonworks.loncomm.NLonComm;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import java.net.InetAddress;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BIpLonNetworkConfig
extends BComponent {
    private static String NONE = Lexicon.make((String)"lonIp").getText("adapter.none");
    private static String[] noAdapterArray = new String[]{NONE};
    private static int[] noneOrdinals = new int[]{-1};
    public static final Property isConfigServer = BIpLonNetworkConfig.newProperty((int)0, (boolean)false, null);
    public static final Property rcvPort = BIpLonNetworkConfig.newProperty((int)0, (int)1628, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)((char)-1))));
    public static final Property configServerIp = BIpLonNetworkConfig.newProperty((int)0, (BValue)BIpAddress.DEFAULT, null);
    public static final Property configServerPort = BIpLonNetworkConfig.newProperty((int)0, (int)1629, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)((char)-1))));
    public static final Property netName = BIpLonNetworkConfig.newProperty((int)0, (String)"Niagara", null);
    public static final Property useExtendedNat = BIpLonNetworkConfig.newProperty((int)0, (boolean)false, null);
    public static final Property adapter = BIpLonNetworkConfig.newProperty((int)64, (BValue)BDynamicEnum.make((int)-1, (BEnumRange)BEnumRange.make((int[])noneOrdinals, (String[])noAdapterArray)), null);
    public static final Property myIpAddress = BIpLonNetworkConfig.newProperty((int)1, (BValue)BIpAddress.DEFAULT, null);
    public static final Property natIpAddress = BIpLonNetworkConfig.newProperty((int)0, (BValue)BIpAddress.DEFAULT, null);
    public static final Type TYPE;
    private Log log;
    static /* synthetic */ Class class$com$tridium$lonIp$datatypes$BIpLonNetworkConfig;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$tridium$platform$tcpip$BTcpIpAdapterSettings;

    public boolean getIsConfigServer() {
        return this.getBoolean(isConfigServer);
    }

    public void setIsConfigServer(boolean bl) {
        this.setBoolean(isConfigServer, bl, null);
    }

    public int getRcvPort() {
        return this.getInt(rcvPort);
    }

    public void setRcvPort(int n) {
        this.setInt(rcvPort, n, null);
    }

    public BIpAddress getConfigServerIp() {
        return (BIpAddress)this.get(configServerIp);
    }

    public void setConfigServerIp(BIpAddress bIpAddress) {
        this.set(configServerIp, (BValue)bIpAddress, null);
    }

    public int getConfigServerPort() {
        return this.getInt(configServerPort);
    }

    public void setConfigServerPort(int n) {
        this.setInt(configServerPort, n, null);
    }

    public String getNetName() {
        return this.getString(netName);
    }

    public void setNetName(String string) {
        this.setString(netName, string, null);
    }

    public boolean getUseExtendedNat() {
        return this.getBoolean(useExtendedNat);
    }

    public void setUseExtendedNat(boolean bl) {
        this.setBoolean(useExtendedNat, bl, null);
    }

    public BEnum getAdapter() {
        return (BEnum)this.get(adapter);
    }

    public void setAdapter(BEnum bEnum) {
        this.set(adapter, (BValue)bEnum, null);
    }

    public BIpAddress getMyIpAddress() {
        return (BIpAddress)this.get(myIpAddress);
    }

    public void setMyIpAddress(BIpAddress bIpAddress) {
        this.set(myIpAddress, (BValue)bIpAddress, null);
    }

    public BIpAddress getNatIpAddress() {
        return (BIpAddress)this.get(natIpAddress);
    }

    public void setNatIpAddress(BIpAddress bIpAddress) {
        this.set(natIpAddress, (BValue)bIpAddress, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == isConfigServer) {
            this.setFlag(context);
        }
        if (context == BMemberTable.internalChange) {
            return;
        }
        if (property == adapter) {
            this.resetIp();
            this.restart();
        } else if (property == myIpAddress) {
            this.restart();
        } else {
            ((BComponent)this.getParent()).changed(BIpChannel.networkConfig, context);
        }
    }

    public void started() throws Exception {
        this.log = Log.getLog((String)this.getLonNetwork().getLogName());
        this.setFlag(null);
        this.initAdapter();
    }

    private final void setFlag(Context context) {
        int n = this.getFlags((Slot)configServerIp);
        n = this.getIsConfigServer() ? n | 4 : n & 0xFFFFFFFB;
        this.setFlags((Slot)configServerIp, n, context);
    }

    public BIpAddress getSegmentConfigServerIp(BChannelMember bChannelMember) {
        BIpAddress bIpAddress = this.getNatIpAddress();
        BIpAddress bIpAddress2 = this.getMyIpAddress();
        if (bIpAddress.equals((Object)BIpAddress.DEFAULT)) {
            return bIpAddress2;
        }
        if (!bIpAddress.equals((Object)bChannelMember.getNatIpAddress())) {
            return bIpAddress;
        }
        return bIpAddress2;
    }

    public BIpAddress getMyNetworkIp() {
        BIpAddress bIpAddress = this.getNatIpAddress();
        return bIpAddress.equals((Object)BIpAddress.DEFAULT) ? this.getMyIpAddress() : bIpAddress;
    }

    public boolean isLocal(BChannelMember bChannelMember) {
        boolean bl = false;
        if (bChannelMember.getIpUcAddress().equals((Object)this.getMyIpAddress()) && bChannelMember.getNatIpAddress().equals((Object)this.getNatIpAddress()) && bChannelMember.getIpUcPort() == this.getRcvPort()) {
            bl = true;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private final void initAdapter() {
        var1_1 = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
        var1_1.lease();
        var2_2 = (BDynamicEnum)this.getAdapter();
        var3_3 = var1_1.getSettings();
        v0 = BIpLonNetworkConfig.class$java$lang$String;
        if (v0 == null) {
            v0 = BIpLonNetworkConfig.class$java$lang$String = BIpLonNetworkConfig.class("[Ljava.lang.String;", false);
        }
        var4_4 = new Array(v0);
        v1 = BIpLonNetworkConfig.class$java$lang$String;
        if (v1 == null) {
            v1 = BIpLonNetworkConfig.class$java$lang$String = BIpLonNetworkConfig.class("[Ljava.lang.String;", false);
        }
        var5_5 = new Array(v1);
        var6_6 = var3_3.getAdapters().getProperties();
        if (true) ** GOTO lbl22
        do {
            if ((var7_7 = (String[])var6_6.get()).getIsAdapterEnabled()) {
                var8_8 = SlotPath.escape((String)var7_7.getDescription());
                var4_4.add((Object)var8_8);
                var5_5.add((Object)var7_7.getIpAddress());
            }
lbl22:
            // 4 sources

            if ((v2 = BIpLonNetworkConfig.class$com$tridium$platform$tcpip$BTcpIpAdapterSettings) != null) continue;
            v2 = BIpLonNetworkConfig.class("[Lcom.tridium.platform.tcpip.BTcpIpAdapterSettings;", false);
        } while (var6_6.next(v2));
        var6_6 = (String[])var4_4.trim();
        var7_7 = (String[])var5_5.trim();
        var8_9 = false;
        var9_10 = var2_2.getRange();
        var10_11 = var9_10.getOrdinals();
        if (var10_11.length != var6_6.length) {
            var8_9 = true;
        } else {
            var11_12 = 0;
            while (var11_12 < var10_11.length) {
                if (!var9_10.getTag(var10_11[var11_12]).equals(var6_6[var11_12])) {
                    var8_9 = true;
                    break;
                }
                ++var11_12;
            }
        }
        var11_13 = this.getMyIpAddress().getInetAddress().getHostAddress();
        var12_14 = 0;
        var13_15 = false;
        var14_16 = 0;
        while (var14_16 < var7_7.length) {
            if (var11_13.equals(var7_7[var14_16])) {
                var12_14 = var14_16;
                var13_15 = true;
                break;
            }
            ++var14_16;
        }
        if (var8_9) {
            this.setAdapter((BEnum)BDynamicEnum.make((int)var12_14, (BEnumRange)BEnumRange.make((String[])var6_6)));
        }
        if (!var13_15) {
            this.updateMyIp(var7_7[0]);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void resetIp() {
        var1_1 = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
        var1_1.lease();
        var2_2 = this.getAdapter().getTag();
        var3_3 = var1_1.getSettings();
        var4_4 = var3_3.getAdapters().getProperties();
        if (true) ** GOTO lbl11
        do {
            if ((var5_5 = (BTcpIpAdapterSettings)var4_4.get()).getIsAdapterEnabled() && var2_2.equals(var6_6 = SlotPath.escape((String)var5_5.getDescription()))) {
                this.updateMyIp(var5_5.getIpAddress());
                break;
            }
lbl11:
            // 3 sources

            if ((v0 = BIpLonNetworkConfig.class$com$tridium$platform$tcpip$BTcpIpAdapterSettings) != null) continue;
            v0 = BIpLonNetworkConfig.class("[Lcom.tridium.platform.tcpip.BTcpIpAdapterSettings;", false);
        } while (var4_4.next(v0));
    }

    private final void updateMyIp(String string) {
        try {
            BChannelMember bChannelMember = this.getIpChannel().getMemberTable().findEntry(this.getMyIpAddress(), 0);
            BIpAddress bIpAddress = BIpAddress.make(InetAddress.getByName(string));
            this.set(myIpAddress, (BValue)bIpAddress, BMemberTable.internalChange);
            if (bChannelMember != null) {
                bChannelMember.setIpUcAddress(bIpAddress);
            }
        }
        catch (Exception exception) {
            this.log.error(exception.getMessage());
        }
    }

    private final void restart() {
        try {
            NLonComm nLonComm = (NLonComm)this.getLonNetwork().lonComm();
            nLonComm.stop();
            nLonComm.start();
            this.log.trace("IpLonNetworkConfig myIp address changed");
        }
        catch (Throwable throwable) {
            this.log.error(throwable.getMessage());
        }
    }

    private final BLonNetwork getLonNetwork() {
        return (BLonNetwork)this.getParent().getParent();
    }

    private final BIpChannel getIpChannel() {
        return (BIpChannel)this.getParent();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$lonIp$datatypes$BIpLonNetworkConfig;
        if (clazz == null) {
            clazz = class$com$tridium$lonIp$datatypes$BIpLonNetworkConfig = BIpLonNetworkConfig.class("[Lcom.tridium.lonIp.datatypes.BIpLonNetworkConfig;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

