/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.datatypes;

import com.tridium.lonworks.util.LonByteArrayUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BIpAddress
extends BSimple {
    private static final byte[] defaultId = new byte[4];
    public static final BIpAddress DEFAULT = new BIpAddress(defaultId);
    public static final int IP_LENGTH = 4;
    public static final Type TYPE;
    private byte[] ipAddress;
    static /* synthetic */ Class class$com$tridium$lonIp$datatypes$BIpAddress;

    public static final BIpAddress make(byte[] byArray) {
        return new BIpAddress(byArray);
    }

    public static final BIpAddress make(InetAddress inetAddress) {
        return new BIpAddress(inetAddress.getAddress());
    }

    public final boolean equals(Object object) {
        if (!(object instanceof BIpAddress)) {
            return false;
        }
        BIpAddress bIpAddress = (BIpAddress)((Object)object);
        int n = 0;
        while (n < bIpAddress.ipAddress.length) {
            if (this.ipAddress[n] != bIpAddress.ipAddress[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final String toString(Context context) {
        return LonByteArrayUtil.toString((byte[])this.ipAddress, (int)10, (char)'.', (int)4, (int)0, (boolean)false);
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.write(this.ipAddress);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        byte[] byArray = new byte[4];
        dataInput.readFully(byArray, 0, 4);
        return new BIpAddress(byArray);
    }

    public final String encodeToString() throws IOException {
        return this.toString(null);
    }

    public final BObject decodeFromString(String string) throws IOException {
        return new BIpAddress(LonByteArrayUtil.getBytes((String)string, (String)".", (int)4, (int)10));
    }

    public final InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.toString(null));
        }
        catch (UnknownHostException unknownHostException) {
            throw new BajaRuntimeException("UnknownHostException for ip address " + this.toString(null));
        }
    }

    public final Type getType() {
        return TYPE;
    }

    public static final BIpAddress fromInputStream(LonInputStream lonInputStream) throws LonException {
        byte[] byArray = lonInputStream.readByteArray(4);
        return new BIpAddress(byArray);
    }

    public final void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.writeByteArray(this.ipAddress);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BIpAddress(byte[] byArray) {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("Invalid array length in BIpAddress constructor. " + LonByteArrayUtil.toString((byte[])byArray));
        }
        this.ipAddress = byArray;
    }

    static {
        Class clazz = class$com$tridium$lonIp$datatypes$BIpAddress;
        if (clazz == null) {
            clazz = class$com$tridium$lonIp$datatypes$BIpAddress = BIpAddress.class("[Lcom.tridium.lonIp.datatypes.BIpAddress;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

