/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp;

import com.tridium.lonIp.Statistics;
import com.tridium.lonIp.datatypes.BChannelMember;
import com.tridium.lonIp.datatypes.BDateTime;
import com.tridium.lonIp.datatypes.BIpAddress;
import com.tridium.lonIp.datatypes.BIpChannel;
import com.tridium.lonIp.datatypes.BIpLonNetworkConfig;
import com.tridium.lonIp.datatypes.BMemberTable;
import com.tridium.lonIp.enums.BMemberStateEnum;
import com.tridium.lonIp.link.LonIpAddress;
import com.tridium.lonIp.link.LonIpLinkLayer;
import com.tridium.lonIp.messages.Acknowledge;
import com.tridium.lonIp.messages.ChannelMembership;
import com.tridium.lonIp.messages.ChannelRouting;
import com.tridium.lonIp.messages.DeviceRegistration;
import com.tridium.lonIp.messages.LonIp;
import com.tridium.lonIp.messages.LonIpMessage;
import com.tridium.lonIp.messages.RequestMessage;
import com.tridium.lonIp.messages.SendList;
import com.tridium.lonIp.messages.StatisticsResp;
import com.tridium.lonIp.util.LonIpAddressManager;
import com.tridium.lonworks.loncomm.LinkedQueue;
import com.tridium.lonworks.util.NmUtil;
import javax.baja.log.Log;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ChannelMonitor
implements Runnable,
LonIp {
    private static final int WAIT_DR = 1;
    private static final int WAIT_CM = 2;
    private static final int WAIT_CR = 3;
    private static final int IDLE = 4;
    LinkedQueue recvQueue;
    BChannelMember[] sendList;
    Clock.Ticket ticket;
    private int delay;
    private int currentDelay;
    private int monitorState;
    private boolean isConfigServer;
    private boolean useExtendedNat;
    private DeviceRegistration curCnfg;
    private ChannelRouting curRoute;
    private BDateTime sendlistDt;
    private BLonNetwork lonworks;
    private BIpChannel ipChan;
    public BIpLonNetworkConfig netCfg;
    private BMemberTable memTab;
    private LonIpLinkLayer link;
    private LonIpAddressManager adrMan;
    private Thread t;
    private boolean done;
    LonIpAddress configServerIp;
    private Log log;

    public void start() {
        this.isConfigServer = this.netCfg.getIsConfigServer();
        this.useExtendedNat = this.netCfg.getUseExtendedNat();
        this.setConfigServerIp();
        this.done = false;
        this.t = new Thread((Runnable)this, this.lonworks.getLogName() + ".LonIpChannelMon");
        this.t.start();
        this.t.setPriority(5);
    }

    public void stop() {
        this.done = true;
        if (this.t != null) {
            this.t.interrupt();
        }
    }

    public void run() {
        while (!this.ipChan.isRunning()) {
            NmUtil.wait((int)1000);
        }
        this.curCnfg = this.createDeviceRegistration();
        this.curRoute = this.createChannelRouting();
        this.startDeviceRegistration();
        while (!this.done) {
            try {
                LonIpMessage lonIpMessage = (LonIpMessage)this.recvQueue.dequeue();
                if (lonIpMessage == null) continue;
                this.processIpMessage(lonIpMessage);
            }
            catch (Throwable throwable) {
                this.log.error("Error in ChannelMonitor:", throwable);
            }
        }
    }

    private final void processIpMessage(LonIpMessage lonIpMessage) {
        if (lonIpMessage.hasExtendedNat) {
            this.netCfg.setUseExtendedNat(true);
        }
        if (this.isConfigServer) {
            switch (lonIpMessage.packetType) {
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 113: {
                    this.sendAck(lonIpMessage, 3);
                    return;
                }
            }
        }
        switch (lonIpMessage.packetType) {
            case 113: {
                this.rcvDeviceConfiguration((DeviceRegistration)lonIpMessage);
                break;
            }
            case 4: {
                this.rcvChannelMembership((ChannelMembership)lonIpMessage);
                break;
            }
            case 8: {
                this.rcvChannelRouting((ChannelRouting)lonIpMessage);
                break;
            }
            case 6: {
                this.rcvSendList((SendList)lonIpMessage);
                break;
            }
            case 7: {
                this.rcvAcknowledge((Acknowledge)lonIpMessage);
                break;
            }
            case 99: {
                this.rcvDeviceConfigurationRequest((RequestMessage)lonIpMessage);
                break;
            }
            case 100: {
                this.rcvChannelMembershipRequest((RequestMessage)lonIpMessage);
                break;
            }
            case 104: {
                this.rcvChannelRoutingRequest((RequestMessage)lonIpMessage);
                break;
            }
            case 96: {
                this.rcvStatusRequest((RequestMessage)lonIpMessage);
                break;
            }
            case 102: {
                System.out.println("Packet type not processed:" + Integer.toString(lonIpMessage.packetType, 16));
                break;
            }
            case 3: {
                this.rcvDeviceRegistration((DeviceRegistration)lonIpMessage);
                break;
            }
            default: {
                System.out.println("Packet type not implemented:" + Integer.toString(lonIpMessage.packetType, 16));
            }
        }
    }

    public void receiveMessage(LonIpMessage lonIpMessage) {
        this.recvQueue.enqueue((LinkedQueue.Linkable)lonIpMessage);
    }

    public void networkConfigChanged(Context context) {
        if (!this.lonworks.getEnabled()) {
            return;
        }
        this.isConfigServer = this.netCfg.getIsConfigServer();
        this.useExtendedNat = this.netCfg.getUseExtendedNat();
        if (this.netCfg.getConfigServerIp().equals((Object)BIpAddress.DEFAULT)) {
            return;
        }
        this.setConfigServerIp();
        this.curCnfg = this.createDeviceRegistration();
        if (this.lonworks.isFault()) {
            this.lonworks.configOk();
            if (!this.lonworks.isServiceRunning()) {
                this.link.stop();
                this.lonworks.serviceStarted();
            }
        }
        this.startDeviceRegistration();
    }

    public void localDataChanged(boolean bl, boolean bl2) {
        if (bl) {
            this.curCnfg = this.createDeviceRegistration();
        }
        if (bl2) {
            this.curRoute = this.createChannelRouting();
        }
        if (bl) {
            this.startDeviceRegistration();
        }
    }

    public void doUpdateMember(BChannelMember bChannelMember) {
        if (this.isConfigServer) {
            return;
        }
        if (this.log.isTraceOn()) {
            this.log.trace("doUpdate member " + bChannelMember.getCnName());
        }
        if (this.netCfg.isLocal(bChannelMember)) {
            bChannelMember.storeLocalConfiguration(this.netCfg, this.lonworks);
            this.localDataChanged(true, true);
        }
    }

    private final synchronized void setConfigServerIp() {
        this.configServerIp = LonIpAddress.make(this.netCfg.getConfigServerIp().getInetAddress(), this.netCfg.getConfigServerPort());
    }

    private final void startDeviceRegistration() {
        if (this.isConfigServer || this.netCfg.getConfigServerIp().equals((Object)BIpAddress.DEFAULT)) {
            return;
        }
        this.monitorState = 1;
        this.sendDeviceRegistration();
        this.startTimer();
        this.currentDelay = 1;
        this.delay = 1;
    }

    private final synchronized void startTimer() {
        if (this.ticket != null) {
            return;
        }
        this.ticket = Clock.schedulePeriodically((BComponent)this.ipChan, (BRelTime)BRelTime.makeSeconds((int)1), (Action)BIpChannel.channelMonitorTimeout, null);
    }

    private final synchronized void stopTimer() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = null;
    }

    public void channelTimerCallback() {
        if (this.isConfigServer) {
            this.stopTimer();
            return;
        }
        switch (this.monitorState) {
            case 1: {
                if (--this.delay != 0) break;
                this.sendDeviceRegistration();
                if (this.currentDelay < 30) {
                    this.currentDelay *= 2;
                }
                this.delay = this.currentDelay;
                break;
            }
            case 2: {
                this.sendChannelMembershipRequest();
                break;
            }
            case 3: {
                if (!this.updateDevices()) break;
                this.monitorState = 4;
                break;
            }
            case 4: {
                this.updateDevices();
                break;
            }
        }
    }

    private final String stateToString() {
        switch (this.monitorState) {
            case 1: {
                return "WAIT_DR";
            }
            case 2: {
                return "WAIT_CM";
            }
            case 3: {
                return "WAIT_CR";
            }
            case 4: {
                return "IDLE";
            }
        }
        return "undefined state {" + Integer.toString(this.monitorState) + '}';
    }

    private final void sendDeviceRegistration() {
        if (this.log.isTraceOn()) {
            this.log.trace("send device registration to config server\n" + this.curCnfg.toString());
        }
        this.curCnfg.packetType = 3;
        this.sendToConfigServer(this.curCnfg);
    }

    private final void sendRoute() {
        if (this.log.isTraceOn()) {
            this.log.trace("send channel route to config server\n" + this.curRoute);
        }
        if (this.curRoute == null) {
            System.out.println("****\n*****\ncurRoute==null\n");
        }
        if (this.netCfg == null) {
            System.out.println("****\n*****\n netCfg==null\n");
        }
        this.sendToConfigServer(this.curRoute);
    }

    private final void sendChannelMembershipRequest() {
        if (this.log.isTraceOn()) {
            this.log.trace("request channel membership from config server");
        }
        RequestMessage requestMessage = new RequestMessage(100);
        this.sendToConfigServer(requestMessage);
    }

    private final void rcvDeviceConfigurationRequest(RequestMessage requestMessage) {
        if (this.log.isTraceOn()) {
            this.log.trace("receive device configuration request from " + requestMessage.getSrcAddress());
        }
        this.curCnfg.packetType = 113;
        this.sendResponse(requestMessage, this.curCnfg);
    }

    private final void sendResponse(RequestMessage requestMessage, LonIpMessage lonIpMessage) {
        lonIpMessage.sequenceNumber = lonIpMessage.sequenceNumber;
        this.send(lonIpMessage, LonIpAddress.make(requestMessage));
    }

    private final void rcvChannelMembershipRequest(RequestMessage requestMessage) {
        if (this.log.isTraceOn()) {
            this.log.trace("send channel membership on request to " + requestMessage.getSrcAddress());
        }
        ChannelMembership channelMembership = this.createChannelMembership();
        this.send(channelMembership, LonIpAddress.make(requestMessage));
    }

    private final void rcvChannelRoutingRequest(RequestMessage requestMessage) {
        BIpAddress bIpAddress;
        if (this.log.isTraceOn()) {
            this.log.trace("rcvChannelRoutingRequest from " + requestMessage.getSrcAddress() + " for " + (Object)((Object)requestMessage.ipAddress));
        }
        if ((bIpAddress = requestMessage.ipAddress).equals((Object)BIpAddress.DEFAULT) || !bIpAddress.equals((Object)this.netCfg.getMyIpAddress()) && !bIpAddress.equals((Object)this.netCfg.getNatIpAddress())) {
            this.sendAck(requestMessage, 4);
            return;
        }
        this.curRoute = this.createChannelRouting();
        if (this.log.isTraceOn()) {
            this.log.trace("send channel routing on request to " + requestMessage.getSrcAddress() + '\n' + this.curRoute.toString());
        }
        this.send(this.curRoute, LonIpAddress.make(requestMessage));
    }

    private final BIpAddress getMyNetworkIp() {
        return this.netCfg.getMyNetworkIp();
    }

    private final int getMyPort() {
        return this.netCfg.getRcvPort();
    }

    private final ChannelRouting createChannelRouting() {
        BChannelMember bChannelMember = this.memTab.findEntry(this.getMyNetworkIp(), this.getMyPort());
        if (bChannelMember == null) {
            return null;
        }
        BDeviceData bDeviceData = this.lonworks.getLocalLonDevice().getDeviceData();
        ChannelRouting channelRouting = new ChannelRouting();
        channelRouting.dateTime = bChannelMember.getRouteTimeStamp();
        channelRouting.ucIpPort = this.netCfg.getRcvPort();
        channelRouting.ucIpAdr = this.getMyNetworkIp();
        channelRouting.nids = new BNeuronId[]{bDeviceData.getNeuronId()};
        ChannelRouting.SubnetNodeRecord subnetNodeRecord = new ChannelRouting.SubnetNodeRecord();
        subnetNodeRecord.sn = bDeviceData.getSubnetNodeId();
        subnetNodeRecord.domainNdx = 0;
        subnetNodeRecord.nidNdx = 0;
        channelRouting.snRec = new ChannelRouting.SubnetNodeRecord[]{subnetNodeRecord};
        ChannelRouting.DomainRecord domainRecord = new ChannelRouting.DomainRecord();
        domainRecord.subnetMask = bChannelMember.getSubnetMask().getByteArrayCopy();
        domainRecord.groupMask = bChannelMember.getGroupMask().getByteArrayCopy();
        domainRecord.domainId = this.lonworks.getLonNetmgmt().getDomainId();
        channelRouting.domRec = new ChannelRouting.DomainRecord[]{domainRecord};
        return channelRouting;
    }

    private final ChannelMembership createChannelMembership() {
        ChannelMembership channelMembership = new ChannelMembership();
        channelMembership.dateTime = BDateTime.make();
        BChannelMember[] bChannelMemberArray = this.memTab.getChannelMembers();
        channelMembership.ips = new BIpAddress[bChannelMemberArray.length];
        channelMembership.ports = new int[bChannelMemberArray.length];
        channelMembership.chanRouteTime = new BDateTime[bChannelMemberArray.length];
        int n = 0;
        while (n < bChannelMemberArray.length) {
            channelMembership.ips[n] = bChannelMemberArray[n].getSegmentIp(this.netCfg);
            channelMembership.ports[n] = bChannelMemberArray[n].getIpUcPort();
            channelMembership.chanRouteTime[n] = bChannelMemberArray[n].getRouteTimeStamp();
            ++n;
        }
        return channelMembership;
    }

    private final DeviceRegistration createDeviceRegistration() {
        DeviceRegistration deviceRegistration = new DeviceRegistration();
        deviceRegistration.dateTime = BDateTime.make();
        deviceRegistration.ucIpPort = this.netCfg.getRcvPort();
        deviceRegistration.ucIpAdr = this.getMyNetworkIp();
        deviceRegistration.chanMembershipDt = deviceRegistration.dateTime;
        deviceRegistration.sendlistDt = this.sendlistDt;
        deviceRegistration.configServerIp = this.netCfg.getIsConfigServer() ? this.getMyNetworkIp() : this.netCfg.getConfigServerIp();
        deviceRegistration.configServerPort = this.netCfg.getConfigServerPort();
        deviceRegistration.mcIps = new BIpAddress[0];
        deviceRegistration.mcPorts = new int[0];
        deviceRegistration.id = this.lonworks.getLocalLonDevice().getNeuronIdAddress().getByteArray();
        deviceRegistration.name = this.netCfg.getNetName();
        return deviceRegistration;
    }

    private final void rcvDeviceConfiguration(DeviceRegistration deviceRegistration) {
        if (deviceRegistration.ucIpAdr.equals((Object)this.getMyNetworkIp()) && deviceRegistration.ucIpPort == this.netCfg.getRcvPort()) {
            this.processMyDeviceConfiguration(deviceRegistration);
        } else {
            this.processDeviceConfiguration(deviceRegistration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void processMyDeviceConfiguration(DeviceRegistration deviceRegistration) {
        if (this.log.isTraceOn()) {
            this.log.trace("receive device configuration :\n" + deviceRegistration.toString());
        }
        if (!deviceRegistration.getSrcAddress().equals(this.configServerIp.inetAdr) || deviceRegistration.getSrcPort() != this.configServerIp.port) {
            if (this.log.isTraceOn()) {
                this.log.trace("config server ip/port changed");
            }
            this.netCfg.setConfigServerIp(BIpAddress.make(deviceRegistration.getSrcAddress()));
            this.netCfg.setConfigServerPort(deviceRegistration.getSrcPort());
        }
        boolean bl = false;
        ChannelMonitor channelMonitor = this;
        synchronized (channelMonitor) {
            if (this.monitorState == 1) {
                bl = true;
            }
            if (this.monitorState == 1 || !deviceRegistration.chanMembershipDt.equals((Object)this.curCnfg.chanMembershipDt)) {
                this.monitorState = 2;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl16 : MonitorExitStatement: MONITOREXIT : var3_3
            this.curCnfg = deviceRegistration;
            this.sendAck(deviceRegistration, 0);
            if (bl && this.curRoute != null) {
                this.sendRoute();
            }
            return;
        }
    }

    private final void processDeviceConfiguration(DeviceRegistration deviceRegistration) {
        BIpAddress bIpAddress = deviceRegistration.ucIpAdr;
        BChannelMember bChannelMember = this.memTab.findEntry(bIpAddress, deviceRegistration.ucIpPort);
        if (bChannelMember == null) {
            if (deviceRegistration.hasExtendedNat) {
                bChannelMember = this.memTab.findEntry(deviceRegistration.ipAdr, deviceRegistration.ucIpPort);
            } else if (!deviceRegistration.getSrcAddress().equals(bIpAddress.getInetAddress()) && (bChannelMember = this.memTab.findEntry(deviceRegistration.getSrcAddress(), deviceRegistration.ucIpPort)) != null && bIpAddress.equals((Object)this.netCfg.getNatIpAddress())) {
                bChannelMember.setNatIpAddress(bIpAddress);
            }
            if (bChannelMember == null) {
                this.log.warning("receive device configuration for unknown member\n" + deviceRegistration.toString());
                this.sendAck(deviceRegistration, 4);
                return;
            }
            bChannelMember.updateNat(deviceRegistration);
        }
        this.sendAck(deviceRegistration, 0);
        if (this.log.isTraceOn()) {
            this.log.trace("receive device configuration for " + bChannelMember.getCnName() + " \n" + deviceRegistration.toString());
        }
        if (bChannelMember.getIState() == BMemberStateEnum.SentDRReq) {
            bChannelMember.storeDeviceConfiguration(deviceRegistration);
            RequestMessage requestMessage = new RequestMessage(104, BDateTime.DEFAULT);
            requestMessage.ipAddress = bChannelMember.getSegmentIp(this.netCfg);
            if (this.memTab.hasDuplicateSegmentIp(requestMessage.ipAddress, this.netCfg)) {
                requestMessage.ipUcPort = bChannelMember.getIpUcPort();
            }
            this.send(requestMessage, LonIpAddress.make(bIpAddress.getInetAddress(), deviceRegistration.ucIpPort));
            bChannelMember.setIState(BMemberStateEnum.SentCRReq);
        }
    }

    private final void rcvDeviceRegistration(DeviceRegistration deviceRegistration) {
        this.log.error("receive device registration - not config server");
        this.sendAck(deviceRegistration, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void rcvChannelMembership(ChannelMembership var1_1) {
        if (this.log.isTraceOn()) {
            this.log.trace("receive channel membership:\n" + var1_1.toString());
        }
        var2_2 = 0;
        var3_3 = this.memTab.getChannelMembers();
        var4_4 = 0;
        while (var4_4 < var1_1.ips.length) {
            var5_6 = var1_1.ips[var4_4];
            var6_7 = var1_1.ports[var4_4];
            var7_8 = null;
            var8_9 = 0;
            while (var8_9 < var3_3.length) {
                if (var3_3[var8_9] != null && var3_3[var8_9].getSegmentIp(this.netCfg).equals((Object)var5_6) && var3_3[var8_9].getIpUcPort() == var6_7) {
                    var7_8 = var3_3[var8_9];
                    var3_3[var8_9] = null;
                    break;
                }
                ++var8_9;
            }
            var8_9 = (int)var5_6.equals((Object)this.getMyNetworkIp());
            if (var7_8 == null) {
                var7_8 = new BChannelMember();
                var7_8.setIpUcAddress(var5_6);
                var7_8.setIpUcPort(var6_7);
                if (var8_9 != 0) {
                    var7_8.storeLocalConfiguration(this.netCfg, this.lonworks);
                    var7_8.setIState(BMemberStateEnum.UpToDate);
                }
                this.memTab.addMember(var7_8, BMemberTable.internalChange);
            }
            if (var8_9 == 0) {
                if (var7_8.getIState() == BMemberStateEnum.NewMember || var7_8.getIState() == BMemberStateEnum.SentDRReq) {
                    var7_8.setIState(BMemberStateEnum.SentDRReq);
                    var9_10 = new RequestMessage(99, BDateTime.DEFAULT);
                    var9_10.ipAddress = var5_6;
                    this.send(var9_10, LonIpAddress.make(var5_6.getInetAddress(), var6_7));
                    var2_2 = 1;
                } else if (var1_1.chanRouteTime[var4_4].isLaterThan(var7_8.getConfigTimeStamp())) {
                    var7_8.setIState(BMemberStateEnum.SentCRReq);
                    var9_10 = new RequestMessage(104, var7_8.getConfigTimeStamp());
                    var9_10.ipAddress = var5_6;
                    this.send(var9_10, LonIpAddress.make(var5_6.getInetAddress(), var6_7));
                } else {
                    var7_8.setIState(BMemberStateEnum.UpToDate);
                }
            }
            ++var4_4;
        }
        var4_5 = this;
        synchronized (var4_5) {
            this.monitorState = 4 - var2_2;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl49 : MonitorExitStatement: MONITOREXIT : var4_5
            var6_7 = 0;
            if (true) ** GOTO lbl58
        }
        do {
            if (var3_3[var6_7] != null) {
                this.memTab.removeMember(var3_3[var6_7], BMemberTable.internalChange);
            }
            ++var6_7;
lbl58:
            // 2 sources

        } while (var6_7 < var3_3.length);
        this.memTab.setTimeStamp(var1_1.dateTime);
    }

    private final boolean updateDevices() {
        boolean bl = true;
        BChannelMember[] bChannelMemberArray = this.memTab.getChannelMembers();
        int n = 0;
        while (n < bChannelMemberArray.length) {
            RequestMessage requestMessage;
            BChannelMember bChannelMember = bChannelMemberArray[n];
            LonIpAddress lonIpAddress = LonIpAddress.make(bChannelMember.getSegmentIp(this.netCfg).getInetAddress(), bChannelMember.getIpUcPort());
            if (bChannelMember.getIState() == BMemberStateEnum.SentDRReq) {
                requestMessage = new RequestMessage(99, BDateTime.DEFAULT);
                requestMessage.ipAddress = bChannelMember.getSegmentIp(this.netCfg);
                this.send(requestMessage, lonIpAddress);
                bl = false;
            } else if (bChannelMember.getIState() == BMemberStateEnum.SentCRReq) {
                requestMessage = new RequestMessage(104, bChannelMember.getConfigTimeStamp());
                requestMessage.ipAddress = bChannelMember.getSegmentIp(this.netCfg);
                this.send(requestMessage, lonIpAddress);
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public Object foo() {
        return new byte[0];
    }

    private final void sendToConfigServer(LonIpMessage lonIpMessage) {
        this.send(lonIpMessage, this.configServerIp);
    }

    private final void rcvSendList(SendList sendList) {
        if (this.log.isTraceOn()) {
            this.log.trace("receive send list - not implemented");
        }
    }

    private final void rcvChannelRouting(ChannelRouting channelRouting) {
        if (this.log.isTraceOn()) {
            this.log.trace("received channel routing:\n" + channelRouting);
        }
        if (channelRouting.snRec.length == 0) {
            this.log.trace("ChannelRouting message has no subnet records");
            return;
        }
        if (channelRouting.snRec.length > 1) {
            this.log.trace("ChannelRouting message has " + channelRouting.snRec.length + " subnet records");
        }
        if (channelRouting.nids.length == 0) {
            this.log.trace("ChannelRouting message has no neuronId records");
            return;
        }
        BIpAddress bIpAddress = channelRouting.ucIpAdr;
        BChannelMember bChannelMember = this.memTab.findEntry(bIpAddress, channelRouting.ucIpPort);
        if (bChannelMember == null) {
            this.log.trace("received ChannelRouting msg for unknown ip " + (Object)((Object)bIpAddress));
            return;
        }
        bChannelMember.updateNat(channelRouting);
        bChannelMember.storeChannelRoute(channelRouting, this.log);
        if (bChannelMember.getIState() == BMemberStateEnum.SentCRReq) {
            bChannelMember.setIState(BMemberStateEnum.UpToDate);
        }
    }

    private final void rcvAcknowledge(Acknowledge acknowledge) {
    }

    private final void rcvStatusRequest(RequestMessage requestMessage) {
        this.link.stats.updateGlobalStats(this.ipChan);
        StatisticsResp statisticsResp = new StatisticsResp(this.link.stats);
        if (requestMessage.clear) {
            this.link.stats = new Statistics();
        }
        this.send(statisticsResp, LonIpAddress.make(requestMessage));
    }

    private final void sendAck(LonIpMessage lonIpMessage, int n) {
        Acknowledge acknowledge = new Acknowledge();
        acknowledge.dateTime = BDateTime.make();
        acknowledge.ackType = n;
        if (lonIpMessage instanceof RequestMessage) {
            acknowledge.requestId = ((RequestMessage)lonIpMessage).requestId;
        }
        this.send(acknowledge, LonIpAddress.make(lonIpMessage.getSrcAddress(), lonIpMessage.getSrcPort()));
    }

    private final void send(LonIpMessage lonIpMessage, LonIpAddress lonIpAddress) {
        if (this.useExtendedNat) {
            lonIpMessage.addExtendedNat(this.netCfg, false);
        }
        this.link.sendIpMessage(lonIpMessage, lonIpAddress);
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        this.adrMan.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"misc", 1);
        spyWriter.prop((Object)"isConfigServer", this.isConfigServer);
        spyWriter.prop((Object)"useExtendedNat", this.useExtendedNat);
        spyWriter.prop((Object)"state", (Object)this.stateToString());
        spyWriter.endProps();
    }

    private final /* synthetic */ void this() {
        this.recvQueue = new LinkedQueue();
        this.sendList = null;
        this.ticket = null;
        this.monitorState = 4;
        this.isConfigServer = false;
        this.useExtendedNat = false;
        this.sendlistDt = BDateTime.DEFAULT;
        this.t = null;
    }

    public ChannelMonitor(BLonNetwork bLonNetwork, LonIpLinkLayer lonIpLinkLayer) {
        this.this();
        this.lonworks = bLonNetwork;
        this.link = lonIpLinkLayer;
        this.ipChan = (BIpChannel)bLonNetwork.get("ipChannel");
        this.netCfg = this.ipChan.getNetworkConfig();
        this.memTab = this.ipChan.getMemberTable();
        this.adrMan = lonIpLinkLayer.adrMan;
        this.log = Log.getLog((String)(bLonNetwork.getLogName() + ".channelMonitor"));
        this.ipChan.registerChannelMonitor(this);
    }
}

