/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusTcp.comm;

import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.modbusCore.BModbusNetwork;
import com.tridium.modbusCore.ModbusException;
import com.tridium.modbusCore.messages.ModbusMessage;
import com.tridium.modbusCore.messages.ModbusReceivedMessage;
import com.tridium.modbusTcp.BModbusTcpDevice;
import com.tridium.modbusTcp.BModbusTcpGateway;
import com.tridium.modbusTcp.BModbusTcpNetwork;
import com.tridium.modbusTcp.BSocketStatusEnum;
import com.tridium.modbusTcp.comm.ModbusTcpComm;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import javax.baja.log.Log;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ModbusTcpRxDriver
extends CommReceiver {
    static Log socketLog = Log.getLog((String)"modbusTcp.socket");
    protected static final int STATE_IDLE = 0;
    protected static final int STATE_NO_SOCKET = 1;
    protected static final int STATE_GOT_SOCKET = 2;
    private BModbusTcpDevice modbusTcpDevice;
    private BModbusTcpGateway modbusTcpGateway;
    private Socket commSocket;
    private OutputStream out;
    protected int numOutstandingRequests;
    protected int numConnectionFailures;
    protected int state;
    protected boolean exit;
    private Object idleMonitor;
    private Object connectMonitor;
    protected BModbusNetwork network;
    protected ModbusReceivedMessage msg;
    protected ModbusMessage requestMessage;

    public void startSocketManager() {
        this.switchState(1);
        this.exit = false;
    }

    public void writeOutputStream(Message message) throws Exception {
        if (this.isConnected()) {
            try {
                this.requestMessage = (ModbusMessage)message;
            }
            catch (Exception exception) {
                this.requestMessage = null;
            }
            ++this.numOutstandingRequests;
        } else {
            throw new ModbusException(104);
        }
        message.write(this.out);
        this.out.flush();
    }

    protected ReceivedMessage receive() throws Exception {
        boolean bl = false;
        while (!bl) {
            bl = this.finiteStateMachine();
        }
        return this.msg;
    }

    private final boolean isConnected() {
        boolean bl = false;
        if (this.state == 2) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void switchState(int n) {
        if (this.state == n) {
            return;
        }
        this.state = n;
        if (n == 1) {
            this.numConnectionFailures = 0;
        }
        Object object = this.idleMonitor;
        synchronized (object) {
            this.idleMonitor.notifyAll();
            return;
        }
    }

    public void stopSocketManager() {
        this.detailsLn("entered method stopSocketManager");
        this.exit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean finiteStateMachine() {
        if (this.exit) {
            return false;
        }
        if (this.state == 2) {
            return this.readMessage();
        }
        Object object = this.idleMonitor;
        synchronized (object) {
            try {
                this.idleMonitor.wait(5000L);
            }
            catch (InterruptedException interruptedException) {}
            return false;
        }
    }

    private final boolean readMessage() {
        this.setSocketTimeout();
        return this.readMessageFromStream();
    }

    protected boolean readMessageFromStream() {
        block12: {
            byte[] byArray = new byte[261];
            try {
                int n = this.getInputStream().read(byArray, 0, 261);
                if (n < 9) {
                    if (n > 0) {
                        this.network.getLog().message("response was too short - " + n + " chars");
                    } else if (n == -1) {
                        this.switchState(1);
                        this.nullStreams();
                        this.closeSocket();
                        if (this.modbusTcpDevice != null) {
                            socketLog.trace(this.modbusTcpDevice.getDisplayName(null) + ": socket read Timeout, socket closed");
                        }
                    }
                    break block12;
                }
                if ((byArray[7] & 0x80) != 0 && this.network.getLog().isTraceOn()) {
                    this.network.getLog().trace("MODBUS exception response - type " + byArray[8]);
                }
                byte[] byArray2 = new byte[n - 6];
                System.arraycopy(byArray, 6, byArray2, 0, byArray2.length);
                int n2 = (byArray[0] & 0xFF) << 8;
                n2 |= byArray[1] & 0xFF;
                this.numOutstandingRequests = 0;
                if (this.msg == null) {
                    this.msg = new ModbusReceivedMessage(byArray2, byArray2.length);
                } else {
                    this.msg.setBytes(byArray2);
                    this.msg.setLength(byArray2.length);
                }
                this.msg.setTransactionId(n2);
                if (!(this.modbusTcpDevice != null && this.modbusTcpDevice.getDisableTransactionIdCheck() || this.requestMessage == null || this.requestMessage.transactionIdentifier == n2)) {
                    if (this.network.getLog().isTraceOn()) {
                        this.network.getLog().trace("Transaction ID missmatch: req/resp = " + this.requestMessage.transactionIdentifier + '/' + n2);
                    }
                    return false;
                }
                return true;
            }
            catch (Exception exception) {
                if (!(exception instanceof SocketException) && !(exception instanceof SocketTimeoutException) && this.commSocket != null && this.commSocket.isConnected()) break block12;
                this.switchState(1);
                this.nullStreams();
                this.closeSocket();
                if (this.modbusTcpDevice == null) break block12;
                socketLog.trace(this.modbusTcpDevice.getDisplayName(null) + ": socket closed Socket Timeout or Exception");
            }
        }
        return false;
    }

    protected void setSocketTimeout() {
        try {
            int n = (int)((BModbusTcpNetwork)this.network).getSocketOptionTimeout().getMillis();
            this.commSocket.setSoTimeout(n);
        }
        catch (Exception exception) {
            this.detailsLn("exception caught setting so timeout, e=" + exception);
        }
    }

    public void closeSocket() {
        if (this.commSocket != null) {
            try {
                this.commSocket.close();
            }
            catch (Exception exception) {
                this.detailsLn("exception caught from closeSocket() while closing commSocket" + exception);
            }
            this.commSocket = null;
            if (this.modbusTcpDevice != null) {
                this.modbusTcpDevice.setSocketStatus(BSocketStatusEnum.closed);
            } else if (this.modbusTcpGateway != null) {
                this.modbusTcpGateway.setSocketStatus(BSocketStatusEnum.closed);
            }
        }
    }

    private final void failureSocketConnectionInit(Exception exception) {
        if (socketLog.isTraceOn() && this.modbusTcpDevice != null) {
            socketLog.trace(this.modbusTcpDevice.getDisplayName(null) + ": open socket failed. Exception: " + exception);
        } else {
            this.detailsLn(" ModbusTcp - Cannot open socket connection to " + ((ModbusTcpComm)this.getComm()).devName() + '.');
        }
        ++this.numConnectionFailures;
        this.nullStreams();
        this.closeSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void notifyConnectMonitor() {
        Object object = this.connectMonitor;
        synchronized (object) {
            this.connectMonitor.notifyAll();
            return;
        }
    }

    private final void successSocketConnectionInit() {
        this.detailsLn(" ModbusTcp - socket connection established to " + ((ModbusTcpComm)this.getComm()).devName() + '.');
        this.switchState(2);
        this.numOutstandingRequests = 0;
        this.notifyConnectMonitor();
    }

    private final void connectSocket() throws Exception {
        InetAddress inetAddress;
        this.modbusTcpDevice = (BModbusTcpDevice)((ModbusTcpComm)this.getComm()).getDevice();
        if (this.network instanceof BModbusTcpGateway) {
            this.modbusTcpGateway = (BModbusTcpGateway)this.network;
        }
        InetAddress inetAddress2 = inetAddress = this.modbusTcpDevice != null ? this.modbusTcpDevice.getInetAddr() : ((BModbusTcpGateway)this.network).getInetAddr();
        if (inetAddress == null) {
            throw new ModbusException(104);
        }
        if (this.modbusTcpDevice != null) {
            this.modbusTcpDevice.setSocketStatus(BSocketStatusEnum.openPending);
            this.commSocket = new Socket(inetAddress, this.modbusTcpDevice.getPort());
            if (socketLog.isTraceOn()) {
                socketLog.trace(this.modbusTcpDevice.getDisplayName(null) + ": socket opened");
            } else {
                this.detailsLn("Socket connection made to device " + ((ModbusTcpComm)this.getComm()).devName() + '.');
            }
        } else if (this.modbusTcpGateway != null) {
            this.modbusTcpGateway.setSocketStatus(BSocketStatusEnum.openPending);
            this.commSocket = new Socket(inetAddress, ((BModbusTcpGateway)this.network).getPort());
            this.detailsLn("Socket connection made to gateway " + ((ModbusTcpComm)this.getComm()).devName() + '.');
        }
        if (this.commSocket != null) {
            if (this.modbusTcpDevice != null) {
                this.modbusTcpDevice.setSocketStatus(BSocketStatusEnum.opened);
            } else if (this.modbusTcpGateway != null) {
                this.modbusTcpGateway.setSocketStatus(BSocketStatusEnum.opened);
            }
            try {
                this.setSocketTimeout();
            }
            catch (Exception exception) {
                this.detailsLn("exception caught setting so timeout, e=" + exception);
            }
        } else if (this.modbusTcpDevice != null) {
            this.modbusTcpDevice.setSocketStatus(BSocketStatusEnum.openFailed);
        } else if (this.modbusTcpGateway != null) {
            this.modbusTcpGateway.setSocketStatus(BSocketStatusEnum.openFailed);
        }
    }

    public void nullStreams() {
        this.setInputStream(null);
        this.out = null;
    }

    private final void createStreams() throws IOException {
        this.setInputStream(this.commSocket.getInputStream());
        this.out = this.commSocket.getOutputStream();
    }

    public synchronized void initSocketConnection() {
        try {
            this.nullStreams();
            this.closeSocket();
            this.connectSocket();
            this.createStreams();
            this.successSocketConnectionInit();
        }
        catch (Exception exception) {
            if (this.modbusTcpDevice != null) {
                this.modbusTcpDevice.setSocketStatus(BSocketStatusEnum.openFailed);
            } else if (this.modbusTcpGateway != null) {
                this.modbusTcpGateway.setSocketStatus(BSocketStatusEnum.openFailed);
            }
            this.failureSocketConnectionInit(exception);
        }
    }

    protected void detailsLn(String string) {
        try {
            if (this.network.getLog().isTraceOn()) {
                this.network.getLog().trace(((ModbusTcpComm)this.getComm()).devName() + "(MbsSoMan driver)-" + string);
            }
        }
        catch (Exception exception) {}
    }

    private final /* synthetic */ void this() {
        this.out = null;
        this.numOutstandingRequests = 0;
        this.numConnectionFailures = 0;
        this.state = 0;
        this.exit = false;
        this.idleMonitor = new Object();
        this.connectMonitor = new Object();
        this.network = null;
        this.msg = null;
        this.requestMessage = null;
    }

    public ModbusTcpRxDriver(BModbusNetwork bModbusNetwork) {
        this.this();
        this.network = bModbusNetwork;
        this.switchState(0);
    }
}

