/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusTcp;

import com.tridium.basicdriver.message.Message;
import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusTcp.BModbusTcpDeviceFolder;
import com.tridium.modbusTcp.BModbusTcpGateway;
import com.tridium.modbusTcp.BModbusTcpGatewayDevice;
import com.tridium.modbusTcp.BModbusTcpNetwork;
import com.tridium.modbusTcp.BSocketStatusEnum;
import com.tridium.modbusTcp.comm.ModbusTcpComm;
import com.tridium.modbusTcp.comm.ModbusTcpRxDriver;
import com.tridium.modbusTcp.comm.ModbusTcpSendRequest;
import java.net.InetAddress;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BModbusTcpDevice
extends BModbusTcpGatewayDevice {
    public static final Property deviceAddress = BModbusTcpDevice.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt(null, (int)0, (int)255));
    public static final Property ipAddress = BModbusTcpDevice.newProperty((int)0, (String)"###.###.###.###", null);
    public static final Property port = BModbusTcpDevice.newProperty((int)0, (int)502, (BFacets)BFacets.makeInt(null, (int)0, (int)((char)-1)));
    public static final Property socketStatus = BModbusTcpDevice.newProperty((int)3, (BValue)BSocketStatusEnum.closed, null);
    public static final Property disableTransactionIdCheck = BModbusTcpDevice.newProperty((int)0, (boolean)false, null);
    public static final Property maxTransactionId = BModbusTcpDevice.newProperty((int)0, (int)((char)-1), (BFacets)BFacets.makeInt(null, (int)0, (int)((char)-1)));
    public static final Type TYPE;
    protected ModbusTcpComm tcpComm;
    static /* synthetic */ Class class$com$tridium$modbusTcp$BModbusTcpDevice;

    public String getIpAddress() {
        return this.getString(ipAddress);
    }

    public void setIpAddress(String string) {
        this.setString(ipAddress, string, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int n) {
        this.setInt(port, n, null);
    }

    public BSocketStatusEnum getSocketStatus() {
        return (BSocketStatusEnum)this.get(socketStatus);
    }

    public void setSocketStatus(BSocketStatusEnum bSocketStatusEnum) {
        this.set(socketStatus, (BValue)bSocketStatusEnum, null);
    }

    public boolean getDisableTransactionIdCheck() {
        return this.getBoolean(disableTransactionIdCheck);
    }

    public void setDisableTransactionIdCheck(boolean bl) {
        this.setBoolean(disableTransactionIdCheck, bl, null);
    }

    public int getMaxTransactionId() {
        return this.getInt(maxTransactionId);
    }

    public void setMaxTransactionId(int n) {
        this.setInt(maxTransactionId, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getNetworkType() {
        return BModbusTcpNetwork.TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        boolean bl = false;
        if (bComponent instanceof BModbusTcpNetwork && !(bComponent instanceof BModbusTcpGateway) || bComponent instanceof BModbusTcpDeviceFolder) {
            bl = true;
        }
        return bl;
    }

    public void started() throws Exception {
        super.started();
        if (Sys.isStationStarted()) {
            this.startComm();
        }
    }

    public void stationStarted() {
        this.startComm();
    }

    public void startComm() {
        try {
            this.tcpComm = new ModbusTcpComm(this.modbusNet());
            this.tcpComm.setDevice((BModbusDevice)this);
            if (!this.isDisabled() && !this.isFatalFault()) {
                this.tcpComm.start();
            }
        }
        catch (Exception exception) {
            this.modbusNet().getModbusLog().error("Exception generated in BModbusTcpDevice.deviceStarted(): ", (Throwable)exception);
        }
    }

    public void stopped() throws Exception {
        this.stopComm();
        super.stopped();
    }

    public void stopComm() {
        if (this.tcpComm != null && this.tcpComm.isCommStarted()) {
            try {
                this.tcpComm.stop();
            }
            catch (Exception exception) {}
        }
    }

    public int getModbusMode() {
        return 2;
    }

    public InetAddress getInetAddr() {
        InetAddress inetAddress;
        try {
            String string = this.getIpAddress().trim();
            inetAddress = string.equalsIgnoreCase("###.###.###.###") || string.length() == 0 ? null : InetAddress.getByName(string);
        }
        catch (Exception exception) {
            inetAddress = null;
        }
        return inetAddress;
    }

    public void changed(Property property, Context context) {
        block12: {
            super.changed(property, context);
            if (!this.isRunning()) {
                return;
            }
            try {
                if (property.equals((Object)ipAddress) || property.equals((Object)port)) {
                    if (this.tcpComm != null && this.tcpComm.isCommStarted()) {
                        this.tcpComm.stop();
                        InetAddress inetAddress = this.getInetAddr();
                        if (inetAddress == null && (BModbusTcpNetwork)this.modbusNet() != null && ((BModbusTcpNetwork)this.modbusNet()).getModbusLog() != null) {
                            ((BModbusTcpNetwork)this.modbusNet()).getModbusLog().error(this.getName() + ": Could not resolve IP address [" + this.getIpAddress() + "].");
                        }
                        this.tcpComm.start();
                    }
                } else if (property.equals((Object)status)) {
                    if (this.isDisabled() || this.isFatalFault()) {
                        if (this.tcpComm != null && this.tcpComm.isCommStarted()) {
                            this.tcpComm.stop();
                        }
                    } else if (this.tcpComm != null && !this.tcpComm.isCommStarted()) {
                        this.tcpComm.start();
                    }
                }
            }
            catch (Exception exception) {
                if ((BModbusTcpNetwork)this.modbusNet() == null || ((BModbusTcpNetwork)this.modbusNet()).getModbusLog() == null) break block12;
                ((BModbusTcpNetwork)this.modbusNet()).getModbusLog().error(this.getName() + ": Caught exception in BModbusTcpDevice.changed()", (Throwable)exception);
            }
        }
    }

    public Message sendModbusMessage(Message message) {
        if (!this.modbusNet().isCommActive() || this.tcpComm == null || !this.tcpComm.isCommStarted()) {
            return null;
        }
        ModbusTcpSendRequest modbusTcpSendRequest = new ModbusTcpSendRequest(this, message, true);
        Message message2 = null;
        int n = this.getSocketStatus().getOrdinal();
        if (n == 0 || n == 2) {
            ((ModbusTcpRxDriver)this.tcpComm.getCommReceiver()).initSocketConnection();
            n = this.getSocketStatus().getOrdinal();
        }
        if (n == 3) {
            ((BModbusTcpNetwork)this.modbusNet()).dispatch(modbusTcpSendRequest);
            message2 = modbusTcpSendRequest.getResponse(0);
        }
        if (message2 != null && ((ModbusResponse)message2).exceptionCode != 10 && ((ModbusResponse)message2).exceptionCode != 11) {
            this.pingOk();
            this.resetPingsFailed();
        } else if (this.incrementPingsFailed() > ((BModbusTcpNetwork)this.modbusNet()).getMaxFailsUntilDeviceDown()) {
            String string = this.getLexicon().getText("pingFail");
            if (message2 != null) {
                string = string + ": " + ((ModbusResponse)message2).getExceptionString();
            }
            this.pingFail(string);
        }
        return message2;
    }

    public ModbusTcpComm getComm() {
        return this.tcpComm;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.tcpComm = null;
    }

    public BModbusTcpDevice() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$modbusTcp$BModbusTcpDevice;
        if (clazz == null) {
            clazz = class$com$tridium$modbusTcp$BModbusTcpDevice = BModbusTcpDevice.class("[Lcom.tridium.modbusTcp.BModbusTcpDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

